/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class Striped {
    private final ReadWriteLock[] locks;

    public static Striped readWriteLock(int lockCnt) {
        return new Striped(lockCnt);
    }

    public Striped(int lockCnt) {
        this.locks = new ReadWriteLock[lockCnt];
        int i = 0;
        while (i < this.locks.length) {
            this.locks[i] = new ReentrantReadWriteLock();
            ++i;
        }
    }

    public final ReadWriteLock getAt(int lockIndex) {
        return this.locks[lockIndex];
    }

    public final int size() {
        return this.locks.length;
    }

    public final void releaseAllLocks() {
        int i = this.size() - 1;
        while (i >= 0) {
            this.locks[i].writeLock().unlock();
            --i;
        }
    }

    public final void acquireAllLocks() {
        int i = 0;
        while (i < this.size()) {
            this.locks[i].writeLock().lock();
            ++i;
        }
    }
}

