/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.impl;

import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import tla2sany.drivers.FrontEndException;
import tla2sany.drivers.SANY;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.output.LogLevel;
import tla2sany.output.SimpleSanyOutput;
import tla2sany.semantic.APSubstInNode;
import tla2sany.semantic.AssumeNode;
import tla2sany.semantic.DecimalNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.LabelNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NumeralNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.OpDefOrDeclNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.StringNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.TheoremNode;
import tlc2.TLCGlobals;
import tlc2.module.BuiltInModuleHelper;
import tlc2.module.TLCBuiltInOverrides;
import tlc2.output.DelayedPrintStream;
import tlc2.output.MP;
import tlc2.overrides.Evaluation;
import tlc2.overrides.ITLCOverrides;
import tlc2.overrides.TLAPlusCallable;
import tlc2.overrides.TLAPlusOperator;
import tlc2.tool.Action;
import tlc2.tool.BuiltInOPs;
import tlc2.tool.Defns;
import tlc2.tool.EvalException;
import tlc2.tool.Specs;
import tlc2.tool.TLCStateMut;
import tlc2.tool.TLCStateMutExt;
import tlc2.tool.ToolGlobals;
import tlc2.tool.impl.ContextEnumerator;
import tlc2.tool.impl.ModelConfig;
import tlc2.tool.impl.OpDefEvaluator;
import tlc2.tool.impl.SymbolNodeValueLookupProvider;
import tlc2.tool.impl.TLAClass;
import tlc2.tool.impl.TLARegistry;
import tlc2.tool.impl.Tool;
import tlc2.tool.impl.WorkerValue;
import tlc2.util.Context;
import tlc2.util.Vect;
import tlc2.value.IBoolValue;
import tlc2.value.IValue;
import tlc2.value.ValueConstants;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.CallableValue;
import tlc2.value.impl.EvaluatingValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.LazyValue;
import tlc2.value.impl.MethodValue;
import tlc2.value.impl.OpRcdValue;
import tlc2.value.impl.PriorityEvaluatingValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.Value;
import util.Assert;
import util.FilenameToStream;
import util.ToolIO;
import util.UniqueString;

public class SpecProcessor
implements ValueConstants,
ToolGlobals {
    private static final String PROPERTY = "PROPERTY";
    private final String rootFile;
    private final int toolId;
    private final Defns defns;
    private final ModelConfig config;
    private final OpDefEvaluator opDefEvaluator;
    private final SymbolNodeValueLookupProvider symbolNodeValueLookupProvider;
    private final TLAClass tlaClass;
    private OpDeclNode[] variablesNodes;
    private ExternalModuleTable moduleTbl;
    private ModuleNode rootModule;
    private Set<OpDefNode> processedDefs;
    private SpecObj specObj;
    private Defns snapshot;
    private Defns preConstantSnapshot;
    private Vect<Action> initPredVec;
    private Action nextPred;
    private Action[] temporals;
    private String[] temporalNames;
    private Action[] impliedTemporals;
    private String[] impliedTemporalNames;
    private Action[] invariants;
    private String[] invNames;
    private Action[] impliedInits;
    private String[] impliedInitNames;
    private Action[] impliedActions;
    private String[] impliedActNames;
    private ExprNode[] modelConstraints;
    private ExprNode[] actionConstraints;
    private ExprNode rlReward;
    private ExprNode periodic;
    private ExprNode[] assumptions;
    private boolean[] assumptionIsAxiom;
    private Vect<Action> invVec = new Vect();
    private Vect<String> invNameVec = new Vect();
    private Vect<Action> impliedInitVec = new Vect();
    private Vect<String> impliedInitNameVec = new Vect();
    private Vect<Action> impliedActionVec = new Vect();
    private Vect<String> impliedActNameVec = new Vect();
    private Vect<Action> temporalVec = new Vect();
    private Vect<String> temporalNameVec = new Vect();
    private Vect<Action> impliedTemporalVec = new Vect();
    private Vect<String> impliedTemporalNameVec = new Vect();
    private final Map<ModuleNode, Map<OpDefOrDeclNode, Object>> constantDefns = new HashMap<ModuleNode, Map<OpDefOrDeclNode, Object>>();
    public static final String LAZY_CONSTANT_OPERATORS = SpecProcessor.class.getName() + ".vetoed";
    private static final Set<String> vetos = new HashSet<String>(Arrays.asList(System.getProperty(LAZY_CONSTANT_OPERATORS, "")));

    public SpecProcessor(String rootFile, FilenameToStream resolver, int toolId, Defns defns, ModelConfig config, SymbolNodeValueLookupProvider snvlp, OpDefEvaluator ode, TLAClass tlaClass, Tool.Mode mode, SpecObj obj) {
        this.rootFile = rootFile;
        this.toolId = toolId;
        this.defns = defns;
        this.config = config;
        this.tlaClass = tlaClass;
        this.processedDefs = new HashSet<OpDefNode>();
        this.initPredVec = new Vect(5);
        this.specObj = obj;
        this.opDefEvaluator = ode;
        this.symbolNodeValueLookupProvider = snvlp;
        this.processSpec(mode);
        this.snapshot = defns.snapshot();
        if (this.opDefEvaluator != null) {
            this.processConstantDefns();
        }
        this.processConfig();
    }

    private void processConstantDefns() {
        ModuleNode[] mods = this.moduleTbl.getModuleNodes();
        int i = 0;
        while (i < mods.length) {
            if (mods[i].processConstantDefns()) {
                this.processConstantDefns(mods[i]);
            }
            ++i;
        }
    }

    public final Map<ModuleNode, Map<OpDefOrDeclNode, Object>> getConstantDefns() {
        return this.constantDefns;
    }

    private void processConstantDefns(ModuleNode mod) {
        OpDefNode opDef;
        OpDeclNode[] consts = mod.getConstantDecls();
        int i = 0;
        while (i < consts.length) {
            Object val = consts[i].getToolObject(this.toolId);
            if (val != null && val instanceof IValue) {
                ((IValue)val).initialize();
                this.constantDefns.computeIfAbsent(mod, key -> new HashMap()).put(consts[i], val);
            } else if (val != null && val instanceof OpDefNode) {
                opDef = (OpDefNode)val;
                Assert.check(opDef.getArity() == consts[i].getArity(), 2225, new String[]{consts[i].getName().toString(), opDef.getName().toString()});
                if (opDef.getArity() == 0) {
                    try {
                        Object defVal = WorkerValue.demux(this.opDefEvaluator, opDef.getBody());
                        opDef.setToolObject(this.toolId, defVal);
                        if (Boolean.getBoolean(SpecProcessor.class.getName() + ".aggressiveConstantCaching")) {
                            consts[i].setToolObject(this.toolId, defVal);
                        }
                        this.constantDefns.computeIfAbsent(mod, key -> new HashMap()).put(opDef, defVal);
                    }
                    catch (EvalException | Assert.TLCRuntimeException e) {
                        String addendum = e instanceof EvalException ? "" : " - specifically: " + e.getMessage();
                        Assert.fail(2281, new String[]{consts[i].getName().toString(), opDef.getName().toString(), addendum});
                    }
                }
            }
            ++i;
        }
        OpDefNode[] opDefs = mod.getOpDefs();
        int i2 = 0;
        while (i2 < opDefs.length) {
            Object realDef;
            boolean evaluate;
            opDef = opDefs[i2];
            ModuleNode moduleNode = opDef.getOriginallyDefinedInModuleNode();
            boolean bl = evaluate = moduleNode == null || moduleNode.processConstantDefns();
            if (evaluate && opDef.getArity() == 0 && (realDef = this.symbolNodeValueLookupProvider.lookup(opDef, Context.Empty, false, this.toolId)) instanceof OpDefNode && this.symbolNodeValueLookupProvider.getLevelBound((opDef = (OpDefNode)realDef).getBody(), Context.Empty, this.toolId) == 0) {
                try {
                    UniqueString opName = opDef.getName();
                    if (!this.isVetoed(opName)) {
                        Object val = WorkerValue.demux(this.opDefEvaluator, opDef.getBody());
                        opDef.setToolObject(this.toolId, val);
                        Object def = this.defns.get(opName);
                        if (def == opDef) {
                            this.defns.put(opName, val);
                            this.constantDefns.computeIfAbsent(opDef.hasSource() ? opDef.getSource().getOriginallyDefinedInModuleNode() : moduleNode, key -> new HashMap()).put(opDef, val);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++i2;
        }
        ModuleNode[] imods = mod.getInnerModules();
        int i3 = 0;
        while (i3 < imods.length) {
            this.processConstantDefns(imods[i3]);
            ++i3;
        }
    }

    private boolean isVetoed(UniqueString us) {
        return vetos.contains(us.toString());
    }

    private final void processSpec(Tool.Mode mode) {
        UniqueString modName;
        Object myVal;
        UniqueString lhs;
        if (TLCGlobals.tool) {
            MP.printMessage(2220);
        }
        PrintStream ps = MP.isSuppressed(2220) ? new DelayedPrintStream(ToolIO.out) : ToolIO.out;
        try {
            SimpleSanyOutput out = new SimpleSanyOutput(ps, LogLevel.INFO);
            SANY.frontEndMain(this.specObj, this.rootFile, out);
        }
        catch (FrontEndException e) {
            if (ps instanceof DelayedPrintStream) {
                DelayedPrintStream dps = (DelayedPrintStream)ps;
                dps.release();
            }
            Assert.fail(2171, e);
        }
        if (TLCGlobals.tool) {
            MP.printMessage(2219);
        }
        MP.printMessage(2185);
        if (!this.specObj.parseErrors.isSuccess()) {
            Assert.fail(3002, this.specObj.parseErrors.getErrors());
        }
        if (!this.specObj.semanticErrors.isSuccess()) {
            Assert.fail(3002, this.specObj.semanticErrors.getErrors());
        }
        this.moduleTbl = this.specObj.getExternalModuleTable();
        UniqueString rootName = UniqueString.uniqueStringOf(this.rootFile);
        this.rootModule = this.moduleTbl.getModuleNode(rootName);
        Assert.check(this.rootModule != null, 2171, String.format(" Module-Table lookup failure for module name %s derived from %s file name.", rootName.toString(), this.rootFile));
        OpDeclNode[] varDecls = this.rootModule.getVariableDecls();
        this.variablesNodes = new OpDeclNode[varDecls.length];
        UniqueString[] varNames = new UniqueString[varDecls.length];
        int i = 0;
        while (i < varDecls.length) {
            this.variablesNodes[i] = varDecls[i];
            varNames[i] = varDecls[i].getName();
            varNames[i].setLoc(i);
            ++i;
        }
        UniqueString.setVariableCount(varDecls.length);
        this.defns.setDefnCount(varDecls.length);
        this.defns.put("TRUE", (Object)BoolValue.ValTrue);
        this.defns.put("FALSE", (Object)BoolValue.ValFalse);
        Value[] elems = new Value[]{BoolValue.ValFalse, BoolValue.ValTrue};
        this.defns.put("BOOLEAN", (Object)new SetEnumValue(elems, true));
        Class stringModule = this.tlaClass.loadClass("Strings");
        if (stringModule == null) {
            Assert.fail(2119);
        }
        Method[] ms = stringModule.getDeclaredMethods();
        int i2 = 0;
        while (i2 < ms.length) {
            int mod = ms[i2].getModifiers();
            if (Modifier.isStatic(mod)) {
                String name = TLARegistry.mapName(ms[i2].getName());
                int acnt = ms[i2].getParameterTypes().length;
                if (!ms[i2].isSynthetic()) {
                    this.defns.put(name, (Object)MethodValue.get(ms[i2]));
                }
            }
            ++i2;
        }
        this.preConstantSnapshot = this.defns.snapshot();
        ModuleNode[] mods = this.moduleTbl.getModuleNodes();
        HashMap<String, ModuleNode> modSet = new HashMap<String, ModuleNode>();
        int i3 = 0;
        while (i3 < mods.length) {
            this.processConstants(mods[i3], this.defns);
            modSet.put(mods[i3].getName().toString(), mods[i3]);
            ++i3;
        }
        AssumeNode[] assumes = this.rootModule.getAssumptions();
        this.assumptions = new ExprNode[assumes.length];
        this.assumptionIsAxiom = new boolean[assumes.length];
        int i4 = 0;
        while (i4 < assumes.length) {
            this.assumptions[i4] = assumes[i4].getAssume();
            this.assumptionIsAxiom[i4] = assumes[i4].getIsAxiom();
            ++i4;
        }
        Hashtable constants = this.initializeConstants();
        Hashtable<String, String> overrides = this.config.getOverrides();
        OpDeclNode[] rootConsts = this.rootModule.getConstantDecls();
        int i5 = 0;
        while (i5 < rootConsts.length) {
            UniqueString name = rootConsts[i5].getName();
            Object val = constants.get(name.toString());
            if (val == null && !overrides.containsKey(name.toString())) {
                Assert.fail(2222, name.toString());
            }
            rootConsts[i5].setToolObject(this.toolId, val);
            this.defns.put(name, val);
            ++i5;
        }
        OpDefNode[] rootOpDefs = this.rootModule.getOpDefs();
        int i6 = 0;
        while (i6 < rootOpDefs.length) {
            UniqueString name = rootOpDefs[i6].getName();
            Object val = constants.get(name.toString());
            if (val == null) {
                this.defns.put(name, (Object)rootOpDefs[i6]);
            } else {
                rootOpDefs[i6].setToolObject(this.toolId, val);
                this.defns.put(name, val);
            }
            ++i6;
        }
        Hashtable<String, Hashtable> modConstants = this.initializeModConstants();
        int i7 = 0;
        while (i7 < mods.length) {
            UniqueString modName2 = mods[i7].getName();
            Hashtable mConsts = modConstants.get(modName2.toString());
            if (mConsts != null) {
                OpDefNode[] opDefs = mods[i7].getOpDefs();
                int j = 0;
                while (j < opDefs.length) {
                    UniqueString name = opDefs[j].getName();
                    Object val = mConsts.get(name.toString());
                    if (val != null) {
                        opDefs[j].getBody().setToolObject(this.toolId, val);
                    }
                    ++j;
                }
            }
            ++i7;
        }
        boolean hasCallableValue = this.processModuleOverrides(mods, rootOpDefs, modSet, overrides);
        HashSet<String> overriden = new HashSet<String>();
        int i8 = 0;
        while (i8 < rootConsts.length) {
            lhs = rootConsts[i8].getName();
            String rhs = overrides.get(lhs.toString());
            if (rhs != null) {
                if (overrides.containsKey(rhs)) {
                    Assert.fail(2223, rhs);
                }
                if ((myVal = this.defns.get(rhs)) == null) {
                    Assert.fail(2224, new String[]{lhs.toString(), rhs});
                }
                rootConsts[i8].setToolObject(this.toolId, myVal);
                this.defns.put(lhs, myVal);
                overriden.add(lhs.toString());
            }
            ++i8;
        }
        if (mode == Tool.Mode.Simulation || mode == Tool.Mode.MC_DEBUG || Boolean.getBoolean(Tool.TLCSTATEMUTEXT_KEY)) {
            TLCStateMutExt.setVariables(this.variablesNodes);
        } else if (hasCallableValue) {
            assert (mode == Tool.Mode.Executor);
            TLCStateMutExt.setVariables(this.variablesNodes);
        } else {
            assert (mode == Tool.Mode.MC);
            TLCStateMut.setVariables(this.variablesNodes);
        }
        i8 = 0;
        while (i8 < rootOpDefs.length) {
            lhs = rootOpDefs[i8].getName();
            String rhs = overrides.get(lhs.toString());
            if (rhs != null) {
                if (overrides.containsKey(rhs)) {
                    Assert.fail(2223, rhs);
                }
                if ((myVal = this.defns.get(rhs)) == null) {
                    Assert.fail(2224, new String[]{lhs.toString(), rhs});
                }
                if (myVal instanceof OpDefNode) {
                    OpDefNode odn = (OpDefNode)myVal;
                    if (rootOpDefs[i8].getNumberOfArgs() != odn.getNumberOfArgs()) {
                        Assert.fail(2225, new String[]{lhs.toString(), rhs});
                    }
                    if (Boolean.getBoolean(SpecProcessor.class.getName() + ".allowCyclicRedefinitions") && odn.isDefinedWith(rootOpDefs[i8])) {
                        this.getRootModule().substituteFor(odn, rootOpDefs[i8]);
                    } else {
                        rootOpDefs[i8].setToolObject(this.toolId, myVal);
                    }
                } else {
                    rootOpDefs[i8].setToolObject(this.toolId, myVal);
                }
                this.defns.put(lhs, myVal);
                overriden.add(lhs.toString());
            }
            ++i8;
        }
        Enumeration<String> keys = overrides.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (overriden.contains(key)) continue;
            Assert.fail(2226, key.toString());
        }
        Hashtable modOverrides = this.config.getModOverrides();
        int i9 = 0;
        while (i9 < mods.length) {
            modName = mods[i9].getName();
            Hashtable mDefs = (Hashtable)modOverrides.get(modName.toString());
            HashSet<String> modOverriden = new HashSet<String>();
            if (mDefs != null) {
                OpDefNode[] opDefs = mods[i9].getOpDefs();
                int j = 0;
                while (j < opDefs.length) {
                    UniqueString lhs2 = opDefs[j].getName();
                    String rhs = (String)mDefs.get(lhs2.toString());
                    if (rhs != null) {
                        Object myVal2;
                        if (mDefs.containsKey(rhs)) {
                            Assert.fail(2223, rhs);
                        }
                        if ((myVal2 = this.defns.get(rhs)) == null) {
                            Assert.fail(2224, new String[]{lhs2.toString(), rhs});
                        }
                        if (myVal2 instanceof OpDefNode && opDefs[j].getNumberOfArgs() != ((OpDefNode)myVal2).getNumberOfArgs()) {
                            Assert.fail(2225, new String[]{lhs2.toString(), rhs});
                        }
                        opDefs[j].getBody().setToolObject(this.toolId, myVal2);
                        modOverriden.add(lhs2.toString());
                    }
                    ++j;
                }
                Enumeration mkeys = mDefs.keys();
                while (mkeys.hasMoreElements()) {
                    Object mkey = mkeys.nextElement();
                    if (modOverriden.contains(mkey)) continue;
                    Assert.fail(2226, mkey.toString());
                }
            }
            ++i9;
        }
        Enumeration modKeys = modOverrides.keys();
        while (modKeys.hasMoreElements()) {
            modName = modKeys.nextElement();
            if (modSet.keySet().contains(modName)) continue;
            Assert.fail(2245, ((Object)modName).toString());
        }
    }

    private final void processConfig() {
        this.processConfigInvariants();
        String specName = this.config.getSpec();
        if (specName.length() == 0) {
            this.processConfigInitAndNext();
        } else {
            Object spec;
            if (this.config.getInit().length() != 0 || this.config.getNext().length() != 0) {
                Assert.fail(2227);
            }
            if ((spec = this.defns.get(specName)) instanceof OpDefNode) {
                OpDefNode opDef = (OpDefNode)spec;
                if (opDef.getArity() != 0) {
                    Assert.fail(2228, new String[]{specName});
                }
                this.processConfigSpec(opDef.getBody(), Context.Empty, tlc2.util.List.Empty, new ArrayList<SemanticNode>());
            } else if (spec == null) {
                Assert.fail(2229, new String[]{"name", specName});
            } else {
                Assert.fail(2230, new String[]{"value", specName, spec.toString()});
            }
        }
        Vect propNames = this.config.getProperties();
        int i = 0;
        while (i < propNames.size()) {
            String propName = (String)propNames.elementAt(i);
            Object prop = this.defns.get(propName);
            if (prop instanceof OpDefNode) {
                OpDefNode opDef = (OpDefNode)prop;
                if (opDef.getArity() != 0) {
                    Assert.fail(2228, new String[]{propName});
                }
                if (opDef.getLevel() == 1) {
                    MP.printWarning(2255, new String[]{propName});
                }
                this.processConfigProps(propName, opDef.getBody(), Context.Empty, tlc2.util.List.Empty);
            } else if (prop == null) {
                Assert.fail(2229, new String[]{"property", propName});
            } else if (!(prop instanceof IBoolValue) || !((BoolValue)prop).val) {
                Assert.fail(2230, new String[]{"property", propName, prop.toString()});
            }
            ++i;
        }
        this.invariants = new Action[this.invVec.size()];
        this.invNames = new String[this.invVec.size()];
        i = 0;
        while (i < this.invVec.size()) {
            this.invariants[i] = this.invVec.elementAt(i);
            this.invNames[i] = this.invNameVec.elementAt(i);
            ++i;
        }
        this.impliedInits = new Action[this.impliedInitVec.size()];
        this.impliedInitNames = new String[this.impliedInitVec.size()];
        i = 0;
        while (i < this.impliedInits.length) {
            this.impliedInits[i] = this.impliedInitVec.elementAt(i);
            this.impliedInitNames[i] = this.impliedInitNameVec.elementAt(i);
            ++i;
        }
        this.impliedInitVec = null;
        this.impliedInitNameVec = null;
        this.impliedActions = new Action[this.impliedActionVec.size()];
        this.impliedActNames = new String[this.impliedActionVec.size()];
        i = 0;
        while (i < this.impliedActions.length) {
            this.impliedActions[i] = this.impliedActionVec.elementAt(i);
            this.impliedActNames[i] = this.impliedActNameVec.elementAt(i);
            ++i;
        }
        this.impliedActionVec = null;
        this.impliedActNameVec = null;
        this.temporals = new Action[this.temporalVec.size()];
        this.temporalNames = new String[this.temporalNameVec.size()];
        i = 0;
        while (i < this.temporals.length) {
            this.temporals[i] = this.temporalVec.elementAt(i);
            this.temporalNames[i] = this.temporalNameVec.elementAt(i);
            ++i;
        }
        this.temporalVec = null;
        this.temporalNameVec = null;
        this.impliedTemporals = new Action[this.impliedTemporalVec.size()];
        this.impliedTemporalNames = new String[this.impliedTemporalNameVec.size()];
        i = 0;
        while (i < this.impliedTemporals.length) {
            this.impliedTemporals[i] = this.impliedTemporalVec.elementAt(i);
            this.impliedTemporalNames[i] = this.impliedTemporalNameVec.elementAt(i);
            ++i;
        }
        this.impliedTemporalVec = null;
        this.impliedTemporalNameVec = null;
        if (this.initPredVec.size() == 0 && (this.impliedInits.length != 0 || this.impliedActions.length != 0 || this.variablesNodes.length != 0 || this.invariants.length != 0 || this.impliedTemporals.length != 0)) {
            Assert.fail(2231);
        }
        if (this.nextPred == null && (this.impliedActions.length != 0 || this.invariants.length != 0 || this.impliedTemporals.length != 0)) {
            Assert.fail(2232);
        }
        if (this.config.getSpec().length() == 0 && !this.config.getProperties().isEmpty() && this.impliedTemporals.length > 0) {
            MP.printWarning(2257, new String[]{""});
        }
        if (this.config.getSpec().length() > 0 && !this.config.getProperties().isEmpty() && this.impliedTemporals.length > 0 && this.temporals.length == 0) {
            MP.printWarning(2259, specName, ((OpDefNode)this.defns.get(specName)).getLocation().toString());
        }
        if (this.config.getSpec().length() > 0 && this.config.getProperties().size() == 1 && this.temporals.length > 0 && Arrays.asList(this.temporals).stream().allMatch(a -> a.getAuxiliary().containsKey(PROPERTY))) {
            String liveName = (String)this.config.getProperties().elementAt(0);
            OpDefNode opDefNode = (OpDefNode)this.defns.get(liveName);
            MP.printWarning(2258, liveName, opDefNode.getLocation().toString(), specName, ((OpDefNode)this.defns.get(specName)).getLocation().toString());
        }
        List<Action> overrides = this.specObj.getInvariants(this);
        ArrayList<Action> a2 = new ArrayList<Action>(Arrays.asList(this.invariants));
        a2.addAll(overrides);
        this.invariants = (Action[])a2.toArray(Action[]::new);
        ArrayList<String> b = new ArrayList<String>(Arrays.asList(this.invNames));
        b.addAll(overrides.stream().map(act -> act.getNameOfDefault()).collect(Collectors.toList()));
        this.invNames = (String[])b.toArray(String[]::new);
        this.processModelConstraints();
        this.processActionConstraints();
        this.processRLReward();
        this.processPeriodic();
    }

    private void processConfigInitAndNext() {
        OpDefNode def;
        String name = this.config.getInit();
        if (name.length() != 0) {
            Object init = this.defns.get(name);
            if (init == null) {
                Assert.fail(2229, new String[]{"initial predicate", name});
            }
            if (!(init instanceof OpDefNode)) {
                Assert.fail(2233, new String[]{"initial predicate", name});
            }
            if ((def = (OpDefNode)init).getArity() != 0) {
                Assert.fail(2228, new String[]{"initial predicate", name});
            }
            this.initPredVec.addElement(new Action((SemanticNode)def.getBody(), Context.Empty, def, true, false));
        }
        if ((name = this.config.getNext()).length() != 0) {
            Object next = this.defns.get(name);
            if (next == null) {
                Assert.fail(2229, new String[]{"next state action", name});
            }
            if (!(next instanceof OpDefNode)) {
                Assert.fail(2233, new String[]{"next state action", name});
            }
            if ((def = (OpDefNode)next).getArity() != 0) {
                Assert.fail(2228, new String[]{"next state action", name});
            }
            this.nextPred = new Action((SemanticNode)def.getBody(), Context.Empty, def);
        }
    }

    private void processConfigInvariants() {
        Vect invs = this.config.getInvariants();
        int i = 0;
        while (i < invs.size()) {
            String name = (String)invs.elementAt(i);
            Object inv = this.defns.get(name);
            if (inv instanceof OpDefNode) {
                OpDefNode def = (OpDefNode)inv;
                if (def.getArity() != 0) {
                    Assert.fail(2228, new String[]{"invariant", name});
                }
                if (def.getLevel() >= 2) {
                    if (!def.getBody().levelParams.isEmpty()) {
                        Assert.fail(2146, new String[]{def.getName().toString(), "includeWarning"});
                    }
                    Assert.fail(2146, def.getName().toString());
                }
                this.invNameVec.addElement(name);
                this.invVec.addElement(new Action((SemanticNode)def.getBody(), Context.Empty, def));
            } else if (inv == null) {
                Assert.fail(2229, new String[]{"invariant", name});
            } else if (!(inv instanceof IBoolValue) || !((BoolValue)inv).val) {
                Assert.fail(2230, new String[]{"invariant", name, inv.toString()});
            } else if (inv instanceof IBoolValue) {
                MP.printWarning(2149, name, ((BoolValue)inv).toString());
            }
            ++i;
        }
    }

    private final void processConfigSpec(ExprNode pred, Context c, tlc2.util.List subs, List<SemanticNode> stack) {
        int level;
        if (pred instanceof SubstInNode) {
            SubstInNode pred1 = (SubstInNode)pred;
            this.processConfigSpec(pred1.getBody(), c, subs.cons(pred1), stack);
            return;
        }
        if (pred instanceof OpApplNode) {
            OpDefNode odn;
            OpApplNode pred1 = (OpApplNode)pred;
            stack.add(pred1);
            ExprOrOpArgNode[] args = pred1.getArgs();
            SymbolNode opNode = pred1.getOperator();
            Object val = this.symbolNodeValueLookupProvider.lookup(opNode, c, false, this.toolId);
            if (args.length == 0) {
                if (val instanceof OpDefNode) {
                    ExprNode body;
                    if (((OpDefNode)val).getArity() != 0) {
                        Assert.fail(2234, new String[]{opNode.getName().toString()});
                    }
                    if (this.symbolNodeValueLookupProvider.getLevelBound(body = ((OpDefNode)val).getBody(), c, this.toolId) == 1) {
                        this.initPredVec.addElement(new Action((SemanticNode)Specs.addSubsts(body, subs), c, (OpDefNode)val, true, false));
                    } else {
                        this.processConfigSpec(body, c, subs, stack);
                    }
                } else if (val == null) {
                    Assert.fail(2235, new String[]{opNode.getName().toString()});
                } else if (val instanceof IBoolValue) {
                    if (!((BoolValue)val).val) {
                        Assert.fail(2237, opNode.getName().toString());
                    }
                } else {
                    Assert.fail(2236, new String[]{opNode.getName().toString(), val.toString(), "spec"});
                }
                return;
            }
            if (val instanceof OpDefNode && (odn = (OpDefNode)val).getBody() != null && !odn.getInRecursive() && odn.getArity() == args.length && subs.isEmpty()) {
                c = this.symbolNodeValueLookupProvider.getOpContext((OpDefNode)val, args, c, false, this.toolId);
                this.processConfigSpec(odn.getBody(), c, subs, stack);
                return;
            }
            int opcode = BuiltInOPs.getOpCode(pred1.getOperator().getName());
            if (opcode == 55 || opcode == 56) {
                Assert.fail(2301);
            }
            if (opcode == 6 || opcode == 36) {
                int i = 0;
                while (i < args.length) {
                    this.processConfigSpec((ExprNode)args[i], c, subs, new ArrayList<SemanticNode>(stack));
                    ++i;
                }
                return;
            }
            if (opcode == 59) {
                OpApplNode oan;
                ExprOrOpArgNode boxArg = args[0];
                if (boxArg instanceof OpApplNode && (oan = (OpApplNode)boxArg).getLevel() <= 1) {
                    Assert.fail(2213, boxArg.toString());
                }
                if (boxArg instanceof OpApplNode && BuiltInOPs.getOpCode(((OpApplNode)boxArg).getOperator().getName()) == 51) {
                    ExprNode arg = (ExprNode)((OpApplNode)boxArg).getArgs()[0];
                    ExprNode subscript = (ExprNode)((OpApplNode)boxArg).getArgs()[1];
                    Vect<SymbolNode> varsInSubscript = null;
                    try {
                        class SubscriptCollector {
                            Vect<SymbolNode> components = new Vect();

                            SubscriptCollector() {
                            }

                            void enter(ExprNode subscript, Context c) {
                                SymbolNode var = SpecProcessor.this.symbolNodeValueLookupProvider.getVar(subscript, c, false, SpecProcessor.this.toolId);
                                if (var != null) {
                                    this.components.addElement(var);
                                    return;
                                }
                                switch (subscript.getKind()) {
                                    case 9: {
                                        OpApplNode subscript1 = (OpApplNode)subscript;
                                        SymbolNode opNode = subscript1.getOperator();
                                        ExprOrOpArgNode[] args = subscript1.getArgs();
                                        int opCode = BuiltInOPs.getOpCode(opNode.getName());
                                        if (opCode == 23) {
                                            int i = 0;
                                            while (i < args.length) {
                                                this.enter((ExprNode)args[i], c);
                                                ++i;
                                            }
                                            return;
                                        }
                                        if (opCode != 0) {
                                            return;
                                        }
                                        Object opDef = SpecProcessor.this.symbolNodeValueLookupProvider.lookup(opNode, c, false, SpecProcessor.this.toolId);
                                        if (opDef instanceof OpDefNode) {
                                            OpDefNode opDef1 = (OpDefNode)opDef;
                                            this.enter(opDef1.getBody(), SpecProcessor.this.symbolNodeValueLookupProvider.getOpContext(opDef1, args, c, false, SpecProcessor.this.toolId));
                                            return;
                                        }
                                        if (!(opDef instanceof LazyValue)) break;
                                        LazyValue lv = (LazyValue)opDef;
                                        this.enter((ExprNode)lv.expr, lv.con);
                                        return;
                                    }
                                    case 13: {
                                        SubstInNode subscript1 = (SubstInNode)subscript;
                                        Subst[] subs = subscript1.getSubsts();
                                        Context c1 = c;
                                        int i = 0;
                                        while (i < subs.length) {
                                            c1 = c1.cons(subs[i].getOp(), SpecProcessor.this.symbolNodeValueLookupProvider.getVal(subs[i].getExpr(), c, false, SpecProcessor.this.toolId));
                                            ++i;
                                        }
                                        this.enter(subscript1.getBody(), c1);
                                        return;
                                    }
                                    case 10: {
                                        LetInNode subscript1 = (LetInNode)subscript;
                                        this.enter(subscript1.getBody(), c);
                                        return;
                                    }
                                    case 29: {
                                        LabelNode subscript1 = (LabelNode)subscript;
                                        this.enter((ExprNode)subscript1.getBody(), c);
                                        return;
                                    }
                                    default: {
                                        Assert.fail(2238, subscript.toString());
                                        return;
                                    }
                                }
                            }

                            Vect<SymbolNode> getComponents() {
                                return this.components;
                            }
                        }
                        SubscriptCollector collector = new SubscriptCollector();
                        Context c1 = c;
                        tlc2.util.List subs1 = subs;
                        while (!subs1.isEmpty()) {
                            SubstInNode sn2 = (SubstInNode)subs1.car();
                            Subst[] snsubs = sn2.getSubsts();
                            int i = 0;
                            while (i < snsubs.length) {
                                c1 = c1.cons(snsubs[i].getOp(), this.symbolNodeValueLookupProvider.getVal(snsubs[i].getExpr(), c, false, this.toolId));
                                ++i;
                            }
                            subs1 = subs1.cdr();
                        }
                        collector.enter(subscript, c1);
                        varsInSubscript = collector.getComponents();
                    }
                    catch (Exception e) {
                        MP.printWarning(2139, new String[0]);
                        varsInSubscript = null;
                    }
                    if (varsInSubscript != null) {
                        int i = 0;
                        while (i < this.variablesNodes.length) {
                            if (!varsInSubscript.contains(this.variablesNodes[i])) {
                                MP.printWarning(2140, new String[]{this.variablesNodes[i].getName().toString()});
                            }
                            ++i;
                        }
                    }
                    if (this.nextPred == null) {
                        this.nextPred = new Action(Specs.addSubsts(arg, subs), c);
                    } else {
                        Assert.fail(2240);
                    }
                } else {
                    this.temporalVec.addElement(new Action(Specs.addSubsts(pred, subs), c));
                    this.temporalNameVec.addElement(pred.toString());
                }
                return;
            }
            if (opcode == 46) {
                this.processConfigSpec((ExprNode)args[0], c, subs, stack);
                return;
            }
        }
        if ((level = this.symbolNodeValueLookupProvider.getLevelBound(pred, c, this.toolId)) <= 1) {
            this.initPredVec.addElement(new Action(Specs.addSubsts(pred, subs), c));
        } else if (level == 3) {
            Action a = new Action(Specs.addSubsts(pred, subs), c);
            Vect properties = this.config.getProperties();
            stack.stream().filter(sn -> properties.contains(sn.getTreeNode().toString())).findAny().ifPresent(sn -> {
                Object object = a.getAuxiliary().put(PROPERTY, sn);
            });
            this.temporalVec.addElement(a);
            this.temporalNameVec.addElement(pred.toString());
        } else {
            Assert.fail(2239, pred.toString());
        }
    }

    private final void processConfigProps(String name, ExprNode pred, Context c, tlc2.util.List subs) {
        int level;
        if (pred instanceof SubstInNode) {
            SubstInNode pred1 = (SubstInNode)pred;
            this.processConfigProps(name, pred1.getBody(), c, subs.cons(pred1));
            return;
        }
        if (pred instanceof OpApplNode) {
            OpDefNode odn;
            OpApplNode pred1 = (OpApplNode)pred;
            ExprOrOpArgNode[] args = pred1.getArgs();
            SymbolNode opNode = pred1.getOperator();
            Object val = this.symbolNodeValueLookupProvider.lookup(opNode, c, false, this.toolId);
            if (args.length == 0) {
                if (val instanceof OpDefNode) {
                    if (((OpDefNode)val).getArity() != 0) {
                        Assert.fail(2234, opNode.getName().toString());
                    }
                    this.processConfigProps(opNode.getName().toString(), ((OpDefNode)val).getBody(), c, subs);
                } else if (val == null) {
                    Assert.fail(2235, opNode.getName().toString());
                } else if (val instanceof IBoolValue) {
                    if (!((BoolValue)val).val) {
                        Assert.fail(2237, opNode.getName().toString());
                    }
                } else {
                    Assert.fail(2236, new String[]{opNode.getName().toString(), val.toString(), "property"});
                }
                return;
            }
            if (val instanceof OpDefNode && (odn = (OpDefNode)val).getBody() != null && !odn.getInRecursive() && odn.getArity() == args.length && subs.isEmpty()) {
                c = this.symbolNodeValueLookupProvider.getOpContext(odn, args, c, false, this.toolId);
                this.processConfigProps(opNode.getName().toString(), odn.getBody(), c, subs);
                return;
            }
            int opcode = BuiltInOPs.getOpCode(pred1.getOperator().getName());
            if (opcode == 3) {
                ContextEnumerator ctxts = null;
                try {
                    ctxts = this.opDefEvaluator.contexts(pred1, c);
                }
                catch (Assert.TLCRuntimeException tLCRuntimeException) {
                    // empty catch block
                }
                if (ctxts != null) {
                    Context c1;
                    if (ctxts.isDone()) {
                        Assert.fail(2253);
                    }
                    while ((c1 = ctxts.nextElement()) != null) {
                        ExprNode expr = (ExprNode)args[0];
                        this.processConfigProps(expr.toString(), expr, c1, subs);
                    }
                    return;
                }
            }
            if (opcode == 6 || opcode == 36) {
                int i = 0;
                while (i < args.length) {
                    ExprNode conj = (ExprNode)args[i];
                    this.processConfigProps(conj.toString(), conj, c, subs);
                    ++i;
                }
                return;
            }
            if (opcode == 59) {
                ExprNode boxArg = (ExprNode)args[0];
                if (boxArg instanceof OpApplNode && BuiltInOPs.getOpCode(((OpApplNode)boxArg).getOperator().getName()) == 51) {
                    OpApplNode boxArg1 = (OpApplNode)boxArg;
                    if (boxArg1.getArgs().length == 0) {
                        name = boxArg1.getOperator().getName().toString();
                    }
                    this.impliedActNameVec.addElement(name);
                    this.impliedActionVec.addElement(new Action(Specs.addSubsts(boxArg, subs), c));
                } else if (this.symbolNodeValueLookupProvider.getLevelBound(boxArg, c, this.toolId) < 2) {
                    this.invVec.addElement(new Action(Specs.addSubsts(boxArg, subs), c));
                    if (boxArg instanceof OpApplNode && ((OpApplNode)boxArg).getArgs().length == 0) {
                        name = ((OpApplNode)boxArg).getOperator().getName().toString();
                    }
                    this.invNameVec.addElement(name);
                } else {
                    this.impliedTemporalVec.addElement(new Action(Specs.addSubsts(pred, subs), c));
                    this.impliedTemporalNameVec.addElement(name);
                }
                return;
            }
            if (opcode == 46) {
                this.processConfigProps(name, (ExprNode)args[0], c, subs);
                return;
            }
        }
        if ((level = this.symbolNodeValueLookupProvider.getLevelBound(pred, c, this.toolId)) <= 1) {
            this.impliedInitVec.addElement(new Action(Specs.addSubsts(pred, subs), c));
            this.impliedInitNameVec.addElement(name);
        } else if (level == 3) {
            this.impliedTemporalVec.addElement(new Action(Specs.addSubsts(pred, subs), c));
            this.impliedTemporalNameVec.addElement(name);
        } else if (level == 2) {
            if (pred instanceof OpApplNode && BuiltInOPs.getOpCode(((OpApplNode)pred).getOperator().getName()) == 51) {
                Assert.fail(2273, new String[]{name, pred.getLocation().toString()});
            } else if (pred instanceof OpApplNode && BuiltInOPs.getOpCode(((OpApplNode)pred).getOperator().getName()) == 50) {
                Assert.fail(2274, new String[]{name, pred.getLocation().toString()});
            } else {
                Assert.fail(2272, new String[]{name, pred.getLocation().toString()});
            }
        } else {
            Assert.fail(2241, name);
        }
    }

    private void processRLReward() {
        String name = this.config.getRLReward();
        if (name.length() != 0) {
            OpDefNode def;
            Object type = this.snapshot.get(name);
            if (type == null) {
                Assert.fail(2229, new String[]{"rlreward", name});
            }
            if (!(type instanceof OpDefNode)) {
                Assert.fail(2233, new String[]{"rlreward", name});
            }
            if ((def = (OpDefNode)type).getArity() != 0) {
                Assert.fail(2228, new String[]{"rlreward", name});
            }
            this.rlReward = def.getBody();
        }
    }

    private void processPeriodic() {
        String name = this.config.getPeriodic();
        if (name.length() != 0) {
            OpDefNode def;
            Object type = this.snapshot.get(name);
            if (type == null) {
                Assert.fail(2229, new String[]{"periodic", name});
            }
            if ((def = (OpDefNode)type).getArity() != 0) {
                Assert.fail(2228, new String[]{"periodic", name});
            }
            this.periodic = def.getBody();
        }
    }

    private void processActionConstraints() {
        Vect names = this.config.getActionConstraints();
        this.actionConstraints = new ExprNode[names.size()];
        int idx = 0;
        int i = 0;
        while (i < names.size()) {
            String name = (String)names.elementAt(i);
            Object constr = this.defns.get(name);
            if (constr instanceof OpDefNode) {
                OpDefNode def = (OpDefNode)constr;
                if (def.getArity() != 0) {
                    Assert.fail(2228, new String[]{"action constraint", name});
                }
                ExprNode body = def.getBody();
                assert (body.getToolObject(this.toolId) == null);
                body.setToolObject(this.toolId, def);
                this.actionConstraints[idx++] = body;
            } else if (constr != null) {
                if (!(constr instanceof IBoolValue) || !((BoolValue)constr).val) {
                    Assert.fail(2230, new String[]{"action constraint", name, constr.toString()});
                }
            } else {
                Assert.fail(2229, new String[]{"action constraint", name});
            }
            ++i;
        }
        if (idx < this.actionConstraints.length) {
            ExprNode[] constrs = new ExprNode[idx];
            int i2 = 0;
            while (i2 < idx) {
                constrs[i2] = this.actionConstraints[i2];
                ++i2;
            }
            this.actionConstraints = constrs;
        }
    }

    private final void processModelConstraints() {
        Vect names = this.config.getConstraints();
        this.modelConstraints = new ExprNode[names.size()];
        int idx = 0;
        int i = 0;
        while (i < names.size()) {
            String name = (String)names.elementAt(i);
            Object constr = this.defns.get(name);
            if (constr instanceof OpDefNode) {
                OpDefNode def = (OpDefNode)constr;
                if (def.getArity() != 0) {
                    Assert.fail(2228, new String[]{"constraint", name});
                }
                ExprNode body = def.getBody();
                assert (body.getToolObject(this.toolId) == null);
                body.setToolObject(this.toolId, def);
                this.modelConstraints[idx++] = body;
            } else if (constr != null) {
                if (!(constr instanceof IBoolValue) || !((BoolValue)constr).val) {
                    Assert.fail(2230, new String[]{"constraint", name, constr.toString()});
                }
            } else {
                Assert.fail(2229, new String[]{"constraint", name});
            }
            ++i;
        }
        if (idx < this.modelConstraints.length) {
            ExprNode[] constrs = new ExprNode[idx];
            int i2 = 0;
            while (i2 < idx) {
                constrs[i2] = this.modelConstraints[i2];
                ++i2;
            }
            this.modelConstraints = constrs;
        }
    }

    private final void processConstants(SemanticNode expr, Defns d) {
        switch (expr.getKind()) {
            case 1: {
                ModuleNode expr1 = (ModuleNode)expr;
                OpDefNode[] opDefs = expr1.getOpDefs();
                int i = 0;
                while (i < opDefs.length) {
                    Object def = opDefs[i].getToolObject(this.toolId);
                    if (def instanceof OpDefNode) {
                        this.processedDefs.add((OpDefNode)def);
                        this.processConstants(((OpDefNode)def).getBody(), d);
                    }
                    this.processConstants(opDefs[i].getBody(), d);
                    ++i;
                }
                ModuleNode[] imods = expr1.getInnerModules();
                int i2 = 0;
                while (i2 < imods.length) {
                    this.processConstants(imods[i2], d);
                    ++i2;
                }
                AssumeNode[] assumps = expr1.getAssumptions();
                int i3 = 0;
                while (i3 < assumps.length) {
                    this.processConstants(assumps[i3], d);
                    ++i3;
                }
                TheoremNode[] thms = expr1.getTheorems();
                int i4 = 0;
                while (i4 < thms.length) {
                    this.processConstants(thms[i4], d);
                    ++i4;
                }
                return;
            }
            case 9: {
                OpApplNode expr1 = (OpApplNode)expr;
                SymbolNode opNode = expr1.getOperator();
                Object val = d.get(opNode.getName());
                if (val != null) {
                    opNode.setToolObject(this.toolId, val);
                } else {
                    ExprOrOpArgNode[] args = expr1.getArgs();
                    int i = 0;
                    while (i < args.length) {
                        if (args[i] != null) {
                            this.processConstants(args[i], d);
                        }
                        ++i;
                    }
                    ExprNode[] bnds = expr1.getBdedQuantBounds();
                    int i5 = 0;
                    while (i5 < bnds.length) {
                        this.processConstants(bnds[i5], d);
                        ++i5;
                    }
                }
                return;
            }
            case 10: {
                LetInNode expr1 = (LetInNode)expr;
                OpDefNode[] letDefs = expr1.getLets();
                int i = 0;
                while (i < letDefs.length) {
                    this.processConstants(letDefs[i].getBody(), d);
                    ++i;
                }
                this.processConstants(expr1.getBody(), d);
                return;
            }
            case 13: {
                SubstInNode expr1 = (SubstInNode)expr;
                Subst[] subs = expr1.getSubsts();
                int i = 0;
                while (i < subs.length) {
                    this.processConstants(subs[i].getExpr(), d);
                    ++i;
                }
                this.processConstants(expr1.getBody(), d);
                return;
            }
            case 30: {
                APSubstInNode expr1 = (APSubstInNode)expr;
                Subst[] subs = expr1.getSubsts();
                int i = 0;
                while (i < subs.length) {
                    this.processConstants(subs[i].getExpr(), d);
                    ++i;
                }
                this.processConstants(expr1.getBody(), d);
                return;
            }
            case 16: {
                NumeralNode expr1 = (NumeralNode)expr;
                IntValue val = IntValue.gen(expr1.val());
                if (expr1.bigVal() != null) {
                    Assert.fail(2265, expr1.toString());
                    return;
                }
                expr1.setToolObject(this.toolId, val);
                return;
            }
            case 17: {
                DecimalNode expr1 = (DecimalNode)expr;
                Assert.fail(2244, expr1.toString());
                return;
            }
            case 18: {
                StringNode expr1 = (StringNode)expr;
                StringValue val = new StringValue(expr1.getRep());
                expr1.setToolObject(this.toolId, val);
                return;
            }
            case 20: {
                AssumeNode expr1 = (AssumeNode)expr;
                this.processConstants(expr1.getAssume(), d);
                return;
            }
            case 12: {
                TheoremNode expr1 = (TheoremNode)expr;
                this.processConstants(expr1.getTheorem(), d);
                return;
            }
            case 8: {
                OpDefNode opdef;
                SymbolNode opArgNode = ((OpArgNode)expr).getOp();
                if (opArgNode.getKind() == 5 && !this.processedDefs.contains(opdef = (OpDefNode)opArgNode)) {
                    this.processedDefs.add(opdef);
                    this.processConstants(opdef.getBody(), d);
                }
                return;
            }
            case 29: {
                LabelNode expr1 = (LabelNode)expr;
                this.processConstants(expr1.getBody(), d);
            }
        }
    }

    public boolean processModuleOverrides(ModuleNode module, ExternalModuleTable moduleTbl) {
        ModuleNode[] mods = moduleTbl.getModuleNodes();
        HashMap<String, ModuleNode> modSet = new HashMap<String, ModuleNode>();
        int i = 0;
        while (i < mods.length) {
            modSet.put(mods[i].getName().toString(), mods[i]);
            ++i;
        }
        return this.processModuleOverrides(mods, module.getOpDefs(), modSet, new Hashtable());
    }

    public boolean processModuleOverrides(ModuleNode[] mods, OpDefNode[] rootOpDefs, Map<String, ModuleNode> modSet, Hashtable overrides) {
        int i = 0;
        while (i < mods.length) {
            UniqueString modName = mods[i].getName();
            Class userModule = this.tlaClass.loadClass(modName.toString());
            if (userModule != null) {
                HashMap<UniqueString, Integer> opname2arity = new HashMap<UniqueString, Integer>();
                if (!BuiltInModuleHelper.isBuiltInModule(userModule)) {
                    OpDefNode[] opDefNodeArray = rootOpDefs;
                    int n = rootOpDefs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        OpDefNode opDefNode = opDefNodeArray[n2];
                        if (opDefNode.getOriginallyDefinedInModuleNode().getName().equals(modName)) {
                            opname2arity.put(opDefNode.getName(), opDefNode.getArity());
                        }
                        ++n2;
                    }
                }
                Hashtable<UniqueString, Value> javaDefs = new Hashtable<UniqueString, Value>();
                Method[] mds = userModule.getDeclaredMethods();
                int j = 0;
                while (j < mds.length) {
                    Method method = mds[j];
                    int mdf = method.getModifiers();
                    if (Modifier.isPublic(mdf) && Modifier.isStatic(mdf)) {
                        String name = TLARegistry.mapName(method.getName());
                        UniqueString uname = UniqueString.uniqueStringOf(name);
                        if (method.getAnnotation(TLAPlusOperator.class) == null && method.getAnnotation(Evaluation.class) == null) {
                            int acnt = method.getParameterCount();
                            Value val = MethodValue.get(method);
                            if (!BuiltInModuleHelper.isBuiltInModule(userModule)) {
                                URL resource = userModule.getResource(userModule.getSimpleName() + ".class");
                                Integer arity = (Integer)opname2arity.get(uname);
                                if (arity == null || arity != acnt) {
                                    MP.printWarning(2400, uname.toString(), resource.toExternalForm(), val.toString());
                                } else {
                                    javaDefs.put(uname, val);
                                    MP.printMessage(2168, uname.toString(), resource.toExternalForm(), val.toString());
                                }
                            } else {
                                javaDefs.put(uname, val);
                            }
                        }
                    }
                    ++j;
                }
                OpDefNode[] opDefs = mods[i].getOpDefs();
                int j2 = 0;
                while (j2 < opDefs.length) {
                    UniqueString uname = opDefs[j2].getName();
                    Object val = javaDefs.get(uname);
                    if (val != null) {
                        opDefs[j2].getBody().setToolObject(this.toolId, val);
                        this.defns.put(uname, val);
                    }
                    ++j2;
                }
            }
            ++i;
        }
        boolean hasCallableValue = false;
        String tlcOverrides = TLCBuiltInOverrides.class.getName() + File.pathSeparator + System.getProperty("tlc2.overrides.TLCOverrides", "tlc2.overrides.TLCOverrides");
        String[] stringArray = tlcOverrides.split(File.pathSeparator);
        int n = stringArray.length;
        int n3 = 0;
        while (n3 < n) {
            String ovrde = stringArray[n3];
            Class idx = this.tlaClass.loadClass(ovrde);
            if (idx != null && ITLCOverrides.class.isAssignableFrom(idx)) {
                try {
                    Class[] candidateClasses;
                    ITLCOverrides index = (ITLCOverrides)idx.newInstance();
                    Class[] classArray = candidateClasses = index.get();
                    int n4 = candidateClasses.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        Method[] candidateMethods;
                        Class c = classArray[n5];
                        Method[] methodArray = candidateMethods = c.getDeclaredMethods();
                        int n6 = candidateMethods.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            EvaluatingValue val;
                            Method m = methodArray[n7];
                            Evaluation evaluation = m.getAnnotation(Evaluation.class);
                            if (evaluation != null) {
                                ModuleNode moduleNode = modSet.get(evaluation.module());
                                if (moduleNode == null) {
                                    if (evaluation.warn()) {
                                        MP.printMessage(2402, evaluation.module() + "!" + evaluation.definition(), c.getResource(c.getSimpleName() + ".class").toExternalForm(), "<Java Method: " + String.valueOf(m) + ">");
                                    }
                                } else {
                                    OpDefNode opDef = moduleNode.getOpDef(evaluation.definition());
                                    if (opDef == null) {
                                        if (evaluation.warn()) {
                                            MP.printMessage(2403, evaluation.module() + "!" + evaluation.definition(), c.getResource(c.getSimpleName() + ".class").toExternalForm(), "<Java Method: " + String.valueOf(m) + ">");
                                        }
                                    } else {
                                        Object toolObject = opDef.getBody().getToolObject(this.toolId);
                                        if (toolObject instanceof EvaluatingValue) {
                                            val = new PriorityEvaluatingValue(m, evaluation.minLevel(), evaluation.priority(), opDef, (EvaluatingValue)toolObject);
                                            opDef.getBody().setToolObject(this.toolId, val);
                                            this.defns.put(evaluation.definition(), (Object)val);
                                        } else if (toolObject instanceof PriorityEvaluatingValue) {
                                            PriorityEvaluatingValue mev = (PriorityEvaluatingValue)toolObject;
                                            mev.add(new EvaluatingValue(m, evaluation.minLevel(), evaluation.priority(), opDef));
                                        } else {
                                            val = new EvaluatingValue(m, evaluation.minLevel(), evaluation.priority(), opDef);
                                            opDef.getBody().setToolObject(this.toolId, val);
                                            this.defns.put(evaluation.definition(), (Object)val);
                                        }
                                        if (!evaluation.silent()) {
                                            MP.printMessage(2168, evaluation.module() + "!" + evaluation.definition(), c.getResource(c.getSimpleName() + ".class").toExternalForm(), "<Java Method: " + String.valueOf(m) + ">");
                                        }
                                    }
                                }
                            } else {
                                TLAPlusCallable jev = m.getAnnotation(TLAPlusCallable.class);
                                if (jev != null) {
                                    ModuleNode moduleNode = modSet.get(jev.module());
                                    if (moduleNode == null) {
                                        if (jev.warn()) {
                                            MP.printMessage(2402, jev.module() + "!" + jev.definition(), c.getResource(c.getSimpleName() + ".class").toExternalForm(), "<Java Method: " + String.valueOf(m) + ">");
                                        }
                                    } else {
                                        OpDefNode opDef = moduleNode.getOpDef(jev.definition());
                                        if (opDef == null) {
                                            if (jev.warn()) {
                                                MP.printMessage(2403, jev.module() + "!" + jev.definition(), c.getResource(c.getSimpleName() + ".class").toExternalForm(), "<Java Method: " + String.valueOf(m) + ">");
                                            }
                                        } else {
                                            val = new CallableValue(m, jev.minLevel(), opDef);
                                            opDef.getBody().setToolObject(this.toolId, val);
                                            this.defns.put(jev.definition(), (Object)val);
                                            hasCallableValue = true;
                                            MP.printMessage(2168, jev.module() + "!" + jev.definition(), c.getResource(c.getSimpleName() + ".class").toExternalForm(), val.toString());
                                        }
                                    }
                                } else {
                                    TLAPlusOperator opOverrideCandidate = m.getAnnotation(TLAPlusOperator.class);
                                    if (opOverrideCandidate != null) {
                                        ModuleNode moduleNode = modSet.get(opOverrideCandidate.module());
                                        if (moduleNode == null) {
                                            if (opOverrideCandidate.warn()) {
                                                MP.printWarning(2402, opOverrideCandidate.identifier(), opOverrideCandidate.module(), m.toString());
                                            }
                                        } else {
                                            OpDefNode opDef = moduleNode.getOpDef(opOverrideCandidate.identifier());
                                            if (opDef == null) {
                                                if (opOverrideCandidate.warn()) {
                                                    MP.printWarning(2403, opOverrideCandidate.identifier(), opOverrideCandidate.module(), m.toString());
                                                }
                                            } else {
                                                Value val2 = MethodValue.get(m, opOverrideCandidate.minLevel());
                                                if (opDef.getArity() != m.getParameterCount()) {
                                                    if (opOverrideCandidate.warn()) {
                                                        MP.printWarning(2400, opDef.getName().toString(), c.getName(), val2.toString());
                                                    }
                                                } else {
                                                    if (opOverrideCandidate.warn()) {
                                                        MP.printMessage(2168, opDef.getName().toString(), c.getName(), val2 instanceof MethodValue ? val2.toString() : val2.getClass().getName());
                                                    }
                                                    opDef.getBody().setToolObject(this.toolId, val2);
                                                    this.defns.put(opOverrideCandidate.identifier(), (Object)val2);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            ++n7;
                        }
                        ++n5;
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    Assert.fail(1000);
                    return hasCallableValue;
                }
            }
            ++n3;
        }
        return hasCallableValue;
    }

    public final void processConstantsDynamicExtendee(ModuleNode submodule) {
        this.processConstants(submodule, this.preConstantSnapshot.snapshot());
    }

    private final Hashtable<String, Serializable> makeConstantTable(Vect<Vect<String>> consts) {
        Hashtable<String, Serializable> constTbl = new Hashtable<String, Serializable>();
        int i = 0;
        while (i < consts.size()) {
            Vect<String> line = consts.elementAt(i);
            int len = line.size();
            String name = line.elementAt(0);
            if (len <= 2) {
                constTbl.put(name, (Serializable)((Object)line.elementAt(1)));
            } else {
                OpRcdValue opVal;
                Serializable val = constTbl.get(name);
                if (val == null) {
                    opVal = new OpRcdValue();
                    opVal.addLine(line);
                    constTbl.put(name, opVal);
                } else {
                    opVal = (OpRcdValue)val;
                    int arity = ((IValue[])opVal.domain.elementAt(0)).length;
                    if (len != arity + 2) {
                        Assert.fail(2242, name);
                    }
                    opVal.addLine(line);
                }
            }
            ++i;
        }
        return constTbl;
    }

    private final Hashtable initializeConstants() {
        Vect consts = this.config.getConstants();
        if (consts == null) {
            return new Hashtable();
        }
        return this.makeConstantTable(consts);
    }

    private final Hashtable<String, Hashtable> initializeModConstants() {
        Hashtable modConstants = this.config.getModConstants();
        Hashtable<String, Hashtable> constants = new Hashtable<String, Hashtable>();
        Enumeration mods = modConstants.keys();
        while (mods.hasMoreElements()) {
            String modName = (String)mods.nextElement();
            constants.put(modName, this.makeConstantTable((Vect)modConstants.get(modName)));
        }
        return constants;
    }

    public ModuleNode getRootModule() {
        return this.rootModule;
    }

    public ExternalModuleTable getModuleTbl() {
        return this.moduleTbl;
    }

    public OpDeclNode[] getVariablesNodes() {
        return this.variablesNodes;
    }

    public Vect<Action> getInitPred() {
        return this.initPredVec;
    }

    public Action getNextPred() {
        return this.nextPred;
    }

    public Action[] getTemporal() {
        return this.temporals;
    }

    public String[] getTemporalNames() {
        return this.temporalNames;
    }

    public Action[] getImpliedTemporals() {
        return this.impliedTemporals;
    }

    public String[] getImpliedTemporalNames() {
        return this.impliedTemporalNames;
    }

    public Action[] getInvariants() {
        return this.invariants;
    }

    public String[] getInvariantsNames() {
        return this.invNames;
    }

    public Action[] getImpliedInits() {
        return this.impliedInits;
    }

    public String[] getImpliedInitNames() {
        return this.impliedInitNames;
    }

    public Action[] getImpliedActions() {
        return this.impliedActions;
    }

    public String[] getImpliedActionNames() {
        return this.impliedActNames;
    }

    public ExprNode[] getModelConstraints() {
        return this.modelConstraints;
    }

    public ExprNode[] getActionConstraints() {
        return this.actionConstraints;
    }

    public ExprNode getRLReward() {
        return this.rlReward;
    }

    public ExprNode getPeriodic() {
        return this.periodic;
    }

    public ExprNode[] getAssumptions() {
        return this.assumptions;
    }

    public boolean[] getAssumptionIsAxiom() {
        return this.assumptionIsAxiom;
    }

    public SpecObj getSpecObj() {
        return this.specObj;
    }

    public Defns getUnprocessedDefns() {
        return this.snapshot;
    }

    public Defns getDefns() {
        return this.defns;
    }

    public List<ExprNode> getPostConditionSpecs() {
        return this.specObj.getPostConditionSpecs();
    }
}

