/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.function.BiPredicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.ParamAndPosition;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SetOfArgLevelConstraints;
import tla2sany.semantic.SetOfLevelConstraints;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.xml.SymbolContext;
import util.UniqueString;

public class InstanceNode
extends LevelNode {
    UniqueString name;
    FormalParamNode[] params;
    ModuleNode module;
    Subst[] substs;
    boolean local;
    private UniqueString stepName = null;

    public UniqueString getName() {
        return this.name;
    }

    public ModuleNode getModule() {
        return this.module;
    }

    public boolean getLocal() {
        return this.local;
    }

    public void setStepName(UniqueString stepName) {
        this.stepName = stepName;
    }

    public UniqueString getStepName() {
        return this.stepName;
    }

    public InstanceNode(UniqueString name, boolean localness, FormalParamNode[] params, ModuleNode module, Subst[] substs, TreeNode stn) {
        super(21, stn);
        this.name = name;
        this.local = localness;
        this.params = params != null ? params : new FormalParamNode[]{};
        this.module = module;
        this.substs = substs != null ? substs : new Subst[]{};
    }

    public boolean isLocal() {
        return this.local;
    }

    @Override
    public final boolean levelCheck(int itr, Errors errors) {
        if (this.levelChecked >= itr) {
            return this.levelCorrect;
        }
        this.levelChecked = itr;
        this.levelParams = new HashSet();
        this.levelCorrect = true;
        if (!this.module.levelCheck(itr, errors)) {
            this.levelCorrect = false;
        }
        int i = 0;
        while (i < this.substs.length) {
            if (!this.substs[i].getExpr().levelCheck(itr, errors)) {
                this.levelCorrect = false;
            }
            ++i;
        }
        i = 0;
        while (i < this.substs.length) {
            SymbolNode op;
            OpDeclNode mparam = this.substs[i].getOp();
            ExprOrOpArgNode mexp = this.substs[i].getExpr();
            mexp.levelCheck(itr, errors);
            ((LevelNode)mparam).levelCheck(itr, errors);
            if (!this.module.isConstant(errors) && mexp.getLevel() > mparam.getLevel()) {
                if (mexp.levelCheck(itr, errors) && ((LevelNode)mparam).levelCheck(itr, errors)) {
                    errors.addError(ErrorCode.INSTANCE_SUBSTITUTION_LEVEL_CONSTRAINTS_EXCEEDED, this.stn.getLocation(), "Level error in instantiating module '" + String.valueOf(this.module.getName()) + "':\nThe level of the expression or operator substituted for '" + String.valueOf(mparam.getName()) + "' \nmust be at most " + mparam.getLevel() + ".");
                }
                this.levelCorrect = false;
            }
            if (!(mexp.getKind() != 8 || (op = ((OpArgNode)mexp).getOp()).getKind() != 5 && op.getKind() != 7 || ((OpDefNode)op).isLeibniz)) {
                errors.addError(ErrorCode.INSTANCE_SUBSTITUTION_NON_LEIBNIZ_OPERATOR, this.stn.getLocation(), "Error in instantiating module '" + String.valueOf(this.module.getName()) + "':\n A non-Leibniz operator substituted for '" + String.valueOf(mparam.getName()) + "'.");
            }
            ++i;
        }
        SetOfLevelConstraints lcSet = this.module.getLevelConstraints();
        SetOfArgLevelConstraints alcSet = this.module.getArgLevelConstraints();
        int i2 = 0;
        while (i2 < this.substs.length) {
            int alen;
            OpDeclNode mparam = this.substs[i2].getOp();
            ExprOrOpArgNode mexp = this.substs[i2].getExpr();
            Integer plevel = (Integer)lcSet.get(mparam);
            if (plevel != null && mexp.getLevel() > plevel) {
                if (mexp.levelCheck(itr, errors)) {
                    errors.addError(ErrorCode.INSTANCE_SUBSTITUTION_LEVEL_CONSTRAINTS_EXCEEDED, this.stn.getLocation(), "Level error in instantiating module '" + String.valueOf(this.module.getName()) + "':\nThe level of the expression or operator substituted for '" + String.valueOf(mparam.getName()) + "' \nmust be at most " + String.valueOf(plevel) + ".");
                }
                this.levelCorrect = false;
            }
            if ((alen = ((SymbolNode)mparam).getArity()) > 0 && ((OpArgNode)mexp).getOp() instanceof OpDefNode) {
                OpDefNode opDef = (OpDefNode)((OpArgNode)mexp).getOp();
                int j = 0;
                while (j < alen) {
                    ParamAndPosition pap = new ParamAndPosition(mparam, j);
                    Integer alevel = (Integer)alcSet.get(pap);
                    boolean opDefLevelCheck = opDef.levelCheck(itr, errors);
                    if (alevel != null && opDef.getMaxLevel(j) < alevel) {
                        if (opDefLevelCheck) {
                            errors.addError(ErrorCode.INSTANCE_SUBSTITUTION_LEVEL_CONSTRAINT_NOT_MET, this.stn.getLocation(), "Level error in instantiating module '" + String.valueOf(this.module.getName()) + "':\nThe level of the argument " + j + " of the operator " + String.valueOf(opDef.getName()) + " \nmust be at least " + String.valueOf(plevel) + ".");
                        }
                        this.levelCorrect = false;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        for (ArgLevelParam alp : this.module.getArgLevelParams()) {
            int i3 = 0;
            while (i3 < this.substs.length) {
                OpDeclNode pi = this.substs[i3].getOp();
                int j = 0;
                while (j < this.substs.length) {
                    if (alp.op == pi && alp.param == this.substs[j].getOp()) {
                        SymbolNode op = ((OpArgNode)this.substs[i3].getExpr()).getOp();
                        boolean opLevelCheck = op.levelCheck(itr, errors);
                        if (op instanceof OpDefNode && this.substs[j].getExpr().getLevel() > ((OpDefNode)op).getMaxLevel(alp.i)) {
                            if (opLevelCheck && this.substs[j].getExpr().levelCheck(itr, errors)) {
                                errors.addError(ErrorCode.INSTANCE_SUBSTITUTION_COPARAMETER_LEVEL_CONSTRAINTS_EXCEEDED, this.stn.getLocation(), "Level error when instantiating module '" + String.valueOf(this.module.getName()) + "':\nThe level of the argument " + alp.i + " of the operator " + String.valueOf(pi.getName()) + "' \nmust be at most " + ((OpDefNode)op).getMaxLevel(alp.i) + ".");
                            }
                            this.levelCorrect = false;
                        }
                    }
                    ++j;
                }
                ++i3;
            }
        }
        lcSet = Subst.getSubLCSet(this.module, this.substs, this.module.isConstant(errors), itr, errors);
        for (SymbolNode param : lcSet.keySet()) {
            if (param.occur(this.params)) continue;
            this.levelConstraints.put(param, (Integer)lcSet.get(param));
        }
        int i4 = 0;
        while (i4 < this.substs.length) {
            lcSet = this.substs[i4].getExpr().getLevelConstraints();
            for (SymbolNode param : lcSet.keySet()) {
                if (param.occur(this.params)) continue;
                this.levelConstraints.put(param, (Integer)lcSet.get(param));
            }
            ++i4;
        }
        alcSet = Subst.getSubALCSet(this.module, this.substs, itr, errors);
        for (ParamAndPosition pap : alcSet.keySet()) {
            if (pap.param.occur(this.params)) continue;
            this.argLevelConstraints.put(pap, (Integer)alcSet.get(pap));
        }
        i = 0;
        while (i < this.substs.length) {
            alcSet = this.substs[i].getExpr().getArgLevelConstraints();
            for (ParamAndPosition pap : alcSet.keySet()) {
                if (pap.param.occur(this.params)) continue;
                this.argLevelConstraints.put(pap, (Integer)alcSet.get(pap));
            }
            ++i;
        }
        HashSet<ArgLevelParam> alpSet = Subst.getSubALPSet(this.module, this.substs);
        for (ArgLevelParam alp : alpSet) {
            if (alp.occur(this.params)) continue;
            this.argLevelParams.add(alp);
        }
        int i5 = 0;
        while (i5 < this.substs.length) {
            alpSet = this.substs[i5].getExpr().getArgLevelParams();
            for (ArgLevelParam alp : alpSet) {
                if (alp.occur(this.params)) continue;
                this.argLevelParams.add(alp);
            }
            ++i5;
        }
        return this.levelCorrect;
    }

    @Override
    public final int getLevel() {
        return 0;
    }

    public final HashSet getLevelParams() {
        return this.levelParams;
    }

    @Override
    public final SetOfLevelConstraints getLevelConstraints() {
        return this.levelConstraints;
    }

    @Override
    public final String levelDataToString() {
        return "LevelConstraints: " + String.valueOf(this.levelConstraints) + "\nArgLevelConstraints: " + String.valueOf(this.argLevelConstraints) + "\nArgLevelParams: " + String.valueOf(this.argLevelParams) + "\n";
    }

    @Override
    public SemanticNode[] getChildren() {
        SemanticNode[] res = new SemanticNode[this.substs.length];
        int i = 0;
        while (i < this.substs.length) {
            res[i] = this.substs[i].getExpr();
            ++i;
        }
        return res;
    }

    public final void walkGaph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(this.myUID, this);
        visitor.preVisit(this);
        int i = 0;
        while (i < this.params.length) {
            this.params[i].walkGraph(semNodesTable, visitor);
            ++i;
        }
        this.module.walkGraph(semNodesTable, visitor);
        visitor.postVisit(this);
    }

    @Override
    public final String toString(int depth, Errors errors) {
        int i;
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*InstanceNode " + super.toString(depth, errors) + "  InstanceName = " + (this.name == null ? "(none)" : this.name.toString()) + Strings.indent(2, "\nModule: " + String.valueOf(this.module.getName())) + Strings.indent(2, "\nlocal: " + this.local);
        if (this.params.length > 0) {
            ret = ret + Strings.indent(2, "\nInstance parameters:");
            i = 0;
            while (i < this.params.length) {
                ret = ret + Strings.indent(4, this.params[i].toString(depth - 1, errors));
                ++i;
            }
        }
        if (this.substs.length > 0) {
            ret = ret + Strings.indent(2, "\nSubstitutions:");
            i = 0;
            while (i < this.substs.length) {
                ret = ret + Strings.indent(2, Strings.indent(2, "\nSubst:" + (this.substs[i] != null ? Strings.indent(2, this.substs[i].toString(depth - 1, errors)) : "<null>")));
                ++i;
            }
        }
        return ret;
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        Element sbts = doc.createElement("substs");
        int i = 0;
        while (i < this.substs.length) {
            sbts.appendChild(this.substs[i].export(doc, context, filter));
            ++i;
        }
        Element prms = doc.createElement("params");
        int i2 = 0;
        while (i2 < this.params.length) {
            prms.appendChild(this.params[i2].export(doc, context, filter));
            ++i2;
        }
        Element ret = doc.createElement("InstanceNode");
        if (this.name != null) {
            ret.appendChild(this.appendText(doc, "uniquename", this.name.toString()));
        }
        ret.appendChild(this.appendText(doc, "module", this.module.getName().toString()));
        ret.appendChild(sbts);
        ret.appendChild(prms);
        return ret;
    }
}

