/*
 * Decompiled with CFR 0.152.
 */
package tlc2.model;

import tlc2.model.Formula;
import tlc2.model.TypedSet;

public class Assignment
extends Formula {
    public static final String ASSIGNMENT_SIGN = " <- ";
    public static final String IS_MV = " [ model value ] ";
    public static final String SYMMETRICAL = " <symmetrical> ";
    private String label;
    private String[] params = new String[0];
    private boolean modelValue = false;
    private boolean symmetry = false;
    private TypedSet setOfModelValues = null;

    public Assignment(String label, String[] params, String right) {
        super(right);
        this.label = label;
        this.setParams(params);
        if (this.label != null && right != null && this.label.equals(right)) {
            this.setModelValue(true);
        }
    }

    @Override
    public String getFormula() {
        return this.getFormula("");
    }

    public String getFormula(String tab) {
        StringBuffer buffer = new StringBuffer(this.getLeft());
        buffer.append(tab);
        buffer.append(ASSIGNMENT_SIGN);
        if (this.modelValue) {
            buffer.append(IS_MV);
            if (this.isSetOfModelValues()) {
                if (this.isSymmetricalSet()) {
                    buffer.append(SYMMETRICAL);
                    buffer.append(this.getFormattedRight());
                } else {
                    buffer.append(this.getFormattedRight());
                }
            }
        } else {
            buffer.append(this.getFormattedRight());
        }
        return buffer.toString();
    }

    public String getLeft() {
        return this.getParametrizedLabel(this.label);
    }

    public String getParametrizedLabel(String id) {
        return id + this.listParams();
    }

    private String listParams() {
        if (this.params.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        int i = 0;
        while (i < this.params.length) {
            buffer.append(this.params[i]);
            buffer.append(i != this.params.length - 1 ? ", " : "");
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public void setFormula(String formula) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String getLabel() {
        return this.label;
    }

    public String getLocalLabel() {
        int beginIndex = this.label.lastIndexOf("!") + 1;
        return this.label.substring(beginIndex);
    }

    public String getRight() {
        return super.getFormula();
    }

    public String getFormattedRight() {
        Object tempRight = this.getRight();
        if (tempRight == null) {
            return null;
        }
        int i = -1;
        i = ((String)tempRight).indexOf("\n");
        if (i != -1) {
            tempRight = ((String)tempRight).substring(0, i + 1) + " ...";
        }
        return tempRight;
    }

    public String[] getParams() {
        return this.params;
    }

    @Override
    public String toString() {
        return this.getFormula();
    }

    public synchronized void setRight(String right) {
        super.setFormula(right);
        this.setOfModelValues = null;
    }

    public void setParams(String[] params) {
        if (params != null) {
            this.params = params;
            int i = 0;
            while (i < this.params.length) {
                this.params[i] = this.params[i].trim();
                ++i;
            }
        } else {
            this.params = new String[0];
        }
    }

    public boolean isModelValue() {
        return this.modelValue;
    }

    public boolean isSimpleModelValue() {
        return this.isModelValue() && !this.isSetOfModelValues();
    }

    public boolean isSetOfModelValues() {
        return this.modelValue && !this.getLabel().equals(this.getRight());
    }

    public synchronized TypedSet getSetOfModelValues() {
        if (this.isSetOfModelValues()) {
            if (this.setOfModelValues == null) {
                this.setOfModelValues = TypedSet.parseSet(this.getRight());
            }
            return this.setOfModelValues;
        }
        return null;
    }

    public boolean isSymmetricalSet() {
        return this.symmetry;
    }

    public void setSymmetric(boolean isSymmetric) {
        if (isSymmetric && !this.modelValue) {
            throw new IllegalArgumentException("Current assignment is not a set of model values");
        }
        this.symmetry = isSymmetric;
    }

    public void setModelValue(boolean modelValue) {
        if (modelValue && this.params.length != 0) {
            throw new IllegalArgumentException("Operators can not be instantiated with model values");
        }
        this.modelValue = modelValue;
    }

    public static String[] getArrayOfEmptyStrings(int number) {
        String[] array = new String[number];
        String EMPTY = new String("");
        int i = 0;
        while (i < number) {
            array[i] = EMPTY;
            ++i;
        }
        return array;
    }

    public boolean equalSignature(Assignment obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.label == null ? obj.label != null : !this.label.equals(obj.label)) {
            return false;
        }
        return this.params.length == obj.params.length;
    }

    public String prettyPrint() {
        return this.prettyPrint("");
    }

    public String prettyPrint(String delim) {
        StringBuffer buf = new StringBuffer();
        if (!this.isModelValue()) {
            return this.getFormula(delim);
        }
        if (this.isSetOfModelValues()) {
            buf.append(this.getLeft());
            buf.append(delim);
            buf.append(ASSIGNMENT_SIGN);
            if (this.isSymmetricalSet()) {
                buf.append("s");
            }
            buf.append(this.getFormattedRight());
        } else {
            buf.append(this.getLeft());
        }
        return buf.toString();
    }
}

