/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import java.util.function.BiPredicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.TreeNode;
import tla2sany.xml.SymbolContext;
import util.UniqueString;

public class OpArgNode
extends ExprOrOpArgNode {
    private SymbolNode op;
    private UniqueString name;
    private int arity;
    private ModuleNode mn;

    public OpArgNode(UniqueString name) {
        super(8, SyntaxTreeNode.nullSTN);
        this.name = name;
        this.arity = -2;
    }

    public OpArgNode(SymbolNode op, TreeNode stn, ModuleNode mn) throws AbortException {
        super(8, stn);
        this.op = op;
        this.name = op.getName();
        this.arity = op.getArity();
        this.mn = mn;
    }

    public final SymbolNode getOp() {
        return this.op;
    }

    public final int getArity() {
        return this.arity;
    }

    public final UniqueString getName() {
        return this.name;
    }

    public final ModuleNode getModule() {
        return this.mn;
    }

    @Override
    public final boolean levelCheck(int iter, Errors errors) {
        if (this.levelChecked >= iter) {
            return this.levelCorrect;
        }
        this.levelChecked = iter;
        this.levelCorrect = this.op.levelCheck(iter, errors);
        this.level = this.op.getLevel();
        this.levelParams = this.op.getLevelParams();
        this.allParams = this.op.getAllParams();
        this.levelConstraints = this.op.getLevelConstraints();
        this.argLevelConstraints = this.op.getArgLevelConstraints();
        this.argLevelParams = this.op.getArgLevelParams();
        return this.levelCorrect;
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        if (this.op != null) {
            this.op.walkGraph(semNodesTable, visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public final String toString(int depth, Errors errors) {
        if (depth <= 0) {
            return "";
        }
        return "\n*OpArgNode: " + (this.name != null ? this.name.toString() : "null") + "  " + super.toString(depth, errors) + "  arity: " + this.arity + "  op: " + (String)(this.op != null ? "" + this.op.getUid() : "null");
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        Element e = doc.createElement("OpArgNode");
        Element n = doc.createElement("argument");
        Element ope = this.op.export(doc, context, filter);
        n.appendChild(ope);
        e.appendChild(n);
        return e;
    }
}

