/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import tla2sany.semantic.OpDeclNode;
import tlc2.TLCGlobals;
import tlc2.module.TLCGetSet;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.ITool;
import tlc2.tool.Simulator;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.impl.Tool;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.tool.liveness.LiveCounterExampleException;
import tlc2.util.IdThread;
import tlc2.util.RandomGenerator;
import tlc2.util.SetOfStates;
import tlc2.util.Vect;
import tlc2.util.statistics.CountDistinct;
import tlc2.value.impl.CounterExample;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.Value;
import util.FileUtil;
import util.UniqueString;

public class SimulationWorker
extends IdThread
implements INextStateFunctor {
    protected static final boolean coverage = TLCGlobals.Coverage.isActionEnabled();
    private final RandomGenerator localRng;
    private TLCState curState;
    private StateVec initStates;
    private final BlockingQueue<SimulationWorkerResult> resultQueue;
    private long traceCnt = 0L;
    private long globalTraceCnt = 0L;
    private final long maxTraceNum;
    private final int maxTraceDepth;
    private final boolean checkDeadlock;
    private final String traceFile;
    protected final ITool tool;
    private final ILiveCheck liveCheck;
    final SimulationWorkerStatistics statistics;
    private volatile boolean stopped = false;
    private final StateVec nextStates = new StateVec(1);

    public SimulationWorker(int id, ITool tool, BlockingQueue<SimulationWorkerResult> resultQueue, long seed, int maxTraceDepth, long maxTraceNum, boolean checkDeadlock, String traceFile, ILiveCheck liveCheck) {
        this(id, tool, resultQueue, seed, maxTraceDepth, maxTraceNum, null, checkDeadlock, traceFile, liveCheck, new LongAdder(), new AtomicLong(), new AtomicLong());
    }

    public SimulationWorker(int id, ITool tool, BlockingQueue<SimulationWorkerResult> resultQueue, long seed, int maxTraceDepth, long maxTraceNum, String traceActions, boolean checkDeadlock, String traceFile, ILiveCheck liveCheck, LongAdder numOfGenStates, AtomicLong numOfGenTraces, AtomicLong m2AndMean) {
        super(id);
        this.localRng = new RandomGenerator(seed);
        this.tool = tool;
        this.maxTraceDepth = maxTraceDepth;
        this.maxTraceNum = maxTraceNum;
        this.resultQueue = resultQueue;
        this.checkDeadlock = checkDeadlock;
        this.traceFile = traceFile;
        this.liveCheck = liveCheck;
        this.statistics = Simulator.EXTENDED_STATISTICS ? new ExtendedSimulationWorkerStatistics(traceActions, numOfGenStates, numOfGenTraces, m2AndMean) : new SimulationWorkerStatistics(traceActions, numOfGenStates, numOfGenTraces, m2AndMean);
    }

    @Override
    public final void run() {
        boolean run = true;
        while (run) {
            run = this.simulateAndReport();
        }
    }

    protected boolean simulateAndReport() {
        try {
            this.globalTraceCnt = this.statistics.collectPreTrace();
            Optional<SimulationWorkerError> res = this.simulateRandomTrace();
            ++this.traceCnt;
            if (res.isPresent()) {
                SimulationWorkerError err = res.get();
                this.resultQueue.put(SimulationWorkerResult.Error(this.myGetId(), err));
            }
            if (this.traceCnt >= this.maxTraceNum) {
                this.resultQueue.put(SimulationWorkerResult.OK(this.myGetId()));
                return false;
            }
            return true;
        }
        catch (InterruptedException e) {
            this.resultQueue.offer(SimulationWorkerResult.OK(this.myGetId()));
            return false;
        }
        catch (Exception e) {
            SimulationWorkerError err = new SimulationWorkerError(0, null, this.getTrace(this.curState), e);
            this.resultQueue.offer(SimulationWorkerResult.Error(this.myGetId(), err));
            return false;
        }
    }

    private final void checkForInterrupt() throws InterruptedException {
        if (Thread.interrupted() || this.stopped) {
            throw new InterruptedException();
        }
    }

    public final void setStopped() {
        this.stopped = true;
    }

    private final TLCState randomState(RandomGenerator rng, StateVec states) {
        int len = states.size();
        if (len > 0) {
            int index = (int)Math.floor(rng.nextDouble() * (double)len);
            return states.elementAt(index);
        }
        return null;
    }

    @Override
    public Object setElement(TLCState s) {
        this.nextStates.clear();
        this.nextStates.addElement(s);
        return this;
    }

    @Override
    public Object addElement(TLCState s, Action a, TLCState t) {
        if (coverage) {
            a.cm.incInvocations();
        }
        t.setPredecessor(s).setAction(a);
        if (!this.tool.isGoodState(t)) {
            Set<OpDeclNode> unassigned = t.getUnassigned();
            String[] parameters = this.tool.getActions().length == 1 ? new String[]{unassigned.size() > 1 ? "s are" : " is", unassigned.stream().map(n -> n.getName().toString()).collect(Collectors.joining(", "))} : new String[]{a.getName().toString(), unassigned.size() > 1 ? "s are" : " is", unassigned.stream().map(n -> n.getName().toString()).collect(Collectors.joining(", "))};
            throw new SimulationWorkerError(2109, parameters, this.getTrace(t));
        }
        this.statistics.collectPreSuccessor(s, a, t);
        int idx = 0;
        try {
            idx = 0;
            while (idx < this.tool.getInvariants().length) {
                if (!this.tool.isValid(this.tool.getInvariants()[idx], t)) {
                    throw new SimulationWorkerError(2110, new String[]{this.tool.getInvNames()[idx]}, this.getTrace(t));
                }
                ++idx;
            }
        }
        catch (Exception e) {
            if (e instanceof SimulationWorkerError) {
                throw e;
            }
            throw new SimulationWorkerError(2111, new String[]{this.tool.getInvNames()[idx], e.getMessage()}, this.getTrace(t));
        }
        try {
            idx = 0;
            while (idx < this.tool.getImpliedActions().length) {
                if (!this.tool.isValid(this.tool.getImpliedActions()[idx], this.curState, t)) {
                    throw new SimulationWorkerError(2112, new String[]{this.tool.getImpliedActNames()[idx]}, this.getTrace(t));
                }
                ++idx;
            }
        }
        catch (Exception e) {
            if (e instanceof SimulationWorkerError) {
                throw e;
            }
            throw new SimulationWorkerError(2113, new String[]{this.tool.getImpliedActNames()[idx], e.getMessage()}, this.getTrace(t));
        }
        if (this.tool.isInModel(t) && this.tool.isInActions(s, t)) {
            if (coverage) {
                a.cm.incSecondary();
            }
            return this.nextStates.addElement(t);
        }
        return this;
    }

    @Override
    public boolean hasStates() {
        assert (Tool.isProbabilistic());
        return !this.nextStates.isEmpty();
    }

    @Override
    public SetOfStates getStates() {
        return new SetOfStates(this.nextStates);
    }

    protected int getNextActionIndex(RandomGenerator rng, Action[] actions, TLCState curState) {
        return (int)Math.floor(this.localRng.nextDouble() * (double)actions.length);
    }

    protected int getNextActionAltIndex(int index, int p, Action[] actions, TLCState curState) {
        this.statistics.collectNextRetries();
        return (index + p) % actions.length;
    }

    private Optional<SimulationWorkerError> simulateRandomTrace() throws Exception {
        this.curState = this.randomState(this.localRng, this.initStates);
        SimulationWorker.setCurrentState(this.curState);
        Action[] allActions = this.tool.getActions();
        int traceIdx = 0;
        while (traceIdx < this.maxTraceDepth) {
            this.checkForInterrupt();
            this.nextStates.clear();
            Action[] actions = this.filterActions(allActions, this.curState);
            int index = this.getNextActionIndex(this.localRng, actions, this.curState);
            int p = this.localRng.nextPrime();
            int i = 0;
            while (i < actions.length) {
                try {
                    this.tool.getNextStates(this, this.curState, actions[index]);
                }
                catch (SimulationWorkerError swe) {
                    return Optional.of(swe);
                }
                if (!this.nextStates.empty()) break;
                index = this.getNextActionAltIndex(index, p, actions, this.curState);
                ++i;
            }
            if (this.nextStates.empty()) {
                if (!this.checkDeadlock) break;
                return Optional.of(new SimulationWorkerError(2114, null, this.getTrace(this.curState), null));
            }
            TLCState s1 = this.randomState(this.localRng, this.nextStates);
            s1.execCallable();
            this.statistics.collectPostSuccessor(this.curState, actions[index], s1);
            this.curState = s1;
            SimulationWorker.setCurrentState(this.curState);
            ++traceIdx;
        }
        this.checkForInterrupt();
        this.liveCheck.checkTrace(this.tool.noDebug(), new Supplier<StateVec>(){

            @Override
            public StateVec get() {
                return SimulationWorker.this.getTrace(SimulationWorker.this.curState);
            }
        });
        this.statistics.collectPostTrace(this.curState);
        if (this.traceFile != null) {
            String fileName = this.traceFile + "_" + String.valueOf(this.myGetId()) + "_" + this.traceCnt;
            PrintWriter pw = new PrintWriter(FileUtil.newBFOS(fileName));
            pw.println("---------------- MODULE " + fileName + " -----------------");
            StateVec stateTrace = new Supplier<StateVec>(){

                @Override
                public StateVec get() {
                    return SimulationWorker.this.getTrace(SimulationWorker.this.curState);
                }
            }.get();
            int idx = 0;
            while (idx < stateTrace.size()) {
                Action curAction = stateTrace.elementAt(idx).getAction();
                if (curAction != null) {
                    pw.println("\\* " + curAction.getLocation());
                }
                pw.println("STATE_" + (idx + 1) + " == ");
                pw.println(String.valueOf(stateTrace.elementAt(idx)) + "\n");
                ++idx;
            }
            pw.println("=================================================");
            pw.close();
        }
        this.postTrace(this.curState);
        return Optional.empty();
    }

    protected boolean postTrace(TLCState finalState) throws FileNotFoundException {
        return true;
    }

    protected Action[] filterActions(Action[] actions, TLCState curState) {
        return actions;
    }

    public final long getTraceCnt() {
        return this.traceCnt + 1L;
    }

    public final synchronized StateVec getTrace(TLCState t) {
        LinkedList<TLCState> trace = new LinkedList<TLCState>();
        while (t != null) {
            TLCState s = t.getPredecessor();
            if (t.equals(s)) {
                t = s;
                continue;
            }
            trace.addFirst(t);
            t = t.getPredecessor();
        }
        int j = 1;
        while (j < trace.size()) {
            ((TLCState)trace.get(j)).setPredecessor((TLCState)trace.get(j - 1));
            ++j;
        }
        assert (trace.isEmpty() || ((TLCState)trace.getFirst()).isInitial() && IntStream.range(0, trace.size()).allMatch(i -> ((TLCState)trace.get(i)).getLevel() == i + 1) && ((TLCState)trace.getLast()).getLevel() == trace.size());
        return new StateVec((TLCState[])trace.toArray(TLCState[]::new));
    }

    public void setInitialStates(StateVec initStates) {
        this.initStates = initStates;
    }

    public void start(StateVec initStates) {
        this.setInitialStates(initStates);
        this.start();
    }

    public final RandomGenerator getRNG() {
        return this.localRng;
    }

    class ExtendedSimulationWorkerStatistics
    extends SimulationWorkerStatistics {
        private long numOfNextRetries;
        private final Map<UniqueString, Integer> numOfActions;
        private final CountDistinct numOfDistinctStates;
        private final CountDistinct[] numOfDistinctValues;

        public ExtendedSimulationWorkerStatistics(String traceActions, LongAdder numOfGenStates, AtomicLong numOfGenTraces, AtomicLong m2AndMean) {
            super(traceActions, numOfGenStates, numOfGenTraces, m2AndMean);
            this.numOfActions = new HashMap<UniqueString, Integer>();
            this.numOfDistinctStates = Simulator.EXTENDED_STATISTICS_NAIVE ? new CountDistinct.Naive() : new CountDistinct.HyperLogLog(8);
            this.numOfDistinctValues = new CountDistinct[TLCState.vars.length];
            int i = 0;
            while (i < TLCState.vars.length) {
                OpDeclNode odn = TLCState.vars[i];
                int varLoc = odn.getName().getVarLoc();
                this.numOfDistinctValues[varLoc] = Simulator.EXTENDED_STATISTICS_NAIVE ? new CountDistinct.Naive() : new CountDistinct.HyperLogLog(10);
                ++i;
            }
        }

        @Override
        public void collectPreSuccessor(TLCState s, Action a, TLCState t) {
            super.collectPreSuccessor(s, a, t);
            int i = 0;
            while (i < TLCState.vars.length) {
                OpDeclNode odn = TLCState.vars[i];
                int varLoc = odn.getName().getVarLoc();
                this.numOfDistinctValues[varLoc].add(t.lookup(odn.getName()));
                ++i;
            }
            this.numOfDistinctStates.add(t);
            this.numOfActions.merge(s.getAction().getName(), 1, Integer::sum);
        }

        @Override
        public void collectNextRetries() {
            ++this.numOfNextRetries;
        }

        @Override
        public Value getActions() {
            HashMap<UniqueString, IntValue> m = new HashMap<UniqueString, IntValue>();
            Vect<Action> specActions = SimulationWorker.this.tool.getSpecActions();
            int i = 0;
            while (i < specActions.size()) {
                Action a = specActions.elementAt(i);
                m.put(a.getName(), IntValue.gen(this.numOfActions.getOrDefault(a.getName(), 0)));
                ++i;
            }
            return new RecordValue(m);
        }

        @Override
        public Value getDistinctStates() {
            return IntValue.narrowToIntValue(this.numOfDistinctStates.count());
        }

        @Override
        public Value getDistinctValues() {
            HashMap<UniqueString, IntValue> m = new HashMap<UniqueString, IntValue>(TLCState.vars.length);
            int i = 0;
            while (i < TLCState.vars.length) {
                OpDeclNode odn = TLCState.vars[i];
                int varLoc = odn.getName().getVarLoc();
                m.put(odn.getName(), IntValue.gen((int)this.numOfDistinctValues[varLoc].count()));
                ++i;
            }
            return new RecordValue(m);
        }

        @Override
        public Value getNextRetries() {
            return IntValue.narrowToIntValue(this.numOfNextRetries);
        }
    }

    public class SimulationWorkerError
    extends INextStateFunctor.InvariantViolatedException {
        public int errorCode;
        public final String[] parameters;
        public final StateVec stateTrace;
        public final Exception exception;

        public SimulationWorkerError(int errorCode, String[] parameters, StateVec stateTrace) {
            this(errorCode, parameters, stateTrace, null);
        }

        public SimulationWorkerError(int errorCode, String[] parameters, StateVec stateTrace, Exception e) {
            this.errorCode = errorCode;
            this.parameters = parameters;
            this.stateTrace = stateTrace;
            this.exception = e;
        }

        @Override
        public String getMessage() {
            return MP.getMessage(this.errorCode, this.parameters);
        }

        public boolean hasTrace() {
            return this.stateTrace != null && !this.stateTrace.empty();
        }

        public List<TLCStateInfo> getTrace() {
            ArrayList<TLCStateInfo> trace = new ArrayList<TLCStateInfo>();
            int j = 0;
            while (j < this.stateTrace.size()) {
                TLCState s = this.stateTrace.elementAt(j);
                TLCState t = j + 1 < this.stateTrace.size() ? this.stateTrace.elementAt(j + 1) : s;
                trace.add(SimulationWorker.this.tool.evalAlias(new TLCStateInfo(s, s.getAction()), t));
                ++j;
            }
            return trace;
        }

        public CounterExample getCounterExample() {
            if (this.exception instanceof LiveCounterExampleException) {
                return ((LiveCounterExampleException)this.exception).counterExample;
            }
            return new CounterExample(this.getTrace());
        }
    }

    public static class SimulationWorkerResult {
        private int workerId;
        private Optional<SimulationWorkerError> error = Optional.empty();

        static SimulationWorkerResult OK(int workerId) {
            SimulationWorkerResult res = new SimulationWorkerResult();
            res.workerId = workerId;
            return res;
        }

        static SimulationWorkerResult Error(int workerId, SimulationWorkerError err) {
            SimulationWorkerResult res = new SimulationWorkerResult();
            res.error = Optional.of(err);
            res.workerId = workerId;
            return res;
        }

        public boolean isError() {
            return this.error.isPresent();
        }

        public SimulationWorkerError error() {
            return this.error.get();
        }

        public int workerId() {
            return this.workerId;
        }
    }

    class SimulationWorkerStatistics {
        private final String traceActions;
        private final LongAdder numOfGenStates;
        private final AtomicLong numOfGenTraces;
        private final AtomicLong welfordM2AndMean;
        final long[][] actionStats;

        public SimulationWorkerStatistics(String traceActions, LongAdder numOfGenStates, AtomicLong numOfGenTraces, AtomicLong m2AndMean) {
            this.traceActions = traceActions;
            this.numOfGenStates = numOfGenStates;
            this.numOfGenTraces = numOfGenTraces;
            this.welfordM2AndMean = m2AndMean;
            if (traceActions != null) {
                int len = SimulationWorker.this.tool.getSpecActions().size();
                this.actionStats = new long[len][len];
            } else {
                this.actionStats = new long[1][1];
            }
        }

        public void collectPreSuccessor(TLCState s, Action a, TLCState t) {
            this.numOfGenStates.increment();
        }

        public void collectPostSuccessor(TLCState s, Action a, TLCState t) {
            if (this.traceActions != null) {
                long[] lArray = this.actionStats[s.getAction().getId()];
                int n = t.getAction().getId();
                lArray[n] = lArray[n] + 1L;
            }
        }

        public long collectPreTrace() {
            return this.numOfGenTraces.incrementAndGet();
        }

        public void collectNextRetries() {
        }

        public void collectPostTrace(TLCState s) {
            this.welfordM2AndMean.accumulateAndGet(Math.min(SimulationWorker.this.maxTraceDepth, s.getLevel()), (acc, tl) -> {
                int mean = (int)(acc & 0xFFFFFFFFL);
                long m2 = acc >>> 32;
                long delta = tl - (long)mean;
                mean = (int)((long)mean + delta / Math.max(this.numOfGenTraces.longValue(), 1L));
                return (m2 += delta * (tl - (long)mean)) << 32 | (long)mean & 0xFFFFFFFFL;
            });
        }

        public Value getTraceStatistics(TLCState s) {
            UniqueString[] n = new UniqueString[2];
            Value[] v = new Value[n.length];
            HashMap<UniqueString, IntValue> behaviorStats = new HashMap<UniqueString, IntValue>();
            while (s != null && !s.isInitial()) {
                behaviorStats.merge(s.getAction().getName(), IntValue.ValOne, IntValue::sum);
                s = s.getPredecessor();
            }
            n[0] = TLCGetSet.SPEC_ACTIONS;
            v[0] = new RecordValue(behaviorStats);
            n[1] = TLCGetSet.ID;
            v[1] = IntValue.narrowToIntValue(SimulationWorker.this.globalTraceCnt);
            return new RecordValue(n, v, false);
        }

        public Value getDistinctStates() {
            return IntValue.ValNegOne;
        }

        public Value getDistinctValues() {
            return IntValue.ValNegOne;
        }

        public Value getActions() {
            return RecordValue.EmptyRcd;
        }

        public Value getNextRetries() {
            return IntValue.ValNegOne;
        }
    }
}

