/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import java.util.function.BiPredicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefOrDeclNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolTable;
import tla2sany.st.TreeNode;
import tla2sany.xml.SymbolContext;
import tlc2.util.statistics.CountDistinct;
import tlc2.value.IValue;
import util.UniqueString;

public class OpDeclNode
extends OpDefOrDeclNode {
    private CountDistinct cd;

    public OpDeclNode(UniqueString us, int kind, int level, int arity, ModuleNode mn, SymbolTable symbolTable, TreeNode stn) {
        super(us, kind, arity, mn, symbolTable, stn);
        this.level = level;
        if (this.getKind() == 2) {
            this.levelParams.add(this);
            this.allParams.add(this);
        }
        this.levelChecked = 1;
        if (this.st != null) {
            this.st.addSymbol(us, this);
        }
    }

    @Override
    public final boolean isLocal() {
        return false;
    }

    @Override
    public final int getArity() {
        return this.arity;
    }

    @Override
    public final boolean match(OpApplNode oa, ModuleNode mn, Errors errors) {
        ExprOrOpArgNode[] args = oa.getArgs();
        if (args == null || this.arity != args.length) {
            errors.addError(ErrorCode.SUSPECTED_UNREACHABLE_CHECK, oa.getTreeNode().getLocation(), "Operator used with the wrong number of arguments.");
            return false;
        }
        return true;
    }

    @Override
    public final boolean levelCheck(int iter, Errors errors) {
        return true;
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        visitor.postVisit(this);
    }

    @Override
    public String getHumanReadableImage() {
        if (this.getKind() == 2) {
            return super.getName().toString() + " CONSTANT";
        }
        if (this.getKind() == 3) {
            return super.getName().toString() + " VARIABLE";
        }
        return super.getHumanReadableImage();
    }

    @Override
    public final String toString(int depth, Errors errors) {
        if (depth <= 0) {
            return "";
        }
        return "\n*OpDeclNode: " + String.valueOf(this.getName()) + "  " + super.toString(depth, errors) + "\n  originallyDefinedInModule: " + (this.originallyDefinedInModule != null ? this.originallyDefinedInModule.getName().toString() : "<null>");
    }

    @Override
    protected String getNodeRef() {
        return "OpDeclNodeRef";
    }

    @Override
    protected Element getSymbolElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        Element e = doc.createElement("OpDeclNode");
        e.appendChild(this.appendText(doc, "uniquename", this.getName().toString()));
        e.appendChild(this.appendText(doc, "arity", Integer.toString(this.getArity())));
        e.appendChild(this.appendText(doc, "kind", Integer.toString(this.getKind())));
        return e;
    }

    public OpDeclNode count(IValue v) {
        this.cd.add(v);
        return this;
    }

    public OpDeclNode setCountDistinct(CountDistinct cd) {
        this.cd = cd;
        return this;
    }

    public CountDistinct getCountDistinct() {
        return this.cd;
    }
}

