/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UsageGenerator {
    private static final String NAME = "NAME";
    private static final String SYNOPSIS = "SYNOPSIS";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String OPTIONS = "OPTIONS";
    private static final String TIPS = "TIPS";
    private static Comparator<Argument> NAME_COMPARATOR = new Comparator<Argument>(){

        @Override
        public int compare(Argument a, Argument b) {
            return a.getArgumentName().compareTo(b.getArgumentName());
        }
    };
    private static Comparator<Argument> NAME_DASH_COMPARATOR = new Comparator<Argument>(){

        @Override
        public int compare(Argument a, Argument b) {
            boolean bDash;
            boolean aDash = a.isDashArgument();
            if (aDash != (bDash = b.isDashArgument())) {
                return aDash ? -1 : 1;
            }
            return a.getArgumentName().compareTo(b.getArgumentName());
        }
    };

    public static void displayUsage(PrintStream ps, String commandName, String version, String commandShortSummary, String commandDescription, List<List<Argument>> commandVariants, List<String> tips, char valuedArgumentsSeparator) {
        String markedUpDescription;
        ps.println();
        ps.println(UsageGenerator.generateSectionHeader(NAME));
        ps.println("\t" + commandName + " - " + commandShortSummary + (String)(version != null ? " - " + version : "") + "\n\n");
        String boldName = UsageGenerator.markupWord(commandName, true);
        HashSet<Argument> arguments = new HashSet<Argument>();
        ps.println(UsageGenerator.generateSectionHeader(SYNOPSIS));
        for (List<Argument> variant : commandVariants) {
            ps.println("\t" + UsageGenerator.generateCommandForVariant(boldName, variant, arguments, valuedArgumentsSeparator));
        }
        ps.println();
        String commandNameRegex = commandName + "(\\)|\\s|$)";
        Pattern p = Pattern.compile(commandNameRegex);
        Matcher m = p.matcher(commandDescription);
        if (m.find()) {
            StringBuilder sb = new StringBuilder();
            if (m.start() > 0) {
                sb.append(commandDescription.substring(0, m.start()));
            }
            sb.append(boldName).append(m.group(1));
            int lastEnd = m.end();
            while (m.find()) {
                sb.append(commandDescription.substring(lastEnd, m.start())).append(boldName).append(m.group(1));
                lastEnd = m.end();
            }
            sb.append(commandDescription.substring(lastEnd, commandDescription.length()));
            markedUpDescription = sb.toString();
        } else {
            markedUpDescription = commandDescription;
        }
        ps.println(UsageGenerator.generateSectionHeader(DESCRIPTION));
        ps.println("\t" + markedUpDescription.replaceAll("(\\r\\n|\\r|\\n)", "\n\t"));
        ps.println();
        ArrayList<Argument> orderedArguments = new ArrayList<Argument>(arguments);
        Collections.sort(orderedArguments, NAME_COMPARATOR);
        ps.println(UsageGenerator.generateSectionHeader(OPTIONS));
        for (Argument arg : orderedArguments) {
            if (!arg.expectsValue() && !arg.isOptional() && (arg.expectsValue() || !arg.isDashArgument())) continue;
            ps.println(UsageGenerator.generateOptionText(arg, valuedArgumentsSeparator));
        }
        ps.println();
        if (tips != null && tips.size() > 0) {
            ps.println(UsageGenerator.generateSectionHeader(TIPS));
            for (String tip : tips) {
                ps.println("\t" + tip.replaceAll("(\\r\\n|\\r|\\n)", "\n\t") + "\n");
            }
        }
    }

    private static String generateCommandForVariant(String boldedCommandName, List<Argument> variant, HashSet<Argument> arguments, char valuedArgumentsSeparator) {
        ArrayList<Argument> optionalSingleDashValueless = new ArrayList<Argument>();
        ArrayList<Argument> optionalDoubleDashValueless = new ArrayList<Argument>();
        ArrayList<Argument> optionalValued = new ArrayList<Argument>();
        ArrayList<Argument> requiredValued = new ArrayList<Argument>();
        ArrayList<Argument> requiredValueless = new ArrayList<Argument>();
        for (Argument arg : variant) {
            if (arg.expectsValue()) {
                if (arg.isOptional()) {
                    optionalValued.add(arg);
                    continue;
                }
                requiredValued.add(arg);
                continue;
            }
            if (arg.isOptional()) {
                if (arg.isDashArgument()) {
                    optionalSingleDashValueless.add(arg);
                    continue;
                }
                if (!arg.isDashDashArgument()) continue;
                optionalDoubleDashValueless.add(arg);
                continue;
            }
            requiredValueless.add(arg);
        }
        Collections.sort(optionalSingleDashValueless, NAME_COMPARATOR);
        Collections.sort(optionalDoubleDashValueless, NAME_COMPARATOR);
        Collections.sort(optionalValued, NAME_COMPARATOR);
        Collections.sort(requiredValued, NAME_COMPARATOR);
        Collections.sort(requiredValueless, NAME_DASH_COMPARATOR);
        StringBuilder sb = new StringBuilder(boldedCommandName);
        if (optionalSingleDashValueless.size() > 0) {
            StringBuilder concatenation = new StringBuilder("-");
            ArrayList<Argument> nonShortArguments = new ArrayList<Argument>();
            for (Argument arg : optionalSingleDashValueless) {
                if (arg.isShortArgument()) {
                    concatenation.append(arg.getDashlessArgumentName());
                    continue;
                }
                nonShortArguments.add(arg);
            }
            if (concatenation.length() > 1) {
                sb.append(" [").append(UsageGenerator.markupWord(concatenation.toString(), true)).append(']');
            }
            for (Argument arg : nonShortArguments) {
                sb.append(" [").append(UsageGenerator.markupWord("-" + arg.getDashlessArgumentName(), true));
                if (arg.hasSubOptions()) {
                    sb.append(" [").append(arg.getSubOptions()).append("]");
                }
                sb.append(']');
            }
        }
        if (optionalDoubleDashValueless.size() > 0) {
            for (Argument arg : optionalDoubleDashValueless) {
                sb.append(" [").append(UsageGenerator.markupWord(arg.getArgumentName(), true));
                if (arg.hasSubOptions()) {
                    sb.append(" [").append(arg.getSubOptions()).append("]");
                }
                sb.append(']');
            }
        }
        if (optionalValued.size() > 0) {
            for (Argument arg : optionalValued) {
                sb.append(" [").append(UsageGenerator.markupWord(arg.getArgumentName(), true)).append(valuedArgumentsSeparator);
                if (arg.hasSubOptions()) {
                    sb.append("[").append(arg.getSubOptions()).append("] ");
                }
                sb.append(UsageGenerator.markupWord(arg.getSampleValue(), false)).append(']');
            }
        }
        if (requiredValued.size() > 0) {
            for (Argument arg : requiredValued) {
                sb.append(" ").append(UsageGenerator.markupWord(arg.getArgumentName(), true)).append(valuedArgumentsSeparator);
                sb.append(UsageGenerator.markupWord(arg.getSampleValue(), false));
            }
        }
        if (requiredValueless.size() > 0) {
            for (Argument arg : requiredValueless) {
                sb.append(" ").append(arg.getArgumentName());
                if (!arg.hasSubOptions()) continue;
                sb.append(" [").append(arg.getSubOptions()).append("]");
            }
        }
        arguments.addAll(variant);
        return sb.toString();
    }

    private static String generateOptionText(Argument argument, char valuedArgumentsSeparator) {
        StringBuilder sb = new StringBuilder("\t");
        sb.append(UsageGenerator.markupWord(argument.getArgumentName(), true));
        if (argument.expectsValue()) {
            sb.append(valuedArgumentsSeparator).append(UsageGenerator.markupWord(argument.getSampleValue(), false));
        }
        sb.append("\n\t\t").append(argument.getDescription().replaceAll("(\\r\\n|\\r|\\n)", "\n\t\t"));
        return sb.toString();
    }

    private static String generateSectionHeader(String title) {
        StringBuilder sb = new StringBuilder(UsageGenerator.markupWord(title, true));
        sb.append('\n');
        return sb.toString();
    }

    private static String markupWord(String word, boolean bold) {
        StringBuilder sb = new StringBuilder(bold ? "\u001b[1m" : "\u001b[3m");
        sb.append(word).append("\u001b[0m");
        return sb.toString();
    }

    public static class Argument {
        private final String argumentName;
        private final String sampleValue;
        private final String description;
        private final boolean optional;
        private final String subOptions;

        public Argument(String key, String optionDescription) {
            this(key, optionDescription, false);
        }

        public Argument(String key, String optionDescription, boolean isOptional) {
            this(key, null, optionDescription, isOptional);
        }

        public Argument(String key, String exampleValue, String optionDescription) {
            this(key, exampleValue, optionDescription, false);
        }

        public Argument(String key, String exampleValue, String optionDescription, boolean isOptional) {
            this(key, exampleValue, optionDescription, isOptional, null);
        }

        public Argument(String key, String exampleValue, String optionDescription, boolean isOptional, String concatenatedSuboptions) {
            this.argumentName = key;
            this.sampleValue = exampleValue;
            this.description = optionDescription;
            this.optional = isOptional;
            this.subOptions = concatenatedSuboptions;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean expectsValue() {
            return this.sampleValue != null;
        }

        public boolean isDashArgument() {
            return this.argumentName.startsWith("-") && !this.isDashDashArgument();
        }

        public boolean isDashDashArgument() {
            return this.argumentName.startsWith("--");
        }

        public boolean isShortArgument() {
            return this.isDashArgument() && this.argumentName.length() == 2 || this.argumentName.length() == 1;
        }

        public boolean hasSubOptions() {
            return this.subOptions != null;
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public String getDashlessArgumentName() {
            if (this.isDashArgument()) {
                return this.argumentName.substring(1);
            }
            return this.argumentName;
        }

        public String getSampleValue() {
            return this.sampleValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSubOptions() {
            return this.subOptions;
        }

        public int hashCode() {
            return Objects.hash(this.argumentName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Argument other = (Argument)obj;
            return Objects.equals(this.argumentName, other.argumentName);
        }
    }
}

