/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import tlc2.TLCGlobals;
import tlc2.tool.FingerprintException;
import tlc2.tool.coverage.CostModel;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.EnumerableValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueExcept;
import tlc2.value.impl.ValueVec;
import util.Assert;

public class UnionValue
extends EnumerableValue
implements Enumerable {
    public final Value set;
    protected SetEnumValue realSet;

    public UnionValue(Value set) {
        this.set = set;
        this.realSet = null;
    }

    public UnionValue(Value val, CostModel cm) {
        this(val);
        this.cm = cm;
    }

    @Override
    public byte getKind() {
        return 20;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            this.convertAndCache();
            return this.realSet.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            this.convertAndCache();
            return this.realSet.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean member(Value elem) {
        try {
            Value val;
            if (!(this.set instanceof Enumerable)) {
                Assert.fail("Attempted to check if:\n " + Values.ppr(elem.toString()) + "\nis an element of the non-enumerable set:\n " + Values.ppr(this.toString()), this.getSource());
            }
            ValueEnumeration Enum2 = ((Enumerable)((Object)this.set)).elements();
            do {
                if ((val = Enum2.nextElement()) != null) continue;
                return false;
            } while (!val.member(elem));
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean isFinite() {
        try {
            Value val;
            if (!(this.set instanceof Enumerable)) {
                Assert.fail("Attempted to check if the nonenumerable set:\n" + Values.ppr(this.toString()) + "\nis a finite set.", this.getSource());
            }
            ValueEnumeration Enum2 = ((Enumerable)((Object)this.set)).elements();
            do {
                if ((val = Enum2.nextElement()) != null) continue;
                return true;
            } while (val.isFinite());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT to the set:\n" + Values.ppr(this.toString()), this.getSource());
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT to the set:\n " + Values.ppr(this.toString()) + ".", this.getSource());
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            this.convertAndCache();
            return this.realSet.size();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        try {
            return this.realSet != null && this.realSet != SetEnumValue.DummyEnum && this.realSet.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            if (this.realSet != null && this.realSet != SetEnumValue.DummyEnum) {
                this.realSet.normalize();
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void deepNormalize() {
        try {
            this.set.deepNormalize();
            if (this.realSet == null) {
                this.realSet = SetEnumValue.DummyEnum;
            } else if (this.realSet != SetEnumValue.DummyEnum) {
                this.realSet.deepNormalize();
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            return this.set.isDefined();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    public static Value union(Value val) {
        boolean canCombine = val instanceof SetEnumValue;
        if (canCombine) {
            ValueVec elems = ((SetEnumValue)val).elems;
            int i = 0;
            while (i < elems.size()) {
                canCombine = canCombine && elems.elementAt(i) instanceof SetEnumValue;
                ++i;
            }
            if (canCombine) {
                ValueVec resElems = new ValueVec();
                SetEnumValue result = new SetEnumValue(resElems, false, val.getCostModel());
                int i2 = 0;
                while (i2 < elems.size()) {
                    ValueVec elems1 = ((SetEnumValue)elems.elementAt((int)i2)).elems;
                    int j = 0;
                    while (j < elems1.size()) {
                        Value elem = elems1.elementAt(j);
                        if (!((Value)result).member(elem)) {
                            resElems.addElement(elem);
                        }
                        ++j;
                    }
                    ++i2;
                }
                return result;
            }
        }
        return new UnionValue(val, val.getCostModel());
    }

    @Override
    public void write(IValueOutputStream vos) throws IOException {
        this.realSet.write(vos);
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.convertAndCache();
            return this.realSet.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            this.convertAndCache();
            return this.realSet.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    private final void convertAndCache() {
        if (this.realSet == null) {
            this.realSet = (SetEnumValue)this.toSetEnum();
        } else if (this.realSet == SetEnumValue.DummyEnum) {
            SetEnumValue val = (SetEnumValue)this.toSetEnum();
            val.deepNormalize();
            this.realSet = val;
        }
    }

    @Override
    public final Value toSetEnum() {
        Value elem;
        if (this.realSet != null && this.realSet != SetEnumValue.DummyEnum) {
            return this.realSet;
        }
        ValueVec vals = new ValueVec();
        ValueEnumeration Enum2 = this.elements();
        while ((elem = Enum2.nextElement()) != null) {
            vals.addElement(elem);
        }
        if (coverage) {
            this.cm.incSecondary(vals.size());
        }
        return new SetEnumValue(vals, false, this.cm);
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            if (TLCGlobals.expand) {
                Value val = this.toSetEnum();
                return val.toString(sb, offset, swallow);
            }
            sb = sb.append("UNION(");
            sb = this.set.toString(sb, offset, swallow);
            sb.append(")");
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            if (this.realSet == null || this.realSet == SetEnumValue.DummyEnum) {
                return new Enumerator();
            }
            return this.realSet.elements();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        ValueEnumeration Enum;
        Value elemSet;
        ValueEnumeration elemSetEnum;

        public Enumerator() {
            if (!(UnionValue.this.set instanceof Enumerable)) {
                Assert.fail("Attempted to enumerate the nonenumerable set:\n" + Values.ppr(this.toString()), UnionValue.this.getSource());
            }
            this.Enum = ((Enumerable)((Object)UnionValue.this.set)).elements();
            this.elemSet = this.Enum.nextElement();
            if (this.elemSet != null) {
                if (!(this.elemSet instanceof Enumerable)) {
                    Assert.fail("Attempted to enumerate UNION(s), but some element of s is nonenumerable.", UnionValue.this.getSource());
                }
                this.elemSetEnum = ((Enumerable)((Object)this.elemSet)).elements();
            }
        }

        @Override
        public final void reset() {
            this.Enum.reset();
            this.elemSet = this.Enum.nextElement();
            this.elemSetEnum = ((Enumerable)((Object)this.elemSet)).elements();
        }

        @Override
        public final Value nextElement() {
            if (this.elemSet == null) {
                return null;
            }
            Value val = this.elemSetEnum.nextElement();
            if (val == null) {
                this.elemSet = this.Enum.nextElement();
                if (this.elemSet == null) {
                    return null;
                }
                if (!(this.elemSet instanceof Enumerable)) {
                    Assert.fail("Attempted to enumerate the nonenumerable set:\n" + Values.ppr(this.elemSet.toString()) + "\nwhen enumerating:\n" + Values.ppr(this.toString()), UnionValue.this.getSource());
                }
                this.elemSetEnum = ((Enumerable)((Object)this.elemSet)).elements();
                val = this.nextElement();
            }
            if (coverage) {
                UnionValue.this.cm.incSecondary();
            }
            return val;
        }
    }
}

