/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Logger;
import javax.management.NotCompliantMBeanException;
import tlc2.output.MP;
import tlc2.tool.TLCTrace;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.FPSetStatistic;
import tlc2.tool.fp.management.DiskFPSetMXWrapper;
import tlc2.tool.management.TLCStandardMBean;
import tlc2.util.BufferedRandomAccessFile;
import tlc2.util.IdThread;
import util.Assert;
import util.FileUtil;

public abstract class DiskFPSet
extends FPSet
implements FPSetStatistic {
    protected static final Logger LOGGER = Logger.getLogger(DiskFPSet.class.getName());
    protected static final long MARK_FLUSHED = Long.MIN_VALUE;
    protected static final long FLUSHED_MASK = Long.MAX_VALUE;
    protected long maxTblCnt;
    protected String metadir;
    protected String fpFilename;
    protected String tmpFilename;
    protected long fileCnt;
    protected AtomicBoolean flusherChosen;
    protected LongAdder tblCnt;
    protected LongAdder tblLoad;
    protected long bucketsCapacity;
    protected BufferedRandomAccessFile[] braf;
    protected BufferedRandomAccessFile[] brafPool;
    protected int poolIndex;
    protected long[] index;
    protected LongAdder memHitCnt = new LongAdder();
    protected LongAdder diskHitCnt = new LongAdder();
    private LongAdder diskLookupCnt = new LongAdder();
    protected LongAdder diskWriteCnt = new LongAdder();
    private LongAdder diskSeekCnt = new LongAdder();
    private LongAdder diskSeekCache = new LongAdder();
    private int checkPointMark;
    protected int growDiskMark;
    protected static final int LogMaxLoad = 4;
    static final int InitialBucketCapacity = 16;
    public static final int NumEntriesPerPage = 1024;
    protected TLCStandardMBean diskFPSetMXWrapper;
    protected long flushTime = 0L;
    protected Flusher flusher;
    protected volatile boolean forceFlush = false;
    protected int currIndex;
    protected int counter;

    protected double getAuxiliaryStorageRequirement() {
        return 1.0;
    }

    protected DiskFPSet(FPSetConfiguration fpSetConfig) throws RemoteException {
        super(fpSetConfig);
        this.maxTblCnt = fpSetConfig.getMemoryInFingerprintCnt();
        if (this.maxTblCnt <= 0L) {
            throw new IllegalArgumentException("Negative or zero upper storage limit");
        }
        this.fileCnt = 0L;
        this.tblCnt = new LongAdder();
        this.tblLoad = new LongAdder();
        this.flusherChosen = new AtomicBoolean(false);
        this.index = null;
        try {
            this.diskFPSetMXWrapper = new DiskFPSetMXWrapper(this);
        }
        catch (NotCompliantMBeanException e) {
            MP.printWarning(1000, "Failed to create MBean wrapper for DiskFPSet. No statistics/metrics will be avaiable.", e);
            this.diskFPSetMXWrapper = TLCStandardMBean.getNullTLCStandardMBean();
        }
    }

    @Override
    public FPSet init(int numThreads, String aMetadir, String filename) throws IOException {
        String propMetaDirPrefix = System.getProperty(DiskFPSet.class.getName() + ".metadirPrefix");
        if (propMetaDirPrefix == null) {
            this.metadir = aMetadir;
        } else {
            File file = new File(aMetadir);
            if (file.isAbsolute()) {
                aMetadir = file.getName();
            }
            String folder = propMetaDirPrefix + File.separator + aMetadir;
            new File(folder).mkdirs();
            this.metadir = folder;
        }
        filename = this.metadir + FileUtil.separator + (String)filename;
        this.tmpFilename = (String)filename + ".tmp";
        this.fpFilename = (String)filename + ".fp";
        this.braf = new BufferedRandomAccessFile[numThreads];
        this.brafPool = new BufferedRandomAccessFile[5];
        this.poolIndex = 0;
        try {
            FileOutputStream f = new FileOutputStream(this.fpFilename);
            f.close();
            int i = 0;
            while (i < numThreads) {
                this.braf[i] = new BufferedRandomAccessFile(this.fpFilename, "r");
                ++i;
            }
            i = 0;
            while (i < this.brafPool.length) {
                this.brafPool[i] = new BufferedRandomAccessFile(this.fpFilename, "r");
                ++i;
            }
        }
        catch (IOException e) {
            String message = MP.getMessage(2167, new String[]{this.fpFilename, e.getMessage()});
            throw new IOException(message);
        }
        return this;
    }

    @Override
    public long size() {
        return this.getTblCnt() + this.fileCnt;
    }

    @Override
    public abstract long sizeof();

    public final void finalize() {
        int i = 0;
        while (i < this.braf.length) {
            try {
                this.braf[i].close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < this.brafPool.length) {
            try {
                this.brafPool[i].close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addThread() throws IOException {
        BufferedRandomAccessFile[] bufferedRandomAccessFileArray = this.braf;
        synchronized (this.braf) {
            int len = this.braf.length;
            BufferedRandomAccessFile[] nraf = new BufferedRandomAccessFile[len + 1];
            int i = 0;
            while (i < len) {
                nraf[i] = this.braf[i];
                ++i;
            }
            nraf[len] = new BufferedRandomAccessFile(this.fpFilename, "r");
            this.braf = nraf;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected boolean needsDiskFlush() {
        return this.getTblCnt() >= this.maxTblCnt || this.forceFlush;
    }

    protected long checkValid(long fp) {
        return fp;
    }

    abstract boolean memLookup(long var1);

    abstract boolean memInsert(long var1) throws IOException;

    abstract void acquireTblWriteLock();

    abstract void releaseTblWriteLock();

    final boolean diskLookup(long fp) throws IOException {
        if (this.index == null) {
            return false;
        }
        this.diskLookupCnt.increment();
        int indexLength = this.index.length;
        int loPage = 0;
        int hiPage = indexLength - 1;
        long loVal = this.index[loPage];
        long hiVal = this.index[hiPage];
        if (fp < loVal || fp > hiVal) {
            return false;
        }
        if (fp == hiVal) {
            return true;
        }
        double dfp = fp;
        while (loPage < hiPage - 1) {
            double dhi = hiPage;
            double dlo = loPage;
            double dloVal = loVal;
            double dhiVal = hiVal;
            int midPage = loPage + 1 + (int)((dhi - dlo - 1.0) * (dfp - dloVal) / (dhiVal - dloVal));
            if (midPage == hiPage) {
                --midPage;
            }
            Assert.check(loPage < midPage && midPage < hiPage, 2134);
            long v = this.index[midPage];
            if (fp < v) {
                hiPage = midPage;
                hiVal = v;
                continue;
            }
            if (fp > v) {
                loPage = midPage;
                loVal = v;
                continue;
            }
            return true;
        }
        return this.diskLookupBinarySearch(fp, indexLength, loPage, hiPage, loVal, hiVal, dfp);
    }

    private final boolean diskLookupBinarySearch(long fp, int indexLength, int loPage, int hiPage, long loVal, long hiVal, double dfp) throws IOException {
        Assert.check(hiPage == loPage + 1, 2134);
        boolean diskHit = false;
        long midEntry = -1L;
        long loEntry = (long)loPage * 1024L;
        long hiEntry = loPage == indexLength - 2 ? this.fileCnt - 1L : (long)hiPage * 1024L;
        try {
            int id = IdThread.GetId(this.braf.length);
            BufferedRandomAccessFile raf = id < this.braf.length ? this.braf[id] : this.poolOpen();
            while (loEntry < hiEntry) {
                midEntry = this.calculateMidEntry(loVal, hiVal, dfp, loEntry, hiEntry);
                Assert.check(loEntry <= midEntry && midEntry < hiEntry, 2134);
                if (raf.seeek(midEntry * 8L)) {
                    this.diskSeekCnt.increment();
                } else {
                    this.diskSeekCache.increment();
                }
                long v = raf.readLong();
                if (fp < v) {
                    hiEntry = midEntry;
                    hiVal = v;
                    continue;
                }
                if (fp > v) {
                    loEntry = midEntry + 1L;
                    loVal = v;
                    continue;
                }
                diskHit = true;
                break;
            }
            if (id >= this.braf.length) {
                this.poolClose(raf);
            }
        }
        catch (IOException e) {
            if (midEntry * 8L < 0L) {
                MP.printError(1000, new String[]{"looking up a fingerprint, and\nmidEntry turned negative (loEntry, midEntry, hiEntry, loVal, hiVal): ", Long.toString(loEntry) + " ", Long.toString(midEntry) + " ", Long.toString(hiEntry) + " ", Long.toString(loVal) + " ", Long.toString(hiVal)}, (Throwable)e);
            }
            MP.printError(2129, e);
            throw e;
        }
        return diskHit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BufferedRandomAccessFile poolOpen() throws IOException {
        BufferedRandomAccessFile[] bufferedRandomAccessFileArray = this.brafPool;
        synchronized (this.brafPool) {
            if (this.poolIndex < this.brafPool.length) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.brafPool[this.poolIndex++];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new BufferedRandomAccessFile(this.fpFilename, "r");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void poolClose(BufferedRandomAccessFile raf) throws IOException {
        BufferedRandomAccessFile[] bufferedRandomAccessFileArray = this.brafPool;
        synchronized (this.brafPool) {
            if (this.poolIndex > 0) {
                this.brafPool[--this.poolIndex] = raf;
            } else {
                raf.close();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    long calculateMidEntry(long loVal, long hiVal, double dfp, long loEntry, long hiEntry) {
        double dhi = hiEntry;
        double dlo = loEntry;
        double dloVal = loVal;
        double dhiVal = hiVal;
        long midEntry = loEntry + (long)((dhi - dlo) * (dfp - dloVal) / (dhiVal - dloVal));
        if (midEntry == hiEntry) {
            --midEntry;
        }
        return midEntry;
    }

    protected final void writeFP(RandomAccessFile outRAF, long fp) throws IOException {
        outRAF.writeLong(fp);
        this.diskWriteCnt.increment();
        if (this.counter == 0) {
            this.index[this.currIndex++] = fp;
            this.counter = 1024;
        }
        --this.counter;
    }

    protected int calculateIndexLen(long buffLen) {
        long indexLen = (this.fileCnt + buffLen - 1L) / 1024L + 2L;
        Assert.check(indexLen > 0L, 1000);
        return (int)indexLen;
    }

    @Override
    public final void close() {
        this.diskFPSetMXWrapper.unregister();
        int i = 0;
        while (i < this.braf.length) {
            try {
                this.braf[i].close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < this.brafPool.length) {
            try {
                this.brafPool[i].close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        this.poolIndex = 0;
    }

    @Override
    public void exit(boolean cleanup) throws IOException {
        super.exit(cleanup);
        if (cleanup) {
            FileUtil.deleteDir(this.metadir, true);
        }
        String hostname = InetAddress.getLocalHost().getHostName();
        MP.printMessage(2211, hostname);
        System.exit(0);
    }

    @Override
    public long checkFPs() throws IOException {
        this.acquireTblWriteLock();
        this.flusher.flushTable();
        this.releaseTblWriteLock();
        BufferedRandomAccessFile braf = new BufferedRandomAccessFile(this.fpFilename, "r");
        long fileLen = ((RandomAccessFile)braf).length();
        long dis = Long.MAX_VALUE;
        if (fileLen > 0L) {
            long x = braf.readLong();
            while (((RandomAccessFile)braf).getFilePointer() < fileLen) {
                long y = braf.readLong();
                long dis1 = y - x;
                if (dis1 >= 0L) {
                    dis = Math.min(dis, dis1);
                }
                x = y;
            }
        }
        ((RandomAccessFile)braf).close();
        return dis;
    }

    @Override
    public void beginChkpt(String fname) throws IOException {
        this.flusherChosen.set(true);
        this.acquireTblWriteLock();
        this.flusher.flushTable();
        FileUtil.copyFile(this.fpFilename, this.getChkptName(fname, "tmp"));
        ++this.checkPointMark;
        this.releaseTblWriteLock();
        this.flusherChosen.set(false);
    }

    @Override
    public void commitChkpt(String fname) throws IOException {
        File oldChkpt = new File(this.getChkptName(fname, "chkpt"));
        File newChkpt = new File(this.getChkptName(fname, "tmp"));
        if (!newChkpt.renameTo(oldChkpt)) {
            throw new IOException("DiskFPSet.commitChkpt: cannot delete " + String.valueOf(oldChkpt));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void recover(String fname) throws IOException {
        chkptRAF = new BufferedRandomAccessFile(this.getChkptName(fname, "chkpt"), "r");
        currRAF = new BufferedRandomAccessFile(this.fpFilename, "rw");
        this.fileCnt = chkptRAF.length() / 8L;
        indexLen = (int)((this.fileCnt - 1L) / 1024L) + 2;
        this.index = new long[indexLen];
        this.currIndex = 0;
        this.counter = 0;
        fp = 0L;
        try {
            predecessor = -9223372036854775808L;
            while (true) {
                fp = chkptRAF.readLong();
                this.writeFP(currRAF, fp);
                Assert.check(predecessor < fp, 2134);
                predecessor = fp;
            }
        }
        catch (EOFException e) {
            Assert.check(this.currIndex == indexLen - 1, 2134);
            this.index[indexLen - 1] = fp;
            chkptRAF.close();
            currRAF.close();
            i = 0;
            ** while (i < this.braf.length)
        }
lbl-1000:
        // 1 sources

        {
            this.braf[i].close();
            this.braf[i] = new BufferedRandomAccessFile(this.fpFilename, "r");
            ++i;
            continue;
        }
lbl28:
        // 1 sources

        i = 0;
        while (i < this.brafPool.length) {
            this.brafPool[i].close();
            this.brafPool[i] = new BufferedRandomAccessFile(this.fpFilename, "r");
            ++i;
        }
        this.poolIndex = 0;
    }

    @Override
    public final void beginChkpt() throws IOException {
    }

    @Override
    public final void commitChkpt() throws IOException {
    }

    @Override
    public final void recoverFP(long fp) throws IOException {
        boolean unique;
        long fp0 = fp & Long.MAX_VALUE;
        boolean bl = unique = !this.memInsert(fp0);
        if (!unique) {
            if (!Boolean.getBoolean(DiskFPSet.class.getName() + ".error2warning")) {
                Assert.fail(2126, "");
            }
            MP.printWarning(2126, String.format("Encountered duplicate fingerprint value %s", Long.toString(fp0)));
        }
        if (this.needsDiskFlush()) {
            this.flusher.flushTable();
        }
    }

    @Override
    public final void recover(TLCTrace trace) throws IOException {
        TLCTrace.Enumerator elements = trace.elements();
        while (elements.nextPos() != -1L) {
            long fp = elements.nextFP();
            this.recoverFP(fp);
        }
        elements.close();
    }

    private String getChkptName(String fname, String name) {
        return this.metadir + FileUtil.separator + fname + ".fp." + name;
    }

    @Override
    public boolean checkInvariant() throws IOException {
        this.acquireTblWriteLock();
        this.flusher.flushTable();
        BufferedRandomAccessFile braf = new BufferedRandomAccessFile(this.fpFilename, "r");
        try {
            long fileLen = ((RandomAccessFile)braf).length();
            long predecessor = Long.MIN_VALUE;
            if (fileLen > 0L) {
                while (((RandomAccessFile)braf).getFilePointer() < fileLen) {
                    long l = braf.readLong();
                    if (predecessor >= l) {
                        return false;
                    }
                    predecessor = l;
                }
            }
        }
        finally {
            ((RandomAccessFile)braf).close();
            this.releaseTblWriteLock();
        }
        return true;
    }

    @Override
    public boolean checkInvariant(long expectedFPCnt) throws IOException {
        return this.checkInvariant() && this.size() == expectedFPCnt;
    }

    @Override
    public long getBucketCapacity() {
        return this.bucketsCapacity;
    }

    @Override
    public long getTblCapacity() {
        return -1L;
    }

    @Override
    public long getIndexCapacity() {
        if (this.index == null) {
            return 0L;
        }
        return this.index.length;
    }

    @Override
    public long getOverallCapacity() {
        return this.getBucketCapacity() + this.getTblCapacity() + this.getIndexCapacity();
    }

    @Override
    public long getTblLoad() {
        return this.tblLoad.sum();
    }

    @Override
    public long getTblCnt() {
        return this.tblCnt.sum();
    }

    @Override
    public long getMaxTblCnt() {
        return this.maxTblCnt;
    }

    @Override
    public long getFileCnt() {
        return this.fileCnt;
    }

    @Override
    public long getDiskLookupCnt() {
        return this.diskLookupCnt.sum();
    }

    @Override
    public long getMemHitCnt() {
        return this.memHitCnt.sum();
    }

    @Override
    public long getDiskHitCnt() {
        return this.diskHitCnt.sum();
    }

    @Override
    public long getDiskWriteCnt() {
        return this.diskWriteCnt.sum();
    }

    @Override
    public long getDiskSeekCnt() {
        return this.diskSeekCnt.sum();
    }

    @Override
    public long getDiskSeekCache() {
        return this.diskSeekCache.sum();
    }

    @Override
    public int getGrowDiskMark() {
        return this.growDiskMark;
    }

    @Override
    public int getCheckPointMark() {
        return this.checkPointMark;
    }

    @Override
    public long getFlushTime() {
        return this.flushTime;
    }

    @Override
    public void forceFlush() {
        this.forceFlush = true;
    }

    @Override
    public int getLockCnt() {
        return 0;
    }

    @Override
    public int getReaderWriterCnt() {
        return this.braf.length + this.brafPool.length;
    }

    @Override
    public double getLoadFactor() {
        return (double)this.getTblCnt() / (double)this.maxTblCnt;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean checkFile(BufferedRandomAccessFile braf, long[] index, long elements) throws IOException {
        block3: {
            fileLen = braf.length();
            if (fileLen / 8L != elements) {
                return false;
            }
            ptr = braf.getFilePointer();
            predecessor = -9223372036854775808L;
            if (fileLen <= 0L) break block3;
            predecessor = braf.readLong();
            if (predecessor == index[0]) ** GOTO lbl14
            return false;
lbl-1000:
            // 1 sources

            {
                l = braf.readLong();
                if (predecessor >= l) {
                    return false;
                }
                predecessor = l;
lbl14:
                // 2 sources

                ** while (braf.getFilePointer() < fileLen)
            }
        }
        braf.seek(ptr);
        return predecessor == index[index.length - 1];
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 1 && !args[0].equals("")) {
            BufferedRandomAccessFile braf = new BufferedRandomAccessFile(new File(args[0]), "r");
            long elements = braf.length() / 8L;
            DecimalFormat df = new DecimalFormat("###,###.###");
            System.out.println(String.format("About to scan %s elements.", df.format(elements)));
            long elem = 0L;
            long i = 0L;
            while (i < elements) {
                long l = braf.readLong();
                if (l < elem) {
                    System.err.println(String.format("Inconsistent elements %s at pos %s < %s at pos %s.", elem, i - 1L, l, i));
                }
                elem = l;
                if (i > 0L && i % 100000000L == 0L) {
                    System.out.println(String.format("Scanned %s elements.", df.format(i)));
                }
                ++i;
            }
        } else if (args.length == 2 && !args[0].equals("") && !args[1].equals("")) {
            BufferedRandomAccessFile superset = new BufferedRandomAccessFile(new File(args[0]), "r");
            BufferedRandomAccessFile subset = new BufferedRandomAccessFile(new File(args[1]), "r");
            long elements = subset.length() / 8L;
            long fileLen = superset.length();
            long i = 0L;
            while (i < elements) {
                block10: {
                    long l = subset.readLong();
                    while (superset.getFilePointer() < fileLen) {
                        long m = superset.readLong();
                        if (l != m) {
                            if (m <= l) continue;
                            System.err.println(String.format("Inconsistent element in superset %s not in superset at pos %s.", m, superset.getFilePointer()));
                            continue;
                        }
                        break block10;
                    }
                    System.err.println(String.format("Element in subset %s not in superset at pos %s.", l, subset.getFilePointer()));
                }
                ++i;
            }
            System.out.println("Finished scanning files.");
        } else {
            System.err.println("Usage: DiskFPSet file.fp OR superset.fp subset.fp");
            System.exit(1);
        }
    }

    public abstract class Flusher {
        protected void prepareTable() {
        }

        void flushTable() throws IOException {
            if (DiskFPSet.this.getTblCnt() == 0L) {
                return;
            }
            this.prepareTable();
            try {
                this.mergeNewEntries();
            }
            catch (IOException e) {
                String msg = "Error: merging entries into file " + DiskFPSet.this.fpFilename + "  " + String.valueOf(e);
                throw new IOException(msg);
            }
            DiskFPSet.this.tblCnt.reset();
            DiskFPSet.this.bucketsCapacity = 0L;
            DiskFPSet.this.tblLoad.reset();
        }

        protected void mergeNewEntries() throws IOException {
            int i = 0;
            while (i < DiskFPSet.this.braf.length) {
                DiskFPSet.this.braf[i].seek(0L);
                ++i;
            }
            i = 0;
            while (i < DiskFPSet.this.brafPool.length) {
                DiskFPSet.this.brafPool[i].close();
                ++i;
            }
            File tmpFile = new File(DiskFPSet.this.tmpFilename);
            tmpFile.delete();
            BufferedRandomAccessFile tmpRAF = new BufferedRandomAccessFile(tmpFile, "rw");
            tmpRAF.setLength((DiskFPSet.this.getTblCnt() + DiskFPSet.this.fileCnt) * 8L);
            this.mergeNewEntries(DiskFPSet.this.braf, tmpRAF);
            int i2 = 0;
            while (i2 < DiskFPSet.this.braf.length) {
                DiskFPSet.this.braf[i2].close();
                ++i2;
            }
            tmpRAF.close();
            try {
                FileUtil.replaceFile(DiskFPSet.this.tmpFilename, DiskFPSet.this.fpFilename);
            }
            catch (IOException e) {
                Assert.fail(2160, e);
            }
            i = 0;
            while (i < DiskFPSet.this.braf.length) {
                DiskFPSet.this.braf[i] = new BufferedRandomAccessFile(DiskFPSet.this.fpFilename, "r");
                ++i;
            }
            i = 0;
            while (i < DiskFPSet.this.brafPool.length) {
                DiskFPSet.this.brafPool[i] = new BufferedRandomAccessFile(DiskFPSet.this.fpFilename, "r");
                ++i;
            }
            assert (DiskFPSet.checkFile(DiskFPSet.this.braf[0], DiskFPSet.this.index, DiskFPSet.this.fileCnt));
            DiskFPSet.this.poolIndex = 0;
        }

        protected abstract void mergeNewEntries(BufferedRandomAccessFile[] var1, BufferedRandomAccessFile var2) throws IOException;
    }
}

