/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.AssumeNode;
import tla2sany.semantic.AssumeProveNode;
import tla2sany.semantic.Context;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.InstanceNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolMatcher;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.SymbolTable;
import tla2sany.semantic.TheoremNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import tla2sany.xml.SymbolContext;
import util.UniqueString;
import util.WrongInvocationException;

public class ModuleNode
extends SymbolNode {
    private final Context ctxt;
    private ModuleNode[] extendees = new ModuleNode[0];
    private HashMap<Boolean, HashSet<ModuleNode>> depthAllExtendeesMap = new HashMap();
    private OpDeclNode[] constantDecls = null;
    private OpDeclNode[] variableDecls = null;
    private ArrayList<SemanticNode> definitions = new ArrayList();
    final Vector<OpDefNode> recursiveDecls = new Vector(8);
    final Vector<OpDefNode> opDefsInRecursiveSection = new Vector(16);
    int nestingLevel;
    private OpDefNode[] opDefs = null;
    private ThmOrAssumpDefNode[] thmOrAssDefs = null;
    private ModuleNode[] modDefs = null;
    private InstanceNode[] instantiations = null;
    private AssumeNode[] assumptions = null;
    private TheoremNode[] theorems = null;
    private LevelNode[] topLevel = null;
    private boolean isInstantiated = false;
    private boolean isStandard = false;
    private final Vector<AssumeNode> assumptionVec = new Vector();
    private final Vector<TheoremNode> theoremVec = new Vector();
    private final Vector<InstanceNode> instanceVec = new Vector();
    private final Vector<SemanticNode> topLevelVec = new Vector();
    private final Vector<OpApplNode> recordVec = new Vector();
    final Vector<OpDefNode> recursiveOpDefNodes = new Vector();
    private SemanticNode[] children = null;

    public ModuleNode(UniqueString us, Context ct, TreeNode stn) {
        super(1, stn, us);
        this.ctxt = ct;
    }

    @Override
    public final int getArity() {
        return -2;
    }

    public final SymbolTable getSymbolTable() {
        return null;
    }

    public final Context getContext() {
        return this.ctxt;
    }

    @Override
    public final boolean isLocal() {
        return false;
    }

    final boolean isParameterFree() {
        return this.getConstantDecls().length == 0 && this.getVariableDecls().length == 0;
    }

    public List<SemanticNode> getDefinitions() {
        return this.definitions;
    }

    public final void createExtendeeArray(Vector<ModuleNode> extendeeVec) {
        this.extendees = new ModuleNode[extendeeVec.size()];
        int i = 0;
        while (i < this.extendees.length) {
            this.extendees[i] = extendeeVec.elementAt(i);
            ++i;
        }
    }

    public final OpDeclNode[] getConstantDecls() {
        if (this.constantDecls != null) {
            return this.constantDecls;
        }
        Vector<OpDeclNode> contextVec = this.ctxt.getConstantDecls();
        this.constantDecls = new OpDeclNode[contextVec.size()];
        int i = 0;
        int j = this.constantDecls.length - 1;
        while (i < this.constantDecls.length) {
            this.constantDecls[j--] = contextVec.elementAt(i);
            ++i;
        }
        return this.constantDecls;
    }

    public final OpDeclNode[] getVariableDecls() {
        if (this.variableDecls != null) {
            return this.variableDecls;
        }
        Vector<OpDeclNode> contextVec = this.ctxt.getVariableDecls();
        this.variableDecls = new OpDeclNode[contextVec.size()];
        int i = 0;
        int j = this.variableDecls.length - 1;
        while (i < this.variableDecls.length) {
            this.variableDecls[j--] = contextVec.elementAt(i);
            ++i;
        }
        return this.variableDecls;
    }

    public final OpDefNode[] getOpDefs() {
        if (this.opDefs != null) {
            return this.opDefs;
        }
        Vector<OpDefNode> contextVec = this.ctxt.getOpDefs();
        this.opDefs = new OpDefNode[contextVec.size()];
        int i = 0;
        int j = this.opDefs.length - 1;
        while (i < this.opDefs.length) {
            this.opDefs[j--] = contextVec.elementAt(i);
            ++i;
        }
        return this.opDefs;
    }

    public final OpDefNode getOpDef(String name) {
        return this.getOpDef(UniqueString.uniqueStringOf(name));
    }

    public final OpDefNode getOpDef(UniqueString name) {
        return Stream.of(this.getOpDefs()).filter(o -> o.getName().equals(name)).findFirst().orElse(null);
    }

    public final ThmOrAssumpDefNode[] getThmOrAssDefs() {
        if (this.thmOrAssDefs != null) {
            return this.thmOrAssDefs;
        }
        Vector<ThmOrAssumpDefNode> contextVec = this.ctxt.getThmOrAssDefs();
        this.thmOrAssDefs = new ThmOrAssumpDefNode[contextVec.size()];
        int i = 0;
        int j = this.thmOrAssDefs.length - 1;
        while (i < this.thmOrAssDefs.length) {
            this.thmOrAssDefs[j--] = contextVec.elementAt(i);
            ++i;
        }
        return this.thmOrAssDefs;
    }

    public final void appendDef(SemanticNode s) {
        this.definitions.add(s);
    }

    public final InstanceNode[] getInstances() {
        if (this.instantiations != null) {
            return this.instantiations;
        }
        this.instantiations = new InstanceNode[this.instanceVec.size()];
        int i = 0;
        while (i < this.instantiations.length) {
            this.instantiations[i] = this.instanceVec.elementAt(i);
            ++i;
        }
        return this.instantiations;
    }

    public final void appendInstance(InstanceNode s) {
        this.instanceVec.addElement(s);
        this.topLevelVec.addElement(s);
    }

    public final ModuleNode[] getInnerModules() {
        if (this.modDefs != null) {
            return this.modDefs;
        }
        Vector<ModuleNode> v = this.ctxt.getModDefs();
        this.modDefs = new ModuleNode[v.size()];
        int i = 0;
        while (i < this.modDefs.length) {
            this.modDefs[i] = v.elementAt(i);
            ++i;
        }
        return this.modDefs;
    }

    public final OpApplNode[] getRecords() {
        OpApplNode[] records = new OpApplNode[this.recordVec.size()];
        int i = 0;
        while (i < this.recordVec.size()) {
            records[i] = this.recordVec.elementAt(i);
            ++i;
        }
        return records;
    }

    public final AssumeNode[] getAssumptions() {
        if (this.assumptions != null) {
            return this.assumptions;
        }
        this.assumptions = new AssumeNode[this.assumptionVec.size()];
        int i = 0;
        while (i < this.assumptions.length) {
            this.assumptions[i] = this.assumptionVec.elementAt(i);
            ++i;
        }
        return this.assumptions;
    }

    public final TheoremNode[] getTheorems() {
        if (this.theorems != null) {
            return this.theorems;
        }
        this.theorems = new TheoremNode[this.theoremVec.size()];
        int i = 0;
        while (i < this.theorems.length) {
            this.theorems[i] = this.theoremVec.elementAt(i);
            ++i;
        }
        return this.theorems;
    }

    public final LevelNode[] getTopLevel() {
        if (this.topLevel != null) {
            return this.topLevel;
        }
        this.topLevel = new LevelNode[this.topLevelVec.size()];
        int i = 0;
        while (i < this.topLevel.length) {
            this.topLevel[i] = (LevelNode)this.topLevelVec.elementAt(i);
            ++i;
        }
        return this.topLevel;
    }

    public String generateUnusedName(String pattern) {
        long suffix;
        Context definedNames = this.getContext();
        String unusedName = null;
        do {
            suffix = System.currentTimeMillis();
        } while (definedNames.occurSymbol(unusedName = String.format(pattern, Long.toString(suffix))));
        return unusedName;
    }

    public boolean isInstantiated() {
        return this.isInstantiated;
    }

    public void setInstantiated(boolean isInstantiated) {
        this.isInstantiated = isInstantiated;
    }

    public boolean isStandard() {
        return this.isStandard;
    }

    public void setStandard(boolean isStandard) {
        this.isStandard = isStandard;
    }

    final OpApplNode addRecord(OpApplNode r) {
        this.recordVec.addElement(r);
        return r;
    }

    final void addAssumption(TreeNode stn, ExprNode ass, SymbolTable st, ThmOrAssumpDefNode tadn) {
        AssumeNode an = new AssumeNode(stn, ass, this, tadn);
        this.assumptionVec.addElement(an);
        this.topLevelVec.addElement(an);
    }

    final void addTheorem(TreeNode stn, LevelNode thm, ProofNode pf, ThmOrAssumpDefNode tadn) {
        TheoremNode tn = new TheoremNode(stn, thm, this, pf, tadn);
        this.theoremVec.addElement(tn);
        this.topLevelVec.addElement(tn);
    }

    final void addTopLevel(LevelNode nd) {
        this.topLevelVec.addElement(nd);
    }

    final void copyAssumes(ModuleNode extendee) {
        int i = 0;
        while (i < extendee.assumptionVec.size()) {
            AssumeNode assume = extendee.assumptionVec.elementAt(i);
            this.assumptionVec.addElement(assume);
            ++i;
        }
    }

    final void copyTheorems(ModuleNode extendee) {
        int i = 0;
        while (i < extendee.theoremVec.size()) {
            TheoremNode theorem = extendee.theoremVec.elementAt(i);
            this.theoremVec.addElement(theorem);
            ++i;
        }
    }

    final void copyTopLevel(ModuleNode extendee) {
        int i = 0;
        while (i < extendee.topLevelVec.size()) {
            LevelNode node = (LevelNode)extendee.topLevelVec.elementAt(i);
            this.topLevelVec.addElement(node);
            ++i;
        }
    }

    public final HashSet<ModuleNode> getExtendedModuleSet() {
        return this.getExtendedModuleSet(true);
    }

    public final HashSet<ModuleNode> getExtendedModuleSet(boolean recursively) {
        Boolean key = recursively;
        HashSet<ModuleNode> extendeesSet = this.depthAllExtendeesMap.get(key);
        if (extendeesSet == null) {
            extendeesSet = new HashSet();
            int i = 0;
            while (i < this.extendees.length) {
                extendeesSet.add(this.extendees[i]);
                if (recursively) {
                    extendeesSet.addAll(this.extendees[i].getExtendedModuleSet(true));
                }
                ++i;
            }
            this.depthAllExtendeesMap.put(key, extendeesSet);
        }
        return extendeesSet;
    }

    public boolean extendsModule(ModuleNode mod) {
        return this.getExtendedModuleSet().contains(mod);
    }

    @Override
    public final boolean match(OpApplNode sn, ModuleNode mn, Errors errors) {
        return false;
    }

    public final TheoremNode[] getThms() {
        return null;
    }

    public final AssumeProveNode[] getAssumes() {
        return null;
    }

    @Override
    public final boolean levelCheck(int itr, Errors errors) {
        int i;
        if (this.levelChecked >= itr) {
            return this.levelCorrect;
        }
        this.levelChecked = itr;
        int firstInSectIdx = 0;
        while (firstInSectIdx < this.opDefsInRecursiveSection.size()) {
            int curNodeIdx = firstInSectIdx;
            OpDefNode curNode = this.opDefsInRecursiveSection.elementAt(curNodeIdx);
            int curSection = curNode.recursiveSection;
            boolean notDone = true;
            while (notDone) {
                if (curNode.inRecursive) {
                    curNode.levelChecked = 1;
                    i = 0;
                    while (i < curNode.getArity()) {
                        curNode.maxLevels[i] = 2;
                        curNode.weights[i] = 1;
                        ++i;
                    }
                } else {
                    curNode.levelChecked = 0;
                }
                if (++curNodeIdx < this.opDefsInRecursiveSection.size()) {
                    curNode = this.opDefsInRecursiveSection.elementAt(curNodeIdx);
                    notDone = curNode.recursiveSection == curSection;
                    continue;
                }
                notDone = false;
            }
            int maxRecursiveLevel = 0;
            HashSet recursiveLevelParams = new HashSet();
            HashSet recursiveAllParams = new HashSet();
            int i2 = firstInSectIdx;
            while (i2 < curNodeIdx) {
                curNode = this.opDefsInRecursiveSection.elementAt(i2);
                if (curNode.inRecursive) {
                    curNode.levelChecked = 0;
                }
                curNode.levelCheck(1, errors);
                if (curNode.inRecursive) {
                    int j = 0;
                    while (j < curNode.getArity()) {
                        if (curNode.maxLevels[j] < 2) {
                            errors.addError(ErrorCode.RECURSIVE_OPERATOR_PRIMES_PARAMETER, curNode.getTreeNode().getLocation(), "Argument " + (j + 1) + " of recursive operator " + String.valueOf(curNode.getName()) + " is primed");
                        }
                        ++j;
                    }
                    maxRecursiveLevel = Math.max(maxRecursiveLevel, curNode.level);
                    recursiveLevelParams.addAll(curNode.levelParams);
                    recursiveAllParams.addAll(curNode.allParams);
                }
                ++i2;
            }
            i2 = firstInSectIdx;
            while (i2 < curNodeIdx) {
                curNode = this.opDefsInRecursiveSection.elementAt(i2);
                if (curNode.inRecursive) {
                    curNode.levelChecked = 2;
                }
                curNode.level = Math.max(curNode.level, maxRecursiveLevel);
                curNode.levelParams.addAll(recursiveLevelParams);
                curNode.allParams.addAll(recursiveAllParams);
                ++i2;
            }
            i2 = firstInSectIdx;
            while (i2 < curNodeIdx) {
                curNode = this.opDefsInRecursiveSection.elementAt(i2);
                if (curNode.inRecursive) {
                    curNode.levelChecked = 1;
                }
                curNode.levelCheck(2, errors);
                ++i2;
            }
            firstInSectIdx = curNodeIdx;
        }
        this.levelCorrect = true;
        ModuleNode[] mods = this.getInnerModules();
        int i3 = 0;
        while (i3 < mods.length) {
            if (!mods[i3].levelCheck(1, errors)) {
                this.levelCorrect = false;
            }
            ++i3;
        }
        OpDefNode[] opDefs = this.getOpDefs();
        int i4 = 0;
        while (i4 < opDefs.length) {
            if (!opDefs[i4].levelCheck(1, errors)) {
                this.levelCorrect = false;
            }
            ++i4;
        }
        this.thmOrAssDefs = this.getThmOrAssDefs();
        i4 = 0;
        while (i4 < this.thmOrAssDefs.length) {
            if (!this.thmOrAssDefs[i4].levelCheck(1, errors)) {
                this.levelCorrect = false;
            }
            ++i4;
        }
        LevelNode[] tpLev = this.getTopLevel();
        int i5 = 0;
        while (i5 < tpLev.length) {
            if (!tpLev[i5].levelCheck(1, errors)) {
                this.levelCorrect = false;
            }
            ++i5;
        }
        OpDeclNode[] decls = this.getConstantDecls();
        i = 0;
        while (i < decls.length) {
            this.levelParams.add(decls[i]);
            this.allParams.add(decls[i]);
            ++i;
        }
        if (!this.isConstant(errors)) {
            i = 0;
            while (i < decls.length) {
                this.levelConstraints.put(decls[i], Levels[0]);
                ++i;
            }
        }
        i = 0;
        while (i < opDefs.length) {
            this.levelConstraints.putAll(opDefs[i].getLevelConstraints());
            this.argLevelConstraints.putAll(opDefs[i].getArgLevelConstraints());
            for (ArgLevelParam alp : opDefs[i].getArgLevelParams()) {
                if (alp.occur(opDefs[i].getParams())) continue;
                this.argLevelParams.add(alp);
            }
            ++i;
        }
        i = 0;
        while (i < tpLev.length) {
            this.levelConstraints.putAll(tpLev[i].getLevelConstraints());
            this.argLevelConstraints.putAll(tpLev[i].getArgLevelConstraints());
            this.argLevelParams.addAll(tpLev[i].getArgLevelParams());
            ++i;
        }
        return this.levelCorrect;
    }

    @Override
    public final int getLevel() {
        throw new WrongInvocationException("Internal Error: Should never call ModuleNode.getLevel()");
    }

    public final boolean isConstant(Errors errors) {
        if (this.getVariableDecls().length > 0) {
            return false;
        }
        this.levelCheck(1, errors);
        OpDefNode[] opDefs = this.getOpDefs();
        int i = 0;
        while (i < opDefs.length) {
            if (opDefs[i].getKind() != 6 && opDefs[i].getBody().getLevel() != 0) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.theoremVec.size()) {
            if (this.theoremVec.elementAt(i).getLevel() != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Collection<SymbolNode> getSymbols(SymbolMatcher symbolMatcher) {
        ArrayList<SymbolNode> result = new ArrayList<SymbolNode>();
        Enumeration<Context.Pair> content = this.ctxt.content();
        while (content.hasMoreElements()) {
            SymbolNode aSymbol = content.nextElement().getSymbol();
            if (!symbolMatcher.matches(aSymbol)) continue;
            result.add(aSymbol);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public final String levelDataToString() {
        return "LevelParams: " + String.valueOf(this.getLevelParams()) + "\nLevelConstraints: " + String.valueOf(this.getLevelConstraints()) + "\nArgLevelConstraints: " + String.valueOf(this.getArgLevelConstraints()) + "\nArgLevelParams: " + String.valueOf(this.getArgLevelParams()) + "\n";
    }

    @Override
    public SemanticNode[] getChildren() {
        if (this.children != null) {
            return this.children;
        }
        OpDefNode[] opDefs = this.getOpDefs();
        this.children = new SemanticNode[opDefs.length + this.topLevel.length];
        int i = 0;
        while (i < opDefs.length) {
            this.children[i] = opDefs[i];
            ++i;
        }
        int j = 0;
        while (j < this.topLevel.length) {
            this.children[i + j] = this.topLevel[j];
            ++j;
        }
        return this.children;
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        if (this.ctxt != null) {
            this.ctxt.walkGraph(semNodesTable, visitor);
        }
        int i = 0;
        while (i < this.topLevelVec.size()) {
            ((LevelNode)this.topLevelVec.elementAt(i)).walkGraph(semNodesTable, visitor);
            ++i;
        }
        visitor.postVisit(this);
    }

    public final void print(int indent, int depth, boolean b, Errors errors) {
        if (depth <= 0) {
            return;
        }
        System.out.print("*ModuleNode: " + String.valueOf(this.name) + "  " + super.toString(depth, errors) + "  errors: " + (String)(errors == null ? "null" : (errors.getNumErrors() == 0 ? "none" : "" + errors.getNumErrors())));
        Vector<String> contextEntries = this.ctxt.getContextEntryStringVector(depth - 1, b, errors);
        int i = 0;
        while (i < contextEntries.size()) {
            System.out.print(Strings.indent(2 + indent, contextEntries.elementAt(i)));
            ++i;
        }
    }

    @Override
    public final String toString(int depth, Errors errors) {
        int i;
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*ModuleNode: " + String.valueOf(this.name) + "  " + super.toString(depth, errors) + "  constant module: " + this.isConstant(errors) + "  errors: " + (String)(errors == null ? "null" : (errors.getNumErrors() == 0 ? "none" : "" + errors.getNumErrors()));
        Vector<String> contextEntries = this.ctxt.getContextEntryStringVector(depth - 1, false, errors);
        if (contextEntries != null) {
            i = 0;
            while (i < contextEntries.size()) {
                ret = contextEntries.elementAt(i) != null ? ret + Strings.indent(2, contextEntries.elementAt(i)) : ret + "*** null ***";
                ++i;
            }
        }
        ret = ret + Strings.indent(2, "\nAllExtended: " + LevelNode.HashSetToString(this.getExtendedModuleSet()));
        if (this.instanceVec.size() > 0) {
            ret = ret + Strings.indent(2, "\nInstantiations:");
            i = 0;
            while (i < this.instanceVec.size()) {
                ret = ret + Strings.indent(4, this.instanceVec.elementAt(i).toString(1, errors));
                ++i;
            }
        }
        if (this.assumptionVec.size() > 0) {
            ret = ret + Strings.indent(2, "\nAssumptions:");
            i = 0;
            while (i < this.assumptionVec.size()) {
                ret = ret + Strings.indent(4, this.assumptionVec.elementAt(i).toString(1, errors));
                ++i;
            }
        }
        if (this.theoremVec.size() > 0) {
            ret = ret + Strings.indent(2, "\nTheorems:");
            i = 0;
            while (i < this.theoremVec.size()) {
                ret = ret + Strings.indent(4, this.theoremVec.elementAt(i).toString(1, errors));
                ++i;
            }
        }
        if (this.topLevelVec.size() > 0) {
            ret = ret + Strings.indent(2, "\ntopLevelVec: ");
            i = 0;
            while (i < this.topLevelVec.size()) {
                ret = ret + Strings.indent(4, ((LevelNode)this.topLevelVec.elementAt(i)).toString(1, errors));
                ++i;
            }
        }
        return ret;
    }

    @Override
    protected String getNodeRef() {
        return "ModuleNodeRef";
    }

    @Override
    protected Element getSymbolElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        Element ret = doc.createElement("ModuleNode");
        ret.appendChild(this.appendText(doc, "uniquename", this.getName().toString()));
        OpDeclNode[] consts = this.getConstantDecls();
        int i = 0;
        while (i < consts.length) {
            if (filter.test(consts[i], this)) {
                ret.appendChild(consts[i].export(doc, context, filter));
            }
            ++i;
        }
        OpDeclNode[] vars = this.getVariableDecls();
        int i2 = 0;
        while (i2 < vars.length) {
            if (filter.test(vars[i2], this)) {
                ret.appendChild(vars[i2].export(doc, context, filter));
            }
            ++i2;
        }
        OpDefNode[] ops = this.getOpDefs();
        int i3 = 0;
        while (i3 < ops.length) {
            if (filter.test(ops[i3], this)) {
                ret.appendChild(ops[i3].export(doc, context, filter));
            }
            ++i3;
        }
        LevelNode[] nodes = this.getTopLevel();
        int i4 = 0;
        while (i4 < nodes.length) {
            if (filter.test(nodes[i4], this)) {
                ret.appendChild(nodes[i4].export(doc, context, filter));
            }
            ++i4;
        }
        return ret;
    }

    public boolean processConstantDefns() {
        return !this.isInstantiated || this.isParameterFree();
    }
}

