/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.modanalyzer;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Path;
import tla2sany.modanalyzer.ModuleContext;
import tla2sany.modanalyzer.ModulePointer;
import tla2sany.modanalyzer.ModuleRelatives;
import tla2sany.modanalyzer.ParseUnitRelatives;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.modanalyzer.SyntaxTreePrinter;
import tla2sany.output.LogLevel;
import tla2sany.output.SanyOutput;
import tla2sany.parser.TLAplusParser;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.st.Location;
import tla2sany.st.ParseTree;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Vector;
import util.FileUtil;
import util.FilenameToStream;
import util.MonolithSpecExtractor;
import util.NamedInputStream;
import util.ToolIO;

public class ParseUnit {
    private SpecObj spec;
    private NamedInputStream nis = null;
    private ParseTree parseTree = null;
    private long parseStamp = 0L;
    private ModulePointer rootModule = null;
    private String rootModuleName;
    private ParseUnitRelatives parseUnitRelatives = new ParseUnitRelatives();

    public NamedInputStream getNis() {
        return this.nis;
    }

    public ParseUnit(SpecObj spec, NamedInputStream source) {
        this.spec = spec;
        this.nis = source;
        this.rootModuleName = source != null ? this.nis.getModuleName() : null;
    }

    public final String toString() {
        return "[ ParseUnit: " + this.rootModuleName + " ]";
    }

    public final boolean isLoaded() {
        return this.nis != null && this.nis.sourceFile().exists() && this.parseStamp > this.nis.sourceFile().lastModified();
    }

    public boolean isLibraryModule() {
        if (this.nis == null || !(this.nis.sourceFile() instanceof FilenameToStream.TLAFile)) {
            return false;
        }
        return ((FilenameToStream.TLAFile)this.nis.sourceFile()).isLibraryModule();
    }

    public final String getName() {
        return this.rootModuleName;
    }

    public final SpecObj getSpec() {
        return this.spec;
    }

    public final String getFileName() {
        return this.nis != null ? this.nis.getFileName() : null;
    }

    public final TreeNode getParseTree() {
        return this.parseTree != null ? this.parseTree.rootNode() : null;
    }

    public final ModulePointer getRootModule() {
        return this.rootModule;
    }

    final Vector<ParseUnit> getExtendees() {
        return this.parseUnitRelatives.extendees;
    }

    final Vector<ParseUnit> getExtendedBy() {
        return this.parseUnitRelatives.extendedBy;
    }

    final Vector<ParseUnit> getInstancees() {
        return this.parseUnitRelatives.instancees;
    }

    final Vector<ParseUnit> getInstancedBy() {
        return this.parseUnitRelatives.instancedBy;
    }

    final void addExtendee(ParseUnit pu) {
        this.parseUnitRelatives.extendees.addElement(pu);
    }

    final void addExtendedBy(ParseUnit pu) {
        this.parseUnitRelatives.extendedBy.addElement(pu);
    }

    final void addInstancee(ParseUnit pu) {
        this.parseUnitRelatives.instancees.addElement(pu);
    }

    final void addInstancedBy(ParseUnit pu) {
        this.parseUnitRelatives.instancedBy.addElement(pu);
    }

    final ModuleRelatives getRelatives(ModulePointer module) {
        return module.getRelatives();
    }

    final ParseUnitRelatives getRelatives() {
        return this.parseUnitRelatives;
    }

    final ModuleContext getContext(ModuleRelatives relatives) {
        return relatives.context;
    }

    final ModuleContext getContext(ModulePointer module) {
        return module.getRelatives().context;
    }

    final ModulePointer getParent(ModulePointer module) {
        return module.getRelatives().outerModule;
    }

    final Vector<ModulePointer> getPeers(ModulePointer module) {
        if (module.getRelatives().outerModule != null) {
            return module.getRelatives().outerModule.getRelatives().directInnerModules;
        }
        return null;
    }

    private final void writeParseTreeToFile(boolean file, Errors errors, SanyOutput out) throws AbortException {
        if (file) {
            String sinkName = this.nis.getModuleName() + ".jcg";
            File compiled = this.spec.getResolver().resolve(sinkName, false);
            if (compiled.exists()) {
                compiled.delete();
            }
            PrintWriter pw = new PrintWriter(FileUtil.newFOS(compiled));
            SyntaxTreePrinter.print(this.parseTree, pw);
            pw.flush();
            pw.close();
        } else {
            PrintWriter pw = new PrintWriter(out.getStream(LogLevel.DEBUG));
            SyntaxTreePrinter.print(this.parseTree, pw);
            pw.flush();
        }
    }

    private final void verifyEquivalenceOfFileAndModuleNames(Errors errors) throws AbortException {
        String fName = this.getFileName();
        fName = fName.substring(fName.lastIndexOf(System.getProperty("file.separator")) + 1);
        fName = fName.substring(0, fName.lastIndexOf("."));
        String mName = this.getParseTree().heirs()[0].heirs()[1].getImage();
        if (!mName.equals(fName)) {
            throw errors.addError(ErrorCode.MODULE_NAME_DIFFERENT_FROM_FILE_NAME, Location.nullLoc, "File name '" + fName + "' does not match the name '" + mName + "' of the top level module it contains.");
        }
    }

    public final void parseFile(Errors errors, boolean firstCall, String name, ParseUnit rootParseUnit, SanyOutput out) throws AbortException {
        boolean parseSuccess;
        Path absoluteResolvedPath;
        if (this.parseStamp > this.nis.sourceFile().lastModified()) {
            return;
        }
        if (!this.nis.sourceFile().exists()) {
            throw errors.addError(ErrorCode.INTERNAL_ERROR, Location.nullLoc, "Error: source file '" + this.nis.getName() + "' has apparently been deleted.");
        }
        try {
            absoluteResolvedPath = this.nis.getAbsoluteResolvedPath();
        }
        catch (IOException e1) {
            absoluteResolvedPath = this.nis.sourceFile().toPath();
        }
        if (ToolIO.getMode() == 0) {
            File rootSourceFile;
            Object originalFilePath = "";
            if (this.nis.sourceFile() instanceof FilenameToStream.TLAFile && ((FilenameToStream.TLAFile)this.nis.sourceFile()).hasLibraryPath()) {
                URI libraryPath = ((FilenameToStream.TLAFile)this.nis.sourceFile()).getLibraryPath();
                if (!absoluteResolvedPath.toUri().getPath().equals(libraryPath.getPath())) {
                    originalFilePath = " (" + String.valueOf(libraryPath) + ")";
                }
            } else if (rootParseUnit != null && rootParseUnit.getNis() != null && (rootSourceFile = rootParseUnit.getNis().sourceFile()) != null) {
                try {
                    MonolithSpecExtractor.module(rootSourceFile, name);
                    originalFilePath = " (" + rootSourceFile.getAbsolutePath() + ")";
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            out.log(LogLevel.INFO, "Parsing file %s%s", absoluteResolvedPath, originalFilePath);
        } else {
            out.log(LogLevel.INFO, "Parsing module %s in file %s", this.nis.getModuleName(), absoluteResolvedPath);
        }
        try {
            this.parseTree = new TLAplusParser(out, this.nis);
            parseSuccess = this.parseTree.parse();
            this.parseStamp = System.currentTimeMillis();
        }
        finally {
            try {
                this.nis.close();
            }
            catch (IOException iOException) {}
        }
        if (!parseSuccess) {
            throw errors.addError(ErrorCode.INTERNAL_ERROR, Location.moduleLocation(this.nis.getModuleName()), "Could not parse module " + this.nis.getModuleName() + " from file " + this.nis.getName());
        }
        TreeNode rootNode = this.parseTree.rootNode();
        rootNode.setLevel(0);
        rootNode.setParent();
        if (firstCall) {
            this.spec.setName(this.getParseTree().heirs()[0].heirs()[1].getImage());
        }
        this.rootModule = new ModulePointer(this.spec, this, this.getParseTree());
        this.determineModuleRelationships(this.rootModule, null);
        this.verifyEquivalenceOfFileAndModuleNames(errors);
        if (System.getProperty("TLA-Print", "off").equals("file")) {
            this.writeParseTreeToFile(true, errors, out);
        } else if (System.getProperty("TLA-Print", "off").equals("on")) {
            this.writeParseTreeToFile(false, errors, out);
        }
    }

    private void handleExtensions(ModulePointer currentModule, ModulePointer otherModule) {
        if (otherModule == null) {
            return;
        }
        ModuleContext currentContext = this.getContext(currentModule);
        Vector<String> extendeeNames = otherModule.getNamesOfModulesExtended();
        int i = 0;
        while (i < extendeeNames.size()) {
            String extendeeName = extendeeNames.elementAt(i);
            ModulePointer extendeeResolvant = currentContext.resolve(extendeeName);
            if (extendeeResolvant != null) {
                Vector<ModulePointer> directInnerModules = extendeeResolvant.getDirectInnerModules();
                int j = 0;
                while (j < directInnerModules.size()) {
                    ModulePointer upperInnerMod = directInnerModules.elementAt(j);
                    currentContext.bindIfNotBound(upperInnerMod.getName(), upperInnerMod);
                    this.handleExtensions(currentModule, extendeeResolvant);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void calculateContextWithinParseUnit(ModulePointer currentModule) {
        ModuleContext currentContext = this.getContext(currentModule);
        if (this.getParent(currentModule) != null) {
            currentContext.union(this.getParent(currentModule).getContext());
        }
        ModulePointer ancestorModule = currentModule;
        while (this.getParent(ancestorModule) != null) {
            currentContext.union(this.getParent(ancestorModule).getContext());
            Vector<ModulePointer> peers = this.getPeers(ancestorModule);
            int i = 0;
            while (i < peers.size() - 1) {
                ModulePointer nextPeer = peers.elementAt(i);
                currentContext.bindIfNotBound(nextPeer.getName(), nextPeer);
                ++i;
            }
            ancestorModule = this.getParent(ancestorModule);
        }
        this.handleExtensions(currentModule, currentModule);
    }

    void determineModuleRelationships(ModulePointer currentModule, ModulePointer parent) {
        ModuleRelatives currentRelatives = new ModuleRelatives(this, currentModule);
        currentModule.putRelatives(currentRelatives);
        currentRelatives.outerModule = parent;
        TreeNode extendNode = currentModule.getExtendsDecl();
        int i = 1;
        while (i < extendNode.heirs().length) {
            String extendedModuleName = extendNode.heirs()[i].getImage();
            currentRelatives.directlyExtendedModuleNames.addElement(extendedModuleName);
            i += 2;
        }
        this.calculateContextWithinParseUnit(currentModule);
        TreeNode body = currentModule.getBody();
        int i2 = 0;
        while (i2 < body.heirs().length) {
            TreeNode def = body.heirs()[i2];
            if (def.getImage().equals("N_Module")) {
                ModulePointer innerModule = new ModulePointer(this.spec, this, def);
                currentRelatives.directInnerModules.addElement(innerModule);
                this.determineModuleRelationships(innerModule, currentModule);
            } else {
                this.getInstances(def, currentRelatives);
            }
            ++i2;
        }
    }

    @Deprecated
    private void getInstanceInLet(TreeNode treeNode, ModuleRelatives currentRelatives) {
        TreeNode[] children = treeNode.heirs();
        if (treeNode.getImage().equals("N_LetIn")) {
            TreeNode[] syntaxTreeNode = children[1].heirs();
            int i = 0;
            while (i < syntaxTreeNode.length) {
                TreeNode def = syntaxTreeNode[i];
                if (def.getImage().equals("N_ModuleDefinition")) {
                    TreeNode[] instanceHeirs = def.heirs();
                    int nonLocalInstanceNodeIX = 2;
                    String instanceModuleName = instanceHeirs[nonLocalInstanceNodeIX].heirs()[1].getImage();
                    currentRelatives.directlyInstantiatedModuleNames.addElement(instanceModuleName);
                } else {
                    TreeNode[] defChildren = def.heirs();
                    int j = 0;
                    while (j < defChildren.length) {
                        this.getInstanceInLet(defChildren[j], currentRelatives);
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < children.length) {
                this.getInstanceInLet(children[i], currentRelatives);
                ++i;
            }
        }
    }

    private void getInstances(TreeNode treeNode, ModuleRelatives currentRelatives) {
        TreeNode[] children = treeNode.heirs();
        int i = 0;
        if (treeNode.getImage().equals("N_NonLocalInstance")) {
            currentRelatives.directlyInstantiatedModuleNames.addElement(children[1].getImage());
            i = 2;
        }
        int j = i;
        while (j < children.length) {
            this.getInstances(children[j], currentRelatives);
            ++j;
        }
    }
}

