/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum ErrorCode {
    INTERNAL_ERROR(4003, ErrorLevel.ERROR, -1),
    SUSPECTED_UNREACHABLE_CHECK(4004, ErrorLevel.ERROR, -1),
    UNSUPPORTED_LANGUAGE_FEATURE(4005, ErrorLevel.ERROR, -1),
    SYMBOL_UNDEFINED(4200, ErrorLevel.ERROR),
    SYMBOL_REDEFINED(4201, ErrorLevel.ERROR),
    BUILT_IN_SYMBOL_REDEFINED(4202, ErrorLevel.ERROR),
    OPERATOR_NAME_INCOMPLETE(4203, ErrorLevel.ERROR),
    OPERATOR_GIVEN_INCORRECT_NUMBER_OF_ARGUMENTS(4204, ErrorLevel.ERROR),
    OPERATOR_LEVEL_CONSTRAINTS_EXCEEDED(4205, ErrorLevel.ERROR),
    ASSUMPTION_IS_NOT_CONSTANT(4206, ErrorLevel.ERROR),
    MODULE_FILE_CANNOT_BE_FOUND(4220, ErrorLevel.ERROR),
    MODULE_NAME_DIFFERENT_FROM_FILE_NAME(4221, ErrorLevel.ERROR),
    MODULE_DEPENDENCIES_ARE_CIRCULAR(4222, ErrorLevel.ERROR),
    MODULE_REDEFINED(4223, ErrorLevel.ERROR),
    EXTENDED_MODULES_SYMBOL_UNIFICATION_CONFLICT(4224, ErrorLevel.ERROR),
    INSTANCE_SUBSTITUTION_MISSING_SYMBOL(4240, ErrorLevel.ERROR),
    INSTANCE_SUBSTITUTION_SYMBOL_REDEFINED_MULTIPLE_TIMES(4241, ErrorLevel.ERROR),
    INSTANCE_SUBSTITUTION_ILLEGAL_SYMBOL_REDEFINITION(4242, ErrorLevel.ERROR),
    INSTANCE_SUBSTITUTION_OPERATOR_CONSTANT_INCORRECT_ARITY(4243, ErrorLevel.ERROR),
    INSTANCE_SUBSTITUTION_NON_LEIBNIZ_OPERATOR(4244, ErrorLevel.ERROR),
    INSTANCE_SUBSTITUTION_LEVEL_CONSTRAINTS_EXCEEDED(4245, ErrorLevel.ERROR),
    INSTANCE_SUBSTITUTION_LEVEL_CONSTRAINT_NOT_MET(4246, ErrorLevel.ERROR),
    INSTANCE_SUBSTITUTION_COPARAMETER_LEVEL_CONSTRAINTS_EXCEEDED(4247, ErrorLevel.ERROR),
    FUNCTION_GIVEN_INCORRECT_NUMBER_OF_ARGUMENTS(4260, ErrorLevel.ERROR),
    FUNCTION_EXCEPT_AT_USED_WHERE_UNDEFINED(4261, ErrorLevel.ERROR),
    RECORD_CONSTRUCTOR_FIELD_REDEFINITION(4262, ErrorLevel.ERROR),
    HIGHER_ORDER_OPERATOR_REQUIRED_BUT_EXPRESSION_GIVEN(4270, ErrorLevel.ERROR),
    HIGHER_ORDER_OPERATOR_ARGUMENT_HAS_INCORRECT_ARITY(4271, ErrorLevel.ERROR),
    HIGHER_ORDER_OPERATOR_PARAMETER_LEVEL_CONSTRAINT_NOT_MET(4272, ErrorLevel.ERROR),
    HIGHER_ORDER_OPERATOR_COPARAMETER_LEVEL_CONSTRAINTS_EXCEEDED(4273, ErrorLevel.ERROR),
    LAMBDA_OPERATOR_ARGUMENT_HAS_INCORRECT_ARITY(4274, ErrorLevel.ERROR),
    LAMBDA_GIVEN_WHERE_EXPRESSION_REQUIRED(4275, ErrorLevel.ERROR),
    RECURSIVE_OPERATOR_PRIMES_PARAMETER(4290, ErrorLevel.ERROR),
    RECURSIVE_OPERATOR_DECLARED_BUT_NOT_DEFINED(4291, ErrorLevel.ERROR),
    RECURSIVE_OPERATOR_DECLARATION_DEFINITION_ARITY_MISMATCH(4292, ErrorLevel.ERROR),
    RECURSIVE_OPERATOR_DEFINED_IN_WRONG_LET_IN_LEVEL(4293, ErrorLevel.ERROR),
    RECURSIVE_SECTION_CONTAINS_ILLEGAL_DEFINITION(4294, ErrorLevel.ERROR),
    ALWAYS_PROPERTY_SENSITIVE_TO_STUTTERING(4310, ErrorLevel.ERROR),
    EVENTUALLY_PROPERTY_SENSITIVE_TO_STUTTERING(4311, ErrorLevel.ERROR),
    BINARY_TEMPORAL_OPERATOR_WITH_ACTION_LEVEL_PARAMETER(4312, ErrorLevel.ERROR),
    LOGICAL_OPERATOR_WITH_MIXED_ACTION_TEMPORAL_PARAMETERS(4313, ErrorLevel.ERROR),
    QUANTIFIED_TEMPORAL_FORMULA_WITH_ACTION_LEVEL_BOUND(4314, ErrorLevel.ERROR),
    QUANTIFICATION_WITH_TEMPORAL_LEVEL_BOUND(4315, ErrorLevel.ERROR),
    LABEL_PARAMETER_REPETITION(4330, ErrorLevel.ERROR),
    LABEL_PARAMETER_MISSING(4331, ErrorLevel.ERROR),
    LABEL_PARAMETER_UNNECESSARY(4332, ErrorLevel.ERROR),
    LABEL_NOT_IN_DEFINITION_OR_PROOF_STEP(4333, ErrorLevel.ERROR),
    LABEL_NOT_ALLOWED_IN_NESTED_ASSUME_PROVE_WITH_NEW(4334, ErrorLevel.ERROR),
    LABEL_NOT_ALLOWED_IN_FUNCTION_EXCEPT(4335, ErrorLevel.ERROR),
    LABEL_REDEFINITION(4336, ErrorLevel.ERROR),
    LABEL_GIVEN_INCORRECT_NUMBER_OF_ARGUMENTS(4337, ErrorLevel.ERROR),
    PROOF_STEP_WITH_IMPLICIT_LEVEL_CANNOT_HAVE_NAME(4350, ErrorLevel.ERROR),
    PROOF_STEP_NON_EXPRESSION_USED_AS_EXPRESSION(4351, ErrorLevel.ERROR),
    TEMPORAL_PROOF_GOAL_WITH_NON_CONSTANT_TAKE_WITNESS_HAVE(4352, ErrorLevel.ERROR),
    TEMPORAL_PROOF_GOAL_WITH_NON_CONSTANT_CASE(4353, ErrorLevel.ERROR),
    QUANTIFIED_TEMPORAL_PICK_FORMULA_WITH_NON_CONSTANT_BOUND(4354, ErrorLevel.ERROR),
    ASSUME_PROVE_USED_WHERE_EXPRESSION_REQUIRED(4355, ErrorLevel.ERROR),
    ASSUME_PROVE_NEW_CONSTANT_HAS_TEMPORAL_LEVEL_BOUND(4356, ErrorLevel.ERROR),
    USE_OR_HIDE_FACT_NOT_VALID(4357, ErrorLevel.ERROR),
    EXTENDED_MODULES_SYMBOL_UNIFICATION_AMBIGUITY(4800, ErrorLevel.WARNING),
    INSTANCED_MODULES_SYMBOL_UNIFICATION_AMBIGUITY(4801, ErrorLevel.WARNING),
    RECORD_CONSTRUCTOR_FIELD_NAME_CLASH(4802, ErrorLevel.WARNING);

    public static final int VARIADIC_PARAMETERS = -1;
    private final int value;
    private final int parameterCount;
    private final ErrorLevel level;
    private static final Map<Integer, ErrorCode> codeMap;

    static {
        codeMap = Arrays.stream(ErrorCode.values()).collect(Collectors.toMap(code -> code.value, code -> code));
    }

    private ErrorCode(int value, ErrorLevel level) {
        this(value, level, 0);
    }

    private ErrorCode(int value, ErrorLevel level, int parameterCount) {
        this.value = value;
        this.level = level;
        this.parameterCount = parameterCount;
    }

    public static ErrorCode fromStandardValue(int value) {
        ErrorCode code = codeMap.get(value);
        if (code == null) {
            throw new IllegalArgumentException(Integer.toString(value));
        }
        return code;
    }

    public int getStandardValue() {
        return this.value;
    }

    public ErrorLevel getSeverityLevel() {
        return this.level;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public static enum ErrorLevel {
        WARNING,
        ERROR;

    }
}

