/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tlc2.TLCGlobals;
import tlc2.tool.EvalControl;
import tlc2.tool.EvalException;
import tlc2.tool.FingerprintException;
import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.coverage.CostModel;
import tlc2.util.Context;
import tlc2.value.IFcnLambdaValue;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.FcnParams;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.FunctionValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.SetOfTuplesValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import util.Assert;
import util.UniqueString;

public class FcnLambdaValue
extends Value
implements FunctionValue,
IFcnLambdaValue {
    public final FcnParams params;
    public final SemanticNode body;
    public ValueExcept[] excepts;
    public final ITool tool;
    public Context con;
    public final TLCState state;
    public final TLCState pstate;
    public int control;
    public FcnRcdValue fcnRcd;

    public FcnLambdaValue(FcnParams params, SemanticNode body, ITool tool, Context c, TLCState s0, TLCState s1, int control) {
        this.params = params;
        this.body = body;
        this.excepts = null;
        this.tool = tool;
        this.con = c;
        this.state = s0.copy();
        this.pstate = s1 != null ? s1.copy() : null;
        this.control = control;
        this.fcnRcd = null;
    }

    public FcnLambdaValue(FcnParams params, SemanticNode body, ITool tool, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        this(params, body, tool, c, s0, s1, control);
        this.cm = cm;
    }

    public FcnLambdaValue(FcnLambdaValue fcn, ITool tool) {
        this.params = fcn.params;
        this.body = fcn.body;
        this.excepts = fcn.excepts;
        this.tool = tool;
        this.con = fcn.con;
        this.state = fcn.state;
        this.pstate = fcn.pstate;
        this.control = fcn.control;
        this.fcnRcd = fcn.fcnRcd;
    }

    public FcnLambdaValue(FcnLambdaValue fcn) {
        this(fcn, fcn.tool);
    }

    @Override
    public final byte getKind() {
        return 8;
    }

    public final void makeRecursive(SymbolNode fname) {
        try {
            this.con = this.con.cons(fname, this);
            this.control = EvalControl.setKeepLazy(this.control);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            FcnRcdValue fcn = (FcnRcdValue)this.toFcnRcd();
            return fcn.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            FcnRcdValue fcn = (FcnRcdValue)this.toFcnRcd();
            return fcn.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check if the value:\n" + Values.ppr(elem.toString()) + "\nis an element of the function " + Values.ppr(this.toString()), this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            Assert.fail("Attempted to check if the function:\n" + Values.ppr(this.toString()) + "\nis a finite set.", this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Value apply(Value args, int control) throws EvalException {
        try {
            if (this.fcnRcd != null) {
                return this.fcnRcd.apply(args, control);
            }
            Value res = null;
            int num = 0;
            ValueExcept[] excepts1 = null;
            if (this.excepts != null) {
                int exlen = this.excepts.length;
                int i = exlen - 1;
                while (i >= 0) {
                    ValueExcept ex = this.excepts[i];
                    Value arg = ex.current();
                    boolean inExcept = true;
                    inExcept = arg.equals(args);
                    if (inExcept) {
                        if (ex.isLast()) {
                            res = ex.value;
                            break;
                        }
                        if (excepts1 == null) {
                            excepts1 = new ValueExcept[exlen];
                        }
                        excepts1[num++] = new ValueExcept(ex, ex.idx + 1);
                    }
                    --i;
                }
            }
            if (res == null) {
                int i;
                Context c1 = this.con;
                FormalParamNode[][] formals = this.params.formals;
                Value[] domains = this.params.domains;
                boolean[] isTuples = this.params.isTuples;
                int plen = this.params.length();
                if (plen == 1) {
                    if (!domains[0].member(args)) {
                        Assert.fail("In applying the function\n" + Values.ppr(this.toString()) + ",\nthe first argument is:\n" + Values.ppr(args.toString()) + "\nwhich is not in its domain.\n", this.getSource());
                    }
                    if (isTuples[0]) {
                        FormalParamNode[] ids = formals[0];
                        TupleValue argVal = (TupleValue)args.toTuple();
                        if (argVal == null) {
                            Assert.fail("In applying the function\n" + Values.ppr(this.toString()) + ",\nthe first argument is:\n" + Values.ppr(args.toString()) + "\nwhich does not match its formal parameter.\n", this.getSource());
                        }
                        if (argVal.size() != ids.length) {
                            return null;
                        }
                        Value[] elems = argVal.elems;
                        i = 0;
                        while (i < ids.length) {
                            c1 = c1.cons(ids[i], elems[i]);
                            ++i;
                        }
                    } else {
                        c1 = c1.cons(formals[0][0], args);
                    }
                } else {
                    TupleValue tv = (TupleValue)args.toTuple();
                    if (tv == null) {
                        Assert.fail("In applying the function\n" + Values.ppr(this.toString()) + ",\nthe argument list is:\n" + Values.ppr(args.toString()) + "\nwhich does not match its formal parameter.\n", this.getSource());
                    }
                    Value[] elems = tv.elems;
                    int argn = 0;
                    i = 0;
                    while (i < formals.length) {
                        FormalParamNode[] ids = formals[i];
                        Value domain = domains[i];
                        if (isTuples[i]) {
                            TupleValue tv1;
                            if (!domain.member(elems[argn])) {
                                Assert.fail("In applying the function\n" + Values.ppr(this.toString()) + ",\nthe argument number " + (argn + 1) + " is:\n" + Values.ppr(elems[argn].toString()) + "\nwhich is not in its domain.\n", this.getSource());
                            }
                            if ((tv1 = (TupleValue)elems[argn++].toTuple()) == null || tv1.size() != ids.length) {
                                Assert.fail("In applying the function\n" + Values.ppr(this.toString()) + ",\nthe argument number " + argn + " is:\n" + Values.ppr(elems[argn - 1].toString()) + "\nwhich does not match its formal parameter.\n", this.getSource());
                            }
                            Value[] avals = tv1.elems;
                            int j = 0;
                            while (j < ids.length) {
                                c1 = c1.cons(ids[j], avals[j]);
                                ++j;
                            }
                        } else {
                            int j = 0;
                            while (j < ids.length) {
                                if (!domain.member(elems[argn])) {
                                    Assert.fail("In applying the function\n" + Values.ppr(this.toString()) + ",\nthe argument number " + (argn + 1) + " is:\n" + Values.ppr(elems[argn].toString()) + "\nwhich is not in the function's domain " + this.getDomain().toString() + ".\n", this.getSource());
                                }
                                c1 = c1.cons(ids[j], elems[argn++]);
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                res = (Value)this.tool.eval(this.body, c1, this.state, this.pstate, control);
            }
            if (num == 0) {
                return res;
            }
            ValueExcept[] excepts2 = new ValueExcept[num];
            int i = 0;
            while (i < num) {
                excepts2[num - 1 - i] = excepts1[i];
                ++i;
            }
            return res.takeExcept(excepts2);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Value select(Value arg) {
        try {
            if (this.fcnRcd != null) {
                return this.fcnRcd.select(arg);
            }
            Value res = null;
            int num = 0;
            ValueExcept[] excepts1 = null;
            if (this.excepts != null) {
                int exlen = this.excepts.length;
                int i = exlen - 1;
                while (i >= 0) {
                    ValueExcept ex = this.excepts[i];
                    Value exArg = ex.current();
                    boolean inExcept = exArg.equals(arg);
                    if (inExcept) {
                        if (ex.isLast()) {
                            res = ex.value;
                            break;
                        }
                        if (excepts1 == null) {
                            excepts1 = new ValueExcept[exlen];
                        }
                        excepts1[num++] = new ValueExcept(ex, ex.idx + 1);
                    }
                    --i;
                }
            }
            if (res == null) {
                int i;
                Context c1 = this.con;
                FormalParamNode[][] formals = this.params.formals;
                Value[] domains = this.params.domains;
                boolean[] isTuples = this.params.isTuples;
                int plen = this.params.length();
                if (plen == 1) {
                    if (!domains[0].member(arg)) {
                        return null;
                    }
                    if (isTuples[0]) {
                        FormalParamNode[] ids = formals[0];
                        TupleValue argVal = (TupleValue)arg.toTuple();
                        if (argVal == null) {
                            Assert.fail("In applying the function\n" + Values.ppr(this.toString()) + ",\nthe first argument is:\n" + Values.ppr(arg.toString()) + "\nwhich does not match its formal parameter.\n", this.getSource());
                        }
                        if (argVal.size() != ids.length) {
                            return null;
                        }
                        Value[] elems = argVal.elems;
                        i = 0;
                        while (i < ids.length) {
                            c1 = c1.cons(ids[i], elems[i]);
                            ++i;
                        }
                    } else {
                        c1 = c1.cons(formals[0][0], arg);
                    }
                } else {
                    TupleValue tv = (TupleValue)arg.toTuple();
                    if (tv == null) {
                        Assert.fail("In applying the function\n" + Values.ppr(this.toString()) + ",\nthe argument list is:\n" + Values.ppr(arg.toString()) + "\nwhich does not match its formal parameter.\n", this.getSource());
                    }
                    Value[] elems = tv.elems;
                    int argn = 0;
                    i = 0;
                    while (i < formals.length) {
                        FormalParamNode[] ids = formals[i];
                        Value domain = domains[i];
                        if (isTuples[i]) {
                            TupleValue tv1;
                            if (!domain.member(elems[argn])) {
                                return null;
                            }
                            if ((tv1 = (TupleValue)elems[argn++].toTuple()) == null) {
                                Assert.fail("In applying the function\n" + Values.ppr(this.toString()) + ",\nthe argument number " + argn + " is:\n" + Values.ppr(elems[argn - 1].toString()) + "\nwhich does not match its formal parameter.\n", this.getSource());
                            }
                            if (tv1.size() != ids.length) {
                                return null;
                            }
                            Value[] avals = tv1.elems;
                            int j = 0;
                            while (j < ids.length) {
                                c1 = c1.cons(ids[j], avals[j]);
                                ++j;
                            }
                        } else {
                            int j = 0;
                            while (j < ids.length) {
                                if (!domain.member(elems[argn])) {
                                    return null;
                                }
                                c1 = c1.cons(ids[j], elems[argn++]);
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                res = (Value)this.tool.eval(this.body, c1, this.state, this.pstate, this.control, this.cm);
            }
            if (num == 0) {
                return res;
            }
            ValueExcept[] excepts2 = new ValueExcept[num];
            int i = 0;
            while (i < num) {
                excepts2[num - 1 - i] = excepts1[i];
                ++i;
            }
            return res.takeExcept(excepts2);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx >= ex.path.length) {
                return ex.value;
            }
            if (this.fcnRcd != null) {
                return this.fcnRcd.takeExcept(ex);
            }
            FcnLambdaValue fcn = new FcnLambdaValue(this);
            if (this.excepts == null) {
                fcn.excepts = new ValueExcept[1];
                fcn.excepts[0] = ex;
            } else {
                int exlen = this.excepts.length;
                fcn.excepts = new ValueExcept[exlen + 1];
                int i = 0;
                while (i < exlen) {
                    fcn.excepts[i] = this.excepts[i];
                    ++i;
                }
                fcn.excepts[exlen] = ex;
            }
            return fcn;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (this.fcnRcd != null) {
                return this.fcnRcd.takeExcept(exs);
            }
            FcnLambdaValue fcn = new FcnLambdaValue(this);
            int exslen = exs.length;
            if (exslen != 0) {
                int i = 0;
                i = exs.length - 1;
                while (i >= 0) {
                    if (exs[i].idx >= exs[i].path.length) break;
                    --i;
                }
                if (i >= 0) {
                    int xlen = exslen - i - 1;
                    fcn.excepts = new ValueExcept[xlen];
                    System.arraycopy(exs, i + 1, fcn.excepts, 0, xlen);
                } else if (this.excepts == null) {
                    fcn.excepts = new ValueExcept[exslen];
                    System.arraycopy(exs, 0, fcn.excepts, 0, exslen);
                } else {
                    int len = this.excepts.length;
                    fcn.excepts = new ValueExcept[len + exslen];
                    System.arraycopy(this.excepts, 0, fcn.excepts, 0, len);
                    System.arraycopy(exs, 0, fcn.excepts, len, exslen);
                }
            }
            return fcn;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value getDomain() {
        try {
            if (this.fcnRcd != null) {
                return this.fcnRcd.getDomain();
            }
            int len = this.params.length();
            if (len == 1) {
                return this.params.domains[0];
            }
            Value[] sets = new Value[len];
            int dlen = this.params.domains.length;
            boolean[] isTuples = this.params.isTuples;
            int idx = 0;
            int i = 0;
            while (i < dlen) {
                FormalParamNode[] formal = this.params.formals[i];
                Value domain = this.params.domains[i];
                if (isTuples[i]) {
                    sets[idx++] = domain;
                } else {
                    int j = 0;
                    while (j < formal.length) {
                        sets[idx++] = domain;
                        ++j;
                    }
                }
                ++i;
            }
            return new SetOfTuplesValue(sets);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            if (this.fcnRcd == null) {
                return this.params.size();
            }
            return this.fcnRcd.size();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final IValue deepCopy() {
        try {
            FcnLambdaValue fcn = new FcnLambdaValue(this);
            if (this.fcnRcd != null) {
                fcn.fcnRcd = (FcnRcdValue)this.fcnRcd.deepCopy();
            }
            return fcn;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.fcnRcd = (FcnRcdValue)ois.readObject();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        FcnRcdValue res = (FcnRcdValue)this.toFcnRcd();
        oos.writeObject(res);
    }

    @Override
    public final boolean isNormalized() {
        block4: {
            if (this.fcnRcd != null) break block4;
            return false;
        }
        try {
            return this.fcnRcd.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            if (this.fcnRcd != null) {
                this.fcnRcd.normalize();
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void deepNormalize() {
        try {
            if (this.fcnRcd == null) {
                if (this.excepts != null) {
                    int i = 0;
                    while (i < this.excepts.length) {
                        this.excepts[i].value.deepNormalize();
                        int j = 0;
                        while (j < this.excepts[i].path.length) {
                            this.excepts[i].path[j].deepNormalize();
                            ++j;
                        }
                        ++i;
                    }
                }
                Value[] paramDoms = this.params.domains;
                int i = 0;
                while (i < paramDoms.length) {
                    paramDoms[i].deepNormalize();
                    ++i;
                }
            } else {
                this.fcnRcd.deepNormalize();
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value toTuple() {
        if (this.params.length() != 1) {
            return null;
        }
        Value dom = this.params.domains[0];
        if (dom instanceof IntervalValue) {
            IntervalValue intv = (IntervalValue)dom;
            if (intv.low != 1) {
                return null;
            }
            Value[] elems = new Value[intv.high];
            int i = 1;
            while (i <= intv.high) {
                elems[i - 1] = this.select(IntValue.gen(i));
                ++i;
            }
            if (coverage) {
                this.cm.incSecondary(elems.length);
            }
            return new TupleValue(elems, this.cm);
        }
        SetEnumValue eSet = (SetEnumValue)dom.toSetEnum();
        if (eSet == null) {
            Assert.fail("To convert a function of form [x \\in S |-> f(x)] to a tuple, the set S must be enumerable.", this.getSource());
        }
        eSet.normalize();
        int len = eSet.size();
        Value[] elems = new Value[len];
        int i = 0;
        while (i < len) {
            Value argVal = eSet.elems.elementAt(i);
            if (!(argVal instanceof IntValue)) {
                return null;
            }
            if (((IntValue)argVal).val != i + 1) {
                return null;
            }
            elems[i] = this.select(argVal);
            ++i;
        }
        this.cm.incSecondary(elems.length);
        return new TupleValue(elems, this.cm);
    }

    @Override
    public final Value toRcd() {
        FcnRcdValue fcn = (FcnRcdValue)this.toFcnRcd();
        if (fcn == null || fcn.domain == null) {
            return null;
        }
        fcn.normalize();
        UniqueString[] vars = new UniqueString[fcn.domain.length];
        int i = 0;
        while (i < fcn.domain.length) {
            if (!(fcn.domain[i] instanceof StringValue)) {
                return null;
            }
            vars[i] = ((StringValue)fcn.domain[i]).getVal();
            ++i;
        }
        if (coverage) {
            this.cm.incSecondary(vars.length);
        }
        return new RecordValue(vars, fcn.values, fcn.isNormalized(), this.cm);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final Value toFcnRcd() {
        try {
            block17: {
                block18: {
                    if (this.fcnRcd != null) break block17;
                    sz = this.params.size();
                    formals = this.params.formals;
                    isTuples = this.params.isTuples;
                    domain = new Value[sz];
                    values = new Value[sz];
                    idx = 0;
                    Enum = this.params.elements();
                    if (this.params.length() != 1) ** GOTO lbl55
                    while ((arg = Enum.nextElement()) != null) {
                        domain[idx] = arg;
                        c1 = this.con;
                        if (isTuples[0]) {
                            ids = formals[0];
                            avals = ((TupleValue)arg).elems;
                            j = 0;
                            while (j < ids.length) {
                                c1 = c1.cons(ids[j], avals[j]);
                                ++j;
                            }
                        } else {
                            c1 = c1.cons(formals[0][0], arg);
                        }
                        values[idx++] = (Value)this.tool.eval(this.body, c1, this.state, this.pstate, this.control);
                    }
                    if (this.params.domains[0] instanceof IntervalValue) {
                        iv = (IntervalValue)this.params.domains[0];
                        this.fcnRcd = new FcnRcdValue(iv, values, this.cm);
                    } else {
                        this.fcnRcd = new FcnRcdValue(domain, values, false, this.cm);
                    }
                    break block18;
lbl-1000:
                    // 1 sources

                    {
                        domain[idx] = arg;
                        argList = ((TupleValue)arg).elems;
                        argn = 0;
                        c1 = this.con;
                        i = 0;
                        while (i < formals.length) {
                            ids = formals[i];
                            if (isTuples[i]) {
                                avals = ((TupleValue)argList[argn++]).elems;
                                j = 0;
                                while (j < ids.length) {
                                    c1 = c1.cons(ids[j], avals[j]);
                                    ++j;
                                }
                            } else {
                                j = 0;
                                while (j < ids.length) {
                                    c1 = c1.cons(ids[j], argList[argn++]);
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        values[idx++] = (Value)this.tool.eval(this.body, c1, this.state, this.pstate, this.control);
lbl55:
                        // 2 sources

                        ** while ((arg = Enum.nextElement()) != null)
                    }
lbl56:
                    // 1 sources

                    this.fcnRcd = new FcnRcdValue(domain, values, false, this.cm);
                }
                if (FcnLambdaValue.coverage) {
                    this.cm.incSecondary(sz);
                }
                if (this.excepts != null) {
                    this.fcnRcd = (FcnRcdValue)this.fcnRcd.takeExcept(this.excepts);
                }
            }
            return this.fcnRcd;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        this.fcnRcd.write(vos);
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            Value fcn = this.toFcnRcd();
            return fcn.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            Value fcn = this.toFcnRcd();
            return fcn.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final StringBuffer toString(StringBuffer sb, int offset) {
        return this.toString(sb, offset, true);
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            if (TLCGlobals.expand || this.params == null) {
                try {
                    Value val = this.toFcnRcd();
                    return val.toString(sb, offset, true);
                }
                catch (Throwable val) {
                    // empty catch block
                }
            }
            sb.append("[" + this.params.toString());
            sb.append(" |-> <expression " + String.valueOf(this.body) + ">]");
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final SemanticNode getBody() {
        return this.body;
    }

    @Override
    public final FcnRcdValue getRcd() {
        return this.fcnRcd;
    }

    @Override
    public FcnParams getParams() {
        return this.params;
    }

    @Override
    public Context getCon() {
        return this.con;
    }

    @Override
    public boolean hasRcd() {
        return this.fcnRcd != null;
    }
}

