/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import tlc2.output.MP;
import tlc2.tool.TLCState;
import tlc2.value.ValueInputStream;
import util.Assert;

public class StatePoolReader
extends Thread {
    private TLCState[] buf;
    private File poolFile;
    private boolean isFull;
    private boolean canRead;
    private boolean finished = false;

    public StatePoolReader(int bufSize) {
        this(bufSize, null);
    }

    public StatePoolReader(int bufSize, File file) {
        super("TLCStatePoolReader");
        this.buf = new TLCState[bufSize];
        this.poolFile = file;
        this.isFull = false;
        this.canRead = false;
    }

    public final synchronized void wakeup() {
        this.canRead = true;
        this.notify();
    }

    public final synchronized void restart(File file, boolean canRead) {
        this.poolFile = file;
        this.isFull = false;
        this.canRead = canRead;
        this.notify();
    }

    public final synchronized TLCState[] doWork(TLCState[] deqBuf, File file) throws IOException, ClassNotFoundException {
        if (this.isFull) {
            assert (this.poolFile == null) : 2137;
            TLCState[] res = this.buf;
            this.buf = deqBuf;
            this.poolFile = file;
            this.isFull = false;
            this.canRead = true;
            this.notify();
            return res;
        }
        if (this.poolFile != null) {
            ValueInputStream vis = new ValueInputStream(this.poolFile);
            int i = 0;
            while (i < deqBuf.length) {
                deqBuf[i] = TLCState.Empty.createEmpty();
                deqBuf[i].read(vis);
                ++i;
            }
            vis.close();
            this.poolFile = file;
            this.canRead = true;
            this.notify();
            return deqBuf;
        }
        ValueInputStream vis = new ValueInputStream(file);
        int i = 0;
        while (i < deqBuf.length) {
            deqBuf[i] = TLCState.Empty.createEmpty();
            deqBuf[i].read(vis);
            ++i;
        }
        vis.close();
        return deqBuf;
    }

    public final synchronized TLCState[] getCache(TLCState[] deqBuf, File file) throws IOException, ClassNotFoundException {
        if (this.isFull) {
            assert (this.poolFile == null) : 2137;
            TLCState[] res = this.buf;
            this.buf = deqBuf;
            this.poolFile = file;
            this.isFull = false;
            this.canRead = false;
            return res;
        }
        if (this.poolFile != null && this.canRead) {
            ValueInputStream vis = new ValueInputStream(this.poolFile);
            int i = 0;
            while (i < deqBuf.length) {
                deqBuf[i] = TLCState.Empty.createEmpty();
                deqBuf[i].read(vis);
                ++i;
            }
            vis.close();
            this.poolFile = file;
            this.canRead = false;
            return deqBuf;
        }
        return null;
    }

    public final synchronized void beginChkpt(ObjectOutputStream oos) throws IOException {
        boolean hasFile = this.poolFile != null;
        oos.writeBoolean(hasFile);
        oos.writeBoolean(this.canRead);
        oos.writeBoolean(this.isFull);
        if (hasFile) {
            oos.writeObject(this.poolFile);
        }
        if (this.isFull) {
            int i = 0;
            while (i < this.buf.length) {
                oos.writeObject(this.buf[i]);
                ++i;
            }
        }
    }

    public final void recover(ObjectInputStream ois) throws IOException {
        boolean hasFile = ois.readBoolean();
        this.canRead = ois.readBoolean();
        this.isFull = ois.readBoolean();
        try {
            if (hasFile) {
                this.poolFile = (File)ois.readObject();
            }
            if (this.isFull) {
                int i = 0;
                while (i < this.buf.length) {
                    this.buf[i] = (TLCState)ois.readObject();
                    ++i;
                }
            }
        }
        catch (ClassNotFoundException e) {
            Assert.fail(2126, e);
        }
    }

    @Override
    public void run() {
        try {
            StatePoolReader statePoolReader = this;
            synchronized (statePoolReader) {
                while (true) {
                    if (this.poolFile == null || this.isFull || !this.canRead) {
                        this.wait();
                        if (!this.finished) continue;
                        return;
                    }
                    ValueInputStream vis = new ValueInputStream(this.poolFile);
                    int i = 0;
                    while (i < this.buf.length) {
                        this.buf[i] = TLCState.Empty.createEmpty();
                        this.buf[i].read(vis);
                        ++i;
                    }
                    vis.close();
                    this.poolFile = null;
                    this.isFull = true;
                }
            }
        }
        catch (Exception e) {
            String[] stringArray;
            if (this.poolFile == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = e.getMessage();
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = e.getMessage();
                stringArray = stringArray3;
                stringArray3[1] = this.poolFile.getName();
            }
            String[] cause = stringArray;
            MP.printError(2125, cause, (Throwable)e);
            System.exit(1);
            return;
        }
    }

    public void setFinished() {
        this.finished = true;
    }
}

