/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.output.StatePrinter;
import tlc2.tool.EvalException;
import tlc2.tool.ITool;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.liveness.AbstractDiskGraph;
import tlc2.tool.liveness.DiskGraph;
import tlc2.tool.liveness.GraphNode;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.tool.liveness.ILiveChecker;
import tlc2.tool.liveness.LNEven;
import tlc2.tool.liveness.OrderOfSolution;
import tlc2.tool.liveness.PossibleErrorModel;
import tlc2.tool.liveness.TBPar;
import tlc2.tool.liveness.TableauNodePtrTable;
import tlc2.util.IntStack;
import tlc2.util.LongVec;
import tlc2.util.MemIntQueue;
import tlc2.util.MemIntStack;
import tlc2.util.SynchronousDiskIntStack;
import tlc2.util.statistics.BucketStatistics;
import tlc2.util.statistics.IBucketStatistics;
import tlc2.value.impl.CounterExample;

public class LiveWorker
implements Callable<Boolean> {
    private static final long SCC_MARKER = -42L;
    public static final IBucketStatistics STATS = new BucketStatistics("Histogram SCC sizes", LiveWorker.class.getPackage().getName(), "StronglyConnectedComponent sizes");
    private static int errFoundByThread = -1;
    private static final Object workerLock = new Object();
    private OrderOfSolution oos = null;
    private AbstractDiskGraph dg = null;
    private PossibleErrorModel pem = null;
    private final ILiveCheck liveCheck;
    private final BlockingQueue<ILiveChecker> queue;
    private final boolean isFinalCheck;
    private final int numWorkers;
    private final ITool tool;
    private final int id;

    public LiveWorker(ITool tool, int id, int numWorkers, ILiveCheck liveCheck, BlockingQueue<ILiveChecker> queue, boolean finalCheck) {
        this.id = id;
        this.tool = tool;
        this.numWorkers = numWorkers;
        this.liveCheck = liveCheck;
        this.queue = queue;
        this.isFinalCheck = finalCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasErrFound() {
        Object object = workerLock;
        synchronized (object) {
            return errFoundByThread != -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasErrFound(int id) {
        Object object = workerLock;
        synchronized (object) {
            return errFoundByThread == id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setErrFound() {
        Object object = workerLock;
        synchronized (object) {
            block6: {
                block5: {
                    if (errFoundByThread != -1) break block5;
                    errFoundByThread = this.id;
                    return true;
                }
                if (errFoundByThread != this.id) break block6;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void checkSccs(ITool tool) throws IOException, InterruptedException, ExecutionException {
        this.dg.makeNodePtrTbl();
        initNodes = this.dg.getInitNodes();
        numOfInits = initNodes.size();
        nodeQueue = new MemIntQueue(this.liveCheck.getMetaDir(), "root", numOfInits / 2 * 5);
        j = 0;
        while (j < numOfInits) {
            state = initNodes.elementAt(j);
            ptr = this.dg.getLink(state, tidx = (int)initNodes.elementAt(j + 1));
            if (ptr >= 0L) {
                if (!LiveWorker.$assertionsDisabled && !DiskGraph.isFilePointer(ptr)) {
                    throw new AssertionError();
                }
                nodeQueue.enqueueLong(state);
                nodeQueue.enqueueInt(tidx);
                nodeQueue.enqueueLong(ptr);
            } else if (!LiveWorker.$assertionsDisabled && this.isFinalCheck && (ptr == -8589934592L || ptr == -12884901888L)) {
                throw new AssertionError();
            }
            j += 2;
        }
        eaaction = this.pem.EAAction;
        slen = this.oos.getCheckState().length;
        alen = this.oos.getCheckAction().length;
        var10_14 = LiveWorker.class;
        synchronized (LiveWorker.class) {
            dfsStack = this.getStack(this.liveCheck.getMetaDir(), "dfs" + this.id);
            comStack = this.getStack(this.liveCheck.getMetaDir(), "com" + this.id);
            // ** MonitorExit[var10_14] (shouldn't be in output)
            if (true) ** GOTO lbl99
            do {
                state = nodeQueue.dequeueLong();
                tidx = nodeQueue.dequeueInt();
                loc = nodeQueue.dequeueLong();
                dfsStack.reset();
                dfsStack.pushLong(state);
                dfsStack.pushInt(tidx);
                dfsStack.pushLong(loc);
                dfsStack.pushLong(0x4000000000000000L);
                newLink = 0x4000000000000000L;
                while (dfsStack.size() >= 7L) {
                    lowLink = dfsStack.popLong();
                    curLoc = dfsStack.popLong();
                    curTidx = dfsStack.popInt();
                    curState = dfsStack.popLong();
                    if (!LiveWorker.$assertionsDisabled && !DiskGraph.isFilePointer(curLoc)) {
                        throw new AssertionError();
                    }
                    if (curLoc == -42L) {
                        curLink = this.dg.getLink(curState, curTidx);
                        if (!LiveWorker.$assertionsDisabled && curLink >= 0x7FFFFFFFFFFFFFFFL) {
                            throw new AssertionError();
                        }
                        if (curLink == lowLink && !(isOK = this.checkComponent(tool, curState, curTidx, comStack))) {
                            return;
                        }
                        plowLink = dfsStack.popLong();
                        dfsStack.pushLong(Math.min(plowLink, lowLink));
                        continue;
                    }
                    link = this.dg.putLink(curState, curTidx, newLink);
                    if (link == -1L) {
                        dfsStack.pushLong(lowLink);
                        dfsStack.pushLong(curState);
                        dfsStack.pushInt(curTidx);
                        dfsStack.pushLong(-42L);
                        comStack.pushLong(curLoc);
                        comStack.pushInt(curTidx);
                        comStack.pushLong(curState);
                        gnode = this.dg.getNode(curState, curTidx, curLoc);
                        succCnt = gnode.succSize();
                        nextLowLink = newLink++;
                        i = 0;
                        while (i < succCnt) {
                            nextState = gnode.getStateFP(i);
                            nextLink = this.dg.getLink(nextState, nextTidx = gnode.getTidx(i));
                            if (nextLink >= 0L) {
                                if (gnode.getCheckAction(slen, alen, i, eaaction)) {
                                    if (DiskGraph.isFilePointer(nextLink)) {
                                        dfsStack.pushLong(nextState);
                                        dfsStack.pushInt(nextTidx);
                                        dfsStack.pushLong(nextLink);
                                    } else {
                                        nextLowLink = Math.min(nextLowLink, nextLink);
                                    }
                                } else if (DiskGraph.isFilePointer(nextLink)) {
                                    nodeQueue.enqueueLong(nextState);
                                    nodeQueue.enqueueInt(nextTidx);
                                    nodeQueue.enqueueLong(nextLink);
                                }
                            } else if (!LiveWorker.$assertionsDisabled && this.isFinalCheck && nextLink == -8589934592L) {
                                throw new AssertionError();
                            }
                            ++i;
                        }
                        dfsStack.pushLong(nextLowLink);
                        continue;
                    }
                    if (!(LiveWorker.$assertionsDisabled || 0x4000000000000000L <= link && link <= 0x7FFFFFFFFFFFFFFFL)) {
                        throw new AssertionError();
                    }
                    dfsStack.pushLong(Math.min(lowLink, link));
                }
lbl99:
                // 2 sources

            } while (nodeQueue.size() > 0L);
            if (!LiveWorker.$assertionsDisabled && comStack.size() != 0L) {
                throw new AssertionError();
            }
            return;
        }
    }

    private IntStack getStack(String metaDir, String name) throws IOException {
        try {
            double freeMemoryInBytes = (double)Runtime.getRuntime().freeMemory() / ((double)this.numWorkers * 1.0);
            long graphSizeInBytes = this.dg.getSizeOnDisk();
            double ratio = (double)graphSizeInBytes / freeMemoryInBytes;
            if (ratio > TLCGlobals.livenessGraphSizeThreshold) {
                int capacityInBytes = 0x800000 << Math.min((int)ratio, 5);
                if ((double)capacityInBytes < freeMemoryInBytes) {
                    return new SynchronousDiskIntStack(metaDir, name, capacityInBytes);
                }
                return new SynchronousDiskIntStack(metaDir, name);
            }
            return new MemIntStack(metaDir, name);
        }
        catch (OutOfMemoryError oom) {
            System.gc();
            SynchronousDiskIntStack sdis = new SynchronousDiskIntStack(metaDir, name, 0x400000);
            MP.printWarning(1000, "Liveness checking will be extremely slow because TLC is running low on memory.\nTry allocating more memory to the Java pool (heap) in future TLC runs.");
            return sdis;
        }
    }

    private boolean checkComponent(ITool tool, long state, int tidx, IntStack comStack) throws IOException, InterruptedException, ExecutionException {
        long comStackSize = comStack.size();
        assert (comStackSize >= 5L && comStackSize % 5L == 0L);
        long state1 = comStack.popLong();
        int tidx1 = comStack.popInt();
        long loc1 = comStack.popLong();
        if (state1 == state && tidx1 == tidx && !this.isStuttering(state1, tidx1, loc1)) {
            this.dg.setMaxLink(state, tidx);
            return true;
        }
        TableauNodePtrTable com = new TableauNodePtrTable(128);
        while (true) {
            com.put(state1, tidx1, loc1);
            assert (AbstractDiskGraph.isFilePointer(loc1));
            this.dg.setMaxLink(state1, tidx1);
            if (state == state1 && tidx == tidx1) break;
            state1 = comStack.popLong();
            tidx1 = comStack.popInt();
            loc1 = comStack.popLong();
        }
        assert ((long)com.size() <= comStackSize / 5L);
        STATS.addSample(com.size());
        int slen = this.oos.getCheckState().length;
        int alen = this.oos.getCheckAction().length;
        int aeslen = this.pem.AEState.length;
        int aealen = this.pem.AEAction.length;
        int plen = this.oos.getPromises().length;
        boolean[] AEStateRes = new boolean[aeslen];
        boolean[] AEActionRes = new boolean[aealen];
        boolean[] promiseRes = new boolean[plen];
        int[] eaaction = this.pem.EAAction;
        int tsz = com.getSize();
        int ci = 0;
        while (ci < tsz) {
            int[] nodes = com.getNodesByLoc(ci);
            if (nodes != null) {
                state1 = TableauNodePtrTable.getKey(nodes);
                int nidx = 2;
                while (nidx < nodes.length) {
                    tidx1 = TableauNodePtrTable.getTidx(nodes, nidx);
                    loc1 = TableauNodePtrTable.getElem(nodes, nidx);
                    GraphNode curNode = this.dg.getNode(state1, tidx1, loc1);
                    int i = 0;
                    while (i < aeslen) {
                        if (!AEStateRes[i]) {
                            int idx = this.pem.AEState[i];
                            AEStateRes[i] = curNode.getCheckState(idx);
                        }
                        ++i;
                    }
                    int succCnt = aealen > 0 ? curNode.succSize() : 0;
                    int i2 = 0;
                    while (i2 < succCnt) {
                        int nextTidx;
                        long nextState = curNode.getStateFP(i2);
                        if (com.getLoc(nextState, nextTidx = curNode.getTidx(i2)) != -1 && curNode.getCheckAction(slen, alen, i2, eaaction)) {
                            int j = 0;
                            while (j < aealen) {
                                if (!AEActionRes[j]) {
                                    int idx = this.pem.AEAction[j];
                                    AEActionRes[j] = curNode.getCheckAction(slen, alen, i2, idx);
                                }
                                ++j;
                            }
                        }
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < plen) {
                        LNEven promise = this.oos.getPromises()[i2];
                        TBPar par = curNode.getTNode(this.oos.getTableau()).getPar();
                        if (par.isFulfilling(promise)) {
                            promiseRes[i2] = true;
                        }
                        ++i2;
                    }
                    nidx += com.getElemLength();
                }
            }
            ++ci;
        }
        int i = 0;
        while (i < aeslen) {
            if (!AEStateRes[i]) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < aealen) {
            if (!AEActionRes[i]) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < plen) {
            if (!promiseRes[i]) {
                return true;
            }
            ++i;
        }
        if (this.setErrFound()) {
            this.printTrace(tool, state, tidx, com);
        }
        return false;
    }

    private boolean isStuttering(long state, int tidx, long loc) throws IOException {
        int slen = this.oos.getCheckState().length;
        int alen = this.oos.getCheckAction().length;
        GraphNode gnode = this.dg.getNode(state, tidx, loc);
        int succCnt = gnode.succSize();
        int i = 0;
        while (i < succCnt) {
            long nextState = gnode.getStateFP(i);
            int nextTidx = gnode.getTidx(i);
            if (state == nextState && tidx == nextTidx) {
                return gnode.getCheckAction(slen, alen, i, this.pem.EAAction);
            }
            ++i;
        }
        return false;
    }

    private void printTrace(final ITool tool, final long state, final int tidx, TableauNodePtrTable nodeTbl) throws IOException, InterruptedException, ExecutionException {
        TLCStateInfo cycleState;
        List<TLCStateInfo> states;
        MP.printError(2116);
        MP.printError(2264);
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<List<TLCStateInfo>> future = executor.submit(new Callable<List<TLCStateInfo>>(){

            @Override
            public List<TLCStateInfo> call() throws Exception {
                LongVec prefix = LiveWorker.this.dg.getPath(state, tidx);
                int plen = prefix.size();
                ArrayList<TLCStateInfo> states = new ArrayList<TLCStateInfo>(plen);
                long fp = prefix.elementAt(plen - 1);
                TLCStateInfo sinfo = tool.getState(fp);
                if (sinfo == null) {
                    throw new EvalException(2123);
                }
                states.add(sinfo);
                int i = plen - 2;
                while (i >= 0) {
                    long curFP = prefix.elementAt(i);
                    if (curFP != fp) {
                        sinfo = tool.getState(curFP, sinfo);
                        states.add(sinfo);
                        fp = curFP;
                    }
                    --i;
                }
                i = 0;
                while (i < states.size() - 1) {
                    int j = i;
                    StatePrinter.printInvariantViolationStateTraceState(tool.getDebugger().evalAlias((TLCStateInfo)states.get(i), ((TLCStateInfo)states.get((int)(i + 1))).state, () -> new ArrayList(states.subList(0, j))));
                    ++i;
                }
                return states;
            }
        });
        MemIntStack cycleStack = new MemIntStack(this.liveCheck.getMetaDir(), "cycle");
        GraphNode curNode = this.dfsPostFix(state, tidx, nodeTbl, cycleStack);
        LongVec postfix = this.bfsPostFix(state, tidx, nodeTbl, curNode);
        while (cycleStack.size() > 0L) {
            long fp = cycleStack.popLong();
            if (postfix.isEmpty() || postfix.lastElement() != fp) {
                postfix.addElement(fp);
            }
            cycleStack.popInt();
        }
        try {
            states = future.get();
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof EvalException) {
                throw (EvalException)ee.getCause();
            }
            throw ee;
        }
        TLCStateInfo sinfo = cycleState = states.get(states.size() - 1);
        if (postfix.isEmpty()) {
            StatePrinter.printInvariantViolationStateTraceState(tool.getDebugger().evalAlias(cycleState, cycleState.state, () -> new ArrayList(states)));
        } else {
            postfix.pack().removeLastIf(cycleState.fingerPrint());
            int i = postfix.size() - 1;
            while (i >= 0) {
                long curFP = postfix.elementAt(i);
                TLCStateInfo sucinfo = tool.getState(curFP, sinfo);
                StatePrinter.printInvariantViolationStateTraceState(tool.getDebugger().evalAlias(sinfo, sucinfo.state, () -> new ArrayList(states)));
                states.add(sucinfo);
                sinfo = sucinfo;
                --i;
            }
            StatePrinter.printInvariantViolationStateTraceState(tool.getDebugger().evalAlias(sinfo, cycleState.state, () -> new ArrayList(states)));
        }
        int stateNumber = (int)cycleState.stateNumber;
        if (sinfo.fingerPrint() == cycleState.fingerPrint()) {
            StatePrinter.printStutteringState(stateNumber);
        } else {
            sinfo = tool.getState(cycleState.fingerPrint(), sinfo);
            assert (tool.getViewSpec() != null || cycleState.state.equals(sinfo.state));
            StatePrinter.printBackToState(sinfo, stateNumber);
        }
        tool.getDebugger().checkPostConditionWithCounterExample(new CounterExample(states, sinfo.getAction(), stateNumber));
    }

    private LongVec bfsPostFix(long state, int tidx, TableauNodePtrTable nodeTbl, GraphNode curNode) throws IOException {
        int slen = this.oos.getCheckState().length;
        int alen = this.oos.getCheckAction().length;
        int[] eaaction = this.pem.EAAction;
        LongVec postfix = new LongVec(16);
        long startState = curNode.stateFP;
        long startTidx = curNode.tindex;
        if (startState != state || startTidx != (long)tidx) {
            MemIntQueue queue = new MemIntQueue(this.liveCheck.getMetaDir(), null);
            long curState = startState;
            int ploc = -1;
            int curLoc = nodeTbl.getNodesLoc(curState);
            int[] nodes = nodeTbl.getNodesByLoc(curLoc);
            TableauNodePtrTable.setSeen(nodes);
            block0: while (true) {
                int tloc = TableauNodePtrTable.startLoc(nodes);
                while (tloc != -1) {
                    int curTidx = TableauNodePtrTable.getTidx(nodes, tloc);
                    long curPtr = TableauNodePtrTable.getPtr(TableauNodePtrTable.getElem(nodes, tloc));
                    curNode = this.dg.getNode(curState, curTidx, curPtr);
                    int succCnt = curNode.succSize();
                    int j = 0;
                    while (j < succCnt) {
                        long nextState = curNode.getStateFP(j);
                        int nextTidx = curNode.getTidx(j);
                        if (curState == nextState && curTidx == nextTidx) {
                            assert (TableauNodePtrTable.isSeen(nodes));
                        } else if (curNode.getCheckAction(slen, alen, j, eaaction)) {
                            if (nextState == state && nextTidx == tidx) {
                                while (curState != startState) {
                                    postfix.addElement(curState);
                                    nodes = nodeTbl.getNodesByLoc(ploc);
                                    curState = TableauNodePtrTable.getKey(nodes);
                                    ploc = TableauNodePtrTable.getParent(nodes);
                                }
                                postfix.addElement(startState);
                                break block0;
                            }
                            int[] nodes1 = nodeTbl.getNodes(nextState);
                            if (nodes1 != null && !TableauNodePtrTable.isSeen(nodes1)) {
                                TableauNodePtrTable.setSeen(nodes1);
                                queue.enqueueLong(nextState);
                                queue.enqueueInt(curLoc);
                            }
                        }
                        ++j;
                    }
                    tloc = TableauNodePtrTable.nextLoc(nodes, tloc);
                }
                TableauNodePtrTable.setParent(nodes, ploc);
                curState = queue.dequeueLong();
                ploc = queue.dequeueInt();
                curLoc = nodeTbl.getNodesLoc(curState);
                nodes = nodeTbl.getNodesByLoc(curLoc);
            }
        }
        return postfix;
    }

    /*
     * Unable to fully structure code
     */
    private GraphNode dfsPostFix(long state, int tidx, TableauNodePtrTable nodeTbl, MemIntStack cycleStack) throws IOException {
        slen = this.oos.getCheckState().length;
        alen = this.oos.getCheckAction().length;
        AEStateRes = new boolean[this.pem.AEState.length];
        AEActionRes = new boolean[this.pem.AEAction.length];
        promiseRes = new boolean[this.oos.getPromises().length];
        eaaction = this.pem.EAAction;
        cnt = AEStateRes.length + AEActionRes.length + promiseRes.length;
        nodes = nodeTbl.getNodes(state);
        tloc = nodeTbl.getIdx(nodes, tidx);
        ptr = TableauNodePtrTable.getElem(nodes, tloc);
        TableauNodePtrTable.setSeen(nodes, tloc);
        curNode = this.dg.getNode(state, tidx, ptr);
        block0: while (cnt > 0) {
            cnt0 = cnt;
            while (true) {
                i = 0;
                while (i < this.pem.AEState.length) {
                    idx = this.pem.AEState[i];
                    if (!AEStateRes[i] && curNode.getCheckState(idx)) {
                        AEStateRes[i] = true;
                        --cnt;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.oos.getPromises().length) {
                    promise = this.oos.getPromises()[i];
                    par = curNode.getTNode(this.oos.getTableau()).getPar();
                    if (!promiseRes[i] && par.isFulfilling(promise)) {
                        promiseRes[i] = true;
                        --cnt;
                    }
                    ++i;
                }
                if (cnt <= 0) continue block0;
                nextState1 = 0L;
                nextState2 = 0L;
                nextTidx1 = 0;
                nextTidx2 = 0;
                tloc1 = -1;
                tloc2 = -1;
                nodes1 = null;
                nodes2 = null;
                hasUnvisitedSucc = false;
                cnt1 = cnt;
                succCnt = curNode.succSize();
                i = 0;
                while (i < succCnt) {
                    nextState = curNode.getStateFP(i);
                    nextTidx = curNode.getTidx(i);
                    nodes = nodeTbl.getNodes(nextState);
                    if (nodes != null) {
                        tloc = nodeTbl.getIdx(nodes, nextTidx);
                        if (tloc != -1 && curNode.getCheckAction(slen, alen, i, eaaction)) {
                            nextState1 = nextState;
                            nextTidx1 = nextTidx;
                            tloc1 = tloc;
                            nodes1 = nodes;
                            j = 0;
                            while (j < this.pem.AEAction.length) {
                                idx = this.pem.AEAction[j];
                                if (!AEActionRes[j] && curNode.getCheckAction(slen, alen, i, idx)) {
                                    AEActionRes[j] = true;
                                    --cnt;
                                }
                                ++j;
                            }
                        }
                    } else {
                        if (cnt < cnt1) {
                            cycleStack.pushInt(curNode.tindex);
                            cycleStack.pushLong(curNode.stateFP);
                            nextPtr = TableauNodePtrTable.getPtr(TableauNodePtrTable.getElem(nodes, tloc));
                            curNode = this.dg.getNode(nextState, nextTidx, nextPtr);
                            nodeTbl.resetElems();
                            continue block0;
                        }
                        if (nodes != null && tloc != -1 && !TableauNodePtrTable.isSeen(nodes, tloc)) {
                            hasUnvisitedSucc = true;
                            nextState2 = nextState;
                            nextTidx2 = nextTidx;
                            tloc2 = tloc;
                            nodes2 = nodes;
                        }
                    }
                    ++i;
                }
                if (cnt >= cnt0) ** GOTO lbl103
                cycleStack.pushInt(curNode.tindex);
                cycleStack.pushLong(curNode.stateFP);
                nextPtr = TableauNodePtrTable.getPtr(TableauNodePtrTable.getElem(nodes1, tloc1));
                curNode = this.dg.getNode(nextState1, nextTidx1, nextPtr);
                nodeTbl.resetElems();
                continue block0;
lbl-1000:
                // 1 sources

                {
                    curState = cycleStack.popLong();
                    curTidx = cycleStack.popInt();
                    curPtr = TableauNodePtrTable.getPtr(nodeTbl.get(curState, curTidx));
                    curNode = this.dg.getNode(curState, curTidx, curPtr);
                    succCnt = curNode.succSize();
                    i = 0;
                    while (i < succCnt) {
                        nextState2 = curNode.getStateFP(i);
                        nextTidx2 = curNode.getTidx(i);
                        nodes2 = nodeTbl.getNodes(nextState2);
                        if (nodes2 != null && (tloc2 = nodeTbl.getIdx(nodes2, nextTidx2)) != -1 && !TableauNodePtrTable.isSeen(nodes2, tloc2)) {
                            hasUnvisitedSucc = true;
                            continue block6;
                        }
                        ++i;
                    }
lbl103:
                    // 3 sources

                    ** while (!hasUnvisitedSucc)
                }
lbl104:
                // 1 sources

                cycleStack.pushInt(curNode.tindex);
                cycleStack.pushLong(curNode.stateFP);
                nextPtr = TableauNodePtrTable.getPtr(TableauNodePtrTable.getElem(nodes2, tloc2));
                curNode = this.dg.getNode(nextState2, nextTidx2, nextPtr);
                TableauNodePtrTable.setSeen(nodes2, tloc2);
            }
        }
        nodeTbl.resetElems();
        return curNode;
    }

    @Override
    public final Boolean call() throws IOException, InterruptedException, ExecutionException {
        ILiveChecker checker;
        while ((checker = (ILiveChecker)this.queue.poll()) != null && !LiveWorker.hasErrFound()) {
            this.oos = checker.getSolution();
            this.dg = checker.getDiskGraph();
            this.dg.createCache();
            PossibleErrorModel[] pems = this.oos.getPems();
            int i = 0;
            while (i < pems.length) {
                if (!LiveWorker.hasErrFound()) {
                    this.pem = pems[i];
                    this.checkSccs(this.tool);
                }
                ++i;
            }
            this.dg.destroyCache();
            this.dg.recordSize();
            assert (this.dg.checkInvariants(this.oos.getCheckState().length, this.oos.getCheckAction().length));
        }
        return LiveWorker.hasErrFound(this.id);
    }

    public String toDotViz(long state, int tidx, TableauNodePtrTable tnpt) throws IOException {
        StringBuffer sb = new StringBuffer(tnpt.size() * 10);
        sb.append("digraph TableauNodePtrTable {\n");
        sb.append("nodesep = 0.7\n");
        sb.append("rankdir=LR;\n");
        int tsz = tnpt.getSize();
        int ci = 0;
        while (ci < tsz) {
            int[] nodes = tnpt.getNodesByLoc(ci);
            if (nodes != null) {
                long state1 = TableauNodePtrTable.getKey(nodes);
                int nidx = 2;
                while (nidx < nodes.length) {
                    int tidx1 = TableauNodePtrTable.getTidx(nodes, nidx);
                    long loc1 = TableauNodePtrTable.getElem(nodes, nidx);
                    GraphNode curNode = this.dg.getNode(state1, tidx1, loc1);
                    sb.append(curNode.toDotViz(state1 == state && tidx1 == tidx, true, this.oos.getCheckState().length, this.oos.getCheckAction().length, tnpt, this.oos));
                    nidx += tnpt.getElemLength();
                }
            }
            ++ci;
        }
        sb.append("}");
        return sb.toString();
    }

    public void writeDotViz(long state, int tidx, TableauNodePtrTable tnpt, File file) {
        if (tnpt.size() <= 1) {
            return;
        }
        try {
            BufferedWriter bwr = new BufferedWriter(new FileWriter(file));
            bwr.write(this.toDotViz(state, tidx, tnpt));
            bwr.flush();
            bwr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class DFSStackDetailedFormatter {
        public static String toString(MemIntStack dfsStack) {
            int size = (int)dfsStack.size();
            StringBuffer buf = new StringBuffer(size / 7);
            int i = 0;
            while ((long)i < dfsStack.size()) {
                long topElement = dfsStack.peakLong(size - i - 2);
                if (topElement == -42L) {
                    buf.append("node [");
                    buf.append(" fp: ");
                    buf.append(dfsStack.peakLong(size - i - 5));
                    buf.append(" tidx: ");
                    buf.append(dfsStack.peakInt(size - i - 3));
                    buf.append(" lowLink: ");
                    buf.append(dfsStack.peakLong(size - i - 7) - 0x4000000000000000L);
                    buf.append("]\n");
                    i += 7;
                    continue;
                }
                if (DiskGraph.isFilePointer(topElement)) {
                    long location = topElement;
                    buf.append("succ [");
                    buf.append(" fp: ");
                    buf.append(dfsStack.peakLong(size - i - 5));
                    buf.append(" tidx: ");
                    buf.append(dfsStack.peakInt(size - i - 3));
                    buf.append(" location: ");
                    buf.append(location);
                    buf.append("]\n");
                    i += 5;
                    continue;
                }
                if (topElement < 0x4000000000000000L) continue;
                long pLowLink = topElement - 0x4000000000000000L;
                buf.append("pLowLink: ");
                buf.append(pLowLink);
                buf.append("\n");
                i += 2;
            }
            assert (i == size);
            return buf.toString();
        }
    }

    public static class DetailedFormatter {
        public static String toString(MemIntStack comStack) {
            int size = (int)comStack.size();
            StringBuffer buf = new StringBuffer(size / 5);
            int i = 0;
            while ((long)i < comStack.size()) {
                long loc = comStack.peakLong(size - i - 5);
                int tidx = comStack.peakInt(size - i - 3);
                long state = comStack.peakLong(size - i - 2);
                buf.append("state: ");
                buf.append(state);
                buf.append(" tidx: ");
                buf.append(tidx);
                buf.append(" loc: ");
                buf.append(loc);
                buf.append("\n");
                i += 5;
            }
            return buf.toString();
        }
    }
}

