/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.File;
import java.io.IOException;
import tlc2.tool.liveness.GraphNode;
import tlc2.tool.liveness.OrderOfSolution;
import tlc2.tool.liveness.TableauDiskGraph;
import tlc2.util.statistics.IBucketStatistics;

public class DebugTableauDiskGraph
extends TableauDiskGraph {
    private static final String FORMAT = "%s%sdgraph_%03d_%s.dot";
    private final OrderOfSolution oos;
    private int counter = 0;

    public DebugTableauDiskGraph(String metadir, int soln, IBucketStatistics graphStats, OrderOfSolution oos) throws IOException {
        super(metadir, soln, graphStats);
        this.oos = oos;
    }

    @Override
    public long addNode(GraphNode node) throws IOException {
        long l;
        try {
            l = super.addNode(node);
        }
        catch (Throwable throwable) {
            this.writeDotViz(this.oos, new File(String.format(FORMAT, this.metadir, File.separator, this.counter++, Long.toString(node.stateFP).substring(0, 6))));
            throw throwable;
        }
        this.writeDotViz(this.oos, new File(String.format(FORMAT, this.metadir, File.separator, this.counter++, Long.toString(node.stateFP).substring(0, 6))));
        return l;
    }

    @Override
    public int setDone(long fp) {
        int n;
        try {
            n = super.setDone(fp);
        }
        catch (Throwable throwable) {
            this.writeDotViz(this.oos, new File(String.format(FORMAT, this.metadir, File.separator, this.counter++, Long.toString(fp).substring(0, 6))));
            throw throwable;
        }
        this.writeDotViz(this.oos, new File(String.format(FORMAT, this.metadir, File.separator, this.counter++, Long.toString(fp).substring(0, 6))));
        return n;
    }

    @Override
    public void recordNode(long fp, int tidx) {
        try {
            super.recordNode(fp, tidx);
        }
        catch (Throwable throwable) {
            this.writeDotViz(this.oos, new File(String.format(FORMAT, this.metadir, File.separator, this.counter++, Long.toString(fp).substring(0, 6))));
            throw throwable;
        }
        this.writeDotViz(this.oos, new File(String.format(FORMAT, this.metadir, File.separator, this.counter++, Long.toString(fp).substring(0, 6))));
    }
}

