/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.PcalBuiltInSymbols;
import pcal.PcalCharReader;
import pcal.PcalDebug;
import pcal.TLAExpr;
import pcal.TLAToken;
import pcal.exception.TokenizerException;
import tla2tex.Misc;
import tla2tex.Symbol;

public class Tokenize {
    private static final int MODULE = 1;
    private static final int TLA = 2;
    public static String Delimiter;
    public static int DelimiterLine;
    public static int DelimiterCol;
    private static Vector<Vector<TLAToken>> vspec;
    private static Vector<TLAToken> linev;
    private static int nextChar;
    private static int getLineCorrection;
    private static String token;
    private static String token1;
    private static String token2;
    private static String token3;
    private static int col1;
    private static int col2;
    private static int col3;
    private static int parenDepth;
    private static boolean inQuantifier;
    private static int cdepth;
    private static int mdepth;
    private static int col;
    private static int ncol;
    public static PcalCharReader reader;
    private static final int PROLOG = 1;
    private static final int PROLOG_DASH = 2;
    private static final int PROLOG_DASHES = 3;
    private static final int PROLOG_SPACES = 4;
    private static final int PROLOG_ID = 5;
    private static final int START = 6;
    private static final int ID = 7;
    private static final int NUM_OR_ID = 8;
    private static final int BS = 9;
    private static final int NUM = 10;
    private static final int NUM_OR_BI = 11;
    private static final int BSBUILT_IN = 12;
    private static final int BUILT_IN = 13;
    private static final int DASH1 = 14;
    private static final int DASH2 = 15;
    private static final int DASH3 = 16;
    private static final int DASHES = 17;
    private static final int EQ1 = 18;
    private static final int EQ2 = 19;
    private static final int EQ3 = 20;
    private static final int EQS = 21;
    private static final int LEFT_PAREN = 22;
    private static final int STRING = 23;
    private static final int ESC_STRING = 24;
    private static final int LINE_COMMENT = 25;
    private static final int LINE_COM_PAREN = 26;
    private static final int LINE_COM_STAR = 27;
    private static final int COMMENT = 28;
    private static final int COMMENT_STAR = 29;
    private static final int COMMENT_PAREN = 30;
    private static final int OR_COMMENT = 31;
    private static final int OR_COMMENT_PAREN = 32;
    private static final int OR_COMMENT_STAR = 33;
    private static final int EPILOG = 34;
    private static final int DONE = 35;
    private static int state;
    private static boolean exprEnd;
    private static boolean parseExpression;
    private static String prevToken;

    static {
        vspec = null;
        linev = new Vector(30, 30);
        getLineCorrection = 0;
        token = "";
        token1 = "";
        token2 = "";
        token3 = "";
        col1 = 0;
        col2 = 0;
        col3 = 0;
        parenDepth = 0;
        inQuantifier = false;
        cdepth = 0;
        mdepth = 0;
        ncol = 0;
        state = 0;
        exprEnd = false;
        parseExpression = true;
        prevToken = " ";
    }

    private static void skipNextChar() {
        ncol = reader.getColumnNumber();
        nextChar = reader.getNextChar();
        getLineCorrection = nextChar == 10 ? -1 : 0;
    }

    private static void addNextChar() {
        token = String.valueOf(token) + Character.toString(nextChar);
        Tokenize.skipNextChar();
    }

    private static void gotoStart() {
        state = 6;
        col = ncol;
    }

    private static void TokenOut(int type) throws TokenizerException {
        if (parseExpression) {
            if (type == 1 || type == 2 || type == 3 || type == 4) {
                if (type != 3 && (Tokenize.IsDelimiter(token) && (type != 4 || !prevToken.equals(".") && !prevToken.equals("[") && !prevToken.equals(",")) || (token.equals(",") && !inQuantifier || token.equals(")") || token.equals("}")) && parenDepth == 0)) {
                    if (parenDepth != 0) {
                        Tokenize.TokenizingError("Expression with an unmatched (, [, {, or << followed by");
                    }
                    if (inQuantifier) {
                        Tokenize.TokenizingError("Expression with \\A or \\E but no following `:` followed by");
                    }
                    exprEnd = true;
                    Delimiter = token;
                    DelimiterCol = col;
                    DelimiterLine = reader.getLineNumber();
                    if (nextChar == 10) {
                        --DelimiterLine;
                    }
                    if (linev.size() > 0) {
                        Tokenize.startNewLine();
                    }
                } else {
                    if (type == 1) {
                        Symbol sym = PcalBuiltInSymbols.GetBuiltInSymbol(token);
                        if (sym.symbolType == 4) {
                            ++parenDepth;
                        }
                        if (sym.symbolType == 5 && --parenDepth < 0) {
                            Tokenize.TokenizingError("Extra (unmatching)");
                        }
                    }
                    prevToken = type == 3 ? " " : token;
                    if ((token.equals("\\A") || token.equals("\u2200") || token.equals("\\E") || token.equals("\u2203")) && parenDepth == 0) {
                        inQuantifier = true;
                    }
                    if (inQuantifier && token.equals(":") && parenDepth == 0) {
                        inQuantifier = false;
                    }
                    if (!token.equals("") || type == 3) {
                        linev.addElement(new TLAToken(token, col, type, reader.getLineNumber() + getLineCorrection));
                    }
                    token = "";
                }
            } else {
                Tokenize.TokenizingError("Illegal token in an expression");
            }
        } else {
            exprEnd = true;
            Delimiter = token;
            DelimiterCol = col;
            DelimiterLine = reader.getLineNumber();
            if (nextChar == 10) {
                --DelimiterLine;
            }
            token = "";
        }
    }

    private static boolean IsDelimiter(String tok) {
        return tok.equals(";") || tok.equals("do") || tok.equals("then") || tok.equals(":=") || tok.equals("\u2254") || tok.equals("begin") || tok.equals("variable") || tok.equals("variables") || tok.equals("||") || tok.equals("\u2016") || tok.equals("end") || tok.equals("else") || tok.equals("elsif") || tok.equals("if") || tok.equals("either") || tok.equals("or") || tok.equals("while") || tok.equals("with") || tok.equals("call") || tok.equals("return") || tok.equals("goto") || tok.equals("print") || tok.equals("assert") || tok.equals("skip") || tok.equals("procedure") || tok.equals("define") || tok.equals("process") || tok.equals("fair");
    }

    private static void CommentTokenOut() {
        token = "";
    }

    private static void startNewLine() {
        vspec.addElement(linev);
        linev = new Vector(30, 30);
        col = 0;
    }

    private static void TokenizingError(String msg) throws TokenizerException {
        throw new TokenizerException(msg + " `" + token + "' found at\n    line " + (reader.getLineNumber() + 1) + ", column " + (col + 1));
    }

    public static TLAExpr TokenizeExpr(PcalCharReader charReader) throws TokenizerException {
        TLAExpr exp = Tokenize.InnerTokenize(charReader, true);
        return exp;
    }

    public static String GetAlgorithmToken(PcalCharReader charReader) throws TokenizerException {
        Tokenize.InnerTokenize(charReader, false);
        return Delimiter;
    }

    public static TLAExpr InnerTokenize(PcalCharReader charReader, boolean isExpr) throws TokenizerException {
        int mode = 2;
        col = ncol = charReader.getColumnNumber();
        parseExpression = isExpr;
        prevToken = " ";
        vspec = new Vector(4);
        reader = charReader;
        linev = new Vector();
        token = "";
        nextChar = reader.getNextChar();
        getLineCorrection = nextChar == 10 ? -1 : 0;
        parenDepth = 0;
        inQuantifier = false;
        switch (mode) {
            case 1: {
                state = 1;
                break;
            }
            case 2: {
                state = 6;
                break;
            }
            default: {
                PcalDebug.ReportBug("TokenizeSpec.Tokenize called with illegal mode");
            }
        }
        exprEnd = false;
        block40: while (state != 35 && !exprEnd) {
            switch (state) {
                case 6: {
                    if (Misc.IsSpace(nextChar)) {
                        Tokenize.skipNextChar();
                        Tokenize.gotoStart();
                        break;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        Tokenize.addNextChar();
                        state = 7;
                        break;
                    }
                    if (8469 == nextChar || 8484 == nextChar || 8477 == nextChar) {
                        Tokenize.addNextChar();
                        Tokenize.TokenOut(4);
                        Tokenize.gotoStart();
                        break;
                    }
                    if (Misc.IsDigit(nextChar)) {
                        Tokenize.addNextChar();
                        state = 8;
                        break;
                    }
                    if (nextChar == 92) {
                        Tokenize.addNextChar();
                        state = 9;
                        break;
                    }
                    if (nextChar == 45) {
                        Tokenize.addNextChar();
                        state = 14;
                        break;
                    }
                    if (nextChar == 61) {
                        Tokenize.addNextChar();
                        state = 18;
                        break;
                    }
                    if (nextChar == 40) {
                        Tokenize.skipNextChar();
                        state = 22;
                        break;
                    }
                    if (nextChar == 34) {
                        Tokenize.skipNextChar();
                        state = 23;
                        break;
                    }
                    if (nextChar == 10) {
                        Tokenize.skipNextChar();
                        Tokenize.startNewLine();
                        Tokenize.gotoStart();
                        break;
                    }
                    if (PcalBuiltInSymbols.IsBuiltInPrefix(Character.toString(nextChar))) {
                        Tokenize.addNextChar();
                        state = 13;
                        break;
                    }
                    if (nextChar == 9) {
                        if (mode == 1) {
                            throw new TokenizerException("Input ended before end of module");
                        }
                        state = 35;
                        break;
                    }
                    Tokenize.addNextChar();
                    Tokenize.TokenizingError("Illegal lexeme");
                    break;
                }
                case 7: {
                    if (token.length() == 3 && (token.equals("WF_") || token.equals("SF_"))) {
                        Tokenize.TokenOut(1);
                        Tokenize.gotoStart();
                        break;
                    }
                    if (Misc.IsLetter(nextChar) || Misc.IsDigit(nextChar)) {
                        Tokenize.addNextChar();
                        break;
                    }
                    if (PcalBuiltInSymbols.IsBuiltInSymbol(token)) {
                        if (token.equals("MODULE")) {
                            ++mdepth;
                        }
                        Tokenize.TokenOut(1);
                        Tokenize.gotoStart();
                        break;
                    }
                    Tokenize.TokenOut(4);
                    Tokenize.gotoStart();
                    break;
                }
                case 8: {
                    if (Misc.IsDigit(nextChar)) {
                        Tokenize.addNextChar();
                        state = 8;
                        break;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        Tokenize.addNextChar();
                        state = 7;
                        break;
                    }
                    Tokenize.TokenOut(2);
                    Tokenize.gotoStart();
                    break;
                }
                case 9: {
                    if (nextChar == 98 || nextChar == 66 || nextChar == 111 || nextChar == 79 || nextChar == 104 || nextChar == 72) {
                        Tokenize.addNextChar();
                        state = 11;
                        break;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        state = 12;
                        break;
                    }
                    if (nextChar == 42) {
                        Tokenize.skipNextChar();
                        token = "";
                        state = 25;
                        break;
                    }
                    state = 13;
                    break;
                }
                case 11: {
                    if (Misc.IsDigit(nextChar)) {
                        state = 10;
                        break;
                    }
                    state = 12;
                    break;
                }
                case 10: {
                    if (Misc.IsDigit(nextChar)) {
                        Tokenize.addNextChar();
                        state = 10;
                        break;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        Tokenize.addNextChar();
                        if (token.charAt(0) == '\\') {
                            Tokenize.TokenizingError("Illegal lexeme");
                            break;
                        }
                        state = 7;
                        break;
                    }
                    Tokenize.TokenOut(2);
                    Tokenize.gotoStart();
                    break;
                }
                case 12: {
                    if (Misc.IsLetter(nextChar) && nextChar != 95) {
                        Tokenize.addNextChar();
                        state = 12;
                        break;
                    }
                    if (PcalBuiltInSymbols.IsBuiltInSymbol(token)) {
                        Tokenize.TokenOut(1);
                        Tokenize.gotoStart();
                        break;
                    }
                    Tokenize.TokenizingError("Illegal lexeme ");
                    break;
                }
                case 13: {
                    if (PcalBuiltInSymbols.IsBuiltInPrefix(token + Character.toString(nextChar))) {
                        Tokenize.addNextChar();
                        break;
                    }
                    if (!PcalBuiltInSymbols.IsBuiltInSymbol(token)) {
                        reader.backspace();
                        while (!PcalBuiltInSymbols.IsBuiltInSymbol(token)) {
                            reader.backspace();
                            if (token.length() == 0) {
                                Tokenize.TokenizingError("Illegal lexeme");
                            }
                            token = token.substring(0, token.length() - 1);
                        }
                        Tokenize.skipNextChar();
                    }
                    Tokenize.TokenOut(1);
                    Tokenize.gotoStart();
                    break;
                }
                case 14: {
                    if (nextChar == 45) {
                        Tokenize.addNextChar();
                        state = 15;
                        break;
                    }
                    state = 13;
                    break;
                }
                case 15: {
                    if (nextChar == 45) {
                        Tokenize.addNextChar();
                        state = 16;
                        break;
                    }
                    state = 13;
                    break;
                }
                case 16: {
                    if (nextChar == 45) {
                        Tokenize.addNextChar();
                        state = 17;
                        break;
                    }
                    Tokenize.TokenizingError("Illegal lexeme");
                    break;
                }
                case 17: {
                    if (nextChar == 45) {
                        Tokenize.addNextChar();
                        state = 17;
                        break;
                    }
                    Tokenize.TokenOut(6);
                    Tokenize.gotoStart();
                    break;
                }
                case 18: {
                    if (nextChar == 61) {
                        Tokenize.addNextChar();
                        state = 19;
                        break;
                    }
                    state = 13;
                    break;
                }
                case 19: {
                    if (nextChar == 61) {
                        Tokenize.addNextChar();
                        state = 20;
                        break;
                    }
                    state = 13;
                    break;
                }
                case 20: {
                    if (nextChar == 61) {
                        Tokenize.addNextChar();
                        state = 21;
                        break;
                    }
                    Tokenize.TokenizingError("Illegal lexeme");
                    break;
                }
                case 21: {
                    if (nextChar == 61) {
                        Tokenize.addNextChar();
                        state = 21;
                        break;
                    }
                    Tokenize.TokenOut(7);
                    if (--mdepth > 0 || mode == 2) {
                        Tokenize.gotoStart();
                        break;
                    }
                    if (mdepth == 0) {
                        state = 34;
                        break;
                    }
                    throw new TokenizerException("Extra end-of-module lexeme on line " + (reader.getLineNumber() + 1));
                }
                case 22: {
                    if (nextChar == 42) {
                        Tokenize.skipNextChar();
                        cdepth = 1;
                        state = 28;
                        break;
                    }
                    token = "(";
                    state = 13;
                    break;
                }
                case 23: {
                    if (nextChar == 92) {
                        Tokenize.addNextChar();
                        state = 24;
                        break;
                    }
                    if (nextChar == 34) {
                        Tokenize.skipNextChar();
                        Tokenize.TokenOut(3);
                        Tokenize.gotoStart();
                        break;
                    }
                    if (PcalBuiltInSymbols.IsStringChar(Character.toString(nextChar))) {
                        Tokenize.addNextChar();
                        state = 23;
                        break;
                    }
                    Tokenize.addNextChar();
                    Tokenize.TokenizingError("Illegal character in string");
                    break;
                }
                case 24: {
                    if (nextChar == 34 || nextChar == 92 || nextChar == 116 || nextChar == 110 || nextChar == 102 || nextChar == 114) {
                        Tokenize.addNextChar();
                        state = 23;
                        break;
                    }
                    Tokenize.addNextChar();
                    Tokenize.TokenizingError("Illegal character following \\ in string");
                    break;
                }
                case 25: {
                    if (nextChar == 40) {
                        Tokenize.skipNextChar();
                        state = 26;
                        break;
                    }
                    if (nextChar == 42 && cdepth > 0) {
                        Tokenize.skipNextChar();
                        state = 27;
                        break;
                    }
                    if (nextChar == 10 || nextChar == 9) {
                        Tokenize.CommentTokenOut();
                        cdepth = 0;
                        Tokenize.gotoStart();
                        break;
                    }
                    if (cdepth == 0) {
                        Tokenize.addNextChar();
                    } else {
                        Tokenize.skipNextChar();
                    }
                    state = 25;
                    break;
                }
                case 26: {
                    if (nextChar == 42) {
                        Tokenize.skipNextChar();
                        ++cdepth;
                        state = 25;
                        break;
                    }
                    if (cdepth == 0) {
                        token = String.valueOf(token) + "(";
                    }
                    state = 25;
                    break;
                }
                case 27: {
                    if (nextChar == 41) {
                        Tokenize.skipNextChar();
                        PcalDebug.Assert(--cdepth >= 0, "case LINE_COM_STAR");
                        state = 25;
                        break;
                    }
                    if (cdepth == 0) {
                        token = String.valueOf(token) + "*";
                    }
                    state = 25;
                    break;
                }
                case 28: {
                    if (nextChar == 42) {
                        Tokenize.skipNextChar();
                        state = 29;
                        break;
                    }
                    if (nextChar == 40) {
                        Tokenize.skipNextChar();
                        state = 30;
                        break;
                    }
                    if (nextChar == 10) {
                        Tokenize.CommentTokenOut();
                        Tokenize.skipNextChar();
                        Tokenize.startNewLine();
                        state = 31;
                        break;
                    }
                    if (nextChar == 9) {
                        throw new TokenizerException("Input ended in the middle of a comment");
                    }
                    if (cdepth == 1) {
                        Tokenize.addNextChar();
                        break;
                    }
                    Tokenize.skipNextChar();
                    break;
                }
                case 29: {
                    if (nextChar == 41) {
                        Tokenize.skipNextChar();
                        if (--cdepth == 0) {
                            Tokenize.CommentTokenOut();
                            Tokenize.gotoStart();
                            break;
                        }
                        state = 28;
                        break;
                    }
                    if (cdepth == 1) {
                        token = String.valueOf(token) + "*";
                    }
                    state = 28;
                    break;
                }
                case 30: {
                    if (nextChar == 42) {
                        Tokenize.skipNextChar();
                        ++cdepth;
                        state = 28;
                        break;
                    }
                    if (cdepth == 1) {
                        token = String.valueOf(token) + "(";
                    }
                    state = 28;
                    break;
                }
                case 31: {
                    if (nextChar == 42) {
                        Tokenize.skipNextChar();
                        state = 33;
                        break;
                    }
                    if (nextChar == 40) {
                        Tokenize.skipNextChar();
                        state = 32;
                        break;
                    }
                    if (nextChar == 10) {
                        Tokenize.CommentTokenOut();
                        Tokenize.skipNextChar();
                        Tokenize.startNewLine();
                        state = 31;
                        break;
                    }
                    if (nextChar == 9) {
                        throw new TokenizerException("Input ended in the middle of a multi-line comment");
                    }
                    if (cdepth == 1) {
                        Tokenize.addNextChar();
                        break;
                    }
                    Tokenize.skipNextChar();
                    break;
                }
                case 33: {
                    if (nextChar == 41) {
                        Tokenize.skipNextChar();
                        PcalDebug.Assert(--cdepth >= 0);
                        if (cdepth == 0) {
                            Tokenize.CommentTokenOut();
                            Tokenize.gotoStart();
                            break;
                        }
                        state = 31;
                        break;
                    }
                    if (cdepth == 1) {
                        token = String.valueOf(token) + "*";
                    }
                    state = 31;
                    break;
                }
                case 32: {
                    if (nextChar == 42) {
                        Tokenize.skipNextChar();
                        ++cdepth;
                        state = 31;
                        break;
                    }
                    if (cdepth == 1) {
                        token = String.valueOf(token) + "(";
                    }
                    state = 31;
                    break;
                }
                case 1: {
                    if (nextChar == 45) {
                        token1 = token;
                        col1 = col;
                        col = ncol;
                        token = "-";
                        Tokenize.skipNextChar();
                        state = 2;
                        break;
                    }
                    if (nextChar == 10) {
                        Tokenize.TokenOut(8);
                        Tokenize.skipNextChar();
                        Tokenize.startNewLine();
                        break;
                    }
                    if (nextChar == 9) {
                        throw new TokenizerException("Input ended before beginning of module");
                    }
                    Tokenize.addNextChar();
                    break;
                }
                case 2: {
                    PcalDebug.Assert(token.length() <= 3);
                    if (nextChar == 45) {
                        Tokenize.addNextChar();
                        if (token.length() != 4) continue block40;
                        state = 3;
                        break;
                    }
                    token = token1 + token;
                    col = col1;
                    state = 1;
                    break;
                }
                case 3: {
                    if (nextChar == 45) {
                        Tokenize.addNextChar();
                        break;
                    }
                    token2 = token;
                    col2 = col;
                    token = "";
                    col = ncol;
                    state = 4;
                    break;
                }
                case 4: {
                    if (nextChar == 32) {
                        Tokenize.addNextChar();
                        break;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        token3 = token;
                        col3 = ncol;
                        token = "";
                        state = 5;
                        break;
                    }
                    token = token1 + token2;
                    col = col1;
                    state = 1;
                    break;
                }
                case 5: {
                    if (Misc.IsLetter(nextChar)) {
                        Tokenize.addNextChar();
                        break;
                    }
                    if (token.equals("MODULE")) {
                        token = token1;
                        col = col1;
                        Tokenize.TokenOut(8);
                        token = token2;
                        col = col2;
                        Tokenize.TokenOut(6);
                        token = "MODULE";
                        col = col3;
                        Tokenize.TokenOut(1);
                        token = "";
                        mdepth = 1;
                        Tokenize.gotoStart();
                        break;
                    }
                    token = token1 + token2 + token3;
                    col = col1;
                    state = 1;
                    break;
                }
                case 34: {
                    if (nextChar == 10) {
                        Tokenize.TokenOut(9);
                        Tokenize.skipNextChar();
                        Tokenize.startNewLine();
                        break;
                    }
                    if (nextChar == 9) {
                        Tokenize.TokenOut(9);
                        state = 35;
                        break;
                    }
                    Tokenize.addNextChar();
                    break;
                }
                default: {
                    PcalDebug.ReportBug("Illegal state in TokenizeSpec.Tokenize");
                }
            }
        }
        if (nextChar != 10) {
            reader.backspace();
        }
        TLAExpr rval = new TLAExpr(vspec);
        rval.normalize();
        return rval;
    }
}

