/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.function.BiPredicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.Context;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.InstanceNode;
import tla2sany.semantic.LevelConstants;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import tla2sany.xml.SymbolContext;

public class LetInNode
extends ExprNode
implements ExploreNode,
LevelConstants {
    private SymbolNode[] opDefs;
    public Context context;
    private InstanceNode[] insts;
    private ExprNode body;
    private OpDefNode[] gottenLets = null;

    public LetInNode(TreeNode treeNode, SymbolNode[] defs, InstanceNode[] insts, ExprNode bdy, Context ctext) {
        super(10, treeNode);
        this.opDefs = defs;
        this.insts = insts;
        this.body = bdy;
        this.context = ctext;
    }

    public final OpDefNode[] getLets() {
        if (this.gottenLets == null) {
            int cnt = 0;
            int i = 0;
            while (i < this.opDefs.length) {
                if (this.opDefs[i].getKind() == 5) {
                    ++cnt;
                }
                ++i;
            }
            this.gottenLets = new OpDefNode[cnt];
            cnt = 0;
            i = 0;
            while (i < this.opDefs.length) {
                if (this.opDefs[i].getKind() == 5) {
                    this.gottenLets[cnt] = (OpDefNode)this.opDefs[i];
                    ++cnt;
                }
                ++i;
            }
        }
        return this.gottenLets;
    }

    public final ExprNode getBody() {
        return this.body;
    }

    @Override
    public final boolean levelCheck(int itr, Errors errors) {
        if (this.levelChecked >= itr) {
            return this.levelCorrect;
        }
        this.levelChecked = itr;
        this.levelCorrect = true;
        int i = 0;
        while (i < this.opDefs.length) {
            if (this.opDefs[i].getKind() != 6 && !this.opDefs[i].levelCheck(itr, errors)) {
                this.levelCorrect = false;
            }
            ++i;
        }
        if (!this.body.levelCheck(itr, errors)) {
            this.levelCorrect = false;
        }
        i = 0;
        while (i < this.insts.length) {
            if (!this.insts[i].levelCheck(itr, errors)) {
                this.levelCorrect = false;
            }
            ++i;
        }
        this.level = this.body.getLevel();
        this.levelParams = new HashSet<SymbolNode>(this.body.getLevelParams());
        this.allParams = new HashSet<SymbolNode>(this.body.getAllParams());
        this.levelConstraints.putAll(this.body.getLevelConstraints());
        i = 0;
        while (i < this.opDefs.length) {
            if (this.opDefs[i].getKind() != 6) {
                this.levelConstraints.putAll(this.opDefs[i].getLevelConstraints());
            }
            ++i;
        }
        this.argLevelConstraints.putAll(this.body.getArgLevelConstraints());
        i = 0;
        while (i < this.opDefs.length) {
            if (this.opDefs[i].getKind() != 6) {
                this.argLevelConstraints.putAll(this.opDefs[i].getArgLevelConstraints());
            }
            ++i;
        }
        this.argLevelParams.addAll(this.body.getArgLevelParams());
        i = 0;
        while (i < this.opDefs.length) {
            if (this.opDefs[i].getKind() != 6) {
                SymbolNode[] params = new FormalParamNode[]{};
                if (this.opDefs[i].getKind() != 23) {
                    params = ((OpDefNode)this.opDefs[i]).getParams();
                }
                for (ArgLevelParam alp : this.opDefs[i].getArgLevelParams()) {
                    if (alp.occur(params)) continue;
                    this.argLevelParams.add(alp);
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.insts.length) {
            this.argLevelParams.addAll(this.insts[i].getArgLevelParams());
            ++i;
        }
        return this.levelCorrect;
    }

    @Override
    public SemanticNode[] getChildren() {
        SemanticNode[] res = new SemanticNode[this.opDefs.length + this.insts.length + 1];
        res[res.length - 1] = this.body;
        int i = 0;
        while (i < this.opDefs.length) {
            res[i] = this.opDefs[i];
            ++i;
        }
        int j = 0;
        while (j < this.insts.length) {
            res[i + j] = this.insts[j];
            ++j;
        }
        return res;
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        if (this.context != null) {
            this.context.walkGraph(semNodesTable, visitor);
        }
        if (this.body != null) {
            this.body.walkGraph(semNodesTable, visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public final String toString(int depth, Errors errors) {
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*LetInNode: " + super.toString(depth, errors);
        Vector<String> contextEntries = this.context.getContextEntryStringVector(1, false, errors);
        if (contextEntries != null) {
            int i = 0;
            while (i < contextEntries.size()) {
                ret = contextEntries.elementAt(i) != null ? ret + Strings.indent(2, contextEntries.elementAt(i)) : ret + "*** null ***";
                ++i;
            }
        }
        ret = ret + Strings.indent(2, "\nBody:" + Strings.indent(2, this.body.toString(depth - 1, errors)));
        return ret;
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        Element ret = doc.createElement("LetInNode");
        ret.appendChild(this.appendElement(doc, "body", this.body.export(doc, context, filter)));
        Element arguments = doc.createElement("opDefs");
        int i = 0;
        while (i < this.opDefs.length) {
            arguments.appendChild(this.opDefs[i].export(doc, context, filter));
            ++i;
        }
        ret.appendChild(arguments);
        return ret;
    }
}

