/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.NoSuchFileException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class ExecutionStatisticsCollector {
    static final String RND_ID_STR = "RANDOM_IDENTIFIER";
    static final String NO_ESC_STR = "NO_STATISTICS";
    private static final String PATH = System.getProperty("user.home", "") + File.separator + ".tlaplus" + File.separator + "esc.txt";
    private static final String HOSTNAME = System.getProperty(ExecutionStatisticsCollector.class.getName() + ".domain", "tlaplus-execution-stats-collection01");
    public static final String PROP = ExecutionStatisticsCollector.class.getName() + ".id";
    private final String pathname;
    private final String hostname;

    public ExecutionStatisticsCollector() {
        this(PATH, HOSTNAME);
    }

    ExecutionStatisticsCollector(String path) {
        this.pathname = path;
        this.hostname = HOSTNAME;
    }

    ExecutionStatisticsCollector(String path, String hostname) {
        this.pathname = path;
        this.hostname = hostname;
    }

    public void collect(Map<String, String> parameters) {
        this.collectAsync(parameters, Boolean.getBoolean(ExecutionStatisticsCollector.class.getName() + ".waitForCompletion"));
    }

    protected void collectAsync(Map<String, String> parameters, boolean waitForCompletion) {
        CompletableFuture<Void> collector = CompletableFuture.runAsync(() -> this.collect0(parameters));
        if (waitForCompletion) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    collector.get(10L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, "TLC Execution Statistics Collector Shutdown Hook"));
        }
    }

    protected void collect0(Map<String, String> parameters) {
        InetAddress optIn;
        String line = null;
        File udcFile = new File(this.pathname);
        if (udcFile.exists()) {
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try (BufferedReader br = new BufferedReader(new FileReader(udcFile));){
                    line = br.readLine();
                    if (line != null && NO_ESC_STR.equals(line.trim())) {
                        return;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
            }
            catch (IOException diableExecStatsSilently) {
                return;
            }
        }
        if ((optIn = this.getOptInDNSRecord()) == null) {
            String id = this.getIdentifier(line);
            if (id != null) {
                parameters.put("id", id);
                this.submit("esc01.tlapl.us", parameters);
            }
        } else {
            String chn = optIn.getCanonicalHostName();
            if (line == null || line.trim().isEmpty()) {
                parameters.put("id", this.getUUIDv1());
                this.submit(chn, parameters);
                return;
            }
            String id = this.getIdentifier(line);
            if (id != null) {
                parameters.put("id", id);
                this.submit(chn, parameters);
                return;
            }
        }
    }

    private InetAddress getOptInDNSRecord() {
        InetAddress optIn = null;
        try {
            optIn = InetAddress.getByName(this.hostname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return optIn;
    }

    public String getIdentifier(String identifier) {
        if (System.getProperty(PROP) != null) {
            return System.getProperty(PROP);
        }
        if (identifier == null || NO_ESC_STR.equals(identifier.trim())) {
            return null;
        }
        if (RND_ID_STR.equals(identifier.trim())) {
            identifier = ExecutionStatisticsCollector.getRandomIdentifier();
        }
        String trimmed = identifier.trim();
        return trimmed.substring(0, Math.min(trimmed.length(), 32));
    }

    public String getIdentifier() {
        String identifier;
        if (System.getProperty(PROP) != null) {
            return System.getProperty(PROP);
        }
        File udcFile = new File(this.pathname);
        if (!udcFile.exists()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(udcFile));){
                identifier = br.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return null;
        }
        return this.getIdentifier(identifier);
    }

    private boolean escFileExists() {
        return new File(this.pathname).exists();
    }

    public boolean isEnabled() {
        return this.getIdentifier() != null || this.getOptInDNSRecord() != null;
    }

    public void set(Selection c) throws IOException {
        File udcFile = new File(PATH);
        udcFile.getParentFile().mkdirs();
        udcFile.createNewFile();
        Throwable throwable = null;
        Object var4_6 = null;
        try (BufferedWriter br = new BufferedWriter(new FileWriter(udcFile));){
            br.write(c.toString() + "\n");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Selection get() {
        if (this.isEnabled()) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (BufferedReader br = new BufferedReader(new FileReader(new File(this.pathname)));){
                    String line = br.readLine();
                    if (RND_ID_STR.equals(line)) {
                        return Selection.RANDOM_IDENTIFIER;
                    }
                    return Selection.ON;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Selection.NO_ESC;
    }

    public static boolean promptUser() {
        return !new ExecutionStatisticsCollector().escFileExists();
    }

    private static String getRandomIdentifier() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    protected void submit(String hostname, Map<String, String> parameters) {
        parameters.put("ts", Long.toString(System.currentTimeMillis()));
        parameters.put("optout", Boolean.FALSE.toString());
        try {
            URL url = new URL((Boolean.getBoolean(ExecutionStatisticsCollector.class.getName() + ".nossl") ? "http" : "https") + "://" + hostname + "/?" + ExecutionStatisticsCollector.encode(parameters));
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("HEAD");
            con.getResponseMessage();
            con.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String encode(Map<String, String> parameters) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer();
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            buf.append(URLEncoder.encode(key, "UTF-8"));
            buf.append("=");
            buf.append(URLEncoder.encode(value, "UTF-8"));
            buf.append(",");
        }
        return buf.toString().replaceFirst(",$", "");
    }

    private static byte[] getMacAddress() {
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                try {
                    byte[] hardwareAddress = iface.getHardwareAddress();
                    if (hardwareAddress == null) continue;
                    return hardwareAddress;
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    private String getUUIDv1() {
        byte[] mac = ExecutionStatisticsCollector.getMacAddress();
        if (mac == null) {
            return ExecutionStatisticsCollector.getRandomIdentifier();
        }
        long uuidEpochOffset = -12219292800000L;
        long millisSinceUuidEpoch = System.currentTimeMillis() - -12219292800000L;
        long timestamp = millisSinceUuidEpoch * 10000L;
        long timeLow = timestamp & 0xFFFFFFFFL;
        long timeMid = timestamp >>> 32 & 0xFFFFL;
        long timeHi = timestamp >>> 48 & 0xFFFL;
        long mostSigBits = timeLow << 32 | timeMid << 16 | (timeHi |= 0x1000L);
        long clockSeq = (long)(Math.random() * 16383.0);
        long leastSigBits = (clockSeq |= 0x8000L) << 48 | ((long)mac[0] & 0xFFL) << 40 | ((long)mac[1] & 0xFFL) << 32 | ((long)mac[2] & 0xFFL) << 24 | ((long)mac[3] & 0xFFL) << 16 | ((long)mac[4] & 0xFFL) << 8 | (long)mac[5] & 0xFFL;
        return new UUID(mostSigBits, leastSigBits).toString().replaceAll("-", "");
    }

    public static void main(String[] args) {
        new ExecutionStatisticsCollector().collect0(new HashMap<String, String>());
    }

    public static enum Selection {
        ON,
        RANDOM_IDENTIFIER,
        NO_ESC;


        public String toString() {
            if (this == ON) {
                return ExecutionStatisticsCollector.getRandomIdentifier();
            }
            if (this == RANDOM_IDENTIFIER) {
                return ExecutionStatisticsCollector.RND_ID_STR;
            }
            return ExecutionStatisticsCollector.NO_ESC_STR;
        }
    }
}

