/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Random;
import tlc2.util.ByteUtils;
import tlc2.util.ExternalSortable;
import tlc2.util.FP64;

public class BigInt
extends BigInteger
implements ExternalSortable {
    public static final BigInt BigZero = new BigInt("0");
    public static final BigInt BigOne = new BigInt("1");
    public static final BigInt BigTwo = new BigInt("2");

    public BigInt(String val) {
        super(val);
    }

    public BigInt(byte[] val) {
        super(val);
    }

    public BigInt(int numBits, Random rnd) {
        super(numBits, rnd);
    }

    public final long fingerPrint() {
        return FP64.New(this.toByteArray());
    }

    @Override
    public final boolean equals(Object x) {
        return x instanceof BigInt && super.equals(x);
    }

    @Override
    public final void write(OutputStream out) throws IOException {
        ByteUtils.writeSizeBigInt(out, this);
    }

    @Override
    public final BigInt read(InputStream in) throws IOException {
        return ByteUtils.readSizeBigInt(in);
    }
}

