/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.liveness.AbstractDiskGraph;

public class TableauNodePtrTable {
    static final long UNDONE = -8589934592L;
    static final long DONE = -12884901888L;
    private int count = 0;
    private int length;
    private int thresh;
    private int[][] nodes;
    public static final int END_MARKER = -1;
    public static final int NO_PARENT = -1;

    public TableauNodePtrTable(int size) {
        this.length = size;
        this.thresh = (int)((double)size * 0.75);
        this.nodes = new int[size][];
    }

    public final int size() {
        return this.count;
    }

    public final int getSize() {
        return this.length;
    }

    public final long get(long k, int tidx) {
        assert (tidx >= -1);
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        int[] node;
        while ((node = this.nodes[loc]) != null) {
            if (TableauNodePtrTable.getKey(node) == k) {
                int idx = this.getIdx(node, tidx);
                if (idx == -1) {
                    return -1L;
                }
                return TableauNodePtrTable.getElem(node, idx);
            }
            loc = (loc + 1) % this.length;
        }
        return -1L;
    }

    public final void put(long k, int tidx) {
        this.put(k, tidx, -8589934592L, -12884901888L);
    }

    public final void put(long k, int tidx, long elem) {
        this.put(k, tidx, elem, elem);
    }

    private final void put(long k, int tidx, long addElem, long newElem) {
        assert (tidx >= -1);
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        while (true) {
            int[] node;
            if ((node = this.nodes[loc]) == null) {
                this.nodes[loc] = this.addElem(k, tidx, addElem);
                ++this.count;
                return;
            }
            if (TableauNodePtrTable.getKey(node) == k) {
                int cloc = this.getIdx(node, tidx);
                if (cloc == -1) {
                    this.nodes[loc] = this.appendElem(node, tidx, newElem);
                } else {
                    TableauNodePtrTable.putElem(this.nodes[loc], addElem, cloc);
                }
                return;
            }
            loc = (loc + 1) % this.length;
        }
    }

    public final int getLoc(long k, int tidx) {
        assert (tidx >= -1);
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        int[] node;
        while ((node = this.nodes[loc]) != null) {
            if (TableauNodePtrTable.getKey(node) == k) {
                if (this.getIdx(node, tidx) == -1) {
                    return -1;
                }
                return loc;
            }
            loc = (loc + 1) % this.length;
        }
        return -1;
    }

    public final int[] getNodes(long k) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        int[] node;
        while ((node = this.nodes[loc]) != null) {
            if (TableauNodePtrTable.getKey(node) == k) {
                return this.nodes[loc];
            }
            loc = (loc + 1) % this.length;
        }
        return null;
    }

    public final int getNodesLoc(long k) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        int[] node;
        while ((node = this.nodes[loc]) != null) {
            if (TableauNodePtrTable.getKey(node) == k) {
                return loc;
            }
            loc = (loc + 1) % this.length;
        }
        return -1;
    }

    public final int[] getNodesByLoc(int loc) {
        return this.nodes[loc];
    }

    public final boolean isDone(long k) {
        int[] node = this.getNodes(k);
        if (node == null) {
            return false;
        }
        if (node.length == 2) {
            return true;
        }
        return node[3] != -2;
    }

    public final int setDone(long k) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        while (true) {
            int[] node;
            if ((node = this.nodes[loc]) == null) {
                this.nodes[loc] = TableauNodePtrTable.addKey(k);
                ++this.count;
                return loc;
            }
            if (TableauNodePtrTable.getKey(node) == k) {
                if (node.length > 2 && node[3] == -2) {
                    node[3] = -3;
                }
                return loc;
            }
            loc = (loc + 1) % this.length;
        }
    }

    private final void put(int[] node) {
        long k = TableauNodePtrTable.getKey(node);
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        while (true) {
            if (this.nodes[loc] == null) {
                this.nodes[loc] = node;
                return;
            }
            loc = (loc + 1) % this.length;
        }
    }

    public final void resetElems() {
        int i = 0;
        while (i < this.nodes.length) {
            int[] node = this.nodes[i];
            if (node != null) {
                int j = 3;
                while (j < node.length) {
                    int n = j;
                    node[n] = node[n] & Integer.MAX_VALUE;
                    j += this.getElemLength();
                }
            }
            ++i;
        }
    }

    private final void grow() {
        this.length = 2 * this.length + 1;
        this.thresh = (int)((double)this.length * 0.75);
        int[][] oldNodes = this.nodes;
        this.nodes = new int[this.length][];
        int i = 0;
        while (i < oldNodes.length) {
            int[] node = oldNodes[i];
            if (node != null) {
                this.put(node);
            }
            ++i;
        }
    }

    public int getElemLength() {
        return 3;
    }

    private static int[] addKey(long key) {
        int[] node = new int[]{(int)(key >>> 32), (int)(key & 0xFFFFFFFFL)};
        return node;
    }

    protected int[] addElem(long key, int tidx, long elem) {
        assert (tidx >= -1);
        int[] node = new int[3 + this.getElemLength() - 1];
        node[0] = (int)(key >>> 32);
        node[1] = (int)(key & 0xFFFFFFFFL);
        node[2] = tidx;
        node[3] = (int)(elem >>> 32);
        node[4] = (int)(elem & 0xFFFFFFFFL);
        return node;
    }

    protected int[] appendElem(int[] node, int tidx, long elem) {
        assert (tidx >= -1);
        int len = node.length;
        int[] newNode = new int[len + this.getElemLength()];
        System.arraycopy(node, 0, newNode, 0, len);
        newNode[len] = tidx;
        newNode[len + 1] = (int)(elem >>> 32);
        newNode[len + 2] = (int)(elem & 0xFFFFFFFFL);
        return newNode;
    }

    public static long getKey(int[] node) {
        long high = node[0];
        long low = node[1];
        return high << 32 | low & 0xFFFFFFFFL;
    }

    public static long getElem(int[] node, int loc) {
        long high = node[loc + 1];
        long low = node[loc + 2];
        return high << 32 | low & 0xFFFFFFFFL;
    }

    public final int getIdx(int[] node, int tidx) {
        assert (tidx >= -1);
        int len = node.length;
        int i = 2;
        while (i < len) {
            if (node[i] == tidx) {
                return i;
            }
            i += this.getElemLength();
        }
        return -1;
    }

    public int getElemTidx(int[] node, int loc) {
        return -1;
    }

    public void putElem(int[] node, long elem, int tableauIdx, int loc) {
        assert (tableauIdx >= -1);
        node[loc + 1] = (int)(elem >>> 32);
        node[loc + 2] = (int)(elem & 0xFFFFFFFFL);
    }

    public static void putElem(int[] node, long elem, int loc) {
        node[loc + 1] = (int)(elem >>> 32);
        node[loc + 2] = (int)(elem & 0xFFFFFFFFL);
    }

    public static int getTidx(int[] node, int loc) {
        return node[loc];
    }

    public static int startLoc(int[] node) {
        return node.length > 2 ? 2 : -1;
    }

    public static int nextLoc(int[] node, int curLoc) {
        int loc = curLoc + 3;
        return loc < node.length ? loc : -1;
    }

    public static boolean isSeen(int[] nodes, int tloc) {
        return TableauNodePtrTable.getElem(nodes, tloc) < 0L;
    }

    public static void setSeen(int[] nodes, int tloc) {
        long ptr = TableauNodePtrTable.getElem(nodes, tloc);
        TableauNodePtrTable.putElem(nodes, ptr | Long.MIN_VALUE, tloc);
    }

    public static long getPtr(long ptr) {
        return ptr & Long.MAX_VALUE;
    }

    public static boolean isSeen(int[] nodes) {
        return nodes[3] < 0;
    }

    public static void setSeen(int[] nodes) {
        nodes[3] = nodes[3] | Integer.MIN_VALUE;
    }

    public static int getParent(int[] nodes) {
        return nodes[4];
    }

    public static void setParent(int[] nodes, int loc) {
        assert (loc >= -1 && (long)loc <= 0x4000000000000000L);
        nodes[4] = loc;
    }

    public String toDotViz() {
        StringBuffer sb = new StringBuffer();
        sb.append("subgraph cluster_table {");
        sb.append("graph[style=bold];");
        sb.append("label = \"NodePtrTable\" style=\"solid\"\n");
        sb.append("node [ labeljust=\"l\",shape=record ]\n");
        sb.append("key [label=<<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\" cellborder=\"1\">\n");
        sb.append("<tr> <td BGCOLOR=\"lightblue\">fp</td> <td BGCOLOR=\"lightblue\">tid</td> <td BGCOLOR=\"lightblue\">idx</td> <td BGCOLOR=\"lightblue\">isDone</td> <td BGCOLOR=\"lightblue\">isSeen</td> <td BGCOLOR=\"lightblue\">ptr</td> <td BGCOLOR=\"lightblue\">pred tid</td> </tr>\n");
        int i = 0;
        while (i < this.nodes.length) {
            if (this.nodes[i] != null) {
                int[] node = this.nodes[i];
                long fp = (long)node[0] << 32 | (long)node[1] & 0xFFFFFFFFL;
                int j = 2;
                if (j == node.length - 1) {
                    sb.append(String.format("<tr> <td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td> </tr>\n", Long.toString(fp).substring(0, 6), "NA", i, this.isDone(fp), "NA", "NA", "NA"));
                }
                while (j < node.length - 1) {
                    String ptr;
                    int tidx = node[j];
                    long elem = TableauNodePtrTable.getElem(node, j);
                    if (AbstractDiskGraph.isFilePointer(elem)) {
                        ptr = elem == -8589934592L ? "undone" : (elem == -12884901888L ? "done" : Long.toString(elem));
                    } else if (0x4000000000000000L == elem) {
                        ptr = "Initial";
                    } else {
                        long offset = 0x4000000000000001L;
                        ptr = Long.toString(elem - 0x4000000000000001L);
                    }
                    int predTidx = this.getElemTidx(node, j);
                    String predTid = predTidx != -1 ? Integer.toString(predTidx) : "-";
                    sb.append(String.format("<tr> <td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td> </tr>\n", Long.toString(fp).substring(0, 6), tidx, i, this.isDone(fp), !TableauNodePtrTable.isSeen(node, j), ptr, predTid));
                    j += this.getElemLength();
                }
            }
            ++i;
        }
        sb.append("</table>>]\n");
        sb.append("}");
        return sb.toString();
    }

    public static class DetailedFormatter {
        public static String toString(TableauNodePtrTable table) {
            StringBuffer buf = new StringBuffer(table.count);
            int i = 0;
            while (i < table.nodes.length) {
                if (table.nodes[i] != null) {
                    int[] node = table.nodes[i];
                    long fp = (long)node[0] << 32 | (long)node[1] & 0xFFFFFFFFL;
                    buf.append("fp (key): " + fp);
                    buf.append(" (idx: " + i + ")");
                    buf.append(" isDone: " + (node.length == 2 || node.length > 2 && node[3] != -2));
                    buf.append("\n");
                    int j = 2;
                    while (j < node.length - 1) {
                        buf.append("\t");
                        int tidx = node[j];
                        buf.append(" tidx: " + tidx);
                        long elem = TableauNodePtrTable.getElem(node, j);
                        if (AbstractDiskGraph.isFilePointer(elem)) {
                            if (elem == -8589934592L) {
                                buf.append("  ptr: undone");
                            } else if (elem == -12884901888L) {
                                buf.append("  ptr: done");
                            } else {
                                buf.append("  ptr: " + elem);
                            }
                        } else if (0x4000000000000000L == elem) {
                            buf.append(" elem: Init State");
                        } else {
                            long offset = 0x4000000000000001L;
                            buf.append(" pred: " + (elem - 0x4000000000000001L));
                        }
                        int predTidx = table.getElemTidx(node, j);
                        if (predTidx != -1) {
                            buf.append(" predtidx: " + predTidx);
                        }
                        buf.append(", isSeen: " + !TableauNodePtrTable.isSeen(node, j));
                        buf.append("\n");
                        j += table.getElemLength();
                    }
                }
                ++i;
            }
            return buf.toString();
        }
    }
}

