/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.property;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class GenericFieldEditorPropertyPage
extends PropertyPage
implements IPropertyChangeListener {
    private List fields;
    private FieldEditor invalidFieldEditor;

    protected void initialize() {
        if (this.fields != null) {
            for (FieldEditor fieldEditor : this.fields) {
                fieldEditor.setPage((DialogPage)this);
                fieldEditor.setPreferenceStore(this.getPreferenceStore());
                fieldEditor.load();
            }
        }
    }

    protected void addEditor(FieldEditor editor) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        this.fields.add(editor);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(4);
        layoutData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)layoutData);
        this.createFieldEditors(composite);
        this.initialize();
        return composite;
    }

    public abstract void createFieldEditors(Composite var1);

    protected void performDefaults() {
        if (this.fields != null) {
            for (FieldEditor pe : this.fields) {
                pe.loadDefault();
            }
        }
        this.checkState();
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.fields != null) {
            for (FieldEditor pe : this.fields) {
                pe.store();
            }
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                this.checkState();
            } else {
                this.setInvalidFieldEditor((FieldEditor)event.getSource());
                this.setValid(newValue);
            }
        }
    }

    protected void checkState() {
        boolean valid = true;
        this.setInvalidFieldEditor(null);
        if (this.fields != null) {
            int size = this.fields.size();
            int i = 0;
            while (i < size) {
                FieldEditor editor = (FieldEditor)this.fields.get(i);
                boolean bl = valid = valid && editor.isValid();
                if (!valid) {
                    this.setInvalidFieldEditor(editor);
                    break;
                }
                ++i;
            }
        }
        this.setValid(valid);
    }

    public void setInvalidFieldEditor(FieldEditor invalidFieldEditor) {
        this.invalidFieldEditor = invalidFieldEditor;
    }

    public FieldEditor getInvalidFieldEditor() {
        return this.invalidFieldEditor;
    }
}

