/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.util;

import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.util.AdapterFactory;
import org.lamport.tla.toolbox.util.LegacyFileDocumentProvider;
import org.lamport.tla.toolbox.util.TLAMarkerInformationHolder;
import org.lamport.tla.toolbox.util.TLAtoPCalMarker;
import org.lamport.tla.toolbox.util.UIHelper;
import pcal.TLAtoPCalMapping;
import tla2sany.st.Location;

public class TLAMarkerHelper {
    public static final String LOCATION_ENDCOLUMN = "toolbox.location.endcolumn";
    public static final String LOCATION_ENDLINE = "toolbox.location.endline";
    public static final String LOCATION_BEGINCOLUMN = "toolbox.location.begincolumn";
    public static final String LOCATION_BEGINLINE = "toolbox.location.beginline";
    public static final String LOCATION_MODULENAME = "toolbox.location.modulename";
    public static final String LOCATION = "toolbox.region";
    public static final String TOOLBOX_MARKERS_ALL_MARKER_ID = "toolbox.markers.ToolboxProblemMarker";
    public static final String TOOLBOX_MARKERS_TLAPARSER_MARKER_ID = "toolbox.markers.TLAParserProblemMarker";
    public static final String TOOLBOX_MARKERS_TRANSLATOR_MARKER_ID = "toolbox.markers.PCalTranslatorProblemMarker";

    public static void installProblemMarker(final IResource resource, final String moduleName, final int severityError, final int[] coordinates, final String message, IProgressMonitor monitor, final String type) {
        Assert.isNotNull((Object)resource);
        Assert.isNotNull((Object)moduleName);
        Assert.isNotNull((Object)coordinates);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = null;
                if (!resource.exists()) {
                    if (!Activator.isSpecManagerInstantiated() || Activator.getSpecManager().getSpecLoaded() == null || Activator.getSpecManager().getSpecLoaded().getProject() == null) return;
                    IProject project = Activator.getSpecManager().getSpecLoaded().getProject();
                    marker = project.createMarker(type);
                    int i = 0;
                    while (i < coordinates.length) {
                        coordinates[i] = -1;
                        ++i;
                    }
                } else {
                    marker = resource.createMarker(type);
                }
                marker.setAttribute("severity", severityError);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("location", (Object)AdapterFactory.getFormattedLocation(coordinates, moduleName));
                marker.setAttribute(TLAMarkerHelper.LOCATION_MODULENAME, (Object)moduleName);
                marker.setAttribute(TLAMarkerHelper.LOCATION_BEGINLINE, coordinates[0]);
                marker.setAttribute(TLAMarkerHelper.LOCATION_BEGINCOLUMN, coordinates[1]);
                marker.setAttribute(TLAMarkerHelper.LOCATION_ENDLINE, coordinates[2]);
                marker.setAttribute(TLAMarkerHelper.LOCATION_ENDCOLUMN, coordinates[3]);
                marker.setAttribute(TLAMarkerHelper.LOCATION, (Object)new Location(coordinates));
                final IMarker fMarker = marker;
                UIHelper.runUISync(new Runnable(){

                    @Override
                    public void run() {
                        block9: {
                            try {
                                if (coordinates[0] == coordinates[3] || coordinates[3] == -1) {
                                    fMarker.setAttribute("lineNumber", coordinates[0]);
                                    break block9;
                                }
                                IDocument document = null;
                                FileEditorInput fileEditorInput = new FileEditorInput((IFile)resource);
                                LegacyFileDocumentProvider fileDocumentProvider = new LegacyFileDocumentProvider();
                                try {
                                    fileDocumentProvider.connect(fileEditorInput);
                                    document = fileDocumentProvider.getDocument(fileEditorInput);
                                }
                                finally {
                                    fileDocumentProvider.disconnect(fileEditorInput);
                                }
                                if (document != null) {
                                    try {
                                        IRegion lineRegion = document.getLineInformation(coordinates[0] - 1);
                                        String textLine = document.get(lineRegion.getOffset(), lineRegion.getLength());
                                        fMarker.setAttribute("charStart", lineRegion.getOffset() + TLAMarkerHelper.getRealOffset(textLine, coordinates[1] - 1));
                                        fMarker.setAttribute("charEnd", lineRegion.getOffset() + TLAMarkerHelper.getRealOffset(textLine, coordinates[3]));
                                    }
                                    catch (BadLocationException e) {
                                        Activator.getDefault().logError("Error accessing the specified error location", e);
                                    }
                                }
                            }
                            catch (CoreException e) {
                                Activator.getDefault().logError("Error accessing the specified error location", e);
                            }
                        }
                    }
                });
            }
        };
        try {
            resource.getWorkspace().run(runnable, null, 1, monitor);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error installing the problem markers", e);
        }
    }

    public static void removeProblemMarkers(final IResource resource, IProgressMonitor monitor, final String type) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker[] problems = null;
                int depth = 2;
                problems = resource.findMarkers(type, true, depth);
                int i = 0;
                while (i < problems.length) {
                    problems[i].delete();
                    ++i;
                }
            }
        };
        try {
            resource.getWorkspace().run(runnable, monitor);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error removing the problem markers", e);
        }
    }

    public static void removeProblemMarkers(IResource resource, IProgressMonitor monitor) {
        TLAMarkerHelper.removeProblemMarkers(resource, monitor, TOOLBOX_MARKERS_TLAPARSER_MARKER_ID);
    }

    public static IMarker[] getProblemMarkers(IResource resource, IProgressMonitor monitor) {
        IMarker[] problems = null;
        try {
            problems = resource.findMarkers(TOOLBOX_MARKERS_ALL_MARKER_ID, true, 2);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error retrieving the problem markers", e);
            problems = new IMarker[]{};
        }
        return problems;
    }

    public static int getRealOffset(String line, int offset) {
        line.indexOf("\t");
        return Math.min(offset, line.length());
    }

    public static void gotoMarker(IMarker problem) {
        TLAMarkerHelper.gotoMarker(problem, false);
    }

    public static void gotoMarker(IMarker problem, boolean jumpToPcal) {
        if (problem.getResource() instanceof IFile) {
            IFile module = (IFile)problem.getResource();
            IEditorPart part = UIHelper.openEditor("org.lamport.tla.toolbox.editor.basic.TLAEditorAndPDFViewer", (IEditorInput)new FileEditorInput(module));
            IGotoMarker gotoMarker = null;
            gotoMarker = part instanceof IGotoMarker ? (IGotoMarker)part : (IGotoMarker)part.getAdapter(IGotoMarker.class);
            if (gotoMarker != null) {
                if (jumpToPcal) {
                    String moduleName = module.getName();
                    TLAtoPCalMapping mapping = ToolboxHandle.getCurrentSpec().getTpMapping(moduleName);
                    if (mapping != null) {
                        problem = new TLAtoPCalMarker(problem, mapping);
                    } else {
                        UIHelper.setStatusLineMessage("No valid TLA to PCal mapping found for current selection");
                        return;
                    }
                }
                gotoMarker.gotoMarker(problem);
            }
        }
    }

    public static boolean currentSpecHasProblems() {
        Spec spec = Activator.getSpecManager().getSpecLoaded();
        if (spec == null) {
            return false;
        }
        return TLAMarkerHelper.getProblemMarkers((IResource)spec.getProject(), null).length > 0;
    }

    public static String getType(IMarker problem) {
        try {
            return problem.getType();
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error retriving marker type", e);
            return null;
        }
    }

    public static void installProblemMarkers(Vector<TLAMarkerInformationHolder> detectedErrors, IProgressMonitor monitor) {
        if (detectedErrors == null || detectedErrors.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < detectedErrors.size()) {
            TLAMarkerInformationHolder holder = detectedErrors.get(i);
            TLAMarkerHelper.installProblemMarker(holder.resource, holder.moduleName, holder.severityError, holder.coordinates, holder.message, monitor, holder.type);
            ++i;
        }
    }
}

