/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.part.FileEditorInput;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.UIHelper;

public class OpenModuleHandler
extends AbstractHandler
implements IHandler {
    public static final String COMMAND_ID = "toolbox.command.module.open";
    public static final String PARAM_MODULE = "toolbox.command.module.open.param";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String moduleName = event.getParameter(PARAM_MODULE);
        OpenModuleHandler.openModule(moduleName);
        return null;
    }

    public static void openModule(String moduleName) {
        if (moduleName == null) {
            throw new RuntimeException("Module was null");
        }
        Spec spec = Activator.getSpecManager().getSpecLoaded();
        IFile module = ResourceHelper.getLinkedFile(spec.getProject(), ResourceHelper.getModuleFileName(moduleName));
        if (module == null) {
            throw new RuntimeException("Module " + moduleName + " could not be found");
        }
        IEditorPart part = UIHelper.openEditor("org.lamport.tla.toolbox.editor.basic.TLAEditorAndPDFViewer", (IEditorInput)new FileEditorInput(module));
        part.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
            }
        });
    }

    public boolean isEnabled() {
        if (Activator.getSpecManager().getSpecLoaded() == null) {
            return false;
        }
        return super.isEnabled();
    }
}

