/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.contribution;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.ToolboxDirectoryVisitor;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.SpecEvent;
import org.lamport.tla.toolbox.tool.SpecLifecycleParticipant;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.ToolboxJob;
import org.lamport.tla.toolbox.util.UIHelper;

public class SizeControlContribution
extends WorkbenchWindowControlContribution
implements IResourceChangeListener {
    private Composite composite;
    private Label sizeLabel;

    public SizeControlContribution() {
        super("specDirectorySize");
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        Activator.getSpecManager().addSpecLifecycleParticipant(new SpecLifecycleParticipant(){

            @Override
            public boolean eventOccured(final SpecEvent event) {
                if (event.getType() == 16 || event.getType() == 2) {
                    UIHelper.runUISync(new Runnable(){

                        @Override
                        public void run() {
                            (this).SizeControlContribution.this.composite.setVisible(false);
                        }
                    });
                    return false;
                }
                if (event.getType() == 8 || event.getType() == 8) {
                    ToolboxJob job = new ToolboxJob("Calculating spec size..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            Spec spec = event.getSpec();
                            long specSize = ResourceHelper.getSizeOfJavaFileResource((IResource)event.getSpec().getProject());
                            spec.setSize(specSize);
                            SizeControlContribution.this.updateSize(specSize);
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
                return true;
            }
        });
    }

    protected Control createControl(Composite parent) {
        if (this.composite != null && !this.composite.isDisposed()) {
            return this.composite;
        }
        this.composite = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 20;
        this.composite.setLayout((Layout)layout);
        Label description = new Label(this.composite, 0);
        description.setText("Storage:");
        description.setSize(50, 20);
        this.sizeLabel = new Label(this.composite, 0x1000800);
        this.sizeLabel.setText("n/a");
        this.sizeLabel.setToolTipText("Size of .toolbox directory. If this appears large and the TLC model checker is *not* running, try removing TLC's volatile data like state/ subdirectories of the model directory.");
        this.sizeLabel.setSize(100, 20);
        this.sizeLabel.setBackground(description.getDisplay().getSystemColor(7));
        this.composite.setVisible(false);
        return this.composite;
    }

    private void updateSize(final long size) {
        if (this.sizeLabel == null || this.sizeLabel.isDisposed()) {
            return;
        }
        UIHelper.runUIAsync(new Runnable(){

            @Override
            public void run() {
                if (!SizeControlContribution.this.composite.isDisposed()) {
                    SizeControlContribution.this.composite.setVisible(false);
                }
                if (!SizeControlContribution.this.sizeLabel.isDisposed() && !SizeControlContribution.this.composite.isDisposed()) {
                    if (size / 1000000000L > 0L) {
                        SizeControlContribution.this.sizeLabel.setText(Long.toString(size / 1000000000L) + " gB");
                    } else if (size / 1000000L > 0L) {
                        SizeControlContribution.this.sizeLabel.setText(Long.toString(size / 1000000L) + " mB");
                    } else if (size / 1000L > 0L) {
                        SizeControlContribution.this.sizeLabel.setText(Long.toString(size / 1000L) + " kB");
                    } else {
                        SizeControlContribution.this.sizeLabel.setText(Long.toString(size) + " bytes");
                    }
                    if (size / 1000L < (long)Activator.getDefault().getPreferenceStore().getInt("minDisplayedSize")) {
                        SizeControlContribution.this.composite.setVisible(false);
                        return;
                    }
                    SizeControlContribution.this.sizeLabel.redraw();
                    SizeControlContribution.this.composite.setVisible(true);
                }
            }
        });
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                if (Activator.isSpecManagerInstantiated()) {
                    ToolboxDirectoryVisitor toolboxDirectoryFinder = new ToolboxDirectoryVisitor();
                    delta.accept((IResourceDeltaVisitor)toolboxDirectoryFinder);
                    List<IProject> directories = toolboxDirectoryFinder.getDirectories();
                    for (IProject resource : directories) {
                        long specSize = ResourceHelper.getSizeOfJavaFileResource((IResource)resource);
                        Spec curSpec = ToolboxHandle.getCurrentSpec();
                        if (curSpec == null) continue;
                        curSpec.setSize(specSize);
                        if (!curSpec.getProject().equals((Object)resource)) continue;
                        this.updateSize(specSize);
                    }
                }
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error during post save status update", e);
            }
        }
    }
}

