/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.provider;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Module;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.ui.provider.SpecContentProvider;

public class ToolboxLabelProvider
extends LabelProvider
implements ILabelProvider,
IDescriptionProvider {
    public String getText(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof Spec) {
            Spec spec = (Spec)element;
            IFile root = spec.getRootFile();
            if (root == null) {
                return null;
            }
            if (root.getName().replaceAll(".tla$", "").equals(spec.getName())) {
                return spec.getName();
            }
            return spec.getName() + " [ " + root.getName() + " ]";
        }
        if (element instanceof Module) {
            return ((Module)element).getModuleName();
        }
        if (element instanceof SpecContentProvider.Group) {
            return element.toString();
        }
        return null;
    }

    public String getDescription(Object element) {
        if (element instanceof Spec) {
            Spec spec = (Spec)element;
            IFile root = spec.getRootFile();
            if (root == null) {
                return super.getText(element);
            }
            return spec.getName() + " [ " + String.valueOf(root.getLocation().toFile()) + " ]";
        }
        if (element instanceof Module) {
            Module module = (Module)element;
            return module.getModuleName() + " [ " + String.valueOf(module.getResource().getLocation().toFile()) + " ]";
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof Spec) {
            if (Activator.getSpecManager().isSpecLoaded((Spec)element)) {
                return Activator.getDefault().getImageRegistry().get("img_spec_open");
            }
            return Activator.getDefault().getImageRegistry().get("img_spec_closed");
        }
        if (element instanceof Module) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        if (element instanceof SpecContentProvider.Group) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY");
        }
        return null;
    }
}

