/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.spec.nature;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.parser.ModuleParserLauncher;
import org.lamport.tla.toolbox.spec.parser.SpecificationParserLauncher;

public class ParserHelper {
    private static final ModuleParserLauncher moduleParser = new ModuleParserLauncher();
    private static final SpecificationParserLauncher launcher = new SpecificationParserLauncher(moduleParser);

    public static void rebuildModule(final IResource resource, IProgressMonitor monitor) {
        if (resource == null) {
            return;
        }
        IWorkspaceRunnable run = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                moduleParser.parseModule(resource, monitor);
            }
        };
        try {
            resource.getWorkspace().run(run, monitor);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error parsing a module", e);
        }
    }

    public static void rebuildSpec(IProgressMonitor monitor) {
        final Spec spec = Activator.getSpecManager().getSpecLoaded();
        if (spec == null) {
            return;
        }
        IWorkspaceRunnable run = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                launcher.parseSpecification(spec, monitor);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(run, monitor);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error parsing a module", e);
        }
    }
}

