/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class HelpButton {
    public static Button helpButton(Composite parent, String helpFile) {
        Button button = new Button(parent, 0);
        HelpButtonListener listener = new HelpButtonListener(parent, helpFile);
        button.addSelectionListener((SelectionListener)listener);
        button.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP"));
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        button.setLayoutData((Object)gridData);
        button.setEnabled(true);
        return button;
    }

    private static class HelpButtonListener
    extends SelectionAdapter
    implements SelectionListener {
        private final String url;
        private Browser browser = null;
        private Shell helpShell = null;
        private Point location = null;
        private Point size = null;

        HelpButtonListener(Composite parent, String helpFile) {
            String file;
            String fileName = file = helpFile;
            String suffix = "";
            int idx = fileName.indexOf("#");
            if (idx != -1) {
                suffix = fileName.substring(idx);
                fileName = fileName.substring(0, idx);
            }
            Bundle bundle = Platform.getBundle((String)"org.lamport.tla.toolbox.doc");
            String urlString = null;
            if (bundle == null) {
                urlString = "http://tla.msr-inria.inria.fr/tlatoolbox/doc/" + file;
                System.out.println("Could not find local copy of help file.");
            } else {
                URL fileURL = bundle.getEntry("html/" + fileName);
                File theFile = null;
                try {
                    theFile = new File(FileLocator.resolve((URL)fileURL).getFile());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (theFile != null) {
                    urlString = theFile.getPath() + suffix;
                }
                if (theFile == null || urlString == null) {
                    urlString = "http://tla.msr-inria.inria.fr/tlatoolbox/doc/" + file;
                    System.out.println("Could not find local copy of help file.");
                }
            }
            this.url = urlString;
        }

        public void widgetSelected(SelectionEvent e) {
            boolean setSize = false;
            if (this.helpShell == null) {
                setSize = true;
                this.helpShell = new Shell(112);
                this.helpShell.setText("Toolbox Help");
                this.helpShell.addDisposeListener(event -> {
                    this.location = this.helpShell.getLocation();
                    this.size = this.helpShell.getSize();
                    this.helpShell = null;
                });
                this.browser = null;
                this.helpShell.setLayout((Layout)new FillLayout());
                Composite comp = new Composite((Composite)this.helpShell, 0);
                comp.setLayout((Layout)new GridLayout(1, false));
                ToolBar navBar = new ToolBar(comp, 0);
                navBar.setLayoutData((Object)new GridData(896));
                final ToolItem back = new ToolItem(navBar, 8);
                back.setText("<-    Back    ");
                back.setEnabled(false);
                final ToolItem forward = new ToolItem(navBar, 8);
                forward.setText(" Forward  ->");
                forward.setEnabled(false);
                try {
                    this.browser = new Browser(comp, 0);
                }
                catch (SWTError e1) {
                    System.out.println("Could not instantiate Browser: " + e1.getMessage());
                    this.helpShell.dispose();
                    return;
                }
                GridData data = new GridData(1808);
                this.browser.setLayoutData((Object)data);
                back.addListener(13, event -> this.browser.back());
                forward.addListener(13, event -> this.browser.forward());
                LocationListener locationListener = new LocationListener(){

                    public void changed(LocationEvent event) {
                        Browser browser = (Browser)event.widget;
                        back.setEnabled(browser.isBackEnabled());
                        forward.setEnabled(browser.isForwardEnabled());
                    }

                    public void changing(LocationEvent event) {
                    }
                };
                this.browser.addLocationListener(locationListener);
            }
            this.browser.setUrl(this.url);
            if (setSize) {
                if (this.location != null) {
                    this.helpShell.setLocation(this.location);
                }
                if (this.size != null) {
                    this.helpShell.setSize(this.size);
                }
            }
            this.helpShell.open();
            this.helpShell.forceFocus();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

