/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.util.pref;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferenceStoreHelper {
    public static void storeRootFilename(IProject project, String rootFilename) {
        Path path = new Path((String)rootFilename);
        Assert.isTrue((boolean)ResourceHelper.isProjectParent(path.removeLastSegments(1), project), (String)(project.getLocation().toOSString() + " is *not* a subdirectory of " + (String)rootFilename + ". This is commonly caused by a symlink contained in the latter path."));
        rootFilename = "PARENT-1-PROJECT_LOC/" + path.lastSegment();
        IEclipsePreferences projectPrefs = PreferenceStoreHelper.getProjectPreferences(project);
        projectPrefs.put("ProjectRootFile", (String)rootFilename);
        PreferenceStoreHelper.storePreferences((Preferences)projectPrefs);
    }

    public static IFile readProjectRootFile(IProject project) {
        IEclipsePreferences projectPrefs = PreferenceStoreHelper.getProjectPreferences(project);
        if (projectPrefs != null) {
            Object rootFileName = projectPrefs.get("ProjectRootFile", "not set");
            if (!"not set".equals(rootFileName)) {
                Path path = new Path((String)rootFileName);
                if (path.isAbsolute()) {
                    rootFileName = "PARENT-1-PROJECT_LOC/" + path.lastSegment();
                    PreferenceStoreHelper.convertAbsoluteToRelative(projectPrefs, (String)rootFileName);
                }
                return ResourceHelper.getLinkedFile(project, (String)rootFileName);
            }
        } else {
            Activator.getDefault().logInfo("projectPrefs is null");
        }
        return null;
    }

    private static void convertAbsoluteToRelative(IEclipsePreferences projectPrefs, String path) {
        projectPrefs.remove("ProjectRootFile");
        projectPrefs.put("ProjectRootFile", path);
        try {
            projectPrefs.flush();
            projectPrefs.sync();
        }
        catch (BackingStoreException notExpectedToHappen) {
            Activator.getDefault().logError("Failed to store rewritten absolute to relative root file name: " + path, notExpectedToHappen);
        }
    }

    private static IEclipsePreferences getProjectPreferences(IProject project) {
        if (project == null) {
            return null;
        }
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences projectNode = scope.getNode("org.lamport.tla.toolbox");
        return projectNode;
    }

    private static void storePreferences(Preferences preferences) {
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            Activator.getDefault().logError("Error storing the preference node", e);
        }
    }

    public static IPreferenceStore getProjectPreferenceStore(IProject project) {
        ProjectScope scope = new ProjectScope(project);
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)scope, "org.lamport.tla.toolbox");
        return store;
    }

    public static IPreferenceStore getProjectPreferenceStore(Spec spec) {
        return PreferenceStoreHelper.getProjectPreferenceStore(spec.getProject());
    }

    public static IPreferenceStore getInstancePreferenceStore() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store;
    }

    public static String[] getStringArray(Spec spec, String key, String[] def) {
        IPreferenceStore projectPreferences = PreferenceStoreHelper.getProjectPreferenceStore(spec);
        String string = projectPreferences.getString(key);
        if (string == null) {
            return def;
        }
        return string.split(" ");
    }
}

