/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.util.ToolboxJob;
import org.lamport.tla.toolbox.util.UIHelper;

public class ParseSpecHandler
extends AbstractHandler
implements IHandler {
    private IProgressMonitor monitor = new NullProgressMonitor();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean proceed = UIHelper.promptUserForDirtyModules();
        if (!proceed) {
            return null;
        }
        final Spec spec = Activator.getSpecManager().getSpecLoaded();
        if (spec != null) {
            ToolboxJob job = new ToolboxJob("Parsing spec handler..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        spec.getProject().build(15, monitor);
                        spec.getProject().build(6, monitor);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return null;
    }

    public boolean isEnabled() {
        if (Activator.getSpecManager().getSpecLoaded() == null) {
            return false;
        }
        return super.isEnabled();
    }

    protected void saveDirtyEditors() {
        Display display = UIHelper.getCurrentDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] windows = Activator.getDefault().getWorkbench().getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    IWorkbenchPage[] pages = windows[i].getPages();
                    int j = 0;
                    while (j < pages.length) {
                        pages[j].saveAllEditors(false);
                        ++j;
                    }
                    ++i;
                }
            }
        });
    }
}

