/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.spec;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.eclipse.core.resources.IResource;
import tla2sany.modanalyzer.ParseUnit;
import tla2sany.semantic.ModuleNode;
import util.FilenameToStream;
import util.NamedInputStream;

public class Module {
    private final File file;
    private ModuleNode node;
    private boolean isRoot = false;
    private IResource resource;
    private final ParseUnit parseUnit;

    public Module(ParseUnit parseUnit) {
        this.file = new File(parseUnit.getNis().sourceFile().getAbsolutePath());
        this.parseUnit = parseUnit;
    }

    public Module(IResource resource) {
        this.file = new File(resource.getLocation().toOSString());
        this.parseUnit = null;
        this.resource = resource;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public File getFile() {
        return this.file;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource aResource) {
        this.resource = aResource;
    }

    public String getModuleName() {
        String filename = this.file.getName();
        int tlaSuffixIndex = filename.toLowerCase().indexOf(".tla");
        if (tlaSuffixIndex != -1) {
            filename = filename.substring(0, tlaSuffixIndex);
        }
        return filename;
    }

    public ModuleNode getNode() {
        return this.node;
    }

    public void setNode(ModuleNode node) {
        this.node = node;
    }

    public boolean isStandardModule() {
        if (this.node != null) {
            return this.node.isStandardModule();
        }
        return this.getAbsolutePath().indexOf("StandardModules") != -1;
    }

    public boolean isLibraryModule() {
        if (this.parseUnit != null && this.parseUnit.isLibraryModule()) {
            return true;
        }
        return this.isStandardModule();
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public void copyTo(Path dst) throws IOException {
        FilenameToStream.TLAFile tlaFile;
        File moduleOverride;
        NamedInputStream nis;
        Files.copy(this.file.toPath(), dst.resolve(this.file.getName()), StandardCopyOption.REPLACE_EXISTING);
        if (this.parseUnit != null && (nis = this.parseUnit.getNis()) != null && nis.sourceFile() instanceof FilenameToStream.TLAFile && (moduleOverride = (tlaFile = (FilenameToStream.TLAFile)nis.sourceFile()).getModuleOverride()) != null) {
            Files.copy(moduleOverride.toPath(), dst.resolve(moduleOverride.getName()), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

