/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.handler;

import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.UIHelper;
import tlc2.output.SpecWriterUtilities;

public class AddModuleHandler
extends AbstractHandler
implements IHandler {
    public static final String[] ACCEPTED_EXTENSIONS = new String[]{"*.tla", "*.*"};
    public static final String COMMAND_ID = "toolbox.command.module.add";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        Spec spec = Activator.getSpecManager().getSpecLoaded();
        FileDialog openFileDialog = UIHelper.getFileDialog(window.getShell());
        openFileDialog.setText("Add TLA+ module to the spec");
        openFileDialog.setFilterPath(ResourceHelper.getParentDirName((IResource)spec.getRootFile()));
        openFileDialog.setFilterExtensions(ACCEPTED_EXTENSIONS);
        String moduleFileName = openFileDialog.open();
        if (moduleFileName != null) {
            IFile module = ResourceHelper.getLinkedFile((IContainer)spec.getProject(), moduleFileName, false);
            if (module != null && module.getFileExtension() == null) {
                moduleFileName = ResourceHelper.getModuleFileName(moduleFileName);
                module = ResourceHelper.getLinkedFile((IContainer)spec.getProject(), moduleFileName, false);
            }
            if (!ResourceHelper.isModule((IResource)module)) {
                MessageDialog.openInformation((Shell)window.getShell(), (String)"The selected file is not a TLA+ file", (String)("The provided file " + module.getName() + " is not a TLA+ file.\n Please select a file with .tla extension."));
                return null;
            }
            if (module.isLinked()) {
                MessageDialog.openInformation((Shell)window.getShell(), (String)"TLA+ Module is part of the spec", (String)("The provided module " + module.getName() + " has already been added to the specification previously."));
            } else {
                Path modulePath = new Path(moduleFileName);
                if (!ResourceHelper.isProjectParent(modulePath.removeLastSegments(1), spec.getProject())) {
                    MessageDialog.openInformation((Shell)window.getShell(), (String)"TLA+ Module is not part of the current spec.", (String)("The provided module " + module.getName() + " is not part of the spec which is currently open. It will therefore be opened in read-only mode.\nIf you want to make changes to this file, you will have to open the corresponding spec first."));
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(moduleFileName));
                    if (fileStore.fetchInfo().isDirectory() || !fileStore.fetchInfo().exists()) {
                        throw new ExecutionException(moduleFileName + " cannot be opened in read-only mode because its file content could not be obtained.");
                    }
                    UIHelper.openEditor("org.lamport.tla.toolbox.editor.basic.TLAEditorReadOnly", (IEditorInput)new FileStoreEditorInput(fileStore));
                    return null;
                }
                if (!modulePath.toFile().exists()) {
                    boolean createNew = MessageDialog.openQuestion((Shell)window.getShell(), (String)"TLA+ Module is not found", (String)("The provided module " + module.getName() + " does not exist. Should the new file be created?"));
                    if (createNew) {
                        try {
                            ResourcesPlugin.getWorkspace().run(ResourceHelper.createTLAModuleCreationOperation((IPath)modulePath), null);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                module = this.createModuleFile(spec, moduleFileName, (IPath)modulePath);
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("toolbox.command.module.open.param", SpecWriterUtilities.getModuleNameChecked((String)module.getName(), (boolean)false));
            UIHelper.runCommand("toolbox.command.module.open", parameters);
        }
        return null;
    }

    public IFile createModuleFile(Spec spec, String moduleFileName, IPath modulePath) {
        if (ResourceHelper.isProjectParent(modulePath.removeLastSegments(1), spec.getProject())) {
            moduleFileName = "PARENT-1-PROJECT_LOC/" + modulePath.lastSegment();
        }
        return ResourceHelper.getLinkedFile((IContainer)spec.getProject(), (String)moduleFileName, true);
    }

    public boolean isEnabled() {
        if (Activator.getSpecManager().getSpecLoaded() == null) {
            return false;
        }
        return super.isEnabled();
    }
}

