/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.property;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.ui.preference.LibraryPathComposite;
import org.lamport.tla.toolbox.ui.property.GenericFieldEditorPropertyPage;
import org.lamport.tla.toolbox.util.UIHelper;
import org.lamport.tla.toolbox.util.pref.PreferenceStoreHelper;

public class SpecPropertyPage
extends GenericFieldEditorPropertyPage {
    private StringFieldEditor rootFileEditor;
    private StringFieldEditor directorySizeEditor;
    private LibraryPathComposite libraryPathComposite;

    @Override
    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.noDefaultAndApplyButton();
        UIHelper.setHelp(control, "SpecPropertyPage");
        return control;
    }

    @Override
    public void createFieldEditors(Composite composite) {
        this.rootFileEditor = new StringFieldEditor("ProjectRootFile", "Specification root module", composite);
        this.addEditor((FieldEditor)this.rootFileEditor);
        this.rootFileEditor.getTextControl(composite).setEditable(false);
        StringFieldEditor pcalParamEditor = new StringFieldEditor("pCalCallParams", "PlusCal call arguments", composite);
        this.addEditor((FieldEditor)pcalParamEditor);
        this.directorySizeEditor = new StringFieldEditor("DoesNotExistIsIrrelevant", "Size of .toolbox directory in kbytes", composite);
        this.addEditor((FieldEditor)this.directorySizeEditor);
        this.directorySizeEditor.getTextControl(composite).setEditable(false);
        this.libraryPathComposite = new LibraryPathComposite((PreferencePage)this);
    }

    @Override
    protected void initialize() {
        super.initialize();
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        Spec spec = (Spec)this.getElement();
        IProject project = spec.getProject();
        String relativePath = preferenceStore.getString("ProjectRootFile");
        IFile resolvedFile = project.getFile(new Path(relativePath).lastSegment());
        this.rootFileEditor.setStringValue(resolvedFile.getLocation().toOSString());
        this.directorySizeEditor.setStringValue(Long.toString(spec.getSize() / 1000L));
    }

    protected IPreferenceStore doGetPreferenceStore() {
        Spec spec = (Spec)this.getElement();
        return PreferenceStoreHelper.getProjectPreferenceStore(spec.getProject());
    }

    @Override
    protected void performDefaults() {
        this.libraryPathComposite.performInit();
        super.performDefaults();
    }

    @Override
    public boolean performOk() {
        this.libraryPathComposite.applyChanges();
        return super.performOk();
    }
}

