/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.lamport.tla.toolbox.util.UIHelper;

public class InformationDialog
extends Dialog {
    private Text dialogText;
    private String message;
    private String title;
    private Image image;

    protected InformationDialog(IShellProvider parentShell, String message) {
        super(parentShell);
        this.setShellStyle(65568);
        this.setBlockOnOpen(true);
        this.message = message;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        if (this.image != null) {
            Label imageLabel = new Label(composite, 0);
            this.image.setBackground(imageLabel.getBackground());
            imageLabel.setImage(this.image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)imageLabel);
        }
        this.dialogText = new Text(composite, 66);
        this.dialogText.setText(this.message);
        this.dialogText.setEditable(false);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.dialogText);
        return composite;
    }

    public static void openWarning(String message, String title) {
        InformationDialog dialog = new InformationDialog(UIHelper.getShellProvider(), message);
        dialog.setTitle(title);
        dialog.setImage(UIHelper.getSWTImage(8));
        dialog.open();
    }

    public static void openError(String message, String title) {
        InformationDialog dialog = new InformationDialog(UIHelper.getShellProvider(), message);
        dialog.setTitle(title);
        dialog.setImage(UIHelper.getSWTImage(1));
        dialog.open();
    }

    public static void openInformation(String message, String title) {
        InformationDialog dialog = new InformationDialog(UIHelper.getShellProvider(), message);
        dialog.setTitle(title);
        dialog.setImage(UIHelper.getSWTImage(2));
        dialog.open();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }
}

