/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.util;

import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class StringSet {
    private Vector<String> contents = new Vector();

    public void add(String str) {
        int position = 0;
        if (this.contents.size() == 0) {
            this.contents.add(str);
            return;
        }
        position = this.binarySearch(str);
        if (position == -1 || !str.equals(this.contents.elementAt(position))) {
            this.contents.add(position + 1, str);
        }
    }

    public void addAll(StringSet ss) {
        int i = 0;
        while (i < ss.contents.size()) {
            this.add(ss.contents.elementAt(i));
            ++i;
        }
    }

    public boolean contains(String str) {
        int position = this.binarySearch(str);
        if (position == -1) {
            return false;
        }
        return str.equals(this.contents.elementAt(this.binarySearch(str)));
    }

    public boolean isEmpty() {
        return this.contents.size() == 0;
    }

    private int binarySearch(String str) {
        if (this.contents.size() == 0 || str.compareTo(this.contents.elementAt(0)) < 0) {
            return -1;
        }
        if (this.contents.elementAt(this.contents.size() - 1).compareTo(str) <= 0) {
            return this.contents.size() - 1;
        }
        int bot = 0;
        int top = this.contents.size() - 1;
        while (bot + 1 < top) {
            int mid = bot + (top - bot) / 2;
            if (str.compareTo(this.contents.elementAt(mid)) < 0) {
                top = mid;
                continue;
            }
            bot = mid;
        }
        return bot;
    }

    public StringSet() {
    }

    public StringSet(HashSet<String> hSet) {
        Iterator<String> iter = hSet.iterator();
        while (iter.hasNext()) {
            this.contents.add(iter.next());
        }
    }

    public StringSet clone() {
        StringSet result = new StringSet();
        int i = 0;
        while (i < this.contents.size()) {
            result.add(this.contents.elementAt(i));
            ++i;
        }
        return result;
    }

    public String toCommaSeparatedString() {
        Object result = "";
        int i = 0;
        while (i < this.contents.size()) {
            result = ((String)result).equals("") ? this.contents.elementAt(i) : (String)result + ", " + this.contents.elementAt(i);
            ++i;
        }
        return result;
    }

    public static StringSet CommaSeparatedListToStringSet(String str) {
        StringSet result = new StringSet();
        String[] elements = str.split(",");
        int i = 0;
        while (i < elements.length) {
            result.add(elements[i].trim());
            ++i;
        }
        return result;
    }

    public String toString() {
        return this.contents.toString();
    }

    public static void test() {
        int max = 12;
        int[] elts = new int[5];
        int i = 1;
        while (i < max) {
            elts[0] = i;
            int j = 1;
            while (j < max) {
                elts[1] = j;
                int k = 1;
                while (k < max) {
                    elts[2] = k;
                    int m = 1;
                    while (m < max) {
                        elts[3] = m;
                        int n = 1;
                        while (n < max) {
                            elts[4] = n++;
                            StringSet.innerTest(elts, max);
                        }
                        ++m;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void innerTest(int[] elts, int max) {
        StringSet ss4;
        int n = elts.length;
        StringSet ss = new StringSet();
        HashSet<CallSite> hs = new HashSet<CallSite>();
        StringSet ss1 = new StringSet();
        StringSet ss2 = new StringSet();
        Object str = "";
        int i = 0;
        while (i < n) {
            ss.add("" + elts[i]);
            hs.add((CallSite)((Object)("" + elts[i])));
            if (i > 0) {
                str = (String)str + " , ";
            }
            str = (String)str + elts[i];
            if (i < n / 2) {
                ss1.add("" + elts[i]);
            } else {
                ss2.add("" + elts[i]);
            }
            ++i;
        }
        int t = 1;
        while (t < ss.contents.size() - 1) {
            if (ss.contents.elementAt(t).compareTo(ss.contents.elementAt(t + 1)) >= 0) {
                System.out.println(t + ", " + (t + 1) + " malordered in: " + ss.toCommaSeparatedString());
            }
            ++t;
        }
        int r = 1;
        while (r < n) {
            if (ss.contains("" + r) != hs.contains("" + r)) {
                System.out.println("ss and hs differ on " + r + " in: " + ss.toCommaSeparatedString());
            }
            ++r;
        }
        StringSet ss3 = ss1.clone();
        ss3.addAll(ss2);
        int z = 1;
        while (z < max) {
            if (ss3.contains("" + z) != (ss1.contains("" + z) || ss2.contains("" + z))) {
                System.out.println(ss3.toCommaSeparatedString() + " != " + ss1.toCommaSeparatedString() + " + " + ss2.toCommaSeparatedString());
            }
            ++z;
        }
        StringSet csl = StringSet.CommaSeparatedListToStringSet((String)str);
        if (!csl.toCommaSeparatedString().equals(ss.toCommaSeparatedString())) {
            System.out.println(csl.toCommaSeparatedString() + " != " + ss.toCommaSeparatedString());
        }
        if ((ss4 = new StringSet()).contains("1")) {
            System.out.println("The empty set is not empty");
        }
    }
}

