/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.tool.SpecEvent;
import org.lamport.tla.toolbox.tool.SpecLifecycleParticipant;

public class SpecLifecycleManager {
    private static final String POINT = "org.lamport.tla.toolbox.spec";
    private static final String CLASS_ATTR_NAME = "class";
    private final List<SpecLifecycleParticipant> extensions = new CopyOnWriteArrayList<SpecLifecycleParticipant>();
    private ExtensionInvocationStrategy simpleInvocationStrategy = new ExtensionInvocationStrategy(){

        @Override
        public boolean invoke(SpecLifecycleParticipant target, SpecEvent event) {
            return target.eventOccured(event);
        }
    };

    public SpecLifecycleManager() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        ArrayList<SpecLifecycleParticipant> specExtensions = new ArrayList<SpecLifecycleParticipant>();
        if (extensionRegistry != null) {
            IConfigurationElement[] decls = extensionRegistry.getConfigurationElementsFor(POINT);
            int i = 0;
            while (i < decls.length) {
                try {
                    SpecLifecycleParticipant extension = (SpecLifecycleParticipant)decls[i].createExecutableExtension(CLASS_ATTR_NAME);
                    assert (extension != null);
                    specExtensions.add(extension);
                    extension.initialize();
                }
                catch (CoreException e) {
                    Activator.getDefault().logError("Error retrieving the registered participants", e);
                }
                ++i;
            }
        }
        this.extensions.addAll(specExtensions);
    }

    public boolean sendEvent(SpecEvent event) {
        return this.sendEventWithVeto(event, false);
    }

    public boolean sendEventWithVeto(SpecEvent event, boolean stopOnVeto) {
        boolean responseAll = true;
        for (SpecLifecycleParticipant target : this.extensions) {
            assert (target != null);
            boolean response = this.simpleInvocationStrategy.invoke(target, event);
            boolean bl = responseAll = responseAll && response;
            if (stopOnVeto && !response) break;
        }
        return responseAll;
    }

    public void terminate() {
        for (SpecLifecycleParticipant extension : this.extensions) {
            extension.terminate();
        }
    }

    public void addSpecLifecycleParticipant(SpecLifecycleParticipant specLifecycleParticipant) {
        this.extensions.add(specLifecycleParticipant);
    }

    public void removeSpecLifecycleParticipant(SpecLifecycleParticipant specLifecycleParticipant) {
        this.extensions.remove(specLifecycleParticipant);
    }

    static abstract class ExtensionInvocationStrategy {
        ExtensionInvocationStrategy() {
        }

        public abstract boolean invoke(SpecLifecycleParticipant var1, SpecEvent var2);
    }
}

