/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.job.NewTLAModuleCreationOperation;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.parser.ParseResult;
import org.lamport.tla.toolbox.spec.parser.ParseResultBroadcaster;
import org.lamport.tla.toolbox.spec.parser.ParserDependencyStorage;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.util.RCPNameToFileIStream;
import org.lamport.tla.toolbox.util.StringSet;
import org.lamport.tla.toolbox.util.UIHelper;
import org.lamport.tla.toolbox.util.pref.PreferenceStoreHelper;
import pcal.TLAtoPCalMapping;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.parser.ParseException;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.parser.TLAplusParser;
import tla2sany.semantic.DefStepNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.InstanceNode;
import tla2sany.semantic.LeafProofNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NewSymbNode;
import tla2sany.semantic.NonLeafProofNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.TheoremNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.semantic.UseOrHideNode;
import tla2sany.st.Location;
import tla2sany.st.TreeNode;
import tlc2.output.SpecWriterUtilities;
import util.StringHelper;
import util.UniqueString;

public class ResourceHelper {
    private static final String PMAP_SUFFIX = ".pmap";
    private static final String PROJECT_DESCRIPTION_FILE = ".project";
    public static final String TOOLBOX_DIRECTORY_SUFFIX = ".toolbox";
    public static final String TLA_EXTENSION = "tla";
    public static final Location infiniteLoc = new Location(Integer.MAX_VALUE, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final String PARENT_ONE_PROJECT_LOC = "PARENT-1-PROJECT_LOC/";

    public static boolean peekProject(String name, String rootFilename) {
        String root = ResourceHelper.getParentDirName(rootFilename);
        if (root == null) {
            return false;
        }
        File projectDir = new File(root.concat("/").concat(name).concat(TOOLBOX_DIRECTORY_SUFFIX));
        return projectDir.exists();
    }

    public static IResource getResourceByModuleName(String name) {
        return ResourceHelper.getResourceByName(ResourceHelper.getModuleFileName(name));
    }

    public static IResource getResourceByName(String name) {
        Spec spec = Activator.getSpecManager().getSpecLoaded();
        if (spec != null) {
            IProject project = spec.getProject();
            return ResourceHelper.getLinkedFile((IContainer)project, name, false);
        }
        return null;
    }

    public static IProject getProject(String name) {
        if (name == null) {
            return null;
        }
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject(name);
        return project;
    }

    public static IProject getProject(String name, String rootFilename, boolean createMissing, boolean importExisting, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)rootFilename);
        IProject project = ResourceHelper.getProject(name);
        if (!project.exists() && createMissing) {
            IProjectDescription description;
            boolean performImport;
            String parentDirectory = ResourceHelper.getParentDirName(rootFilename);
            Assert.isNotNull((Object)parentDirectory);
            IPath projectDescriptionPath = new Path(parentDirectory).removeTrailingSeparator().append(name.concat(TOOLBOX_DIRECTORY_SUFFIX)).addTrailingSeparator();
            boolean bl = performImport = importExisting && projectDescriptionPath.append(PROJECT_DESCRIPTION_FILE).toFile().exists();
            if (performImport) {
                description = project.getWorkspace().loadProjectDescription(projectDescriptionPath.append(PROJECT_DESCRIPTION_FILE));
                String[] natureIds = description.getNatureIds();
                boolean natureFound = false;
                int i = 0;
                while (i < natureIds.length) {
                    if ("toolbox.natures.TLANature".equals(natureIds[i])) {
                        natureFound = true;
                        break;
                    }
                    ++i;
                }
                if (!natureFound) {
                    String[] newNatureIds = new String[natureIds.length + 1];
                    System.arraycopy(natureIds, 0, newNatureIds, 0, natureIds.length);
                    newNatureIds[natureIds.length] = "toolbox.natures.TLANature";
                    description.setNatureIds(newNatureIds);
                }
                ICommand[] commands = description.getBuildSpec();
                boolean tlaBuilderFound = false;
                int numberOfBuildersToInstall = 1;
                int i2 = 0;
                while (i2 < commands.length) {
                    String builderName = commands[i2].getBuilderName();
                    if (builderName.equals("toolbox.builder.TLAParserBuilder")) {
                        tlaBuilderFound = true;
                        --numberOfBuildersToInstall;
                    }
                    if (tlaBuilderFound) break;
                    ++i2;
                }
                if (numberOfBuildersToInstall > 0) {
                    ICommand[] newCommands = new ICommand[commands.length + numberOfBuildersToInstall];
                    System.arraycopy(commands, 0, newCommands, 0, commands.length);
                    int position = commands.length;
                    if (!tlaBuilderFound) {
                        ICommand command = description.newCommand();
                        command.setBuilderName("toolbox.builder.TLAParserBuilder");
                        newCommands[position] = command;
                        ++position;
                    }
                }
            } else {
                description = project.getWorkspace().newProjectDescription(name);
                description.setLocation(projectDescriptionPath);
                description.setNatureIds(new String[]{"toolbox.natures.TLANature"});
                ICommand command = description.newCommand();
                command.setBuilderName("toolbox.builder.TLAParserBuilder");
                description.setBuildSpec(new ICommand[]{command});
            }
            project.create(description, monitor);
            project.refreshLocal(2, monitor);
            project.open(monitor);
            if (performImport) {
                ResourceHelper.relocateFiles(project, (IPath)new Path(parentDirectory), monitor);
            }
        }
        return project;
    }

    public static IFile getLinkedFile(IContainer project, String name, boolean createNew) {
        if (name == null || project == null) {
            return null;
        }
        Path location = new Path(name);
        IFile file = project.getFile((IPath)new Path(location.lastSegment()));
        if (createNew) {
            if (!file.isLinked()) {
                try {
                    file.createLink((IPath)location, 0, (IProgressMonitor)new NullProgressMonitor());
                    return file;
                }
                catch (CoreException e) {
                    Activator.getDefault().logError("Error creating resource link to " + name, e);
                }
            }
            if (file.exists()) {
                return file;
            }
            return null;
        }
        return file;
    }

    public static IFile getLinkedFileUnchecked(IContainer project, String name, boolean createNew) throws CoreException {
        if (name == null || project == null) {
            return null;
        }
        Path location = new Path(name);
        IFile file = project.getFile((IPath)new Path(location.lastSegment()));
        if (createNew) {
            if (!file.isLinked()) {
                file.createLink((IPath)location, 0, (IProgressMonitor)new NullProgressMonitor());
                return file;
            }
            if (file.exists()) {
                return file;
            }
            return null;
        }
        return file;
    }

    private static void relocateFiles(IProject project, IPath newLocationParent, IProgressMonitor monitor) {
        Assert.isNotNull((Object)project);
        Assert.isNotNull((Object)newLocationParent);
        if (!newLocationParent.hasTrailingSeparator()) {
            newLocationParent.addTrailingSeparator();
        }
        try {
            try {
                final HashMap<IResource, IPath> failures = new HashMap<IResource, IPath>();
                IResource[] members = project.members();
                monitor.beginTask("Relocating Files", members.length * 2);
                int i = 0;
                while (i < members.length) {
                    IResource resource = members[i];
                    if (resource.isLinked() && (!resource.isAccessible() || resource.getRawLocation().isAbsolute())) {
                        String name = members[i].getName();
                        IPath newLocation = newLocationParent.append(name);
                        members[i].delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).split(1));
                        if (newLocation.toFile().exists()) {
                            ResourceHelper.getLinkedFile((IContainer)project, PARENT_ONE_PROJECT_LOC + name, true);
                            monitor.worked(1);
                            Activator.getDefault().logDebug("File found " + newLocation.toOSString());
                        } else {
                            failures.put(members[i], newLocation);
                            Activator.getDefault().logError("Error relocating files in " + project.getName(), new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox", "Error relocating file " + name + ". The specified location " + newLocation.toOSString() + " did not contain the file.")));
                        }
                    } else {
                        monitor.worked(2);
                    }
                    ++i;
                }
                if (!failures.isEmpty()) {
                    final StringBuffer buf = new StringBuffer(failures.size());
                    buf.append(String.format("The Toolbox failed to find %s %s while opening the %s spec:", failures.size(), failures.size() > 1 ? "files" : "file", project.getName()));
                    buf.append("\n\n");
                    RCPNameToFileIStream resolver = new RCPNameToFileIStream(ResourceHelper.getTLALibraryPath(project));
                    for (Map.Entry entry : failures.entrySet()) {
                        String moduleName = ((IResource)entry.getKey()).getName();
                        File resolve = resolver.resolve(moduleName, false);
                        boolean assumedStandardModule = resolve.exists();
                        String path = ((IPath)entry.getValue()).toOSString();
                        buf.append(String.format("%s %s", path, assumedStandardModule ? "(standard module)" : ""));
                        buf.append("\n\n");
                    }
                    buf.append("Files marked as standard modules will not cause the spec parser to fail. If you intended to provide an overwrite of a standard module, it is up to you now to provide the module.\nMissing user modules will result in a parser failure and have to be manually created.");
                    UIJob job = new UIJob("Warning relocating files"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            MessageDialog.openWarning((Shell)UIHelper.getShell(), (String)String.format("Failed to find %s spec files!", failures.size(), failures.size() > 1 ? "files" : "file"), (String)buf.toString());
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error relocating files in " + project.getName(), e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public static String[] getTLALibraryPath(IProject project) {
        IPreferenceStore store = PreferenceStoreHelper.getProjectPreferenceStore(project);
        String prefStr = store.getString("TLA_LIBRARY_PATH");
        if ("".equals(prefStr)) {
            prefStr = PreferenceStoreHelper.getInstancePreferenceStore().getString("TLA_LIBRARY_PATH");
        }
        if (!"".equals(prefStr)) {
            String[] locations;
            Vector<String> locationList = new Vector<String>();
            String[] stringArray = locations = prefStr.split("\\|");
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                String location = stringArray[n2];
                String[] split = location.split("\\*");
                if (Boolean.parseBoolean(split[1])) {
                    locationList.add(split[0]);
                }
                ++n2;
            }
            return locationList.toArray(new String[locationList.size()]);
        }
        return new String[0];
    }

    public static IFile getLinkedFile(IProject project, String name) {
        return ResourceHelper.getLinkedFile((IContainer)project, name, true);
    }

    public static String getParentDirName(String path) {
        return new File(path).getParent();
    }

    public static String getParentDirName(IResource resource) {
        if (resource == null) {
            return null;
        }
        return ResourceHelper.getParentDirName(resource.getLocation().toOSString());
    }

    public static ModuleNode getModuleNode(String moduleName) {
        SpecObj specObj = ToolboxHandle.getSpecObj();
        if (specObj == null) {
            return null;
        }
        return specObj.getExternalModuleTable().getModuleNode(UniqueString.uniqueStringOf((String)moduleName));
    }

    public static String getModuleName(String moduleFilename) {
        return SpecWriterUtilities.getModuleNameChecked((String)moduleFilename, (boolean)true);
    }

    public static String getModuleName(IResource resource) {
        if (resource == null) {
            return null;
        }
        if (resource.getLocation() == null) {
            return null;
        }
        return ResourceHelper.getModuleName(resource.getLocation().toOSString());
    }

    public static String getModuleFileName(String moduleName) {
        if (moduleName == null || moduleName.equals("")) {
            return null;
        }
        return moduleName.concat(".").concat(TLA_EXTENSION);
    }

    public static IFile[] getModuleOverrides(IProject project, IFile moduleFile) {
        String[] extensions;
        int indexOfFileExtension = moduleFile.getFileExtension().length() + 1;
        String moduleName = moduleFile.getName().substring(0, moduleFile.getName().length() - indexOfFileExtension);
        ArrayList<IFile> res = new ArrayList<IFile>();
        String[] stringArray = extensions = new String[]{".class", ".java"};
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            try {
                IFile userModuleOverride = ResourceHelper.getLinkedFileUnchecked((IContainer)project, PARENT_ONE_PROJECT_LOC + moduleName + extension, true);
                if (userModuleOverride != null && userModuleOverride.exists()) {
                    res.add(userModuleOverride);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        return res.toArray(new IFile[0]);
    }

    public static boolean isModule(IResource resource) {
        return resource != null && TLA_EXTENSION.equals(resource.getFileExtension());
    }

    public static StringBuffer getEmptyModuleContent(String moduleFilename) {
        StringBuffer buffer = new StringBuffer();
        String moduleName = SpecWriterUtilities.getModuleNameChecked((String)moduleFilename, (boolean)false);
        int numberOfDashes = Math.max(4, (Activator.getDefault().getPreferenceStore().getInt("editorRightMargin") - moduleName.length() - 9) / 2);
        String dashes = StringHelper.copyString((String)"-", (int)numberOfDashes);
        buffer.append(dashes).append(" MODULE ").append(moduleName).append(" ").append(dashes).append(StringHelper.copyString((String)StringHelper.PLATFORM_NEWLINE, (int)3));
        return buffer;
    }

    public static StringBuilder getModuleClosingTag() {
        IPreferenceStore ips = Activator.getDefault().getPreferenceStore();
        int rightMarginWidth = ips.getInt("editorRightMargin");
        boolean addModificationHistory = ips.getBoolean("editorAddModificationHistory");
        return SpecWriterUtilities.getModuleClosingTag((int)rightMarginWidth, (boolean)addModificationHistory);
    }

    public static boolean isRoot(IFile module) {
        Spec spec = Activator.getSpecManager().getSpecLoaded();
        if (spec == null) {
            return false;
        }
        return spec.getRootFile().equals((Object)module);
    }

    public static QualifiedName getQName(String localName) {
        return new QualifiedName("org.lamport.tla.toolbox", localName);
    }

    public static IWorkspaceRunnable createTLAModuleCreationOperation(IPath rootNamePath) {
        return new NewTLAModuleCreationOperation(rootNamePath);
    }

    public static void addContent(IFile file, StringBuilder buffer, IProgressMonitor monitor) throws CoreException {
        ByteArrayInputStream stream = new ByteArrayInputStream(buffer.toString().getBytes());
        if (file.exists()) {
            file.appendContents((InputStream)stream, 1, monitor);
        } else {
            file.create((InputStream)stream, true, monitor);
        }
    }

    public static ISchedulingRule getModifyRule(IResource[] resources) {
        if (resources == null) {
            return null;
        }
        ISchedulingRule combinedRule = null;
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        int i = 0;
        while (i < resources.length) {
            if (resources[i] == null || !resources[i].exists()) {
                return null;
            }
            ISchedulingRule rule = ruleFactory.modifyRule(resources[i]);
            combinedRule = MultiRule.combine((ISchedulingRule)rule, combinedRule);
            ++i;
        }
        return combinedRule;
    }

    public static ISchedulingRule getCreateRule(IResource resource) {
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        return ruleFactory.createRule(resource);
    }

    public static ISchedulingRule getModifyRule(IResource resource) {
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule rule = ruleFactory.modifyRule(resource);
        return rule;
    }

    public static ISchedulingRule getDeleteRule(IResource[] resources) {
        if (resources == null) {
            return null;
        }
        ISchedulingRule combinedRule = null;
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        int i = 0;
        while (i < resources.length) {
            ISchedulingRule rule = ruleFactory.deleteRule(resources[i]);
            combinedRule = MultiRule.combine((ISchedulingRule)rule, combinedRule);
            ++i;
        }
        return combinedRule;
    }

    public static ISchedulingRule getCreateRule(IResource[] resources) {
        if (resources == null) {
            return null;
        }
        ISchedulingRule combinedRule = null;
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        int i = 0;
        while (i < resources.length) {
            ISchedulingRule rule = ruleFactory.createRule(resources[i]);
            combinedRule = MultiRule.combine((ISchedulingRule)rule, combinedRule);
            ++i;
        }
        return combinedRule;
    }

    public static IProject projectRename(IProject project, String aNewName, IProgressMonitor aMonitor) {
        try {
            IProjectDescription description = project.getDescription();
            IPath basePath = description.getLocation().removeLastSegments(1).removeTrailingSeparator();
            IPath newPath = basePath.append(aNewName.concat(TOOLBOX_DIRECTORY_SUFFIX)).addTrailingSeparator();
            description.setLocation(newPath);
            description.setName(aNewName);
            project.refreshLocal(2, aMonitor);
            project.copy(description, 32, aMonitor);
            return ResourcesPlugin.getWorkspace().getRoot().getProject(aNewName);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error renaming a specification", e);
            return null;
        }
    }

    public static IProject refreshProject(IProject aProject, IProgressMonitor aMonitor) {
        try {
            aProject.refreshLocal(2, aMonitor);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error refreshing a specification", e);
        }
        return aProject;
    }

    public static IProject refreshSpec(Spec aSpec, IProgressMonitor aMonitor) {
        return ResourceHelper.refreshProject(ResourceHelper.getProject(aSpec.getName()), aMonitor);
    }

    public static void deleteProject(IProject project, IProgressMonitor aMonitor, boolean isForget) {
        try {
            if (isForget) {
                project.delete(8, aMonitor);
            } else {
                project.delete(true, aMonitor);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error deleting a specification", e);
        }
    }

    public static ParseResult getValidParseResult(IFile file) {
        ParseResult parseResult = ParseResultBroadcaster.getParseResultBroadcaster().getParseResult(file.getLocation());
        if (parseResult == null) {
            return null;
        }
        long timeWhenParsed = parseResult.getParserCalled();
        long timeWhenWritten = file.getLocalTimeStamp();
        if (timeWhenWritten == -1L || timeWhenWritten > timeWhenParsed) {
            return null;
        }
        return parseResult;
    }

    public static TheoremNode getTheoremNodeWithCaret(ParseResult parseResult, String moduleName, ITextSelection textSelection, IDocument document) {
        if (parseResult == null || parseResult.getStatus() != 0) {
            return null;
        }
        ModuleNode module = parseResult.getSpecObj().getExternalModuleTable().getModuleNode(UniqueString.uniqueStringOf((String)moduleName));
        if (module == null) {
            return null;
        }
        TheoremNode[] theorems = module.getTheorems();
        TheoremNode stepWithCaret = null;
        int i = 0;
        while (i < theorems.length) {
            TheoremNode step;
            TheoremNode theoremNode = theorems[i];
            if (theoremNode.getLocation().source().equals(moduleName) && (step = UIHelper.getThmNodeStepWithCaret(theoremNode, textSelection.getOffset(), document)) != null) {
                stepWithCaret = step;
                break;
            }
            ++i;
        }
        return stepWithCaret;
    }

    public static LevelNode getPfStepOrUseHideFromMod(ParseResult parseResult, String moduleName, ITextSelection textSelection, IDocument document) {
        block3: {
            try {
                if (parseResult != null && parseResult.getStatus() == 0) break block3;
                return null;
            }
            catch (BadLocationException e) {
                Activator.getDefault().logError("Error getting line number of caret.", e);
                return null;
            }
        }
        ModuleNode module = parseResult.getSpecObj().getExternalModuleTable().getModuleNode(UniqueString.uniqueStringOf((String)moduleName));
        return ResourceHelper.getPfStepOrUseHideFromModuleNode(module, document.getLineOfOffset(textSelection.getOffset()) + 1);
    }

    public static LevelNode getPfStepOrUseHideFromModuleNode(ModuleNode module, int lineNum) {
        if (module == null) {
            return null;
        }
        LevelNode[] topLevelNodes = module.getTopLevel();
        int i = 0;
        while (i < topLevelNodes.length) {
            LevelNode node;
            if (topLevelNodes[i].getLocation().source().equals(module.getName().toString()) && (node = ResourceHelper.getLevelNodeFromTree(topLevelNodes[i], lineNum)) != null) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public static LevelNode getLevelNodeFromTree(LevelNode levelNode, int lineNum) {
        TheoremNode theoremNode;
        ProofNode proof;
        int nodeBeginLine = levelNode.getLocation().beginLine();
        int nodeEndLine = 0;
        if (levelNode instanceof TheoremNode) {
            nodeEndLine = ((TheoremNode)levelNode).getTheorem().getLocation().endLine();
        } else if (levelNode instanceof UseOrHideNode || levelNode instanceof InstanceNode || levelNode instanceof DefStepNode) {
            nodeEndLine = levelNode.getLocation().endLine();
        } else {
            return null;
        }
        if (nodeBeginLine <= lineNum && nodeEndLine >= lineNum) {
            return levelNode;
        }
        if (levelNode instanceof TheoremNode && (proof = (theoremNode = (TheoremNode)levelNode).getProof()) != null) {
            Location proofLoc = proof.getLocation();
            if (lineNum >= nodeEndLine && lineNum <= proofLoc.endLine()) {
                if (proof instanceof NonLeafProofNode) {
                    NonLeafProofNode nonLeafProof = (NonLeafProofNode)proof;
                    LevelNode[] steps = nonLeafProof.getSteps();
                    int i = 0;
                    while (i < steps.length) {
                        LevelNode node = ResourceHelper.getLevelNodeFromTree(steps[i], lineNum);
                        if (node != null) {
                            return node;
                        }
                        ++i;
                    }
                    return levelNode;
                }
                return levelNode;
            }
        }
        return null;
    }

    public static IDocument getDocFromName(String moduleName) {
        IFile module = (IFile)ResourceHelper.getResourceByModuleName(moduleName);
        return ResourceHelper.getDocFromFile(module);
    }

    public static IDocument getDocFromFile(IFile file) {
        FileDocumentProvider fdp = new FileDocumentProvider();
        FileEditorInput input = new FileEditorInput(file);
        try {
            fdp.connect((Object)input);
            IDocument iDocument = fdp.getDocument((Object)input);
            return iDocument;
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error getting document for module " + String.valueOf(file), e);
        }
        finally {
            fdp.disconnect((Object)input);
        }
        return null;
    }

    public static long getSizeOfJavaFileResource(IResource resource) {
        if (resource == null) {
            return 0L;
        }
        IPath ipath = resource.getLocation();
        if (ipath == null) {
            return 0L;
        }
        File file = ipath.toFile();
        if (file == null) {
            return 0L;
        }
        return ResourceHelper.getDirSize(file);
    }

    private static long getDirSize(File dir) {
        long size = 0L;
        if (dir.isFile()) {
            size = dir.length();
        } else {
            File[] subFiles = dir.listFiles();
            if (subFiles == null) {
                return 0L;
            }
            size += dir.length();
            int i = 0;
            while (i < subFiles.length) {
                File file = subFiles[i];
                size = file.isFile() ? (size += file.length()) : (size += ResourceHelper.getDirSize(file));
                ++i;
            }
        }
        return size;
    }

    public static boolean isFromUserModule(SemanticNode node) {
        SyntaxTreeNode csNode = (SyntaxTreeNode)node.stn;
        String name = ResourceHelper.getModuleFileName(csNode.getFilename());
        return ToolboxHandle.isUserModule(name);
    }

    public static SemanticNode[] getUsesOfSymbol(SymbolNode symbol, SemanticNode module) {
        Vector<SemanticNode> found = new Vector<SemanticNode>(20);
        ResourceHelper.innerGetUsesOfSymbol(symbol, module, found);
        SemanticNode[] value = new SemanticNode[found.size()];
        int i = 0;
        while (i < value.length) {
            value[i] = found.elementAt(i);
            ++i;
        }
        return value;
    }

    private static boolean sourceEquals(SemanticNode node, SymbolNode symbol) {
        if (node == symbol) {
            return true;
        }
        if (node instanceof OpDefNode && ((OpDefNode)node).getSource() == symbol) {
            return true;
        }
        return node instanceof ThmOrAssumpDefNode && ((ThmOrAssumpDefNode)node).getSource() == symbol;
    }

    private static void innerGetUsesOfSymbol(SymbolNode symbol, SemanticNode node, Vector<SemanticNode> found) {
        SemanticNode[] children;
        SymbolNode[] defs = null;
        if (node instanceof OpApplNode) {
            OpApplNode oan = (OpApplNode)node;
            if (ResourceHelper.sourceEquals((SemanticNode)oan.getOperator(), symbol) || oan.subExpressionOf != null && ResourceHelper.sourceEquals((SemanticNode)oan.subExpressionOf, symbol)) {
                found.add(node);
            }
        } else if (node instanceof OpArgNode && ResourceHelper.sourceEquals((SemanticNode)((OpArgNode)node).getOp(), symbol)) {
            found.add(node);
        } else {
            if (node instanceof LeafProofNode) {
                defs = ((LeafProofNode)node).getDefs();
            } else if (node instanceof UseOrHideNode) {
                defs = ((UseOrHideNode)node).defs;
            }
            if (defs != null && defs.length != 0) {
                UniqueString defStr = UniqueString.uniqueStringOf((String)"DEF");
                int defIdx = -1;
                SyntaxTreeNode stn = (SyntaxTreeNode)node.stn;
                if (stn.getKind() == 406) {
                    if (stn.getHeirs().length > 1) {
                        stn = stn.getHeirs()[1];
                    } else {
                        Activator.getDefault().logWarning("Bug in ResourceHelper line 1435");
                    }
                }
                int i = 0;
                while (i < stn.getHeirs().length) {
                    SyntaxTreeNode nd = stn.getHeirs()[i];
                    if (nd.image == defStr) {
                        defIdx = i;
                        break;
                    }
                    ++i;
                }
                if (defIdx != -1) {
                    i = 0;
                    while (i < defs.length) {
                        if (ResourceHelper.sourceEquals((SemanticNode)defs[i], symbol)) {
                            if (defIdx + 2 * i + 1 < stn.getHeirs().length) {
                                found.add((SemanticNode)new NewSymbNode(null, null, (TreeNode)stn.getHeirs()[defIdx + 2 * i + 1]));
                            } else {
                                Activator.getDefault().logWarning("Bug at ResourceHelper line 1471");
                            }
                        }
                        ++i;
                    }
                } else {
                    Activator.getDefault().logWarning("Bug at ResourceHelper line 1477");
                }
            }
        }
        if ((children = node.getChildren()) == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            SemanticNode sn = children[i];
            if (sn != null && node.getLocation().source().equals(sn.getLocation().source())) {
                ResourceHelper.innerGetUsesOfSymbol(symbol, sn, found);
            }
            ++i;
        }
    }

    public static ExprOrOpArgNode[] getUsesOfUserDefinedOps(SemanticNode expr) {
        Vector<ExprOrOpArgNode> found = new Vector<ExprOrOpArgNode>(20);
        ResourceHelper.innerGetUsesOfUserDefinedOps(expr, found);
        ExprOrOpArgNode[] value = new ExprOrOpArgNode[found.size()];
        int i = 0;
        while (i < value.length) {
            value[i] = found.elementAt(i);
            ++i;
        }
        return value;
    }

    private static boolean hasUserDefinedOp(SemanticNode node) {
        SymbolNode sym;
        if (!(node instanceof ExprOrOpArgNode)) {
            return false;
        }
        if (node instanceof OpApplNode) {
            sym = ((OpApplNode)node).getOperator();
        } else if (node instanceof OpArgNode) {
            sym = ((OpArgNode)node).getOp();
        } else {
            return false;
        }
        if (!(sym instanceof OpDefNode)) {
            return false;
        }
        OpDefNode op = (OpDefNode)sym;
        return op.getKind() == 5;
    }

    private static void innerGetUsesOfUserDefinedOps(SemanticNode node, Vector<ExprOrOpArgNode> found) {
        SemanticNode[] children;
        if (ResourceHelper.hasUserDefinedOp(node)) {
            found.add((ExprOrOpArgNode)node);
        }
        if ((children = node.getChildren()) == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            SemanticNode sn = children[i];
            if (sn != null && node.getLocation().source().equals(sn.getLocation().source())) {
                ResourceHelper.innerGetUsesOfUserDefinedOps(sn, found);
            }
            ++i;
        }
    }

    public static String[] getModuleNames() {
        Spec spec = ToolboxHandle.getCurrentSpec();
        if (spec == null) {
            return null;
        }
        String rootFileName = spec.getRootFilename();
        if (rootFileName == null) {
            return null;
        }
        String rootModuleName = SpecWriterUtilities.getModuleNameChecked((String)rootFileName, (boolean)false);
        if (rootModuleName == null) {
            return null;
        }
        ParserDependencyStorage pds = Activator.getModuleDependencyStorage();
        if (pds == null) {
            return null;
        }
        List listOfImportedModules = pds.getListOfExtendedModules(rootModuleName + ".tla");
        Object[] value = new String[listOfImportedModules.size() + 1];
        int i = 0;
        while (i < listOfImportedModules.size()) {
            String element = (String)listOfImportedModules.get(i);
            value[i] = element.substring(0, element.length() - 4);
            ++i;
        }
        value[listOfImportedModules.size()] = rootModuleName;
        Arrays.sort(value);
        return value;
    }

    public static HashSet<String> declaredSymbolsInScope(ModuleNode module, Location loc) {
        HashSet<String> result = new HashSet<String>();
        ResourceHelper.addDeclaredSymbolsInScope(result, module, loc);
        return result;
    }

    public static void addDeclaredSymbolsInScope(HashSet<String> result, ModuleNode module, Location loc) {
        HashSet extendees = module.getExtendedModuleSet();
        extendees.add(module);
        for (ModuleNode modNode : extendees) {
            OpDeclNode[] decls = modNode.getConstantDecls();
            int i = 0;
            while (i < decls.length) {
                if (modNode != module || ResourceHelper.earlierLine(decls[i].stn.getLocation(), loc)) {
                    result.add(decls[i].getName().toString());
                }
                ++i;
            }
            decls = modNode.getVariableDecls();
            i = 0;
            while (i < decls.length) {
                if (modNode != module || ResourceHelper.earlierLine(decls[i].stn.getLocation(), loc)) {
                    result.add(decls[i].getName().toString());
                }
                ++i;
            }
        }
        HashSet<ModuleNode> allModulesSet = new HashSet<ModuleNode>();
        ResourceHelper.addImportedModules(allModulesSet, result, loc, module);
        for (ModuleNode modNode : allModulesSet) {
            OpDefNode[] decls = modNode.getOpDefs();
            int i = 0;
            while (i < decls.length) {
                if (modNode != module || ResourceHelper.earlierLine(decls[i].stn.getLocation(), loc)) {
                    result.add(decls[i].getName().toString());
                }
                ++i;
            }
            ThmOrAssumpDefNode[] tdecls = module.getThmOrAssDefs();
            int i2 = 0;
            while (i2 < tdecls.length) {
                if (modNode != module || ResourceHelper.earlierLine(tdecls[i2].stn.getLocation(), loc)) {
                    result.add(tdecls[i2].getName().toString());
                }
                ++i2;
            }
        }
    }

    public static void addImportedModules(HashSet<ModuleNode> modules, HashSet<String> symbols, Location loc, ModuleNode node) {
        if (modules.contains(node)) {
            return;
        }
        modules.add(node);
        HashSet extendees = node.getExtendedModuleSet();
        for (ModuleNode modNode : extendees) {
            ResourceHelper.addImportedModules(modules, symbols, infiniteLoc, modNode);
        }
        InstanceNode[] instances = node.getInstances();
        int i = 0;
        while (i < instances.length) {
            if (ResourceHelper.earlierLine(instances[i].stn.getLocation(), loc) && (!instances[i].getLocal() || ResourceHelper.earlierLine(loc, infiniteLoc))) {
                if (instances[i].getName() != null) {
                    symbols.add(instances[i].getName().toString());
                } else {
                    ResourceHelper.addImportedModules(modules, symbols, infiniteLoc, instances[i].getModule());
                }
            }
            ++i;
        }
    }

    public static StringSet declaredSymbolsInScopeSet(ModuleNode module, Location loc) {
        StringSet result = new StringSet();
        ResourceHelper.addDeclaredSymbolsInScopeSet(result, module, loc);
        return result;
    }

    public static void addDeclaredSymbolsInScopeSet(StringSet result, ModuleNode module, Location loc) {
        HashSet extendees = module.getExtendedModuleSet();
        extendees.add(module);
        for (ModuleNode modNode : extendees) {
            OpDeclNode[] decls = modNode.getConstantDecls();
            int i = 0;
            while (i < decls.length) {
                if (modNode != module || ResourceHelper.earlierLine(decls[i].stn.getLocation(), loc)) {
                    result.add(decls[i].getName().toString());
                }
                ++i;
            }
            decls = modNode.getVariableDecls();
            i = 0;
            while (i < decls.length) {
                if (modNode != module || ResourceHelper.earlierLine(decls[i].stn.getLocation(), loc)) {
                    result.add(decls[i].getName().toString());
                }
                ++i;
            }
        }
        HashSet<ModuleNode> allModulesSet = new HashSet<ModuleNode>();
        ResourceHelper.addImportedModulesSet(allModulesSet, result, loc, module);
        for (ModuleNode modNode : allModulesSet) {
            OpDefNode[] decls = modNode.getOpDefs();
            int i = 0;
            while (i < decls.length) {
                if (modNode != module || ResourceHelper.earlierLine(decls[i].stn.getLocation(), loc)) {
                    result.add(decls[i].getName().toString());
                }
                ++i;
            }
            ThmOrAssumpDefNode[] tdecls = module.getThmOrAssDefs();
            int i2 = 0;
            while (i2 < tdecls.length) {
                if (modNode != module || ResourceHelper.earlierLine(tdecls[i2].stn.getLocation(), loc)) {
                    result.add(tdecls[i2].getName().toString());
                }
                ++i2;
            }
        }
    }

    public static void addImportedModulesSet(HashSet<ModuleNode> modules, StringSet symbols, Location loc, ModuleNode node) {
        if (modules.contains(node)) {
            return;
        }
        modules.add(node);
        HashSet extendees = node.getExtendedModuleSet();
        for (ModuleNode modNode : extendees) {
            ResourceHelper.addImportedModulesSet(modules, symbols, infiniteLoc, modNode);
        }
        InstanceNode[] instances = node.getInstances();
        int i = 0;
        while (i < instances.length) {
            if (ResourceHelper.earlierLine(instances[i].stn.getLocation(), loc) && (!instances[i].getLocal() || ResourceHelper.earlierLine(loc, infiniteLoc))) {
                if (instances[i].getName() != null) {
                    symbols.add(instances[i].getName().toString());
                } else {
                    ResourceHelper.addImportedModulesSet(modules, symbols, infiniteLoc, instances[i].getModule());
                }
            }
            ++i;
        }
    }

    private static boolean earlierLine(Location loc1, Location loc2) {
        return loc1.beginLine() < loc2.beginLine();
    }

    public static FormalParamNode[] getBoundIdentifiers(ExprNode expr) {
        Vector<FormalParamNode> vec = new Vector<FormalParamNode>();
        ResourceHelper.innerGetBoundIdentifiers(vec, expr);
        FormalParamNode[] result = new FormalParamNode[vec.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = vec.elementAt(i);
            ++i;
        }
        return result;
    }

    private static void innerGetBoundIdentifiers(Vector<FormalParamNode> vec, ExprNode expr) {
        if (expr instanceof OpApplNode) {
            int i;
            OpApplNode node = (OpApplNode)expr;
            if (node.getUnbdedQuantSymbols() != null) {
                i = 0;
                while (i < node.getUnbdedQuantSymbols().length) {
                    vec.add(node.getUnbdedQuantSymbols()[i]);
                    ++i;
                }
            }
            if (node.getBdedQuantSymbolLists() != null) {
                i = 0;
                while (i < node.getBdedQuantSymbolLists().length) {
                    FormalParamNode[] nodeList = node.getBdedQuantSymbolLists()[i];
                    int j = 0;
                    while (j < nodeList.length) {
                        vec.add(nodeList[j]);
                        ++j;
                    }
                    ResourceHelper.innerGetBoundIdentifiers(vec, node.getBdedQuantBounds()[i]);
                    ++i;
                }
            }
            i = 0;
            while (i < node.getArgs().length) {
                if (node.getArgs()[i] instanceof ExprNode) {
                    ResourceHelper.innerGetBoundIdentifiers(vec, (ExprNode)node.getArgs()[i]);
                }
                ++i;
            }
        } else if (expr instanceof LetInNode) {
            int i = 0;
            LetInNode node = (LetInNode)expr;
            if (i < node.getLets().length) {
                OpDefNode def = node.getLets()[i];
                int j = 0;
                while (j < def.getParams().length) {
                    vec.add(def.getParams()[j]);
                    ++j;
                }
                ResourceHelper.innerGetBoundIdentifiers(vec, node.getBody());
                return;
            }
        } else {
            return;
        }
    }

    public static boolean isValidSpecName(String aSpecName) {
        String identifier = ResourceHelper.getIdentifier(aSpecName);
        return aSpecName.equals(identifier);
    }

    public static String getIdentifier(String aSpecName) {
        ByteArrayInputStream stream = new ByteArrayInputStream(aSpecName.getBytes());
        TLAplusParser tlaParser = new TLAplusParser((InputStream)stream);
        tlaParser.token_source.SwitchTo(2);
        try {
            return tlaParser.Identifier().getImage();
        }
        catch (ParseException e) {
            return "";
        }
    }

    public static boolean isValidLibraryLocation(String location) {
        if (location != null && location.length() > 0) {
            Path path = new Path(location);
            File directoryOrArchive = path.toFile();
            return directoryOrArchive.exists();
        }
        return false;
    }

    public static TLAtoPCalMapping readTLAtoPCalMapping(IProject project, String filename) {
        IFile file = project.getFile(filename + PMAP_SUFFIX);
        if (file.exists()) {
            try {
                ObjectInputStream inputStream = new ObjectInputStream(new FileInputStream(file.getLocation().toOSString()));
                Object object = inputStream.readObject();
                inputStream.close();
                if (object instanceof TLAtoPCalMapping) {
                    return (TLAtoPCalMapping)object;
                }
            }
            catch (InvalidClassException e) {
                String error = "The TLA+ to PCal mapping file " + filename + ".pmap has likely been generated with an older version of the TLA+ Toolbox. Please (re)move the old file out of the way and retranslate your PCal algorithm again.\nIf you do not retranslate TLA+ to PCal mapping will not work.\n(If moving the file does not fix this error, then please report a bug).";
                Activator.getDefault().logInfo(error);
                Activator.getDefault().logDebug(error, e);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean writeTLAtoPCalMapping(IProject project, String filename, TLAtoPCalMapping mapping, IProgressMonitor monitor) {
        IFile file = project.getFile(filename + PMAP_SUFFIX);
        try {
            ObjectOutputStream outputStream = new ObjectOutputStream(new FileOutputStream(file.getLocation().toOSString()));
            outputStream.writeObject(mapping);
            outputStream.close();
            monitor.worked(1);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean isLinkedFile(IProject project, String name) throws CoreException {
        IFile file = project.getFile((IPath)new Path(new Path(name).lastSegment()));
        return file.isLinked(512);
    }

    public static boolean isProjectParent(IPath aFileName, IProject project) {
        return aFileName.equals((Object)project.getLocation().removeLastSegments(1));
    }

    public static class ErrorMessageRunnable
    implements Runnable {
        String title;
        String message;

        public ErrorMessageRunnable(String tit, String msg) {
            this.title = tit;
            this.message = msg;
        }

        @Override
        public void run() {
            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)this.title, (String)this.message);
        }
    }
}

