/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.util.UIHelper;

public abstract class SaveDirtyEditorAbstractHandler
extends AbstractHandler {
    protected IEditorPart activeEditor;

    public boolean saveDirtyEditor(ExecutionEvent event) {
        this.activeEditor = UIHelper.getActiveEditor();
        if (this.activeEditor.isDirty()) {
            this.getPrefs().setDefault(String.valueOf(((Object)((Object)this)).getClass()) + ".dontBother", false);
            if (this.getPrefs().getBoolean(String.valueOf(((Object)((Object)this)).getClass()) + ".dontBother")) {
                this.activeEditor.doSave((IProgressMonitor)new NullProgressMonitor());
            } else {
                Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                SaveMessageDialog dialog = new SaveMessageDialog(shell, this.getDialogTitle(), this.getDialogMessage());
                int res = dialog.open();
                if (res == 2) {
                    this.getPrefs().setValue(String.valueOf(((Object)((Object)this)).getClass()) + ".dontBother", true);
                    res = 0;
                }
                if (res == 0 || res == 5) {
                    this.activeEditor.doSave((IProgressMonitor)new NullProgressMonitor());
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    private IPreferenceStore getPrefs() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected String getDialogMessage() {
        return "The current editor has not been saved, should the editor be saved first?";
    }

    protected String getDialogTitle() {
        return "Save " + this.activeEditor.getTitle() + " editor?";
    }

    public boolean isEnabled() {
        if (UIHelper.getActiveEditor() == null) {
            return false;
        }
        return super.isEnabled();
    }

    private class SaveMessageDialog
    extends MessageDialog {
        public SaveMessageDialog(Shell parentShell, String dialogTitle, String dialogMessage) {
            super(parentShell, dialogTitle, null, dialogMessage, 3, new String[]{"&Save", "&Cancel", "Save and &never ask again"}, 0);
        }
    }
}

