/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.parser.ModuleParserLauncher;
import org.lamport.tla.toolbox.spec.parser.ParseResult;
import org.lamport.tla.toolbox.tool.IParseResult;
import org.lamport.tla.toolbox.util.pref.PreferenceStoreHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import tla2sany.modanalyzer.SpecObj;

public class ToolboxHandle {
    public static String I_RESTORE_LAST_SPEC = "restoreLastSpec";

    public static IFile getRootModule() {
        return Activator.getSpecManager().getSpecLoaded() == null ? null : Activator.getSpecManager().getSpecLoaded().getRootFile();
    }

    public static IResource getRootModule(IProject project) {
        return PreferenceStoreHelper.readProjectRootFile(project);
    }

    public static IPreferenceStore getInstanceStore() {
        return PreferenceStoreHelper.getInstancePreferenceStore();
    }

    public static SpecObj getSpecObj() {
        Spec spec = null;
        try {
            spec = Activator.getSpecManager().getSpecLoaded();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (spec != null) {
            return spec.getValidRootModule();
        }
        return null;
    }

    public static Spec getSpecByName(String name) {
        return Activator.getSpecManager().getSpecByName(name);
    }

    public static Spec getCurrentSpec() {
        return Activator.getSpecManager().getSpecLoaded();
    }

    public static boolean isUserModule(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return Activator.getModuleDependencyStorage().hasModule(name);
    }

    public static List<String> getExtendedModules(String moduleName) {
        return Activator.getModuleDependencyStorage().getListOfExtendedModules(moduleName);
    }

    public static IPath getTLAToolsClasspath() {
        Bundle bundle = null;
        Bundle[] bundles = Activator.getDefault().getBundle().getBundleContext().getBundles();
        int i = 0;
        while (i < bundles.length) {
            Bundle aBundle = bundles[i];
            if ("org.lamport.tlatools".equals(aBundle.getSymbolicName())) {
                Version otherVersion;
                Version version = otherVersion = bundle != null ? bundle.getVersion() : Version.parseVersion((String)"0.0.0");
                if (aBundle.getVersion().compareTo(otherVersion) > 0) {
                    bundle = aBundle;
                }
            }
            ++i;
        }
        if (bundle == null) {
            return null;
        }
        URL local = null;
        try {
            local = FileLocator.toFileURL((URL)bundle.getEntry("/"));
        }
        catch (IOException e) {
            return null;
        }
        String fullPath = new File(local.getPath()).getAbsolutePath();
        return Path.fromOSString((String)fullPath);
    }

    public static IParseResult parseModule(IResource resource, IProgressMonitor monitor, boolean installMarkers, boolean updateDependencies) {
        ModuleParserLauncher moduleParser = new ModuleParserLauncher();
        ParseResult result = moduleParser.parseModule(resource, monitor, installMarkers, updateDependencies);
        return result;
    }
}

