/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.spec.parser;

import java.util.List;
import java.util.Vector;
import org.lamport.tla.toolbox.spec.parser.DoubleHashedTable;

public class ParserDependencyStorage {
    private DoubleHashedTable moduleStore = null;

    public ParserDependencyStorage() {
        this.initialize();
    }

    public void initialize() {
        this.moduleStore = new DoubleHashedTable(101);
    }

    public boolean hasModule(String moduleName) {
        return this.moduleStore.containsKey(moduleName) || this.moduleStore.containsValue(moduleName);
    }

    public List put(String parsedModule, List listOfParsedModules) {
        if (parsedModule == null || listOfParsedModules == null) {
            return new Vector(0);
        }
        List oldValues = this.parseFailed(parsedModule);
        this.moduleStore.put(parsedModule, listOfParsedModules);
        return oldValues;
    }

    public List parseFailed(String parseModule) {
        return this.moduleStore.removeKey(parseModule);
    }

    public List getListOfModulesToReparse(String changedModule) {
        Vector dependantModules = (Vector)this.moduleStore.getKeys(changedModule);
        if (dependantModules == null) {
            dependantModules = new Vector();
        }
        return dependantModules;
    }

    public List getListOfExtendedModules(String rootModule) {
        Vector dependantModules = null;
        if (rootModule == null) {
            dependantModules = new Vector();
            return dependantModules;
        }
        dependantModules = (Vector)this.moduleStore.getValues(rootModule);
        if (dependantModules == null) {
            dependantModules = new Vector();
        }
        return dependantModules;
    }
}

