/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.util.AdapterFactory;
import org.lamport.tla.toolbox.util.TLAMarkerHelper;
import org.lamport.tla.toolbox.util.UIHelper;
import org.lamport.tla.toolbox.util.compare.MarkerComparator;

public class ProblemView
extends ViewPart {
    public static final String ID = "toolbox.view.ProblemView";
    private ExpandBar bar = null;

    public void createPartControl(Composite parent) {
        this.bar = new ExpandBar(parent, 2560);
        this.bar.setSpacing(8);
        UIHelper.setHelp((Control)this.bar, "ProblemView");
        this.fillData(Activator.getSpecManager().getSpecLoaded());
    }

    private void fillData(Spec specLoaded) {
        if (specLoaded == null) {
            this.hide();
            return;
        }
        IMarker[] markers = TLAMarkerHelper.getProblemMarkers((IResource)specLoaded.getProject(), null);
        if (markers == null || markers.length == 0) {
            this.hide();
        }
        ArrayList<IMarker> markersList = new ArrayList<IMarker>(Arrays.asList(markers));
        Collections.sort(markersList, new MarkerComparator());
        int iterations = Math.min(markers.length, 20);
        int j = 0;
        while (j < iterations) {
            final IMarker problem = (IMarker)markersList.get(j);
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    TLAMarkerHelper.gotoMarker(problem, (event.stateMask & SWT.MOD1) != 0);
                }
            };
            Composite problemItem = new Composite((Composite)this.bar, 1);
            problemItem.setLayout((Layout)new RowLayout(512));
            problemItem.addListener(3, listener);
            String[] lines = problem.getAttribute("message", "").split("\n");
            int i = 0;
            while (i < lines.length) {
                StyledText styledText = new StyledText(problemItem, 1);
                styledText.setEditable(false);
                styledText.setCursor(styledText.getDisplay().getSystemCursor(21));
                styledText.setText(lines[i]);
                styledText.addListener(3, listener);
                if (this.isErrorLine(lines[i], problem)) {
                    StyleRange range = new StyleRange();
                    range.underline = true;
                    range.foreground = styledText.getDisplay().getSystemColor(3);
                    range.start = 0;
                    range.length = lines[i].length();
                    styledText.setStyleRange(range);
                }
                ++i;
            }
            ExpandItem item = new ExpandItem(this.bar, 0, 0);
            item.setExpanded(true);
            String markerType = TLAMarkerHelper.getType(problem);
            item.setText(AdapterFactory.getMarkerTypeAsText(markerType) + " " + AdapterFactory.getSeverityAsText(problem.getAttribute("severity", 2)));
            item.setHeight(problemItem.computeSize((int)-1, (int)-1).y);
            item.setControl((Control)problemItem);
            item.addListener(3, listener);
            ++j;
        }
    }

    public void hide() {
        UIHelper.runUIAsync(new Runnable(){

            @Override
            public void run() {
                ProblemView.this.getViewSite().getPage().hideView((IViewPart)ProblemView.this);
            }
        });
    }

    private boolean isErrorLine(String line, IMarker marker) {
        return line.indexOf("module " + marker.getAttribute("toolbox.location.modulename", "toolbox.location.modulename")) != -1;
    }

    public void setFocus() {
        this.bar.setFocus();
    }
}

