/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.provider;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Module;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.manager.WorkspaceSpecManager;
import org.lamport.tla.toolbox.ui.provider.IGroup;
import org.lamport.tla.toolbox.util.ResourceHelper;

public class SpecContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final Hashtable<Module, Group> reverseLookup = new Hashtable();

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof WorkspaceSpecManager) {
            return ((WorkspaceSpecManager)parentElement).getRecentlyOpened();
        }
        if (parentElement instanceof Spec) {
            Spec spec = (Spec)parentElement;
            if (Activator.getSpecManager().isSpecLoaded(spec)) {
                Module[] constructModules = this.constructModules(spec);
                Group group = new Group(spec, constructModules);
                int i = 0;
                while (i < constructModules.length) {
                    Module module = constructModules[i];
                    this.reverseLookup.put(module, group);
                    ++i;
                }
                return new Group[]{group};
            }
            return EMPTY_ARRAY;
        }
        if (parentElement instanceof Group) {
            return ((Group)parentElement).getModules();
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof Spec) {
            return Activator.getSpecManager();
        }
        if (element instanceof Group) {
            return Activator.getSpecManager().isSpecLoaded(((Group)element).getSpec());
        }
        if (element instanceof Module) {
            return this.reverseLookup.get(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Spec) {
            return Activator.getSpecManager().isSpecLoaded((Spec)element);
        }
        if (element instanceof Group) {
            Group group = (Group)element;
            if (Activator.getSpecManager().isSpecLoaded(group.getSpec())) {
                return group.getModules().length > 0;
            }
        }
        return element instanceof WorkspaceSpecManager;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.reverseLookup.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected Module[] constructModules(Spec spec) {
        Vector<Module> modules = new Vector<Module>();
        IResource[] moduleResources = spec.getModuleResources();
        int i = 0;
        while (i < moduleResources.length) {
            if (ResourceHelper.isModule(moduleResources[i])) {
                Module module = new Module(moduleResources[i]);
                modules.add(module);
            }
            ++i;
        }
        return modules.toArray(new Module[modules.size()]);
    }

    public static class Group
    implements IGroup {
        private final Module[] modules;
        private final Spec spec;

        public Group(Spec spec, Module[] modules) {
            this.spec = spec;
            this.modules = modules;
        }

        public Spec getSpec() {
            return this.spec;
        }

        public Module[] getModules() {
            return this.modules;
        }

        public String toString() {
            return "modules";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.spec == null ? 0 : this.spec.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Group other = (Group)obj;
            return !(this.spec == null ? other.spec != null : !this.spec.equals(other.spec));
        }
    }
}

