/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.preference;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.nature.ParserHelper;
import org.lamport.tla.toolbox.ui.preference.SWTFactory;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.ToolboxJob;

public class LibraryPathComposite {
    public static final String LIBRARY_PATH_LOCATION_PREFIX = "TLA_LIBRARY_PATH";
    public static final String LOCATION_DELIM = "|";
    public static final String STATE_DELIM = "*";
    public static final String ESCAPE_REGEX = "\\";
    private final LinkedList<String> fLocationList = new LinkedList();
    private final PreferencePage preferencePage;
    private CheckboxTableViewer fTableViewer;
    private Button moveUpButton;
    private Button moveDownButton;

    public LibraryPathComposite(PreferencePage preferencePage) {
        this.preferencePage = preferencePage;
        Composite parent = (Composite)preferencePage.getControl();
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 768, 0, 0);
        SWTFactory.createWrapLabel(comp, "Add, remove or edit TLA+ library path locations. Unchecked locations will not be used, order reflects in the search order (Spec specific library path locations replace the general library path locations).", 2, 250);
        SWTFactory.createVerticalSpacer(comp, 1);
        SWTFactory.createWrapLabel(comp, "&TLA+ library path locations:", 2);
        Table table = new Table(comp, 68130);
        table.setLayoutData((Object)new GridData(1808));
        GridData gd = (GridData)table.getLayoutData();
        gd.widthHint = 250;
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.stateMask == 0 && e.keyCode == 127) {
                    LibraryPathComposite.this.removeLocation();
                }
            }
        });
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TableColumnLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite bcomp = SWTFactory.createComposite(comp, 1, 1, 1042, 0, 0);
        this.moveUpButton = SWTFactory.createPushButton(bcomp, "&Move up", null);
        this.moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryPathComposite.this.move(true);
            }
        });
        this.moveDownButton = SWTFactory.createPushButton(bcomp, "Mo&ve down", null);
        this.moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryPathComposite.this.move(false);
            }
        });
        SWTFactory.createHorizontalSpacer(bcomp, 1);
        Button button = SWTFactory.createPushButton(bcomp, "Add Dire&ctory...", null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String loc = LibraryPathComposite.this.getDirectory(null);
                if (loc != null) {
                    LibraryPathComposite.this.addLocation(loc);
                }
            }
        });
        button = SWTFactory.createPushButton(bcomp, "Add Archive &File...", null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String loc = LibraryPathComposite.this.getZipArchiveFile(null);
                if (loc != null) {
                    LibraryPathComposite.this.addLocation(loc);
                }
            }
        });
        final Button editbutton = SWTFactory.createPushButton(bcomp, "&Edit Location...", null);
        editbutton.setEnabled(false);
        editbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryPathComposite.this.edit();
            }
        });
        final Button remove = SWTFactory.createPushButton(bcomp, "&Remove", null);
        remove.setEnabled(false);
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryPathComposite.this.removeLocation();
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)LibraryPathComposite.this.fTableViewer.getSelection();
                remove.setEnabled(!selection.isEmpty());
                editbutton.setEnabled(selection.size() == 1);
                LibraryPathComposite.this.updateEnablementMoveButtons(selection);
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LibraryPathComposite.this.edit();
            }
        });
        this.performInit();
        Dialog.applyDialogFont((Control)comp);
    }

    private void updateEnablementMoveButtons(IStructuredSelection selection) {
        this.moveUpButton.setEnabled(this.fLocationList.indexOf(selection.getFirstElement()) != 0);
        this.moveDownButton.setEnabled(this.fLocationList.indexOf(selection.getFirstElement()) != this.fLocationList.size() - 1);
    }

    public void applyChanges() {
        Spec spec;
        StringBuffer locations = new StringBuffer();
        for (Object e : this.fLocationList) {
            locations.append(e);
            locations.append(STATE_DELIM);
            locations.append(this.fTableViewer.getChecked(e));
            locations.append(LOCATION_DELIM);
        }
        if (this.hasLocationsChanges(locations.toString()) && (spec = Activator.getSpecManager().getSpecLoaded()) != null) {
            if (MessageDialog.openQuestion((Shell)this.preferencePage.getShell(), (String)"Locations changed", (String)"TLA library path locations have changed. Reparsing is required for the changes to take effect.\nReparse now?")) {
                ToolboxJob toolboxJob = new ToolboxJob(""){

                    protected IStatus run(IProgressMonitor monitor) {
                        ParserHelper.rebuildSpec(monitor);
                        return Status.OK_STATUS;
                    }
                };
                toolboxJob.schedule();
            } else {
                spec.setStatus(-99);
            }
        }
        this.preferencePage.getPreferenceStore().setValue(LIBRARY_PATH_LOCATION_PREFIX, locations.toString());
    }

    private boolean hasLocationsChanges(String newLocations) {
        Object[] newCheckedLocations;
        int i;
        String oldLocations = this.preferencePage.getPreferenceStore().getString(LIBRARY_PATH_LOCATION_PREFIX);
        if (oldLocations != null && oldLocations.equalsIgnoreCase(newLocations)) {
            return false;
        }
        ArrayList<String> oldCheckedElements = new ArrayList<String>();
        if (oldLocations != null && oldLocations.length() > 0) {
            String[] locations = oldLocations.split("\\|");
            i = 0;
            while (i < locations.length) {
                String[] values = locations[i].split("\\*");
                if (Boolean.valueOf(values[1]).booleanValue()) {
                    oldCheckedElements.add(values[0]);
                }
                ++i;
            }
        }
        if ((newCheckedLocations = this.fTableViewer.getCheckedElements()).length != oldCheckedElements.size()) {
            return true;
        }
        i = 0;
        while (i < newCheckedLocations.length) {
            if (!oldCheckedElements.contains(newCheckedLocations[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void performInit() {
        this.fLocationList.clear();
        String location = this.preferencePage.getPreferenceStore().getString(LIBRARY_PATH_LOCATION_PREFIX);
        ArrayList<String> checkedLocations = new ArrayList<String>();
        if (location != null && location.length() > 0) {
            String[] locations = location.split("\\|");
            int i = 0;
            while (i < locations.length) {
                String[] values = locations[i].split("\\*");
                this.fLocationList.add(values[0]);
                if (Boolean.valueOf(values[1]).booleanValue()) {
                    checkedLocations.add(values[0]);
                }
                ++i;
            }
            this.fLocationList.remove("");
        }
        this.fTableViewer.setInput(this.fLocationList);
        this.fTableViewer.setCheckedElements((Object[])checkedLocations.toArray(new String[checkedLocations.size()]));
        this.fTableViewer.refresh();
        this.preferencePage.setErrorMessage(null);
    }

    private void validateLocations() {
        if (this.fLocationList.size() > 0) {
            String loc2 = null;
            for (String loc2 : this.fLocationList) {
                if (ResourceHelper.isValidLibraryLocation(loc2)) continue;
                this.preferencePage.setErrorMessage("{0} is not a valid library path location");
                this.preferencePage.setValid(false);
                return;
            }
        }
        this.preferencePage.setValid(true);
        this.preferencePage.setErrorMessage(null);
    }

    void move(boolean moveUp) {
        ISelection selection = this.fTableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            String selected = (String)ss.getFirstElement();
            int index = this.fLocationList.indexOf(selected);
            if (moveUp && index - 1 >= 0) {
                this.fLocationList.remove(index);
                this.fLocationList.add(index - 1, selected);
                this.fTableViewer.refresh();
                this.updateEnablementMoveButtons(ss);
            } else if (!moveUp && index + 1 < this.fLocationList.size()) {
                this.fLocationList.remove(index);
                this.fLocationList.add(index + 1, selected);
                this.fTableViewer.refresh();
                this.updateEnablementMoveButtons(ss);
            }
        }
    }

    String getDirectory(String prevLocation) {
        String open;
        DirectoryDialog dialog = new DirectoryDialog(this.preferencePage.getShell());
        dialog.setMessage("Select the library path location");
        if (prevLocation != null) {
            dialog.setFilterPath(prevLocation);
        }
        if ((open = dialog.open()) != null) {
            return open + File.separator;
        }
        return null;
    }

    String getZipArchiveFile(String prevLocation) {
        String open;
        FileDialog dialog = new FileDialog(this.preferencePage.getShell());
        dialog.setFilterExtensions(new String[]{"*.jar", "*.zip"});
        if (prevLocation != null) {
            dialog.setFilterPath(prevLocation);
        }
        if ((open = dialog.open()) != null) {
            return open;
        }
        return null;
    }

    void addLocation(String location) {
        if (this.fLocationList.contains(location)) {
            return;
        }
        this.fLocationList.add(location);
        this.fTableViewer.refresh();
        this.fTableViewer.setChecked((Object)location, true);
        this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)location));
        this.validateLocations();
    }

    void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        String location = selection.getFirstElement().toString();
        File file = new File(location);
        String newloc = null;
        newloc = file.isDirectory() ? this.getDirectory(location) : this.getZipArchiveFile(location);
        if (newloc != null) {
            this.fLocationList.remove(location);
            this.addLocation(newloc);
        }
    }

    void removeLocation() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        this.fLocationList.removeAll(selection.toList());
        this.fTableViewer.refresh();
        this.validateLocations();
    }

    class TableColumnLabelProvider
    extends ColumnLabelProvider {
        Image archive = null;

        TableColumnLabelProvider() {
        }

        public void dispose() {
            if (this.archive != null) {
                this.archive.dispose();
            }
            super.dispose();
        }

        public Image getImage(Object element) {
            File file = new File(element.toString());
            if (file.isDirectory()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            if (this.archive == null) {
                ImageDescriptor image = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(file.getName());
                this.archive = image.createImage();
            }
            return this.archive;
        }
    }
}

