/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.util;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Module;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.util.ResourceHelper;
import pcal.TLAtoPCalMapping;
import tla2sany.st.Location;

public class AdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] CLASSES = new Class[]{IWorkbenchAdapter.class, IResource.class};

    public Class<?>[] getAdapterList() {
        return CLASSES;
    }

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adapterType == IWorkbenchAdapter.class && adaptableObject instanceof Spec) {
            return (T)((Object)new SpecWorkbenchAdapter());
        }
        if (IResource.class.equals(adapterType) && adaptableObject instanceof Module) {
            return (T)((Module)adaptableObject).getResource();
        }
        if (IResource.class.equals(adapterType) && adaptableObject instanceof Spec) {
            return (T)((Spec)adaptableObject).getRootFile();
        }
        return null;
    }

    public static String getFormattedLocation(int[] coordinates, String moduleName) {
        return "from line " + coordinates[0] + ", column " + coordinates[1] + " to line " + coordinates[2] + ", column " + coordinates[3] + " of module " + moduleName;
    }

    public static IRegion locationToRegion(IDocument document, Location location) throws BadLocationException {
        int offset = document.getLineOffset(location.beginLine() - 1) + location.beginColumn() - 1;
        int length = document.getLineOffset(location.endLine() - 1) + location.endColumn() - offset;
        return new Region(offset, length);
    }

    public static IRegion locationToRegion(Location location) {
        IFile module = (IFile)ResourceHelper.getResourceByModuleName(location.source());
        if (module != null && module instanceof IFile && module.exists()) {
            try {
                return AdapterFactory.locationToRegion(ResourceHelper.getDocFromFile(module), location);
            }
            catch (BadLocationException e) {
                Activator.getDefault().logError("Error converting location to region for location " + String.valueOf(location), e);
            }
        }
        return null;
    }

    public static String getStatusAsString(int status) {
        switch (status) {
            case -5: {
                return " module not found ";
            }
            case 0: {
                return " parsed ";
            }
            case -1: {
                return " error ";
            }
            case -4: 
            case -3: 
            case -2: {
                return " error ";
            }
            case -99: {
                return " unparsed ";
            }
        }
        return " unknown " + status;
    }

    public static String getStatusAsString(Spec spec) {
        if (spec != null) {
            return AdapterFactory.getStatusAsString(spec.getStatus());
        }
        return " no spec ";
    }

    public static int getStatusAsSWTBGColor(Spec spec) {
        if (spec != null) {
            switch (spec.getStatus()) {
                case 0: {
                    return 5;
                }
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: {
                    return 4;
                }
                case -99: {
                    return 7;
                }
            }
            return 15;
        }
        return 15;
    }

    public static int getStatusAsSWTFGColor(Spec spec) {
        if (spec != null) {
            switch (spec.getStatus()) {
                case 0: {
                    return 2;
                }
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: {
                    return 1;
                }
                case -99: {
                    return 2;
                }
            }
            return 2;
        }
        return 2;
    }

    public static boolean isProblemStatus(int parseStatus) {
        switch (parseStatus) {
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                return true;
            }
            case -100: 
            case -99: 
            case 0: {
                return false;
            }
        }
        return false;
    }

    public static boolean hasProblemStatus(Spec spec) {
        if (spec != null) {
            return AdapterFactory.isProblemStatus(spec.getStatus());
        }
        return false;
    }

    public static String getSeverityAsText(int severity) {
        switch (severity) {
            case 2: {
                return "Error";
            }
            case 1: {
                return "Warning";
            }
        }
        return "Info";
    }

    public static String getMarkerTypeAsText(String markerType) {
        if (markerType == null || "".equals(markerType)) {
            return "";
        }
        if ("toolbox.markers.ToolboxProblemMarker".equals(markerType)) {
            return "TLA+ Toolbox";
        }
        if ("toolbox.markers.PCalTranslatorProblemMarker".equals(markerType)) {
            return "PCal Translator";
        }
        if ("toolbox.markers.TLAParserProblemMarker".equals(markerType)) {
            return "TLA+ Parser";
        }
        return "";
    }

    public static List<String> adaptModules(String name, List<Module> userModules) {
        Vector<String> dependents = new Vector<String>(userModules.size());
        int i = 0;
        while (i < userModules.size()) {
            Module module = userModules.get(i);
            if (!module.getFile().getName().equals(name)) {
                dependents.add(module.getFile().getName());
            }
            ++i;
        }
        return dependents;
    }

    public static pcal.Region jumptToPCal(TLAtoPCalMapping mapping, Location location, IDocument document) throws BadLocationException {
        int beginAlgorithmLine = AdapterFactory.GetLineOfPCalAlgorithm(document);
        if (beginAlgorithmLine == -1) {
            throw new BadLocationException("The algorithm is no longer in the module.");
        }
        pcal.Region tlaRegion = location.toRegion();
        return mapping.mapTLAtoPCalRegion(tlaRegion, beginAlgorithmLine);
    }

    public static int GetLineOfPCalAlgorithm(IDocument document) {
        try {
            String moduleAsString = document.get();
            return AdapterFactory.LocationToLine(document, TLAtoPCalMapping.GetLineOfPCalAlgorithm((String)moduleAsString));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int GetLineOfPCalAlgorithm(IFile module) {
        return AdapterFactory.GetLineOfPCalAlgorithm(ResourceHelper.getDocFromFile(module));
    }

    private static int LocationToLine(IDocument document, int location) throws BadLocationException {
        if (location == -1) {
            return -1;
        }
        return document.getLineOfOffset(location);
    }

    class SpecWorkbenchAdapter
    extends WorkbenchAdapter {
        SpecWorkbenchAdapter() {
        }

        public String getLabel(Object object) {
            Spec spec = (Spec)object;
            return spec == null ? "" : spec.getName();
        }
    }
}

