/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.view;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class PDFBrowserEditor
extends EditorPart {
    public static final String ID = "org.lamport.tla.toolbox.PDFBrowserEditor";
    private Browser browser;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        if (this.browser != null && input instanceof IFileEditorInput) {
            this.setFileInput((IFileEditorInput)input);
        }
    }

    public void createPartControl(Composite parent) {
        Composite body = new Composite(parent, 0);
        body.setLayout((Layout)new FillLayout());
        this.browser = new Browser(body, 0);
        if (this.getEditorInput() instanceof IFileEditorInput) {
            this.setFileInput((IFileEditorInput)this.getEditorInput());
        } else {
            this.browser.setText("<html><body></body></html>");
        }
    }

    private void setFileInput(IFileEditorInput input) {
        this.browser.setUrl(input.getFile().getLocationURI().toASCIIString());
    }

    public void setFocus() {
        this.browser.getParent().setFocus();
    }

    public boolean isDirty() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

