/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.navigator;

import java.util.HashMap;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Module;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.ui.provider.IGroup;
import org.lamport.tla.toolbox.util.UIHelper;

public class ToolboxExplorer
extends CommonNavigator {
    public static final String VIEW_ID = "toolbox.view.ToolboxExplorer";
    public static final String COMMAND_ID = "toolbox.command.cnf.open.delegate";
    public static final int DEFAULT_EXPAND_LEVEL = 2;

    protected Object getInitialInput() {
        return Activator.getSpecManager();
    }

    protected void handleDoubleClick(DoubleClickEvent anEvent) {
        super.handleDoubleClick(anEvent);
        if (anEvent.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)anEvent.getSelection();
            Object firstElement = iss.getFirstElement();
            if (firstElement instanceof Module) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("toolbox.command.module.open.param", ((Module)firstElement).getModuleName());
                UIHelper.runCommand("toolbox.command.module.open", parameters);
            } else if (!(firstElement instanceof IGroup || firstElement instanceof Spec && ((Spec)firstElement).isCurrentSpec())) {
                UIHelper.runCommand(COMMAND_ID, new HashMap<String, String>());
            }
        }
    }

    private static CommonNavigator findCommonNavigator(String navigatorViewId) {
        IViewPart findView;
        IWorkbenchPage page = UIHelper.getActivePage();
        if (page != null && (findView = UIHelper.getActivePage().findView(navigatorViewId)) != null && findView instanceof CommonNavigator) {
            return (CommonNavigator)findView;
        }
        return null;
    }

    public static CommonViewer getViewer() {
        CommonNavigator navigator = ToolboxExplorer.findCommonNavigator(VIEW_ID);
        if (navigator != null) {
            CommonViewer commonViewer = navigator.getCommonViewer();
            commonViewer.setAutoExpandLevel(2);
            return commonViewer;
        }
        return null;
    }

    public static void refresh() {
        CommonViewer instance = ToolboxExplorer.getViewer();
        if (instance != null) {
            instance.refresh();
        }
    }
}

