/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.launch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.lamport.tla.toolbox.spec.Module;
import org.lamport.tla.toolbox.tool.IParseResult;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.TLCActivator;
import org.lamport.tla.toolbox.tool.tlc.job.DistributedTLCJob;
import org.lamport.tla.toolbox.tool.tlc.job.ITLCJobStatus;
import org.lamport.tla.toolbox.tool.tlc.job.TLCJobFactory;
import org.lamport.tla.toolbox.tool.tlc.job.TLCProcessJob;
import org.lamport.tla.toolbox.tool.tlc.launch.IModelConfigurationConstants;
import org.lamport.tla.toolbox.tool.tlc.launch.IModelConfigurationDefaults;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.model.ModelWriter;
import org.lamport.tla.toolbox.tool.tlc.model.TLCSpec;
import org.lamport.tla.toolbox.tool.tlc.output.IProcessOutputSink;
import org.lamport.tla.toolbox.tool.tlc.util.ModelHelper;
import org.lamport.tla.toolbox.ui.handler.ShowHistoryHandler;
import org.lamport.tla.toolbox.util.AdapterFactory;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.TLAMarkerInformationHolder;
import org.lamport.tla.toolbox.util.UIHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import pcal.Validator;
import tla2sany.modanalyzer.ParseUnit;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDeclNode;
import tlc2.TLC;
import tlc2.TLCGlobals;
import tlc2.model.Assignment;
import tlc2.model.Formula;
import tlc2.model.TypedSet;
import tlc2.output.SpecWriterUtilities;
import tlc2.tool.distributed.TLCServer;
import tlc2.util.FP64;
import util.ExecutionStatisticsCollector;

public class TLCModelLaunchDelegate
extends LaunchConfigurationDelegate
implements IModelConfigurationConstants,
IModelConfigurationDefaults {
    public static final String LAUNCH_CONFIGURATION_TYPE = "org.lamport.tla.toolbox.tool.tlc.modelCheck";
    public static final String MODE_MODELCHECK = "modelcheck";
    public static final String MODE_GENERATE = "generate";
    protected MutexRule mutexRule = new MutexRule();
    private Launch launch;
    private static final Set<String> local = new HashSet<String>(Arrays.asList("ad hoc", "off"));

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        this.launch = new Launch(configuration, mode, null);
        return this.launch;
    }

    public boolean preLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        if (!config.exists()) {
            return false;
        }
        AtomicBoolean success = new AtomicBoolean(true);
        int specType = config.getAttribute("modelBehaviorSpecType", 2);
        if (specType != 0 && mode.equals(MODE_MODELCHECK)) {
            Set results;
            Model model = (Model)config.getAdapter(Model.class);
            IFile rootModule = model.getSpec().toSpec().getRootFile();
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (InputStream is = rootModule.getContents();){
                    results = Validator.validate((ParseUnit)model.getSpec().toSpec().getRootModule().getRootParseUnit(), (InputStream)is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                monitor.done();
                throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", e.getMessage()));
            }
            Display d = PlatformUI.getWorkbench().getDisplay();
            if (results.contains(Validator.ValidationResult.TLA_DIVERGENCE_EXISTS) && results.contains(Validator.ValidationResult.PCAL_DIVERGENCE_EXISTS)) {
                d.syncExec(() -> {
                    MessageDialog md = new MessageDialog(d.getActiveShell(), "The PlusCal algorithm and its translation have been modified after the last translation.", null, String.format("The PlusCal algorithm and its translation in module %s have been modified since the last translation (chksums mismatch).\n\nTo permanently disable this warning, change the conjuncts on the \\* BEGIN TRANSLATION line to:\n\n\t\tchksum(pcal) \\in STRING /\\ chksum(tla) \\in STRING\n\nWould you like to abort model-checking?", model.getSpec().getRootModuleName()), 4, new String[]{"&Abort Model-Checking", "Continue &Model-Checking", "Abort && Show Spec &History"}, 0);
                    int open = md.open();
                    if (open != 1) {
                        success.set(false);
                        if (open == 2) {
                            Module m = new Module((IResource)model.getSpec().getRootFile());
                            ShowHistoryHandler.openHistoryForModule((Module)m);
                        }
                    }
                });
            } else if (results.contains(Validator.ValidationResult.TLA_DIVERGENCE_EXISTS)) {
                d.syncExec(() -> {
                    MessageDialog md = new MessageDialog(d.getActiveShell(), "The TLA+ translation has been modified after the last translation.", null, String.format("The TLA+ translation in module %s has changed since its last translation (chksum(tla) mismatch).\n\nTo permanently disable this warning, change the second conjunct on the \\* BEGIN TRANSLATION line to:\n\n\t\tchksum(tla) \\in STRING\n\nWould you like to abort model-checking?", model.getSpec().getRootModuleName()), 2, new String[]{"&Abort Model-Checking", "Continue &Model-Checking", "Abort && Show Spec &History"}, 1);
                    int open = md.open();
                    if (open != 1) {
                        success.set(false);
                        if (open == 2) {
                            Module m = new Module((IResource)model.getSpec().getRootFile());
                            ShowHistoryHandler.openHistoryForModule((Module)m);
                        }
                    }
                });
            } else if (results.contains(Validator.ValidationResult.PCAL_DIVERGENCE_EXISTS)) {
                d.syncExec(() -> {
                    MessageDialog md = new MessageDialog(d.getActiveShell(), "PlusCal algorithm has changed but not re-translated", null, String.format("The PlusCal algorithm in module %s has changed since its last translation (chksum(pcal) mismatch).\n\nTo permanently disable this warning, change the first conjunct on the \\* BEGIN TRANSLATION line to:\n\n\t\tchksum(pcal) \\in STRING\n\nWould you like to abort model-checking?", model.getSpec().getRootModuleName()), 4, new String[]{"&Abort Model-Checking", "Continue &Model-Checking", "Abort && Show Spec &History"}, 0);
                    int open = md.open();
                    if (open != 1) {
                        success.set(false);
                        if (open == 2) {
                            Module m = new Module((IResource)model.getSpec().getRootFile());
                            ShowHistoryHandler.openHistoryForModule((Module)m);
                        }
                    }
                });
            } else if (results.contains(Validator.ValidationResult.ERROR_ENCOUNTERED)) {
                d.syncExec(() -> {
                    MessageDialogWithToggle.openWarning((Shell)d.getActiveShell(), (String)"Error encountered", (String)"Something went wrong attempting to detect divergence between PlusCal and its translation, continue anyway?");
                    success.set(false);
                });
            }
        }
        try {
            monitor.beginTask("Reading model parameters", 1);
        }
        finally {
            monitor.done();
        }
        return success.get();
    }

    public boolean buildForLaunch(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        Model model = (Model)config.getAdapter(Model.class);
        int STEP = 100;
        try {
            boolean hasSpec;
            monitor.beginTask("Creating model", 30);
            monitor.subTask("Creating directories");
            TLCSpec spec = model.getSpec();
            IProject project = spec.getProject();
            if (project == null) {
                throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error accessing the spec project " + spec.getName()));
            }
            IFile specRootFile = spec.getRootFile();
            if (specRootFile == null) {
                throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error accessing the root module " + spec.getRootFilename()));
            }
            IFolder modelFolder = model.getFolder();
            IPath targetFolderPath = modelFolder.getProjectRelativePath().addTrailingSeparator();
            IFile tlaFile = project.getFile(targetFolderPath.append("MC.tla"));
            IFile cfgFile = project.getFile(targetFolderPath.append("MC.cfg"));
            IFile outFile = project.getFile(targetFolderPath.append("MC.out"));
            IFile[] files = new IFile[]{tlaFile, cfgFile, outFile};
            if (modelFolder.exists()) {
                IResource[] members = modelFolder.members();
                if (members.length == 0) {
                    monitor.worked(STEP);
                } else {
                    boolean recover = config.getAttribute("recover", false);
                    IResource[] checkpoints = ((Model)config.getAdapter(Model.class)).getCheckpoints(false);
                    boolean checkFiles = recover;
                    monitor.beginTask("Deleting files", members.length);
                    int i = 0;
                    while (i < members.length) {
                        if (checkFiles) {
                            if (checkpoints.length > 0 && checkpoints[0].equals((Object)members[i])) {
                                checkFiles = false;
                            }
                        } else {
                            try {
                                if (!members[i].getName().equals("MC_TE.out")) {
                                    members[i].delete(1, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).split(1));
                                }
                            }
                            catch (CoreException e) {
                                TLCActivator.logError("Error deleting a file " + String.valueOf(members[i].getLocation()), e);
                            }
                        }
                        ++i;
                    }
                }
            } else {
                modelFolder.create(1025, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).split(STEP));
            }
            monitor.subTask("Copying files");
            specRootFile.copy(targetFolderPath.append(specRootFile.getProjectRelativePath()), 1025, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).split(1));
            IResource specRootFileCopy = modelFolder.findMember(specRootFile.getProjectRelativePath());
            if (specRootFileCopy == null) {
                throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error copying " + spec.getRootFilename() + " into " + targetFolderPath.toOSString()));
            }
            this.copyUserModuleOverride(monitor, 2, project, targetFolderPath, specRootFile);
            List extendedModules = ToolboxHandle.getExtendedModules((String)specRootFile.getName());
            IFile moduleFile = null;
            int i = 0;
            while (i < extendedModules.size()) {
                String module = (String)extendedModules.get(i);
                if (ToolboxHandle.isUserModule((String)module) && ResourceHelper.isLinkedFile((IProject)project, (String)module) && (moduleFile = ResourceHelper.getLinkedFile((IContainer)project, (String)module, (boolean)false)) != null) {
                    try {
                        moduleFile.copy(targetFolderPath.append(moduleFile.getProjectRelativePath()), 1025, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).split(STEP / extendedModules.size()));
                        this.copyUserModuleOverride(monitor, STEP / extendedModules.size(), project, targetFolderPath, moduleFile);
                    }
                    catch (ResourceException re) {
                        TLCActivator.logError(String.format("Error copying file %s to %s. Please correct the path to %s. \n(The first place to check is in the %s/.project file. Restart the Toolbox when you change the .project file.)", moduleFile.getLocation(), targetFolderPath, moduleFile.getName(), modelFolder.getRawLocation().removeLastSegments(1)), re);
                        throw new CoreException((IStatus)new Status(4, "org.lamport.tlc.toolbox.tool.tlc", String.format("Error copying file %s to %s. Please correct the path to %s. \n(The first place to check is in the %s/.project file. Restart the Toolbox when you change the .project file.)", moduleFile.getLocation(), targetFolderPath, moduleFile.getName(), modelFolder.getRawLocation().removeLastSegments(1))));
                    }
                }
                ++i;
            }
            if (!local.contains(TLCModelLaunchDelegate.getMode(config))) {
                Path modelDirectoryPath = Paths.get(modelFolder.getRawLocation().makeAbsolute().toFile().toURI());
                for (Module m : spec.getModulesSANY()) {
                    if (!m.isLibraryModule() || m.isStandardModule()) continue;
                    try {
                        m.copyTo(modelDirectoryPath);
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, "org.lamport.tlc.toolbox.tool.tlc", String.format("Error copying file %s to %s.", m.getFile(), modelDirectoryPath), (Throwable)e));
                    }
                }
            }
            i = 0;
            while (i < files.length) {
                if (files[i].exists()) {
                    files[i].setContents((InputStream)new ByteArrayInputStream("".getBytes()), 1025, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).split(1));
                } else {
                    files[i].create((InputStream)new ByteArrayInputStream("".getBytes()), 1025, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).split(1));
                }
                ++i;
            }
            monitor.worked(STEP);
            monitor.subTask("Creating contents");
            ModelWriter writer = new ModelWriter();
            writer.addPrimer("MC", spec.getRootModuleName());
            List<Assignment> constants = ModelHelper.deserializeAssignmentList(config.getAttribute("modelParameterConstants", new ArrayList()));
            TypedSet modelValues = TypedSet.parseSet((String)config.getAttribute("modelParameterModelValues", ""));
            writer.addConstants(constants, modelValues, "modelParameterConstants", "modelParameterModelValues");
            writer.addNewDefinitions(config.getAttribute("modelParameterNewDefinitions", ""), "modelParameterNewDefinitions");
            writer.addConstantsBis(constants, "modelParameterConstants");
            List<Assignment> overrides = ModelHelper.deserializeAssignmentList(config.getAttribute("modelParameterDefinitions", new ArrayList()));
            writer.addFormulaList(SpecWriterUtilities.createOverridesContent(overrides, (String)"def_ov", (SpecObj)ToolboxHandle.getCurrentSpec().getValidRootModule()), "CONSTANT", "modelParameterDefinitions");
            int specType = config.getAttribute("modelBehaviorSpecType", 2);
            boolean bl = hasSpec = specType != 0;
            if (hasSpec) {
                String constraintValue = config.getAttribute("modelParameterContraint", "");
                writer.addFormulaList(SpecWriterUtilities.createSourceContent((String)constraintValue, (String)"constr"), "CONSTRAINT", "modelParameterContraint");
                constraintValue = config.getAttribute("modelParameterActionConstraint", "");
                writer.addFormulaList(SpecWriterUtilities.createSourceContent((String)constraintValue, (String)"action_constr"), "ACTION_CONSTRAINT", "modelParameterActionConstraint");
                writer.addView(config.getAttribute("view", ""), "modelParameterView");
                writer.addPostCondition(config.getAttribute("postCondition", ""), "modelParameterPostCondition");
                writer.addAlias(config.getAttribute("alias", ""), "modelParameterAlias");
            }
            writer.addConstantExpressionEvaluation(model.getEvalExpression(), "modelExpressionEval");
            switch (specType) {
                case 0: {
                    OpDeclNode[] vars;
                    ModuleNode rootModuleNode = ModelHelper.getRootModuleNode();
                    if (rootModuleNode == null || (vars = rootModuleNode.getVariableDecls()) == null || vars.length <= 0) break;
                    String var = rootModuleNode.getVariableDecls()[0].getName().toString();
                    writer.addFormulaList(SpecWriterUtilities.createFalseInit((String)var), "INIT", "modelBehaviorNoSpec");
                    writer.addFormulaList(SpecWriterUtilities.createFalseNext((String)var), "NEXT", "modelBehaviorNoSpec");
                    break;
                }
                case 1: {
                    String specIdentifier = config.getAttribute("modelBehaviorSpec", "");
                    if (spec.declares(specIdentifier) && !TLCModelLaunchDelegate.isExpression(specIdentifier)) {
                        writer.addFormulaList(specIdentifier, "SPECIFICATION", "modelBehaviorSpec");
                        break;
                    }
                    String value = config.getAttribute("modelBehaviorSpec", "");
                    writer.addFormulaList(SpecWriterUtilities.createSourceContent((String)value, (String)"spec"), "SPECIFICATION", "modelBehaviorSpec");
                    break;
                }
                case 2: {
                    String init = config.getAttribute("modelBehaviorInit", "");
                    if (spec.declares(init) && !TLCModelLaunchDelegate.isExpression(init)) {
                        writer.addFormulaList(init, "INIT", "modelBehaviorInit");
                    } else {
                        String value = config.getAttribute("modelBehaviorInit", "");
                        writer.addFormulaList(SpecWriterUtilities.createSourceContent((String)value, (String)"init"), "INIT", "modelBehaviorInit");
                    }
                    String next = config.getAttribute("modelBehaviorNext", "");
                    if (spec.declares(next) && !TLCModelLaunchDelegate.isExpression(next)) {
                        writer.addFormulaList(next, "NEXT", "modelBehaviorInit");
                        break;
                    }
                    String value = config.getAttribute("modelBehaviorNext", "");
                    writer.addFormulaList(SpecWriterUtilities.createSourceContent((String)value, (String)"next"), "NEXT", "modelBehaviorNext");
                }
            }
            if (hasSpec) {
                List invariants = config.getAttribute("modelCorrectnessInvariants", new ArrayList());
                writer.addFormulaList(TLCModelLaunchDelegate.createProperties(writer, spec, invariants, "inv"), "INVARIANT", "modelCorrectnessInvariants");
                List properties = config.getAttribute("modelCorrectnessProperties", new ArrayList());
                writer.addFormulaList(TLCModelLaunchDelegate.createProperties(writer, spec, properties, "prop"), "PROPERTY", "modelCorrectnessProperties");
            }
            monitor.worked(STEP);
            monitor.subTask("Writing contents");
            writer.writeFiles(tlaFile, cfgFile, monitor);
            modelFolder.refreshLocal(1, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).split(STEP));
        }
        finally {
            monitor.done();
        }
        return false;
    }

    private static boolean isExpression(String formula) {
        return formula.contains("!");
    }

    private static List<String[]> createProperties(ModelWriter writer, TLCSpec spec, List<String> properties, String scheme) {
        List checkedFormula = Formula.deserializeFormulaList(properties);
        List createFormulaListContent = SpecWriterUtilities.createFormulaListContentFormula((List)checkedFormula, (String)scheme);
        List<Formula> declaredFormula = checkedFormula.stream().filter(f -> spec.declares(f.getFormula()) && !TLCModelLaunchDelegate.isExpression(f.getFormula())).collect(Collectors.toList());
        declaredFormula.forEach(f -> {
            String[] stringArray = createFormulaListContent.set(checkedFormula.indexOf(f), new String[]{f.getFormula(), "", String.valueOf(checkedFormula.indexOf(f))});
        });
        return createFormulaListContent;
    }

    private void copyUserModuleOverride(IProgressMonitor monitor, int ticks, IProject project, IPath targetFolderPath, IFile tlaFile) throws CoreException {
        IFile[] userModuleOverrides;
        IFile[] iFileArray = userModuleOverrides = ResourceHelper.getModuleOverrides((IProject)project, (IFile)tlaFile);
        int n = userModuleOverrides.length;
        int n2 = 0;
        while (n2 < n) {
            IFile userModuleOverride = iFileArray[n2];
            try {
                userModuleOverride.copy(targetFolderPath.append(userModuleOverride.getProjectRelativePath()), 1025, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).split(ticks));
            }
            catch (CoreException e) {
                userModuleOverride.delete(true, monitor);
            }
            ++n2;
        }
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Verifying model files", 4);
        Model model = (Model)configuration.getAdapter(Model.class);
        IFile rootModule = model.getTLAFile();
        monitor.worked(1);
        IParseResult parseResult = ToolboxHandle.parseModule((IResource)rootModule, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).split(1), (boolean)false, (boolean)false);
        Vector detectedErrors = parseResult.getDetectedErrors();
        boolean status = !AdapterFactory.isProblemStatus((int)parseResult.getStatus());
        monitor.worked(1);
        model.removeMarkers("org.lamport.tla.toolbox.tlc.modelErrorSANY");
        monitor.worked(1);
        if (!detectedErrors.isEmpty()) {
            TLCActivator.logDebug("Errors in model file found " + String.valueOf(rootModule.getLocation()));
        }
        Map<TLAMarkerInformationHolder, Hashtable<String, Object>> props = this.sany2ToolboxErrors(monitor, rootModule, detectedErrors);
        props.values().forEach(marker -> {
            IMarker iMarker = model.setMarker((Map<String, Object>)marker, "org.lamport.tla.toolbox.tlc.modelErrorSANY");
        });
        if (MODE_GENERATE.equals(mode)) {
            return false;
        }
        return status;
    }

    protected Map<TLAMarkerInformationHolder, Hashtable<String, Object>> sany2ToolboxErrors(IProgressMonitor monitor, IFile rootModule, Vector<TLAMarkerInformationHolder> detectedErrors) throws CoreException {
        FileEditorInput fileEditorInput = new FileEditorInput(rootModule);
        FileDocumentProvider fileDocumentProvider = new FileDocumentProvider();
        HashMap<TLAMarkerInformationHolder, Hashtable<String, Object>> result = new HashMap<TLAMarkerInformationHolder, Hashtable<String, Object>>();
        try {
            fileDocumentProvider.connect((Object)fileEditorInput);
            IDocument document = fileDocumentProvider.getDocument((Object)fileEditorInput);
            FindReplaceDocumentAdapter searchAdapter = new FindReplaceDocumentAdapter(document);
            int i = 0;
            while (i < detectedErrors.size()) {
                TLAMarkerInformationHolder markerHolder = detectedErrors.get(i);
                String message = markerHolder.getMessage();
                if (markerHolder.getModuleName() != null) {
                    if (!markerHolder.getModuleName().equals(rootModule.getName())) {
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch((ILaunch)this.launch);
                        throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Fatal error during validation of the model. SANY discovered an error somewhere else than the MC file. This is a bug. The error message was " + message + " in the module " + markerHolder.getModuleName()));
                    }
                } else {
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch((ILaunch)this.launch);
                    throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Fatal error during validation of the model. SANY discovered an error somewhere else than the MC file. This is a bug. The error message was " + message + "."));
                }
                int severity = markerHolder.getSeverityError();
                int[] coordinates = markerHolder.getCoordinates();
                result.put(markerHolder, ModelHelper.createMarkerDescription(rootModule, document, searchAdapter, message, severity, coordinates));
                ++i;
            }
        }
        finally {
            fileDocumentProvider.disconnect((Object)fileEditorInput);
            monitor.done();
        }
        return result;
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (!MODE_MODELCHECK.equals(mode)) {
            throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Unsupported launch mode " + mode));
        }
        Model model = (Model)config.getAdapter(Model.class);
        IProject project = model.getSpec().getProject();
        if (project == null) {
            throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error accessing the spec project " + model.getSpec().getName()));
        }
        model.setRunning(true);
        model.setOriginalTraceShown(true);
        int numberOfWorkers = config.getAttribute("numberOfWorkers", LAUNCH_NUMBER_OF_WORKERS_DEFAULT);
        String cloud = TLCModelLaunchDelegate.getMode(config);
        TLCProcessJob job = null;
        if ("off".equalsIgnoreCase(cloud)) {
            job = new TLCProcessJob(model.getSpec().getName(), model.getName(), launch, numberOfWorkers);
            job.setRule(this.mutexRule);
        } else if ("ad hoc".equalsIgnoreCase(cloud)) {
            job = new DistributedTLCJob(model.getSpec().getName(), model.getName(), launch, numberOfWorkers);
            job.setRule(this.mutexRule);
        } else {
            IConfigurationElement[] elements;
            numberOfWorkers = config.getAttribute("distributedNodesCount", 1);
            IFolder launchDir = model.getFolder();
            File file = launchDir.getRawLocation().makeAbsolute().toFile();
            BundleContext bundleContext = FrameworkUtil.getBundle(TLCModelLaunchDelegate.class).getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(IExtensionRegistry.class);
            IExtensionRegistry registry = (IExtensionRegistry)bundleContext.getService(serviceReference);
            IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.lamport.tla.toolx.tlc.job");
            if (elements.length != 0) {
                boolean checkDeadlock;
                IConfigurationElement element = iConfigurationElementArray[0];
                DummyProcess process = new DummyProcess(launch);
                launch.addProcess((IProcess)process);
                TLCJobFactory factory = (TLCJobFactory)element.createExecutableExtension("clazz");
                Properties props = new Properties();
                props.put("mainClass", TLC.class.getName());
                props.put("modelName", model.getName());
                props.put("specName", model.getSpec().getName());
                if (numberOfWorkers > 1) {
                    props.put("mainClass", TLCServer.class.getName());
                }
                props.put("result.mail.address", config.getAttribute("result.mail.address", "tlc@localhost"));
                ExecutionStatisticsCollector udc = new ExecutionStatisticsCollector();
                if (udc.isEnabled()) {
                    props.put(ExecutionStatisticsCollector.PROP, udc.getIdentifier());
                }
                StringBuffer tlcParams = new StringBuffer();
                if (!launch.getLaunchConfiguration().getAttribute("mcMode", true)) {
                    tlcParams.append("-simulate");
                    tlcParams.append(" ");
                    tlcParams.append("-depth");
                    tlcParams.append(" ");
                    int depth = launch.getLaunchConfiguration().getAttribute("simuDepth", 100);
                    tlcParams.append(Integer.toString(depth));
                    tlcParams.append(" ");
                }
                if (launch.getLaunchConfiguration().getAttribute("fpIndexRandom", true)) {
                    int fpIndex = new Random().nextInt(FP64.Polys.length);
                    tlcParams.append("-fp");
                    tlcParams.append(" ");
                    tlcParams.append(String.valueOf(fpIndex));
                } else {
                    int fpSeedOffset = launch.getLaunchConfiguration().getAttribute("fpIndex", 1);
                    tlcParams.append("-fp");
                    tlcParams.append(" ");
                    tlcParams.append(String.valueOf(fpSeedOffset));
                }
                tlcParams.append(" ");
                int maxSetSize = launch.getLaunchConfiguration().getAttribute("maxSetSize", TLCGlobals.setBound);
                if (maxSetSize != TLCGlobals.setBound) {
                    tlcParams.append("-maxSetSize ");
                    tlcParams.append(String.valueOf(maxSetSize));
                    tlcParams.append(" ");
                }
                if (model.getAttribute("deferLiveness", false)) {
                    tlcParams.append("-lncheck ");
                    tlcParams.append("final");
                    tlcParams.append(" ");
                }
                if (!(checkDeadlock = config.getAttribute("modelCorrectnessCheckDeadlock", true))) {
                    tlcParams.append("-deadlock");
                }
                job = factory.getTLCJob(cloud, file, numberOfWorkers, props, tlcParams.toString());
                job.addJobChangeListener((IJobChangeListener)new WithStatusJobChangeListener(process, (Model)config.getAdapter(Model.class)));
            }
            if (job == null) {
                throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", String.format("The distribution mode '%s' selected in the \"How to run?\" section caused an error. Check the Toolbox's \"Installation Details\" if the 'JCloud distributed TLC provider' is installed. If not, this is a bug and should be reported to the Toolbox authors. Thank you for your help and sorry for the inconvenience.\n\nIn the meantime, try running the Toolbox in non-distributed mode by setting \"Run in distributed mode\" to 'off'. You might have to 'Repair' your model via the \"Spec Explorer\" first.", cloud)));
            }
        }
        job.setPriority(30);
        job.setUser(true);
        TLCJobChangeListener tlcJobListener = new TLCJobChangeListener((Model)config.getAdapter(Model.class));
        job.addJobChangeListener((IJobChangeListener)tlcJobListener);
        job.schedule();
    }

    private static String getMode(ILaunchConfiguration config) throws CoreException {
        block3: {
            if (config.hasAttribute("distributedTLC")) {
                try {
                    return config.getAttribute("distributedTLC", "off");
                }
                catch (CoreException e) {
                    boolean distributed = config.getAttribute("distributedTLC", false);
                    if (!distributed) break block3;
                    return "ad hoc";
                }
            }
        }
        return "off";
    }

    class DummyProcess
    implements IProcess {
        private final ILaunch launch;
        private boolean termiated = false;

        public DummyProcess(ILaunch aLaunch) {
            this.launch = aLaunch;
        }

        public void setTerminated() {
            this.termiated = true;
        }

        public void terminate() throws DebugException {
        }

        public boolean isTerminated() {
            return this.termiated;
        }

        public boolean canTerminate() {
            return !this.termiated;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public String getAttribute(String key) {
            return null;
        }

        public void setAttribute(String key, String value) {
        }

        public IStreamsProxy getStreamsProxy() {
            return null;
        }

        public ILaunch getLaunch() {
            return this.launch;
        }

        public String getLabel() {
            return this.getClass().getSimpleName();
        }

        public int getExitValue() throws DebugException {
            return 0;
        }
    }

    class MutexRule
    implements ISchedulingRule {
        MutexRule() {
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    }

    class TLCJobChangeListener
    extends JobChangeAdapter {
        private Model model;

        public TLCJobChangeListener(Model model) {
            this.model = model;
        }

        public void done(final IJobChangeEvent event) {
            super.done(event);
            IFolder modelFolder = this.model.getFolder();
            WorkspaceJob refreshJob = new WorkspaceJob(""){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    TLCJobChangeListener.this.model.getCheckpoints(true);
                    return Status.OK_STATUS;
                }
            };
            refreshJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().refreshRule((IResource)modelFolder));
            refreshJob.schedule();
            if (event.getJob() instanceof TLCProcessJob) {
                Assert.isTrue((boolean)(event.getJob() instanceof TLCProcessJob));
                Assert.isNotNull((Object)event.getResult());
                TLCProcessJob tlcJob = (TLCProcessJob)event.getJob();
                if (!Status.CANCEL_STATUS.equals(event.getJob().getResult()) && tlcJob.hasCrashed()) {
                    this.model.setStale();
                }
            }
            this.model.setRunning(false);
            int snapshotKeepCount = TLCActivator.getDefault().getPreferenceStore().getInt("numberOfSnapshotsToKeep");
            if (snapshotKeepCount <= 0 || this.model.isSnapshot()) {
                return;
            }
            refreshJob = new WorkspaceJob("Taking snapshot of " + this.model.getName() + "..."){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    monitor.beginTask("Taking snapshot of " + TLCJobChangeListener.this.model.getName() + "...", 1);
                    final Model snapshot = TLCJobChangeListener.this.model.snapshot();
                    final IStatus status = event.getJob().getResult();
                    if (status instanceof ITLCJobStatus) {
                        snapshot.setRunningRemotely(true);
                        final List<IProcessOutputSink> sinks = this.getProcessOutputSinks(snapshot);
                        Job j = new Job(String.format("Consuming output of Cloud TLC for model %s", TLCJobChangeListener.this.model.getName())){

                            /*
                             * Exception decompiling
                             */
                            protected IStatus run(IProgressMonitor monitor) {
                                /*
                                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                 * 
                                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 2[TRYBLOCK]
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                 */
                                throw new IllegalStateException("Decompilation failed");
                            }

                            public boolean belongsTo(Object family) {
                                return snapshot == family;
                            }

                            protected void canceling() {
                                if (PlatformUI.getWorkbench().isClosing()) {
                                    super.canceling();
                                    return;
                                }
                                if (status instanceof ITLCJobStatus && snapshot.isRunningRemotely()) {
                                    ITLCJobStatus tlcJobStatus = (ITLCJobStatus)status;
                                    tlcJobStatus.killTLC();
                                    snapshot.setRunningRemotely(false);
                                }
                                super.canceling();
                            }
                        };
                        j.schedule();
                        final IFile launchFile = snapshot.getLaunchConfiguration().getFile();
                        if (launchFile.exists()) {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    UIHelper.openEditor((String)"org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor", (IFile)launchFile);
                                }
                            });
                        }
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }

                private List<IProcessOutputSink> getProcessOutputSinks(Model snapshot) {
                    IConfigurationElement[] decls = Platform.getExtensionRegistry().getConfigurationElementsFor("org.lamport.tla.toolbox.tlc.processOutputSink");
                    ArrayList<IProcessOutputSink> sinks = new ArrayList<IProcessOutputSink>(decls.length);
                    int i = 0;
                    while (i < decls.length) {
                        try {
                            IProcessOutputSink sink = (IProcessOutputSink)decls[i].createExecutableExtension("class");
                            sink.initializeSink(snapshot, 1);
                            sinks.add(sink);
                        }
                        catch (CoreException e) {
                            TLCActivator.logError("Error instatiating the IProcessSink extension", e);
                        }
                        ++i;
                    }
                    return sinks;
                }
            };
            refreshJob.setRule((ISchedulingRule)this.model.getSpec().getProject());
            refreshJob.schedule();
        }
    }

    class WithStatusJobChangeListener
    extends JobChangeAdapter {
        private final Model model;
        private final DummyProcess process;

        public WithStatusJobChangeListener(DummyProcess process, Model model) {
            this.process = process;
            this.model = model;
        }

        public void done(IJobChangeEvent event) {
            super.done(event);
            this.model.setRunning(false);
            this.model.recover();
            this.process.setTerminated();
            IStatus status = event.getJob().getResult();
            final String message = status.getMessage();
            if (status instanceof ITLCJobStatus) {
                ITLCJobStatus result = (ITLCJobStatus)status;
                if (result.isReconnect()) {
                    return;
                }
                final URL url = result.getURL();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        boolean yesOpenBrowser = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Cloud TLC", (String)(message + "\n\nClick OK to open a status page in your browser. Click Cancel to ignore the status page (you can still go there later)."));
                        if (yesOpenBrowser) {
                            try {
                                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
                            }
                            catch (PartInitException doesNotHappen) {
                                doesNotHappen.printStackTrace();
                            }
                        }
                    }
                });
            }
        }
    }
}

