/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.launch;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.lamport.tla.toolbox.spec.parser.ParseResult;
import org.lamport.tla.toolbox.tool.IParseResult;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.LongFormDialog;
import org.lamport.tla.toolbox.tool.tlc.TLCActivator;
import org.lamport.tla.toolbox.tool.tlc.job.TraceExplorerJob;
import org.lamport.tla.toolbox.tool.tlc.launch.IConfigurationConstants;
import org.lamport.tla.toolbox.tool.tlc.launch.IModelConfigurationConstants;
import org.lamport.tla.toolbox.tool.tlc.launch.TLCModelLaunchDelegate;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.model.TLCSpec;
import org.lamport.tla.toolbox.tool.tlc.model.TraceExpressionModelWriter;
import org.lamport.tla.toolbox.tool.tlc.util.ModelHelper;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.TLAMarkerInformationHolder;
import org.lamport.tla.toolbox.util.UIHelper;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.OpDefNode;
import tlc2.model.Assignment;
import tlc2.model.Formula;
import tlc2.model.MCState;
import tlc2.model.TraceExpressionInformationHolder;
import tlc2.model.TypedSet;
import tlc2.output.AbstractSpecWriter;
import tlc2.output.SpecWriterUtilities;

public class TraceExplorerDelegate
extends TLCModelLaunchDelegate
implements ILaunchConfigurationDelegate,
IModelConfigurationConstants,
IConfigurationConstants {
    public static final String MODE_TRACE_EXPLORE = "exploreTrace";
    private static final String EMPTY_STRING = "";
    private TraceExpressionInformationHolder[] traceExpressionData;
    private IFile tlaFile;
    private IFile cfgFile;
    private IFile outFile;
    private List<MCState> trace;
    private String initId;
    private String nextId;
    private String actionConstraintId;

    @Override
    public boolean buildForLaunch(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        Model model = (Model)config.getAdapter(Model.class);
        IProject project = model.getSpec().getProject();
        int STEP = 100;
        IFolder modelFolder = model.getFolder();
        if (!modelFolder.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Trace explorer was run and the model folder does not exist. This is a bug."));
        }
        IPath targetFolderPath = modelFolder.getProjectRelativePath().addTrailingSeparator();
        this.tlaFile = project.getFile(targetFolderPath.append("TE.tla"));
        this.cfgFile = project.getFile(targetFolderPath.append("TE.cfg"));
        this.outFile = project.getFile(targetFolderPath.append("TE.out"));
        TLCActivator.logDebug("Writing files to: " + targetFolderPath.toOSString());
        IFile[] files = new IFile[]{this.tlaFile, this.cfgFile, this.outFile};
        final IResource[] members = modelFolder.members();
        if (members.length == 0) {
            monitor.worked(STEP);
        } else {
            final IResource[] checkpoints = model.getCheckpoints(false);
            ISchedulingRule deleteRule = ResourceHelper.getDeleteRule((IResource[])members);
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    monitor.beginTask("Deleting files", members.length);
                    int i = 0;
                    while (i < members.length) {
                        try {
                            if (!(checkpoints.length > 0 && checkpoints[0].equals((Object)members[i]) || members[i].getName().equals("MC.cfg") || members[i].getName().equals("MC.tla") || members[i].getName().equals("MC.out") || members[i].getName().equals("MC_TE.out") || members[i].getName().endsWith(".class") || members[i].getName().endsWith(".java"))) {
                                members[i].delete(1, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).split(1));
                            }
                        }
                        catch (CoreException e) {
                            TLCActivator.logError("Error deleting a file " + String.valueOf(members[i].getLocation()), e);
                        }
                        ++i;
                    }
                    monitor.done();
                }
            }, deleteRule, 1, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).split(STEP));
        }
        monitor.subTask("Copying files");
        IFile specRootFile = model.getSpec().getRootFile();
        if (specRootFile == null) {
            throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error accessing the root module " + model.getSpec().getRootFilename()));
        }
        specRootFile.copy(targetFolderPath.append(specRootFile.getProjectRelativePath()), 1025, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).split(1));
        IResource specRootFileCopy = modelFolder.findMember(specRootFile.getProjectRelativePath());
        if (specRootFileCopy == null) {
            throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error copying " + model.getSpec().getRootFilename() + " into " + targetFolderPath.toOSString()));
        }
        ModelHelper.copyExtendedModuleFiles(specRootFile, targetFolderPath, monitor, STEP, project);
        ModelHelper.copyModuleFiles(specRootFile, targetFolderPath, monitor, STEP, project, model.getTraceExplorerExtends().stream().map(m -> m + ".tla").collect(Collectors.toSet()), e -> true);
        ModelHelper.createOrClearFiles(files, monitor);
        monitor.worked(STEP);
        monitor.subTask("Creating contents");
        this.trace = model.getErrorTrace();
        TraceExpressionModelWriter writer = new TraceExpressionModelWriter();
        Set<String> traceExplorerExtends = model.getTraceExplorerExtends();
        traceExplorerExtends.add("TLC");
        traceExplorerExtends.add("Toolbox");
        traceExplorerExtends.add("Sequences");
        traceExplorerExtends.add("Naturals");
        writer.addPrimer("TE", ResourceHelper.getModuleName((String)model.getSpec().getRootFilename()), traceExplorerExtends);
        this.writeModelInfo(model.getSpec().getValidRootModule(), config, (AbstractSpecWriter)writer);
        writer.addTraceFunction(this.trace);
        this.traceExpressionData = writer.createAndAddVariablesAndDefinitions(Formula.deserializeFormulaList((List)config.getAttribute("traceExploreExpressions", new ArrayList())), "traceExploreExpressions");
        String[] initNextActionConstraint = writer.addInitNext(this.trace);
        if (initNextActionConstraint != null) {
            this.initId = initNextActionConstraint[0];
            this.nextId = initNextActionConstraint[1];
            this.actionConstraintId = initNextActionConstraint[2];
        }
        monitor.worked(STEP);
        monitor.subTask("Writing contents");
        writer.writeFiles(this.tlaFile, this.cfgFile, monitor);
        return false;
    }

    @Override
    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Verifying model files", 4);
        Model model = (Model)configuration.getAdapter(Model.class);
        IFile rootModule = model.getTEFile();
        monitor.worked(1);
        IParseResult parseResult = ToolboxHandle.parseModule((IResource)rootModule, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).split(1), (boolean)false, (boolean)false);
        Assert.isTrue((boolean)(parseResult instanceof ParseResult), (String)"Object returned by parsing the module is not an instance of ParseResult. This is not expected by the toolbox.");
        Vector detectedErrors = parseResult.getDetectedErrors();
        if (detectedErrors.size() > 0) {
            Map<TLAMarkerInformationHolder, Hashtable<String, Object>> props = this.sany2ToolboxErrors(monitor, rootModule, detectedErrors);
            final StringBuffer errorMessage = new StringBuffer();
            for (TLAMarkerInformationHolder errorInfo : parseResult.getDetectedErrors()) {
                if (props.containsKey(errorInfo)) {
                    errorMessage.append(props.get(errorInfo).get("message"));
                    continue;
                }
                errorMessage.append(errorInfo.getMessage() + "\n");
            }
            UIHelper.runUIAsync((Runnable)new Runnable(){

                @Override
                public void run() {
                    LongFormDialog dialog = new LongFormDialog("Parsing error when running trace explorer", errorMessage.toString());
                    dialog.open();
                }
            });
            return false;
        }
        OpDefNode[] opDefNodes = ((ParseResult)parseResult).getSpecObj().getExternalModuleTable().getRootModule().getOpDefs();
        Hashtable<String, OpDefNode> nodeTable = new Hashtable<String, OpDefNode>(opDefNodes.length);
        Assert.isNotNull((Object)opDefNodes, (String)"OpDefNodes[] from parsing TE.tla is null. This is a bug.");
        int j = 0;
        while (j < opDefNodes.length) {
            String key = opDefNodes[j].getName().toString();
            nodeTable.put(key, opDefNodes[j]);
            ++j;
        }
        ArrayList<TraceExpressionInformationHolder> levelThreeExpressions = new ArrayList<TraceExpressionInformationHolder>();
        int i = 0;
        while (i < this.traceExpressionData.length) {
            OpDefNode opDefNode = (OpDefNode)nodeTable.get(this.traceExpressionData[i].getIdentifier());
            int level = opDefNode.getBody().getLevel();
            this.traceExpressionData[i].setLevel(level);
            if (level == 3) {
                levelThreeExpressions.add(this.traceExpressionData[i]);
            }
            ++i;
        }
        if (!levelThreeExpressions.isEmpty()) {
            final StringBuffer errorBuffer = new StringBuffer();
            errorBuffer.append("The trace explorer cannot evaluate temporal formulas. The following expressions are temporal formulas:\n\n");
            for (TraceExpressionInformationHolder expressionInfo : levelThreeExpressions) {
                errorBuffer.append(expressionInfo.getExpression() + "\n\n");
            }
            UIHelper.runUIAsync((Runnable)new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Temporal formulas found", (String)errorBuffer.toString());
                }
            });
            return false;
        }
        ModelHelper.createOrClearFiles(new IFile[]{this.tlaFile, this.cfgFile, this.outFile}, monitor);
        monitor.subTask("Creating contents");
        TraceExpressionModelWriter writer = new TraceExpressionModelWriter();
        writer.addInfoComments(this.traceExpressionData);
        Set<String> traceExplorerExtends = model.getTraceExplorerExtends();
        traceExplorerExtends.add("TLC");
        traceExplorerExtends.add("Toolbox");
        traceExplorerExtends.add("Sequences");
        traceExplorerExtends.add("Naturals");
        writer.addPrimer("TE", ResourceHelper.getModuleName((String)model.getSpec().getRootFilename()), traceExplorerExtends);
        this.writeModelInfo(model.getSpec().getValidRootModule(), configuration, (AbstractSpecWriter)writer);
        writer.addTraceFunction(this.trace);
        writer.addVariablesAndDefinitions(this.traceExpressionData, "traceExploreExpressions", true);
        writer.addInitNext(this.trace, this.traceExpressionData, this.initId, this.nextId, this.actionConstraintId);
        writer.addProperties(this.trace);
        writer.writeFiles(this.tlaFile, this.cfgFile, monitor);
        IFolder modelFolder = model.getFolder();
        modelFolder.refreshLocal(1, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).split(100));
        ((Model)configuration.getAdapter(Model.class)).setOriginalTraceShown(false);
        return true;
    }

    @Override
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        TLCActivator.logDebug("launch called");
        if (!MODE_TRACE_EXPLORE.equals(mode)) {
            throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Unsupported launch mode " + mode));
        }
        Model model = (Model)configuration.getAdapter(Model.class);
        TLCSpec spec = model.getSpec();
        IProject project = spec.getProject();
        if (project == null) {
            throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error accessing the spec project " + spec.getName()));
        }
        TraceExplorerJob tlcjob = new TraceExplorerJob(spec.getName(), model.getName(), launch, 1);
        tlcjob.setPriority(20);
        tlcjob.setUser(true);
        tlcjob.setRule(this.mutexRule);
        tlcjob.schedule();
    }

    private void writeModelInfo(SpecObj specObj, ILaunchConfiguration config, AbstractSpecWriter writer) throws CoreException {
        List<Assignment> constants = ModelHelper.deserializeAssignmentList(config.getAttribute("modelParameterConstants", new ArrayList()), true);
        TypedSet modelValues = TypedSet.parseSet((String)config.getAttribute("modelParameterModelValues", EMPTY_STRING));
        writer.addConstants(constants, modelValues, "modelParameterConstants", "modelParameterModelValues");
        writer.addNewDefinitions(config.getAttribute("modelParameterNewDefinitions", EMPTY_STRING), "modelParameterNewDefinitions");
        writer.addConstantsBis(constants, "modelParameterConstants");
        List<Assignment> overrides = ModelHelper.deserializeAssignmentList(config.getAttribute("modelParameterDefinitions", new ArrayList()));
        writer.addFormulaList(SpecWriterUtilities.createOverridesContent(overrides, (String)"def_ov", (SpecObj)specObj), "CONSTANT", "modelParameterDefinitions");
    }
}

