/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.lamport.tla.toolbox.util.UIHelper;

public class LongFormDialog
extends Dialog {
    private final String m_title;
    private final String m_message;

    public LongFormDialog(String title, String message) {
        super(UIHelper.getShellProvider());
        this.setShellStyle(67696);
        this.m_title = title;
        this.m_message = message;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(2, false));
        Display d = container.getDisplay();
        Font f = d.getSystemFont();
        GC gc = new GC((Drawable)container.getShell());
        gc.setFont(f);
        Point roughTitleSize = gc.textExtent(this.m_title);
        gc.dispose();
        Label errorIcon = new Label(container, 0);
        errorIcon.setImage(d.getSystemImage(1));
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        errorIcon.setLayoutData((Object)gd);
        Text text = new Text(container, 2570);
        gd = new GridData();
        gd.heightHint = 180;
        gd.minimumWidth = Math.max(300, (int)((double)roughTitleSize.x * 1.2));
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        text.setLayoutData((Object)gd);
        text.setText(this.m_message);
        container.pack();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.m_title);
    }
}

